/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.Trace;
import com.streamscape.cli.ClientContext;
import com.streamscape.cli.ClientState;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.error.Error;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.utils.SDOUtils;
import java.util.Arrays;

public class OtherTypeWrapper {
    private static JSerializer serializer = null;
    private Object object;
    private byte[] objectBytes;
    private transient int length = -1;

    private static synchronized void initSerializer() {
        if (serializer == null) {
            JSerializerFactory jFactory = null;
            jFactory = RuntimeState.isActive() ? DataspaceStoreManager.getRuntimeContext().getJSerializerFactory() : (ClientState.isActive() ? ClientContext.getInstance().getJSerializerFactory() : JSerializerFactory.getInstance());
            serializer = jFactory.createSerializer("DataspaceOtherTypeSerializer");
        }
    }

    public static synchronized void unloadSerializer() {
        serializer = null;
    }

    OtherTypeWrapper() {
        this.length = -1;
    }

    public OtherTypeWrapper(byte[] objectBytes, boolean withDeserialization) {
        if (withDeserialization) {
            this.object = OtherTypeWrapper.deserialize(objectBytes);
        } else {
            this.objectBytes = objectBytes;
        }
    }

    public OtherTypeWrapper(Object object) {
        this.object = object;
    }

    public synchronized byte[] getBytes() {
        if (this.objectBytes != null) {
            return this.objectBytes;
        }
        if (serializer == null) {
            OtherTypeWrapper.initSerializer();
        }
        try {
            byte[] bytes = serializer.serialize(this.object);
            if (this.length != -1 && (bytes == null && this.length != 0 || bytes != null && bytes.length != this.length)) {
                Trace.logError(this, "WARNING: Serialized bytes length mismatch when getting bytes for wrapped object {}. Expected length: {}, but object length is {}. Cutting object to the length {}.", this.object != null ? this.object.getClass().toString() : "null", this.length, bytes == null ? "null" : Integer.valueOf(bytes.length), this.length);
                Trace.logException(this, new Exception(), true);
                if (this.length == 0) {
                    bytes = new byte[]{};
                }
                if (this.length < bytes.length) {
                    bytes = Arrays.copyOf(bytes, this.length);
                }
            }
            return bytes;
        }
        catch (Exception e) {
            throw Error.error(3473, e.toString());
        }
    }

    public synchronized int getBytesLength() {
        if (this.length == -1) {
            byte[] bytes = this.getBytes();
            this.length = bytes == null ? 0 : bytes.length;
        }
        return this.length;
    }

    public Object getObject() {
        if (this.object == null && this.objectBytes != null) {
            this.object = OtherTypeWrapper.deserialize(this.objectBytes);
            this.objectBytes = null;
        }
        return this.object;
    }

    public String toString() {
        return super.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof OtherTypeWrapper) {
            if (this.objectBytes != null) {
                return SDOUtils.equals(this.objectBytes, ((OtherTypeWrapper)other).objectBytes);
            }
            return SDOUtils.equals(this.object, ((OtherTypeWrapper)other).object);
        }
        return false;
    }

    public int hashCode() {
        if (this.object != null) {
            this.object.hashCode();
        }
        return 1;
    }

    public OtherTypeWrapper cloneForInsert(boolean isMemoryTable) throws JSerializerException {
        byte[] bytes = null;
        if (this.object != null) {
            bytes = serializer.serialize(this.object);
        } else if (this.objectBytes != null) {
            bytes = this.objectBytes;
        }
        return new OtherTypeWrapper(bytes, isMemoryTable);
    }

    public static Object unwrap(Object data) {
        while (data instanceof OtherTypeWrapper) {
            data = ((OtherTypeWrapper)data).getObject();
        }
        return data;
    }

    public static OtherTypeWrapper wrap(Object data) {
        if (data instanceof OtherTypeWrapper) {
            return (OtherTypeWrapper)data;
        }
        return new OtherTypeWrapper(data);
    }

    public static Object unwrapWithArrays(Object data) {
        if (data != null && data instanceof Object[]) {
            return Arrays.stream((Object[])data).map(o -> OtherTypeWrapper.unwrap(o)).toArray(Object[]::new);
        }
        return OtherTypeWrapper.unwrap(data);
    }

    public static Object unwrapAndClone(Object data) {
        while (data instanceof OtherTypeWrapper) {
            while (((OtherTypeWrapper)data).object instanceof OtherTypeWrapper) {
                data = ((OtherTypeWrapper)data).object;
            }
            if (((OtherTypeWrapper)data).object != null) {
                try {
                    data = SDOUtils.cloneByJSerializer(((OtherTypeWrapper)data).object);
                }
                catch (SDOException exception) {
                    data = ((OtherTypeWrapper)data).object;
                    Trace.logException(OtherTypeWrapper.class, exception, true);
                }
                continue;
            }
            if (((OtherTypeWrapper)data).objectBytes != null) {
                data = OtherTypeWrapper.deserialize(((OtherTypeWrapper)data).objectBytes);
                continue;
            }
            data = null;
        }
        return data;
    }

    private static Object deserialize(byte[] bytes) {
        if (serializer == null) {
            OtherTypeWrapper.initSerializer();
        }
        try {
            return serializer.deserialize(bytes);
        }
        catch (Exception e) {
            throw Error.error(3473, e);
        }
    }

    static {
        OtherTypeWrapper.initSerializer();
    }
}

