/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.DateTimeType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.lib.loader.FabricClassLoader;
import com.streamscape.sdo.tuple.CollectionTupleSet;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OtherType
extends Type {
    private String name = null;
    private Class<?> internalClass = null;
    private final Object internalClassMutex = new Object();
    public static Boolean typeSafe = true;

    public OtherType() {
        super(1111, 1111, 0L, 0);
    }

    protected OtherType(int type) {
        super(1111, type, 0L, 0);
    }

    public OtherType(String name, Class<?> internalClass) {
        super(1111, 1111, 0L, 0);
        this.name = name;
        this.internalClass = internalClass;
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode;
    }

    @Override
    public Class<?> getJDBCClass() {
        return Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInternalClass(Session session, Class<?> clazz) {
        Object object = this.internalClassMutex;
        synchronized (object) {
            this.internalClass = clazz;
        }
    }

    @Override
    public Class<?> getInternalClass(Session session) {
        try {
            return this.resolveInternalClass(session);
        }
        catch (Exception exception) {
            Trace.logError(this, exception.getMessage());
            return Object.class;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> resolveInternalClass(Session session) {
        Object object = this.internalClassMutex;
        synchronized (object) {
            if (this.internalClass != null) {
                ClassLoader classLoader = this.internalClass.getClassLoader();
                if (!(!(classLoader instanceof FabricClassLoader) || ((FabricClassLoader)classLoader).isLoaded() && ((FabricClassLoader)classLoader).isWorking())) {
                    this.internalClass = null;
                } else {
                    return this.internalClass;
                }
            }
            if (session != null && this.userTypeModifier != null) {
                try {
                    this.internalClass = session.sessionContext.typeAnalyzer.getClassBySemanticType(this.userTypeModifier.getName().name);
                    if (this.internalClass != null) {
                        return this.internalClass;
                    }
                }
                catch (Exception ex) {
                    throw new DataspaceException("Unable to resolve class for type '" + this.userTypeModifier.getName().name + "'. " + ex.getMessage());
                }
            }
            return Object.class;
        }
    }

    @Override
    public String getJDBCClassName() {
        return "java.lang.Object";
    }

    @Override
    public int getSQLGenericTypeCode() {
        return this.typeCode;
    }

    public int typeCode() {
        return this.typeCode;
    }

    @Override
    public String getNameString() {
        if (this.name != null) {
            return this.name;
        }
        return "OTHER";
    }

    @Override
    public String getDefinition() {
        if (this.name != null) {
            return this.name;
        }
        return "OTHER";
    }

    @Override
    public Type getAggregateType(Type other) {
        if (other == null) {
            return this;
        }
        if (other == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == other.typeCode) {
            return this;
        }
        throw Error.error(5562);
    }

    @Override
    public Type getCombinedType(Session session, Type other, int operation) {
        return this;
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if ((a = OtherTypeWrapper.unwrap(a)) == (b = OtherTypeWrapper.unwrap(b))) {
            return 0;
        }
        if (a instanceof Character) {
            a = Character.toString(((Character)a).charValue());
        }
        if (b instanceof Character) {
            b = Character.toString(((Character)b).charValue());
        }
        if (a instanceof BigDecimal && b instanceof Number) {
            b = BigDecimal.valueOf(((Number)b).longValue());
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            return ((Comparable)a).compareTo((Comparable)b);
        }
        if (SDOUtils.equals(a, b)) {
            return 0;
        }
        if (a.getClass() != b.getClass()) {
            throw Error.incompatibleComparisonTypesError(a, b);
        }
        return -1;
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        return a;
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        Class<?> toTypeClass = session instanceof Session ? this.getInternalClass((Session)session) : this.internalClass;
        a = OtherTypeWrapper.unwrap(a);
        if (toTypeClass != null && toTypeClass == Date.class && otherType instanceof DateTimeType) {
            Date d = new Date(((Date)otherType.convertSQLToJava(session, a)).getTime());
            a = new OtherTypeWrapper(d);
            return a;
        }
        if (!(otherType instanceof OtherType)) {
            try {
                Class<?> typeClass = toTypeClass;
                if (typeClass == null && this.userTypeModifier != null) {
                    typeClass = ((Session)session).sessionContext.typeAnalyzer.getClassBySemanticType(this.userTypeModifier.getName().name);
                }
                if (typeClass != null) {
                    Object result;
                    Type actualType = Types.getParameterSQLType((Session)session, typeClass);
                    if (actualType == null && this.userTypeModifier != null) {
                        actualType = Types.getParameterSQLType((Session)session, this.userTypeModifier.getName().name);
                    }
                    if (actualType != null && !(actualType instanceof OtherType) && (result = actualType.convertToType(session, a, otherType)) != null) {
                        a = result;
                    }
                }
            }
            catch (Exception error) {
                throw new DataspaceException(error);
            }
        }
        a = OtherTypeWrapper.unwrap(a);
        if (otherType != null) {
            switch (otherType.typeCode) {
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    if (!(a instanceof String)) break;
                    try {
                        a = new OtherTypeWrapper(StringConverter.hexStringToByteArray((String)a), true);
                        break;
                    }
                    catch (Exception error) {
                        // empty catch block
                    }
                }
            }
        }
        a = OtherTypeWrapper.unwrap(a);
        if (toTypeClass != null && a != null) {
            if (toTypeClass != CollectionTupleSet.class && Arrays.asList("list", "listint", "set", "setint").contains(this.getNameString().toLowerCase()) && (List.class.isAssignableFrom(toTypeClass) || Set.class.isAssignableFrom(toTypeClass))) {
                AbstractCollection result;
                AbstractCollection abstractCollection = result = Set.class.isAssignableFrom(toTypeClass) ? new HashSet() : new ArrayList();
                if (a.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(a); ++i) {
                        result.add(OtherTypeWrapper.unwrapAndClone(Array.get(a, i)));
                    }
                    a = result;
                } else if (a instanceof Collection && a.getClass() != result.getClass()) {
                    result.addAll((Collection)a);
                    a = result;
                }
            }
            if (!(!typeSafe.booleanValue() || toTypeClass.isAssignableFrom(a.getClass()) || TypeFactory.wrapPrimitive(toTypeClass).isAssignableFrom(TypeFactory.wrapPrimitive(a.getClass())) || TypeFactory.wrapPrimitive(toTypeClass) == Character.class && ((a instanceof Character[] || a instanceof char[]) && Array.getLength(a) == 1 || a instanceof String && ((String)a).length() == 1))) {
                String valueTypeName = null;
                if (a != null && valueTypeName == null || valueTypeName.equalsIgnoreCase("other")) {
                    valueTypeName = Type.resolveTypeName(session, a);
                }
                throw new DataspaceException("Incompatible data types in assignment. Value of type '" + valueTypeName + "' cannot be cast to type '" + this.getTypeDefinition() + "'.");
            }
        }
        if (a != null && !(a instanceof OtherTypeWrapper)) {
            a = new OtherTypeWrapper(a);
        }
        return a;
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        if ((a = OtherTypeWrapper.unwrap(a)) == null) {
            return a;
        }
        Class<?> clazz = this.internalClass;
        if (clazz == null || clazz.isAssignableFrom(a.getClass()) || clazz.getName().equals(a.getClass().getName())) {
            return new OtherTypeWrapper(a);
        }
        throw Error.error(5561);
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return StringConverter.byteArrayToHexString(((OtherTypeWrapper)a).getBytes());
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        return StringConverter.byteArrayToSQLHexString(((OtherTypeWrapper)a).getBytes());
    }

    @Override
    public Object convertSQLToJava(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        return a instanceof OtherTypeWrapper ? ((OtherTypeWrapper)a).getObject() : a;
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        return new OtherTypeWrapper(a);
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        if (otherType.typeCode == this.typeCode) {
            return true;
        }
        return otherType.typeCode == 0;
    }

    @Override
    public boolean isObjectType() {
        return true;
    }

    @Override
    public boolean isListType() {
        if (this.internalClass != null) {
            return List.class.isAssignableFrom(this.internalClass);
        }
        if (this.userTypeModifier != null) {
            return "list".equalsIgnoreCase(this.userTypeModifier.getName().name) || "listint".equalsIgnoreCase(this.userTypeModifier.getName().name);
        }
        return false;
    }

    @Override
    public boolean isSetType() {
        if (this.internalClass != null) {
            return Set.class.isAssignableFrom(this.internalClass);
        }
        if (this.userTypeModifier != null) {
            return "set".equalsIgnoreCase(this.userTypeModifier.getName().name) || "setint".equalsIgnoreCase(this.userTypeModifier.getName().name);
        }
        return false;
    }

    @Override
    public boolean isCollectionType() {
        if (this.internalClass != null) {
            return Collection.class.isAssignableFrom(this.internalClass);
        }
        if (this.userTypeModifier != null) {
            return this.isListType() || this.isSetType();
        }
        return false;
    }

    @Override
    public boolean canBeAssignedFrom(Type otherType) {
        if (super.canBeAssignedFrom(otherType)) {
            return true;
        }
        return "object".equalsIgnoreCase(this.name);
    }
}

