/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.types.LoggedExpression;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.SchedulerException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class MetasetTypeWrapper
implements LoggedExpression {
    private final String dataspaceName;
    private final DataspaceStore dataspaceStore;
    private boolean shouldBeLogged = false;

    public MetasetTypeWrapper(String dataspaceName, DataspaceStore dataspaceStore) {
        this.dataspaceName = dataspaceName;
        this.dataspaceStore = dataspaceStore;
    }

    private Metaset getMetaset() {
        DataspaceSchema dataspaceSchema = this.dataspaceStore.schemaManager.findSchema(this.dataspaceName);
        if (dataspaceSchema == null) {
            throw new DataspaceException("Dataspace with name " + this.dataspaceName + " does not exist.");
        }
        String metasetName = dataspaceSchema.getMetasetName();
        if (metasetName == null || metasetName.length() == 0) {
            throw new DataspaceException("Metaset for dataspace " + dataspaceSchema.getName() + " is not set.");
        }
        Metaset metaset = dataspaceSchema.getMetaset();
        if (metaset == null) {
            throw new DataspaceException("Metaset " + metasetName + " does not exist.");
        }
        return metaset;
    }

    public UUID getOID() {
        return this.getMetaset().getOID();
    }

    public String getName() {
        return this.getMetaset().getName();
    }

    public String getDescription() {
        return this.getMetaset().getDescription();
    }

    public String getAuthor() {
        return this.getMetaset().getAuthor();
    }

    public String getOwner() {
        return this.getMetaset().getOwner();
    }

    public Date getCreationTime() {
        return this.getMetaset().getCreationTime();
    }

    public Date getLastUpdateTime() {
        return this.getMetaset().getLastUpdateTime();
    }

    public void set(String key, Object value) throws SchedulerException {
        this.getMetaset().set(key, value);
        this.shouldBeLogged = true;
    }

    public void remove(String key) throws SchedulerException {
        this.getMetaset().remove(key);
        this.shouldBeLogged = true;
    }

    public Object get(String key) {
        return this.getMetaset().get(key);
    }

    public boolean exists(String key) {
        return this.getMetaset().exists(key);
    }

    public List<String> listPredefinedKeys() {
        return this.getMetaset().listPredefinedKeys();
    }

    public List<String> listDynamicKeys() {
        return this.getMetaset().listDynamicKeys();
    }

    public List<String> listKeys() {
        return this.getMetaset().listKeys();
    }

    public List<Object> listValues() {
        return this.getMetaset().listValues();
    }

    @Override
    public String getAndResetLoggedStatement() {
        if (this.shouldBeLogged) {
            return "alter dataspace " + this.dataspaceName + " set metaset dynamic values '" + MetasetTypeWrapper.serializeMetasetValues(this.getMetaset().getDynamicProperties()) + "' metaset predefined values '" + MetasetTypeWrapper.serializeMetasetValues(this.getMetaset().getPredefinedProperties()) + "'";
        }
        return null;
    }

    public static String serializeMetasetValues(Map<String, Object> metasetValues) {
        try {
            return HTTPUtils.getJsonSerializerForRest(DataspaceStore.getContext()).serialize(metasetValues).replace("'", "''");
        }
        catch (SerializerException e) {
            Trace.logException(MetasetTypeWrapper.class, e, true);
            Trace.logError(MetasetTypeWrapper.class, "Failed to serializer metaset values");
            return "{}";
        }
    }

    public static Map<String, Object> deserializeMetasetValues(String json) {
        try {
            return HTTPUtils.getJsonSerializerForRest(DataspaceStore.getContext()).deserialize(HashMap.class, json);
        }
        catch (SerializerException e) {
            Trace.logException(MetasetTypeWrapper.class, e, true);
            Trace.logError(MetasetTypeWrapper.class, "Failed to deserializer metaset values");
            return new HashMap<String, Object>();
        }
    }
}

