/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.types.DTIType;
import com.streamscape.ds.types.IntervalType;
import com.streamscape.ds.types.Type;

public class IntervalSecondData {
    public static final IntervalSecondData oneDay = IntervalSecondData.newIntervalDay(1L, Type.SQL_INTERVAL_DAY);
    public final long units;
    public final int nanos;

    public static IntervalSecondData newIntervalDay(long days, IntervalType type) {
        return new IntervalSecondData(days * 24L * 60L * 60L, 0, type);
    }

    public static IntervalSecondData newIntervalHour(long hours, IntervalType type) {
        return new IntervalSecondData(hours * 60L * 60L, 0, type);
    }

    public static IntervalSecondData newIntervalMinute(long minutes, IntervalType type) {
        return new IntervalSecondData(minutes * 60L, 0, type);
    }

    public static IntervalSecondData newIntervalSeconds(long seconds, IntervalType type) {
        return new IntervalSecondData(seconds, 0, type);
    }

    public IntervalSecondData(long seconds, int nanos, IntervalType type) {
        if (seconds >= type.getIntervalValueLimit()) {
            throw Error.error(3435);
        }
        this.units = seconds;
        this.nanos = nanos;
    }

    public IntervalSecondData(long seconds, int nanos) {
        this.units = seconds;
        this.nanos = nanos;
    }

    public IntervalSecondData(long seconds, long nanos, IntervalType type, boolean normalise) {
        if (nanos >= 1000000000L) {
            carry = nanos / 1000000000L;
            nanos %= 1000000000L;
            seconds += carry;
        } else if (nanos <= -1000000000L) {
            carry = -nanos / 1000000000L;
            nanos = -(-nanos % 1000000000L);
            seconds -= carry;
        }
        int scaleFactor = DTIType.nanoScaleFactors[type.scale];
        nanos /= (long)scaleFactor;
        if (seconds > 0L && (nanos *= (long)scaleFactor) < 0L) {
            nanos += 1000000000L;
            --seconds;
        } else if (seconds < 0L && nanos > 0L) {
            nanos -= 1000000000L;
            ++seconds;
        }
        scaleFactor = DTIType.yearToSecondFactors[type.endPartIndex];
        seconds /= (long)scaleFactor;
        if ((seconds *= (long)scaleFactor) >= type.getIntervalValueLimit()) {
            throw Error.error(3435);
        }
        this.units = seconds;
        this.nanos = (int)nanos;
    }

    public boolean equals(Object other) {
        if (other instanceof IntervalSecondData) {
            return this.units == ((IntervalSecondData)other).units && this.nanos == ((IntervalSecondData)other).nanos;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.units ^ this.nanos;
    }

    public int compareTo(IntervalSecondData b) {
        long diff = this.units - b.units;
        if (diff == 0L && (diff = (long)(this.nanos - b.nanos)) == 0L) {
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }

    public long getSeconds() {
        return this.units;
    }

    public int getNanos() {
        return this.nanos;
    }

    public String toString() {
        return Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION.convertToString(this);
    }
}

