/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.jdbc.JDBCBlobClient;
import com.streamscape.ds.jdbc.JDBCClobClient;
import com.streamscape.ds.persist.FlobManager;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobDataID;
import com.streamscape.ds.types.Type;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Objects;

public final class FlobType
extends Type {
    public static String NAME_STRING = "FLOB";
    private String charset = null;
    private Boolean autotag = null;
    private String location = null;
    private boolean charsetFromDefinition = true;
    private boolean autotagFromDefinition = true;
    private boolean locaitonFromDefinition = true;
    private boolean isLazy = false;
    private boolean isVariable = false;

    public FlobType() {
        super(-2, 1119, Long.MAX_VALUE, 0);
    }

    public FlobType(FlobType type) {
        this();
        this.charset = type.charset;
        this.autotag = type.autotag;
        this.location = type.location;
        this.charsetFromDefinition = type.charsetFromDefinition;
        this.autotagFromDefinition = type.autotagFromDefinition;
        this.locaitonFromDefinition = type.locaitonFromDefinition;
        this.isLazy = type.isLazy;
        this.isVariable = type.isVariable;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setCharsetNotFromDefinition(String charset) {
        this.charset = charset;
        this.charsetFromDefinition = false;
    }

    public boolean isCharsetFromDefinition() {
        return this.charsetFromDefinition;
    }

    public Boolean getAutotag() {
        return this.autotag;
    }

    public void setAutotag(Boolean autotag) {
        this.autotag = autotag;
    }

    public void setAutotagNotFromDefinition(Boolean autotag) {
        this.autotag = autotag;
        this.autotagFromDefinition = false;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setLocationNotFromDefinition(String location) {
        this.location = location;
        this.locaitonFromDefinition = false;
    }

    public void setLazy(boolean isLazy) {
        this.isLazy = isLazy;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public void setVariable(boolean isVariable) {
        this.isVariable = isVariable;
    }

    public boolean isVariable() {
        return this.isVariable;
    }

    @Override
    public boolean isFlobType() {
        return true;
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode;
    }

    @Override
    public String getFullNameString() {
        return this.getDefinition();
    }

    @Override
    public String getJDBCClassName() {
        return this.getCharset() != null ? Clob.class.getName() : Blob.class.getName();
    }

    @Override
    public Class<?> getJDBCClass() {
        return this.getCharset() != null ? Clob.class : Blob.class;
    }

    @Override
    public Class<?> getInternalClass(Session session) {
        return this.getCharset() != null ? char[].class : byte[].class;
    }

    @Override
    public String getNameString() {
        return NAME_STRING;
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof JDBCClobClient) {
            return ((JDBCClobClient)a).getClob();
        }
        if (a instanceof JDBCBlobClient) {
            return ((JDBCBlobClient)a).getBlob();
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertSQLToJava(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof FlobDataID) {
            if (((FlobDataID)a).getCharset() != null) {
                return new JDBCClobClient(session, ((FlobData)a).getClobAdapter());
            }
            return new JDBCBlobClient(session, ((FlobData)a).getBlobAdapter());
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        return this.castOrConvertToType(session, a, otherType, false);
    }

    private Object castOrConvertToType(SessionInterface session, Object a, Type otherType, boolean cast) {
        switch (otherType.typeCode) {
            case 1119: {
                if (!this.canBeAssignedFrom(otherType)) break;
                return a;
            }
        }
        throw Error.error(5561);
    }

    @Override
    public boolean canBeAssignedFrom(Type otherType) {
        if (!(otherType instanceof FlobType)) {
            return false;
        }
        FlobType flobOtherType = (FlobType)otherType;
        return flobOtherType.typeCode == this.typeCode && (this.isVariable() || flobOtherType.isVariable() && flobOtherType.isLazy() || this.autotag == flobOtherType.autotag && (this.location == flobOtherType.location || this.location != null && this.location.equals(flobOtherType.location) || this.location != null && flobOtherType.location != null && FlobManager.normalizePath(this.location).equals(FlobManager.normalizePath(flobOtherType.location))));
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object o) {
        if (o == null) {
            return o;
        }
        if (o instanceof FlobData) {
            return o;
        }
        throw Error.error(5561);
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        return -1;
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        return null;
    }

    @Override
    public String convertToString(Object a) {
        return null;
    }

    @Override
    public String convertToSQLString(Object a) {
        return null;
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        return false;
    }

    @Override
    public Type getAggregateType(Type other) {
        return null;
    }

    @Override
    public Type getCombinedType(Session session, Type other, int operation) {
        return null;
    }

    @Override
    public String getDefinition() {
        StringBuilder builder = new StringBuilder();
        builder.append("FLOB".toLowerCase());
        boolean needCloseBracket = false;
        if (this.autotag != null && this.autotag.booleanValue() && this.autotagFromDefinition) {
            builder.append("(").append("AUTOTAG".toLowerCase());
            needCloseBracket = true;
        }
        if (this.location != null && this.location.length() > 0 && this.locaitonFromDefinition) {
            builder.append(needCloseBracket ? " " : "(");
            builder.append("LOCATION".toLowerCase()).append(" '").append(this.location).append("'");
            needCloseBracket = true;
        }
        if (this.charset != null && this.charset.length() > 0 && this.charsetFromDefinition) {
            builder.append(needCloseBracket ? " " : "(");
            builder.append("CHARSET".toLowerCase()).append(" '").append(this.charset).append("'");
            needCloseBracket = true;
        }
        if (needCloseBracket) {
            builder.append(")");
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        FlobType otherFlob = (FlobType)other;
        return Objects.equals(this.location, otherFlob.location) && Objects.equals(this.charset, otherFlob.charset) && Objects.equals(this.autotag, otherFlob.autotag);
    }
}

