/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultLob;
import com.streamscape.ds.result.ResultLobFactory;
import com.streamscape.ds.result.ResultLobFactoryFactory;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.AbstractClobDataID;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.FlobData;

public class FlobDataID
implements FlobData {
    private long id;
    private String filename;
    private String charset;
    private String location;
    private Boolean autotag;
    private boolean linked = false;
    private long size;
    private boolean isManaged = true;
    private int usageCount;
    private boolean isValid = true;

    public FlobDataID(long id) {
        this.id = id;
    }

    public FlobDataID(long flobId, String filename, String charset, String location, Boolean autotag, boolean linked, boolean isManaged, boolean isValid) {
        this(flobId, filename, charset, location, autotag, linked, isManaged, -1, isValid);
    }

    public FlobDataID(long flobId, String filename, String charset, String location, Boolean autotag, boolean linked, boolean isManaged, int usageCount, boolean isValid) {
        this(flobId);
        this.filename = filename;
        this.charset = charset;
        this.location = location;
        this.autotag = autotag;
        this.linked = linked;
        this.isManaged = isManaged;
        this.usageCount = usageCount;
        this.isValid = isValid;
    }

    public void initialize(FlobData flobData) {
        this.filename = flobData.getFilename();
        this.charset = flobData.getCharset();
        this.location = flobData.getLocation();
        if (this.autotag == null) {
            this.autotag = flobData.getAutotag();
        }
        this.linked = flobData.getLinked();
        this.isManaged = flobData.isManaged();
        this.isValid = flobData.isValid();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public Boolean getAutotag() {
        return this.autotag;
    }

    public void setAutotag(Boolean autotag) {
        this.autotag = autotag;
    }

    @Override
    public boolean getLinked() {
        return this.linked;
    }

    @Override
    public boolean isManaged() {
        return this.isManaged;
    }

    public long getSize() {
        return this.size;
    }

    public int getUsageCount() {
        return this.usageCount;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public ClobData getClobAdapter() {
        return new AbstractClobDataID(this.id){

            @Override
            protected ResultLobFactory getResultLobFactory() {
                return FlobDataID.this.getResultLobFactory();
            }

            @Override
            public long length(SessionInterface session) {
                return FlobDataID.this.length(session);
            }
        };
    }

    @Override
    public BlobDataID getBlobAdapter() {
        return new FlobDataBlobAdapter(this.id){

            @Override
            protected ResultLobFactory getResultLobFactory() {
                return FlobDataID.this.getResultLobFactory();
            }

            @Override
            public long length(SessionInterface session) {
                return FlobDataID.this.length(session);
            }

            @Override
            public FlobData getFlobData() {
                return FlobDataID.this;
            }
        };
    }

    @Override
    public long length(SessionInterface session) {
        ResultLob resultOut = this.getResultLobFactory().newLobGetLengthRequest(this.id);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getBlockLength();
    }

    protected ResultLobFactory getResultLobFactory() {
        return ResultLobFactoryFactory.getFlobResultFactory();
    }

    public static abstract class FlobDataBlobAdapter
    extends BlobDataID {
        public FlobDataBlobAdapter(long id) {
            super(id);
        }

        public abstract FlobData getFlobData();
    }
}

