/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FacetsUtils {
    private static ThreadLocal<Boolean> isUpdateStatementLevel1 = new ThreadLocal();
    private static ThreadLocal<Boolean> isUpdateStatementLevel2 = new ThreadLocal();

    public static String facetsToString(Map facets) {
        if (facets == null) {
            facets = new HashMap();
        }
        return "{" + String.valueOf(facets.entrySet().stream().map(e -> NameManager.quoteNameIfNeeded(String.valueOf(((Map.Entry)e).getKey())) + ": " + FacetsUtils.facetsValueToString(((Map.Entry)e).getValue())).collect(Collectors.joining(","))) + "}";
    }

    public static String aspectsToString(List aspects) {
        return "[" + String.valueOf(aspects.stream().map(e -> FacetsUtils.facetsValueToString(e)).collect(Collectors.joining(","))) + "]";
    }

    public static String facetsValueToString(Object value) {
        if (value instanceof String) {
            return "'" + String.valueOf(value) + "'";
        }
        if (value instanceof TimestampData) {
            return "'" + DataspaceDateTime.getSqlTimestampString(((TimestampData)value).getMilliseconds(), 0) + "'";
        }
        if (value instanceof TimeData) {
            return "'" + DataspaceDateTime.getSqlTimeString(((TimestampData)value).getMilliseconds(), 0) + "'";
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static void validateAspectFactType(Type columnType) {
        switch (columnType.typeCode) {
            case -6: 
            case -5: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 25: 
            case 91: 
            case 92: 
            case 93: 
            case 1112: 
            case 1117: {
                break;
            }
            default: {
                throw new DataspaceException("Type '" + columnType.getNameString() + "' is not supported by Aspects/Facts. Only primitive types are supported.");
            }
        }
    }

    public static void setUpdateStatementLevel1(boolean isUpdateStatement) {
        if (isUpdateStatement) {
            isUpdateStatementLevel1.set(isUpdateStatement);
        } else {
            isUpdateStatementLevel1.remove();
        }
    }

    public static boolean isUpdateStatementLevel1() {
        Boolean isInUpdate = isUpdateStatementLevel1.get();
        return isInUpdate != null && isInUpdate == true;
    }

    public static void setUpdateStatementLevel2(boolean isUpdateStatement) {
        if (isUpdateStatement) {
            isUpdateStatementLevel2.set(isUpdateStatement);
        } else {
            isUpdateStatementLevel2.remove();
        }
    }

    public static boolean isUpdateStatementLevel2() {
        Boolean isInUpdate = isUpdateStatementLevel2.get();
        return isInUpdate != null && isInUpdate == true;
    }
}

