/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.Trace;
import com.streamscape.cli.ds.collection.Facets;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.FacetsSchemaObject;
import com.streamscape.ds.types.FacetsUtils;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.UserTypeModifier;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class FacetsType
extends Type {
    public static final FacetsType DEFAULT = new FacetsType();
    private final FacetsSchemaObject facetsSchemaObject;

    private FacetsType() {
        super(1122, 1122, 0L, 0);
        this.facetsSchemaObject = null;
    }

    public FacetsType(FacetsSchemaObject facetsSchemaObject) {
        super(1122, 1122, 0L, 0);
        this.userTypeModifier = new UserTypeModifier(facetsSchemaObject.getObjectName(), 41, this);
        this.facetsSchemaObject = facetsSchemaObject;
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode;
    }

    @Override
    public String getJDBCClassName() {
        return Facets.class.getName();
    }

    @Override
    public Class<?> getJDBCClass() {
        return Facets.class;
    }

    @Override
    public Class<?> getInternalClass(Session session) {
        return Facets.class;
    }

    @Override
    public String getNameString() {
        return this.userTypeModifier != null ? "FACETS(" + this.userTypeModifier.getName().getNameString() + ")" : "FACETS";
    }

    @Override
    public String getDefinition() {
        return this.userTypeModifier != null ? "FACETS(" + this.userTypeModifier.getName().getNameString() + ")" : "FACETS";
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        a = OtherTypeWrapper.unwrap(a);
        b = OtherTypeWrapper.unwrap(b);
        Object aFacets = a;
        Object bFacets = b;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Facets) {
            aFacets = (Facets)a;
        } else if (a instanceof String) {
            try {
                aFacets = (Facets)new OtherTypeWrapper(StringConverter.hexStringToByteArray((String)a)).getObject();
            }
            catch (IOException e) {
                aFacets = a;
                Trace.logException(this, e, true);
            }
        }
        if (b instanceof Facets) {
            bFacets = (Facets)b;
        } else if (b instanceof String) {
            try {
                bFacets = (Facets)new OtherTypeWrapper(StringConverter.hexStringToByteArray((String)b)).getObject();
            }
            catch (IOException e) {
                bFacets = b;
                Trace.logException(this, e, true);
            }
        }
        if (!(aFacets instanceof Facets)) {
            throw Error.incompatibleComparisonTypesError("Facets", aFacets);
        }
        if (!(bFacets instanceof Facets)) {
            throw Error.incompatibleComparisonTypesError("Facets", bFacets);
        }
        return Objects.equals(aFacets, bFacets) ? 0 : -1;
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        return a;
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type type) {
        if ((a = OtherTypeWrapper.unwrap(a)) instanceof String) {
            try {
                a = new OtherTypeWrapper(StringConverter.hexStringToByteArray((String)a), true);
                a = OtherTypeWrapper.unwrap(a);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (a == null) {
            return null;
        }
        if (!(a instanceof Map)) {
            throw new DataspaceException("Cannot convert value " + String.valueOf(a) + " of type " + type.getDefinition() + " to type " + this.getDefinition() + ".");
        }
        if (this.facetsSchemaObject == null) {
            return new Facets((Map)a);
        }
        Map map = (Map)OtherTypeWrapper.unwrap(a);
        Facets resultFacets = new Facets();
        for (Map.Entry entry : map.entrySet()) {
            ColumnSchema column = this.facetsSchemaObject.getColumnsMap().get(entry.getKey());
            Object value = entry.getValue();
            if (column == null) {
                if (this.facetsSchemaObject.isStatic()) {
                    throw new DataspaceException("Invalid key '" + (String)entry.getKey() + "' specified for " + this.getDefinition() + "'.");
                }
            } else {
                value = column.getDataType().convertJavaToSQL(session, value);
            }
            resultFacets.put((String)entry.getKey(), value);
        }
        return new OtherTypeWrapper(resultFacets);
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object o) {
        if ((o = OtherTypeWrapper.unwrap(o)) == null) {
            return null;
        }
        if (o instanceof Facets) {
            return o;
        }
        if (o instanceof Map) {
            return new OtherTypeWrapper(new Facets((Map)o));
        }
        throw new DataspaceException(String.valueOf(o.getClass()) + " cannot be converted to facets");
    }

    @Override
    public String convertToString(Object a) {
        return this.convertToSQLString(a);
    }

    @Override
    public String convertToSQLString(Object a) {
        Object u = OtherTypeWrapper.unwrap(a);
        if (u == null) {
            return "null";
        }
        return u instanceof Map ? FacetsUtils.facetsToString((Map)u) : u.toString();
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        return otherType instanceof FacetsType;
    }

    @Override
    public Type getAggregateType(Type other) {
        throw new DataspaceException("getAggregateType not implemented for facets.");
    }

    @Override
    public Type getCombinedType(Session session, Type other, int operation) {
        throw new DataspaceException("getCombinedType not implemented for facets.");
    }

    @Override
    public Object convertSQLToJava(SessionInterface session, Object a) {
        return OtherTypeWrapper.unwrap(a);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        return new OtherTypeWrapper(OtherTypeWrapper.unwrap(a));
    }

    @Override
    public String getSQL() {
        return this.getTypeDefinition();
    }

    @Override
    public String getTypeDefinition() {
        return this.getDefinition();
    }

    public FacetsSchemaObject getFacetsSchemaObject() {
        return this.facetsSchemaObject;
    }
}

