/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.session.Session;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FacetsSchemaObject
implements SchemaObject {
    private NameManager.ObjectName name;
    private List<ColumnSchema> columns;
    private Map<String, ColumnSchema> columnsMap;
    private boolean isIndexed;
    private boolean isStatic;
    private String description;

    public FacetsSchemaObject(NameManager.ObjectName name, List<ColumnSchema> columns, boolean isIndexed, boolean isStatic, String description) {
        this.name = name;
        this.columns = columns;
        this.isIndexed = isIndexed;
        this.isStatic = isStatic;
        this.description = description;
        this.columnsMap = new LinkedHashMap<String, ColumnSchema>();
        columns.forEach(c -> this.columnsMap.put(c.getNameString(), (ColumnSchema)c));
    }

    @Override
    public int getObjectType() {
        return 41;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        return set;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.name.getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ').append("FACETS").append(' ');
        sb.append(name);
        sb.append('(');
        sb.append(this.columns.stream().map(p -> NameManager.quoteNameIfNeeded(p.getObjectName().getStatementName()) + " " + p.dataType.getDefinition()).collect(Collectors.joining(", ")));
        sb.append(')').append(' ');
        if (this.isIndexed) {
            sb.append("INDEXED ");
        }
        if (this.isStatic) {
            sb.append("STATIC ");
        }
        if (this.description != null) {
            sb.append("DESCRIPTION '").append(this.description).append("'");
        }
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public List<ColumnSchema> getColumns() {
        return this.columns;
    }

    public Map<String, ColumnSchema> getColumnsMap() {
        return this.columnsMap;
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getDescription() {
        return this.description;
    }
}

