/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.Trace;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionData;
import com.streamscape.ds.types.CloseableWrapper;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.FileSystemProvider;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.dropbox.DropBoxFileInfo;
import com.streamscape.sef.dropbox.DropBoxFileSystem;
import com.streamscape.tools.lexer.BufferUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class DropboxTypeWrapper
implements CloseableWrapper {
    private DropBoxFileSystem fileSystem;
    private Session session;

    public DropboxTypeWrapper(DropBoxFileSystem fileSystem, Session session) {
        this.fileSystem = fileSystem;
        this.session = session;
    }

    public List<DropBoxFileInfo> ls(String path) throws IOException {
        return this.fileSystem.listDropBox(path, false);
    }

    public List<DropBoxFileInfo> ls(String path, boolean recursive) throws IOException {
        return this.fileSystem.listDropBox(path, recursive);
    }

    public void put(String localFilePath, String targetFilePath) throws IOException {
        File sourceFile = new File(BufferUtils.unslashPath(localFilePath));
        File targetFile = new File(BufferUtils.unslashPath(targetFilePath));
        if (this.fileSystem.exists(targetFile.getPath())) {
            FileInfo info = this.fileSystem.getInfo(targetFile.getPath());
            if (info.isFile()) {
                throw new IOException("Target file already exist.");
            }
            if (this.fileSystem.exists((targetFile = new File(targetFile.getPath(), sourceFile.getName())).getPath())) {
                throw new IOException("Target file already exist.");
            }
        }
        try (InputStream sourceInputStream = SessionData.createFileInputStream(this.session, sourceFile.getPath(), false, true, null);){
            try (OutputStream outputStream = this.fileSystem.create(targetFile.getPath());
                 BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
                FileIOUtils.copy((InputStream)new BufferedInputStream(sourceInputStream), (OutputStream)bufferedOutputStream);
            }
            catch (UtilitiesException e) {
                throw new IOException(e);
            }
        }
    }

    public void get(String remoteFilePath, String localFilePath) throws IOException {
        File sourceFile = new File(BufferUtils.unslashPath(remoteFilePath));
        File targetFile = new File(BufferUtils.unslashPath(localFilePath));
        try (FileSystem targetFileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(this.session, targetFile.getPath());){
            if (targetFileSystem.exists(targetFile.getPath())) {
                FileInfo info = targetFileSystem.getInfo(targetFile.getPath());
                if (info.isFile()) {
                    throw new IOException("Target file already exist.");
                }
                if (targetFileSystem.exists((targetFile = new File(targetFile.getPath(), sourceFile.getName())).getPath())) {
                    throw new IOException("Target file already exist.");
                }
            }
            try (InputStream sourceInputStream = this.fileSystem.open(sourceFile.getPath());){
                try (OutputStream outputStream = targetFileSystem.create(targetFile.getPath());
                     BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
                    FileIOUtils.copy((InputStream)new BufferedInputStream(sourceInputStream), outputStream);
                }
                catch (UtilitiesException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    public void copy(String sourceFilePath, String targetFileOrDirectoryPath) throws IOException {
        this.fileSystem.copy(BufferUtils.unslashPath(sourceFilePath), BufferUtils.unslashPath(targetFileOrDirectoryPath));
    }

    public void move(String sourceFilePath, String targetFileOrDirectoryPath) throws IOException {
        this.fileSystem.move(BufferUtils.unslashPath(sourceFilePath), BufferUtils.unslashPath(targetFileOrDirectoryPath));
    }

    public void rename(String sourceFilePath, String targetFilePath) throws IOException {
        this.fileSystem.rename(BufferUtils.unslashPath(sourceFilePath), BufferUtils.unslashPath(targetFilePath));
    }

    public boolean delete(String fileOrDirectoryPath, boolean recursive) throws IOException {
        return this.fileSystem.delete(BufferUtils.unslashPath(fileOrDirectoryPath), recursive);
    }

    public void createFile(String filePath) throws IOException {
        this.fileSystem.createNewFile(BufferUtils.unslashPath(filePath));
    }

    public void createDirectory(String directoryPath) throws IOException {
        this.fileSystem.mkdir(BufferUtils.unslashPath(directoryPath));
    }

    public boolean exists(String fileOrDirectoryPath) throws IOException {
        return this.fileSystem.exists(BufferUtils.unslashPath(fileOrDirectoryPath));
    }

    public FileInfo getInfo(String fileOrDirectoryPath) throws IOException {
        return this.fileSystem.getInfo(BufferUtils.unslashPath(fileOrDirectoryPath));
    }

    @Override
    public void close() {
        try {
            this.fileSystem.close();
        }
        catch (IOException e) {
            Trace.logError(this, "Failed to close dropbox file system.");
            Trace.logException(this, e, true);
        }
    }
}

