/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.DTIType;
import com.streamscape.ds.types.IntervalMonthData;
import com.streamscape.ds.types.IntervalSecondData;
import com.streamscape.ds.types.IntervalType;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public final class DateTimeType
extends DTIType {
    public final boolean withTimeZone;
    private String nameString;
    public static final long epochSeconds = DataspaceDateTime.getSqlDateMilliseconds("1-01-01") / 1000L;
    public static final TimestampData epochTimestamp = new TimestampData(epochSeconds);

    public DateTimeType(int typeGroup, int type, int scale) {
        super(typeGroup, type, 0L, scale);
        this.withTimeZone = type == 94 || type == 95;
        this.nameString = this.getNameStringPrivate();
    }

    @Override
    public int displaySize() {
        switch (this.typeCode) {
            case 91: {
                return 10;
            }
            case 92: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 94: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
            case 93: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 95: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode;
    }

    public Class getJDBCClass() {
        switch (this.typeCode) {
            case 91: {
                return Date.class;
            }
            case 92: 
            case 94: {
                return Time.class;
            }
            case 93: 
            case 95: {
                return Timestamp.class;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Class getInternalClass(Session session) {
        switch (this.typeCode) {
            case 91: {
                return Date.class;
            }
            case 92: 
            case 94: {
                return Time.class;
            }
            case 93: 
            case 95: {
                return Timestamp.class;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getJDBCClassName() {
        switch (this.typeCode) {
            case 91: {
                return "java.sql.Date";
            }
            case 92: 
            case 94: {
                return "java.sql.Time";
            }
            case 93: 
            case 95: {
                return "java.sql.Timestamp";
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCPrecision() {
        return this.displaySize();
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 9;
    }

    @Override
    public String getNameString() {
        return this.nameString;
    }

    private String getNameStringPrivate() {
        switch (this.typeCode) {
            case 91: {
                return "SQLDATE";
            }
            case 92: {
                return "SQLTIME";
            }
            case 94: {
                return "SQLTIME WITH TIME ZONE";
            }
            case 93: {
                return "SQLTIMESTAMP";
            }
            case 95: {
                return "SQLTIMESTAMP WITH TIME ZONE";
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getDefinition() {
        String token;
        switch (this.typeCode) {
            case 91: {
                return "SQLDATE";
            }
            case 92: 
            case 94: {
                if (this.scale == 0) {
                    return this.getNameString();
                }
                token = "SQLTIME";
                break;
            }
            case 93: 
            case 95: {
                if (this.scale == 6) {
                    return this.getNameString();
                }
                token = "SQLTIMESTAMP";
                break;
            }
            default: {
                throw Error.runtimeError(201, "DateTimeType");
            }
        }
        StringBuffer sb = new StringBuffer(16);
        sb.append(token);
        sb.append('(');
        sb.append(this.scale);
        sb.append(')');
        if (this.withTimeZone) {
            sb.append(" WITH TIME ZONE");
        }
        return sb.toString();
    }

    @Override
    public boolean isDateTimeType() {
        return true;
    }

    @Override
    public boolean isDateTimeTypeWithZone() {
        return this.withTimeZone;
    }

    @Override
    public boolean acceptsFractionalPrecision() {
        return this.typeCode != 91;
    }

    @Override
    public Type getAggregateType(Type other) {
        int startType;
        if (other == null) {
            return this;
        }
        if (other == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == other.typeCode) {
            return this.scale >= other.scale ? this : other;
        }
        if (other.typeCode == 0) {
            return this;
        }
        if (other.isCharacterType()) {
            return other.getAggregateType(this);
        }
        if (!other.isDateTimeType()) {
            throw Error.error(5562);
        }
        DateTimeType otherType = (DateTimeType)other;
        if (otherType.startIntervalType > this.endIntervalType || this.startIntervalType > otherType.endIntervalType) {
            throw Error.error(5562);
        }
        int newType = this.typeCode;
        int scale = this.scale > otherType.scale ? this.scale : otherType.scale;
        boolean zone = this.withTimeZone || otherType.withTimeZone;
        int n = startType = otherType.startIntervalType > this.startIntervalType ? this.startIntervalType : otherType.startIntervalType;
        newType = startType == 104 ? (zone ? 94 : 92) : (zone ? 95 : 93);
        return DateTimeType.getDateTimeType(newType, scale);
    }

    @Override
    public Type getCombinedType(Session session, Type other, int operation) {
        switch (operation) {
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                int startType;
                if (this.typeCode == other.typeCode) {
                    return this;
                }
                if (other.typeCode == 0) {
                    return this;
                }
                if (!other.isDateTimeType()) {
                    throw Error.error(5562);
                }
                DateTimeType otherType = (DateTimeType)other;
                if (otherType.startIntervalType > this.endIntervalType || this.startIntervalType > otherType.endIntervalType) {
                    throw Error.error(5562);
                }
                int newType = this.typeCode;
                int scale = this.scale > otherType.scale ? this.scale : otherType.scale;
                boolean zone = this.withTimeZone || otherType.withTimeZone;
                int n = startType = otherType.startIntervalType > this.startIntervalType ? this.startIntervalType : otherType.startIntervalType;
                newType = startType == 104 ? (zone ? 94 : 92) : (zone ? 95 : 93);
                return DateTimeType.getDateTimeType(newType, scale);
            }
            case 32: 
            case 33: {
                if (other.isIntervalType()) {
                    if (this.typeCode != 91 && other.scale > this.scale) {
                        return DateTimeType.getDateTimeType(this.typeCode, other.scale);
                    }
                    return this;
                }
                if (other.isDateTimeType()) {
                    if (operation != 33 || other.typeComparisonGroup != this.typeComparisonGroup) break;
                    if (this.typeCode == 91) {
                        return Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                    }
                    return Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                }
                if (!other.isNumberType()) break;
                return this;
            }
        }
        throw Error.error(5562);
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long diff = ((TimeData)a).getSeconds() - ((TimeData)b).getSeconds();
                if (diff == 0L) {
                    diff = ((TimeData)a).getNanos() - ((TimeData)b).getNanos();
                }
                return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
            }
            case 91: 
            case 93: 
            case 95: {
                long diff = ((TimestampData)a).getMilliseconds() - ((TimestampData)b).getMilliseconds();
                if (diff == 0L) {
                    diff = ((TimestampData)a).getNanos() - ((TimestampData)b).getNanos();
                }
                return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        if (a instanceof OtherTypeWrapper) {
            a = ((OtherTypeWrapper)a).getObject();
        }
        if (a == null) {
            return null;
        }
        a = this.convertSQLTimestampToTimestampData(session, a);
        if (this.scale == 9) {
            return a;
        }
        switch (this.typeCode) {
            case 91: {
                return a;
            }
            case 92: 
            case 94: {
                TimeData ti = (TimeData)a;
                int nanos = ti.getNanos();
                int newNanos = this.scaleNanos(nanos);
                if (newNanos == nanos) {
                    return ti;
                }
                return new TimeData(ti.getSeconds(), newNanos, ti.getZone());
            }
            case 93: 
            case 95: {
                TimestampData ts = (TimestampData)a;
                int nanos = ts.getNanos();
                int newNanos = this.scaleNanos(nanos);
                if (newNanos == nanos) {
                    return ts;
                }
                return new TimestampData(ts.getMilliseconds(), newNanos, ts.getZone());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    int scaleNanos(int nanos) {
        int divisor = nanoScaleFactors[this.scale];
        return nanos / divisor * divisor;
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if ((a = OtherTypeWrapper.unwrap(a)) == null) {
            return a;
        }
        if (otherType instanceof DateTimeType) {
            a = ((DateTimeType)otherType).convertSQLTimestampToTimestampData(session, a);
        }
        switch (otherType.typeCode) {
            case 40: {
                a = a.toString();
            }
            case 1: 
            case 12: 
            case 100: 
            case 1112: 
            case 1121: {
                switch (this.typeCode) {
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return session.getScanner().convertToDatetimeInterval(session, (String)a, this);
                    }
                }
                break;
            }
            case 25: 
            case 1117: {
                switch (this.typeCode) {
                    case 91: 
                    case 93: {
                        int nanos = (int)((Long)a % 1000L) * 1000000;
                        return new TimestampData((Long)a + (long)(session.getZoneSeconds() * 1000), nanos);
                    }
                    case 92: {
                        int nanos = (int)((Long)a % 1000L) * 1000000;
                        return new TimeData((int)((Long)a / 1000L) + session.getZoneSeconds(), nanos);
                    }
                }
            }
            case 1111: 
            case 1113: {
                if (java.util.Date.class.isAssignableFrom(a.getClass())) {
                    return this.convertJavaToSQL(session, a);
                }
                if (a instanceof TimestampData || a instanceof TimeData) {
                    return a;
                }
                throw Error.error(5561);
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                break;
            }
            default: {
                throw Error.error(5561);
            }
        }
        switch (this.typeCode) {
            case 91: {
                switch (otherType.typeCode) {
                    case 91: {
                        return a;
                    }
                    case 95: {
                        long milliseconds = ((TimestampData)a).getMilliseconds() + (long)(((TimestampData)a).getZone() * 1000);
                        long l = DataspaceDateTime.getNormalisedDate(milliseconds);
                        return new TimestampData(l);
                    }
                    case 93: {
                        long l = DataspaceDateTime.getNormalisedDate(((TimestampData)a).getMilliseconds());
                        return new TimestampData(l);
                    }
                }
                throw Error.error(5561);
            }
            case 94: {
                switch (otherType.typeCode) {
                    case 94: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 92: {
                        TimeData ti = (TimeData)a;
                        return new TimeData(ti.getSeconds() - session.getZoneSeconds(), this.scaleNanos(ti.getNanos()), session.getZoneSeconds());
                    }
                    case 95: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = DataspaceDateTime.convertToNormalisedTime(ts.getMilliseconds() * 1000L) / 1000L;
                        return new TimeData((int)seconds, this.scaleNanos(ts.getNanos()), ts.getZone());
                    }
                    case 93: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = ts.getMilliseconds() - (long)session.getZoneSeconds();
                        seconds = DataspaceDateTime.convertToNormalisedTime(seconds * 1000L) / 1000L;
                        return new TimeData((int)seconds, this.scaleNanos(ts.getNanos()), session.getZoneSeconds());
                    }
                }
                throw Error.error(5561);
            }
            case 92: {
                switch (otherType.typeCode) {
                    case 94: {
                        TimeData ti = (TimeData)a;
                        return new TimeData(ti.getSeconds() + ti.getZone(), this.scaleNanos(ti.getNanos()), 0);
                    }
                    case 92: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 95: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = ts.getMilliseconds() + (long)ts.getZone();
                        seconds = DataspaceDateTime.convertToNormalisedTime(seconds * 1000L) / 1000L;
                        return new TimeData((int)seconds, this.scaleNanos(ts.getNanos()), 0);
                    }
                    case 93: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = ts.getMilliseconds();
                        return new TimeData((int)(seconds / 1000L), this.scaleNanos(ts.getNanos()));
                    }
                }
                throw Error.error(5561);
            }
            case 95: {
                switch (otherType.typeCode) {
                    case 94: {
                        TimeData ti = (TimeData)a;
                        long milliseconds = session.getCurrentDate().getMilliseconds() + (long)(ti.getSeconds() * 1000);
                        return new TimestampData(milliseconds, this.scaleNanos(ti.getNanos()), ti.getZone());
                    }
                    case 92: {
                        TimeData ti = (TimeData)a;
                        long milliseconds = session.getCurrentDate().getMilliseconds() + (long)(ti.getSeconds() * 1000) - (long)(session.getZoneSeconds() * 1000);
                        return new TimestampData(milliseconds, this.scaleNanos(ti.getNanos()), session.getZoneSeconds());
                    }
                    case 95: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 93: {
                        TimestampData ts = (TimestampData)a;
                        long milliseconds = ts.getMilliseconds() - (long)(session.getZoneSeconds() * 1000);
                        return new TimestampData(milliseconds, this.scaleNanos(ts.getNanos()), session.getZoneSeconds());
                    }
                    case 91: {
                        TimestampData ts = (TimestampData)a;
                        return new TimestampData(ts.getMilliseconds(), 0, session.getZoneSeconds());
                    }
                }
                throw Error.error(5561);
            }
            case 93: {
                switch (otherType.typeCode) {
                    case 94: {
                        TimeData ti = (TimeData)a;
                        long milliseconds = session.getCurrentDate().getMilliseconds() + (long)(ti.getSeconds() * 1000) - (long)(session.getZoneSeconds() * 1000);
                        return new TimestampData(milliseconds, this.scaleNanos(ti.getNanos()), session.getZoneSeconds());
                    }
                    case 92: {
                        TimeData ti = (TimeData)a;
                        long milliseconds = session.getCurrentDate().getMilliseconds() + (long)(ti.getSeconds() * 1000);
                        return new TimestampData(milliseconds, this.scaleNanos(ti.getNanos()));
                    }
                    case 95: {
                        TimestampData ts = (TimestampData)a;
                        long milliseconds = ts.getMilliseconds() + (long)(ts.getZone() * 1000);
                        return new TimestampData(milliseconds, this.scaleNanos(ts.getNanos()));
                    }
                    case 93: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 91: {
                        return a;
                    }
                }
                throw Error.error(5561);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        DateTimeType otherType = null;
        if (a instanceof Time) {
            otherType = Type.SQL_TIME;
        } else if (a instanceof Timestamp) {
            otherType = Type.SQL_TIMESTAMP;
        } else if (a instanceof Date) {
            otherType = Type.SQL_DATE;
        } else {
            DateTimeType dateTimeType = otherType = a instanceof TimeData ? Type.SQL_TIME : Type.SQL_TIMESTAMP;
        }
        if (otherType instanceof DateTimeType) {
            a = otherType.convertSQLTimestampToTimestampData(session, a);
        }
        return this.convertToType(session, a, otherType);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof String) {
            switch (this.typeCode) {
                case 92: 
                case 94: {
                    break;
                }
                case 91: {
                    a = DataspaceDateTime.getSqlDateMilliseconds((String)a);
                    break;
                }
                case 93: 
                case 95: {
                    a = DataspaceDateTime.getSqlTimestampMilliseconds((String)a, session.getTimeZone().getID());
                }
            }
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (a instanceof Date) break;
                if (a instanceof java.util.Date) {
                    return this.convertSQLTimestampToTimestampData(session, a);
                }
            }
            case 91: {
                if (a instanceof Time) break;
                if (a instanceof java.util.Date) {
                    return this.convertSQLTimestampToTimestampData(session, a);
                }
            }
            case 93: 
            case 95: {
                if (a instanceof Time) break;
                if (a instanceof java.util.Date) {
                    return this.convertSQLTimestampToTimestampData(session, a);
                }
                if (!(a instanceof Long)) break;
                return new TimestampData((Long)a + (long)(session.getZoneSeconds() * 1000), 0, 0);
            }
        }
        throw Error.error(5561);
    }

    private Object convertSQLTimestampToTimestampData(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long millis;
                if (a instanceof TimeData || !(a instanceof java.util.Date)) break;
                int nanos = 0;
                int zoneSeconds = 0;
                if (this.typeCode == 92) {
                    millis = DataspaceDateTime.convertMillisFromCalendar(session.getCalendar(), ((java.util.Date)a).getTime());
                } else {
                    millis = ((java.util.Date)a).getTime();
                    zoneSeconds = session.getZoneSeconds();
                }
                millis = DataspaceDateTime.getNormalisedTime(millis);
                if (a instanceof Timestamp) {
                    nanos = ((Timestamp)a).getNanos();
                    nanos = DateTimeType.normaliseFraction(nanos, this.scale);
                }
                return new TimeData((int)millis / 1000, nanos, zoneSeconds);
            }
            case 91: {
                if (a instanceof TimestampData || !(a instanceof java.util.Date)) break;
                long millis = DataspaceDateTime.convertMillisFromCalendar(session.getCalendar(), ((java.util.Date)a).getTime());
                millis = DataspaceDateTime.getNormalisedDate(millis);
                return new TimestampData(millis);
            }
            case 93: 
            case 95: {
                if (a instanceof TimestampData) break;
                if (a instanceof java.util.Date) {
                    long millis;
                    int nanos = 0;
                    int zoneSeconds = 0;
                    if (this.typeCode == 93) {
                        millis = DataspaceDateTime.convertMillisFromCalendar(session.getCalendar(), ((java.util.Date)a).getTime());
                        nanos = (int)(millis % 1000L);
                        nanos *= DTIType.nanoScaleFactors[3];
                    } else {
                        millis = ((java.util.Date)a).getTime();
                        zoneSeconds = DataspaceDateTime.getZoneMillis(session.getCalendar(), millis) / 1000;
                    }
                    if (a instanceof Timestamp) {
                        nanos = ((Timestamp)a).getNanos();
                        nanos = DateTimeType.normaliseFraction(nanos, this.scale);
                    }
                    return new TimestampData(millis, nanos, zoneSeconds);
                }
                if (!(a instanceof Long)) break;
                return new TimestampData((Long)a + (long)(session.getZoneSeconds() * 1000), 0, 0);
            }
        }
        return a;
    }

    public Object convertSQLToJavaGMT(SessionInterface session, Object a) {
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long millis = ((TimeData)a).getSeconds() * 1000;
                return new Time(millis += (long)(((TimeData)a).getNanos() / 1000000));
            }
            case 91: {
                long millis = ((TimestampData)a).getMilliseconds();
                return new Date(millis);
            }
            case 93: 
            case 95: {
                long millis = ((TimestampData)a).getMilliseconds();
                Timestamp value = new Timestamp(millis);
                value.setNanos(((TimestampData)a).getNanos());
                return value;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertSQLToJava(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 92: {
                Calendar cal = session.getCalendar();
                long millis = DataspaceDateTime.convertMillisToCalendar(cal, ((TimeData)a).getSeconds() * 1000);
                millis = DataspaceDateTime.getNormalisedTime(cal, millis);
                Time value = new Time(millis);
                return value;
            }
            case 94: {
                long millis = ((TimeData)a).getSeconds() * 1000;
                long offset = ((TimeData)a).getZone() * 1000 - session.getTimeZone().getOffset(0L);
                return new Time(millis += offset);
            }
            case 91: {
                Calendar cal = session.getCalendar();
                long millis = DataspaceDateTime.convertMillisToCalendar(cal, ((TimestampData)a).getMilliseconds());
                Date value = new Date(millis);
                return value;
            }
            case 93: {
                Calendar cal = session.getCalendar();
                long millis = DataspaceDateTime.convertMillisToCalendar(cal, ((TimestampData)a).getMilliseconds());
                Timestamp value = new Timestamp(millis);
                value.setNanos(((TimestampData)a).getNanos());
                return value;
            }
            case 95: {
                Timestamp value = new Timestamp(((TimestampData)a).getMilliseconds());
                value.setNanos(((TimestampData)a).getNanos());
                return value;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public static int normaliseTime(int seconds) {
        while (seconds < 0) {
            seconds += 86400;
        }
        if (seconds > 86400) {
            seconds %= 86400;
        }
        return seconds;
    }

    @Override
    public String convertToString(Object a) {
        boolean zone = false;
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 91: {
                return DataspaceDateTime.getSqlDateStringGMT(((TimestampData)a).getMilliseconds());
            }
            case 92: 
            case 94: {
                TimeData t = (TimeData)a;
                int seconds = DateTimeType.normaliseTime(t.getSeconds() + t.getZone());
                String s = this.intervalSecondToString(seconds, t.getNanos(), false);
                if (!this.withTimeZone) {
                    return s;
                }
                StringBuffer sb = new StringBuffer(s);
                s = Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(((TimeData)a).getZone(), 0, true);
                sb.append(s);
                return sb.toString();
            }
            case 93: 
            case 95: {
                TimestampData ts = (TimestampData)a;
                StringBuffer sb = new StringBuffer();
                DataspaceDateTime.getSqlTimestampStringGMT(sb, ts.getMilliseconds() + (long)ts.getZone(), ts.getNanos(), this.scale);
                if (!this.withTimeZone) {
                    return sb.toString();
                }
                String s = Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(((TimestampData)a).getZone(), 0, true);
                sb.append(s);
                return sb.toString();
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        StringBuffer sb = new StringBuffer(32);
        switch (this.typeCode) {
            case 91: {
                sb.append("SQLDATE");
                break;
            }
            case 92: 
            case 94: {
                sb.append("SQLTIME");
                break;
            }
            case 93: 
            case 95: {
                sb.append("SQLTIMESTAMP");
            }
        }
        sb.append(StringConverter.toQuotedString(this.convertToString(a), '\'', false));
        return sb.toString();
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        if (otherType.typeCode == 0) {
            return true;
        }
        if (otherType.isCharacterType()) {
            return true;
        }
        if (otherType.isObjectType() && otherType.userTypeModifier != null && otherType.userTypeModifier.getName() != null && otherType.userTypeModifier.getName().name.toUpperCase().equals("DATE")) {
            return true;
        }
        if (!otherType.isDateTimeType()) {
            return false;
        }
        if (otherType.typeCode == 91) {
            return this.typeCode != 92;
        }
        if (otherType.typeCode == 92) {
            return this.typeCode != 91;
        }
        return true;
    }

    @Override
    public int canMoveFrom(Type otherType) {
        if (otherType == this) {
            return 0;
        }
        if (this.typeCode == otherType.typeCode) {
            return this.scale >= otherType.scale ? 0 : -1;
        }
        return -1;
    }

    @Override
    public Object add(Object a, Object b, Type otherType) {
        if (a == null || b == null) {
            return null;
        }
        if (otherType.isNumberType()) {
            if (this.typeCode == 91) {
                b = ((NumberType)otherType).floor(b);
            }
            b = Type.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(IntervalSecondData.oneDay, b);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (b instanceof IntervalMonthData) {
                    throw Error.runtimeError(201, "DateTimeType");
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)a, (int)((IntervalSecondData)b).units, ((IntervalSecondData)b).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (b instanceof IntervalMonthData) {
                    return DateTimeType.addMonths((TimestampData)a, (int)((IntervalMonthData)b).units);
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)a, (long)((int)((IntervalSecondData)b).units), ((IntervalSecondData)b).nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object subtract(Object a, Object b, Type otherType) {
        if (a == null || b == null) {
            return null;
        }
        if (otherType.isNumberType()) {
            if (this.typeCode == 91) {
                b = ((NumberType)otherType).floor(b);
            }
            b = Type.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(IntervalSecondData.oneDay, b);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (b instanceof IntervalMonthData) {
                    throw Error.runtimeError(201, "DateTimeType");
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)a, -((int)((IntervalSecondData)b).units), -((IntervalSecondData)b).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (b instanceof IntervalMonthData) {
                    return DateTimeType.addMonths((TimestampData)a, -((int)((IntervalMonthData)b).units));
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)a, (long)(-((int)((IntervalSecondData)b).units)), -((IntervalSecondData)b).nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Object truncate(Object a, int part) {
        if (a == null) {
            return null;
        }
        long millis = this.getMillis(a);
        millis = DataspaceDateTime.getTruncatedPart(millis, part);
        switch (this.typeCode) {
            case 92: 
            case 94: {
                return new TimeData((int)(millis / 1000L), 0, ((TimeData)a).getZone());
            }
            case 91: 
            case 93: 
            case 95: {
                return new TimestampData(millis, 0, ((TimestampData)a).getZone());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Object round(Object a, int part) {
        if (a == null) {
            return null;
        }
        long millis = this.getMillis(a);
        millis = DataspaceDateTime.getRoundedPart(millis, part);
        switch (this.typeCode) {
            case 92: 
            case 94: {
                return new TimeData((int)(millis / 1000L), 0, ((TimeData)a).getZone());
            }
            case 91: 
            case 93: 
            case 95: {
                return new TimestampData(millis, 0, ((TimestampData)a).getZone());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Type) {
            return super.equals(other) && ((DateTimeType)other).withTimeZone == this.withTimeZone;
        }
        return false;
    }

    @Override
    public int getPart(Session session, Object dateTime, int part) {
        int calendarPart;
        int increment = 0;
        int divisor = 1;
        switch (part) {
            case 101: {
                calendarPart = 1;
                break;
            }
            case 102: {
                increment = 1;
                calendarPart = 2;
                break;
            }
            case 103: 
            case 260: {
                calendarPart = 5;
                break;
            }
            case 104: {
                calendarPart = 11;
                break;
            }
            case 105: {
                calendarPart = 12;
                break;
            }
            case 106: {
                calendarPart = 13;
                break;
            }
            case 259: {
                calendarPart = 7;
                break;
            }
            case 262: {
                calendarPart = 3;
                break;
            }
            case 266: {
                if (this.typeCode != 92 && this.typeCode != 94) {
                    try {
                        DateTimeType target = this.withTimeZone ? Type.SQL_TIME_WITH_TIME_ZONE : Type.SQL_TIME;
                        dateTime = target.castToType(session, dateTime, this);
                    }
                    catch (DataspaceException target) {
                        // empty catch block
                    }
                }
                return ((TimeData)dateTime).getSeconds();
            }
            case 257: {
                if (this.typeCode == 95) {
                    return ((TimestampData)dateTime).getZone() / 3600;
                }
                return ((TimeData)dateTime).getZone() / 3600;
            }
            case 258: {
                if (this.typeCode == 95) {
                    return ((TimestampData)dateTime).getZone() / 60 % 60;
                }
                return ((TimeData)dateTime).getZone() / 60 % 60;
            }
            case 263: {
                increment = 1;
                divisor = 3;
                calendarPart = 2;
                break;
            }
            case 261: {
                calendarPart = 6;
                break;
            }
            default: {
                throw Error.runtimeError(201, "DateTimeType - " + part);
            }
        }
        long millis = this.getMillis(dateTime);
        return DataspaceDateTime.getDateTimePart(millis, calendarPart) / divisor + increment;
    }

    long getMillis(Object dateTime) {
        if (this.typeCode == 92 || this.typeCode == 94) {
            return (((TimeData)dateTime).getSeconds() + ((TimeData)dateTime).getZone()) * 1000;
        }
        return ((TimestampData)dateTime).getMilliseconds() + (long)(((TimestampData)dateTime).getZone() * 1000);
    }

    @Override
    public BigDecimal getSecondPart(Object dateTime) {
        long seconds = this.getPart(null, dateTime, 106);
        int nanos = 0;
        if (this.typeCode == 93) {
            nanos = ((TimestampData)dateTime).getNanos();
        } else if (this.typeCode == 92) {
            nanos = ((TimeData)dateTime).getNanos();
        }
        return this.getSecondPart(seconds, nanos);
    }

    public String getPartString(Session session, Object dateTime, int part) {
        String javaPattern = "";
        switch (part) {
            case 264: {
                javaPattern = "EEEE";
                break;
            }
            case 265: {
                javaPattern = "MMMM";
            }
        }
        SimpleDateFormat format = session.getSimpleDateFormatGMT();
        try {
            format.applyPattern(javaPattern);
        }
        catch (Exception exception) {
            // empty catch block
        }
        java.util.Date date = (java.util.Date)this.convertSQLToJavaGMT(session, dateTime);
        return format.format(date);
    }

    public Object getValue(long seconds, int nanos, int zoneSeconds) {
        long milliseconds = 0L;
        switch (this.typeCode) {
            case 91: {
                milliseconds = DataspaceDateTime.getNormalisedDate((seconds + (long)zoneSeconds) * 1000L);
                return new TimestampData(milliseconds);
            }
            case 94: {
                milliseconds = DataspaceDateTime.getNormalisedDate(seconds * 1000L);
                return new TimeData((int)seconds, nanos, zoneSeconds);
            }
            case 92: {
                seconds = DataspaceDateTime.getNormalisedTime((seconds + (long)zoneSeconds) * 1000L) / 1000L;
                return new TimeData((int)seconds, nanos);
            }
            case 95: {
                return new TimestampData(seconds * 1000L, nanos, zoneSeconds);
            }
            case 93: {
                return new TimestampData((seconds + (long)zoneSeconds) * 1000L, nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public DateTimeType getDateTimeTypeWithoutZone() {
        if (this.withTimeZone) {
            DateTimeType type = switch (this.typeCode) {
                case 94 -> new DateTimeType(92, 92, this.scale);
                case 95 -> new DateTimeType(93, 93, this.scale);
                default -> throw Error.runtimeError(201, "DateTimeType");
            };
            type.nameString = this.nameString;
            return type;
        }
        return this;
    }

    public static DateTimeType getDateTimeType(int type, int scale) {
        if (scale > 9) {
            throw Error.error(5592);
        }
        switch (type) {
            case 91: {
                return SQL_DATE;
            }
            case 92: {
                if (scale == 0) {
                    return SQL_TIME;
                }
                return new DateTimeType(92, type, scale);
            }
            case 94: {
                if (scale == 0) {
                    return SQL_TIME_WITH_TIME_ZONE;
                }
                return new DateTimeType(92, type, scale);
            }
            case 93: {
                if (scale == 6) {
                    return SQL_TIMESTAMP;
                }
                return new DateTimeType(93, type, scale);
            }
            case 95: {
                if (scale == 6) {
                    return SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                return new DateTimeType(95, type, scale);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Object changeZone(Object a, Type otherType, int targetZone, int localZone) {
        if (a == null) {
            return null;
        }
        if (otherType.typeCode == 95 || otherType.typeCode == 94) {
            localZone = 0;
        }
        if (targetZone > 50400 || -targetZone > 50400) {
            throw Error.error(3409);
        }
        switch (this.typeCode) {
            case 94: {
                TimeData value = (TimeData)a;
                if (localZone == 0 && value.zone == targetZone) break;
                return new TimeData(value.getSeconds() - localZone, value.getNanos(), targetZone);
            }
            case 95: {
                TimestampData value = (TimestampData)a;
                if (localZone == 0 && value.zone == targetZone) break;
                return new TimestampData(value.getMilliseconds() - (long)(localZone * 1000), value.getNanos(), targetZone);
            }
        }
        return a;
    }

    public boolean canAdd(IntervalType other) {
        return other.startPartIndex >= this.startPartIndex && other.endPartIndex <= this.endPartIndex;
    }

    public int getSqlDateTimeSub() {
        switch (this.typeCode) {
            case 91: {
                return 1;
            }
            case 92: {
                return 2;
            }
            case 93: {
                return 3;
            }
        }
        return 0;
    }

    public static Boolean overlaps(Session session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Object[] temp;
        if (a == null || b == null) {
            return null;
        }
        if (a[0] == null || b[0] == null) {
            return null;
        }
        if (a[1] == null) {
            a[1] = a[0];
        }
        if (b[1] == null) {
            b[1] = b[0];
        }
        Type commonType = ta[0].getCombinedType(session, tb[0], 41);
        a[0] = commonType.castToType(session, a[0], ta[0]);
        b[0] = commonType.castToType(session, b[0], tb[0]);
        a[1] = ta[1].isIntervalType() ? commonType.add(a[0], a[1], ta[1]) : commonType.castToType(session, a[1], ta[1]);
        b[1] = tb[1].isIntervalType() ? commonType.add(b[0], b[1], tb[1]) : commonType.castToType(session, b[1], tb[1]);
        if (commonType.compare(session, a[0], a[1]) > 0) {
            temp = a[0];
            a[0] = a[1];
            a[1] = temp;
        }
        if (commonType.compare(session, b[0], b[1]) > 0) {
            temp = b[0];
            b[0] = b[1];
            b[1] = temp;
        }
        if (commonType.compare(session, a[0], b[0]) > 0) {
            temp = a;
            a = b;
            b = temp;
        }
        if (commonType.compare(session, a[1], b[0]) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int subtractMonths(TimestampData a, TimestampData b, boolean isYear) {
        Calendar calendar = DataspaceDateTime.tempCalGMT;
        synchronized (calendar) {
            boolean negate = false;
            if (b.getMilliseconds() > a.getMilliseconds()) {
                negate = true;
                TimestampData temp = a;
                a = b;
                b = temp;
            }
            DataspaceDateTime.setTimeInMillis(DataspaceDateTime.tempCalGMT, a.getMilliseconds());
            int months = DataspaceDateTime.tempCalGMT.get(2);
            int years = DataspaceDateTime.tempCalGMT.get(1);
            DataspaceDateTime.setTimeInMillis(DataspaceDateTime.tempCalGMT, b.getMilliseconds());
            months -= DataspaceDateTime.tempCalGMT.get(2);
            years -= DataspaceDateTime.tempCalGMT.get(1);
            if (isYear) {
                months = years * 12;
            } else {
                if (months < 0) {
                    months += 12;
                    --years;
                }
                months += years * 12;
            }
            if (negate) {
                months = -months;
            }
            return months;
        }
    }

    public static TimeData addSeconds(TimeData source, int seconds, int nanos) {
        seconds += (nanos += source.getNanos()) / 1000000000;
        if ((nanos %= 1000000000) < 0) {
            nanos += 1000000000;
            --seconds;
        }
        seconds += source.getSeconds();
        TimeData ti = new TimeData(seconds %= 86400, nanos, source.getZone());
        return ti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimestampData addMonths(TimestampData source, int months) {
        int n = source.getNanos();
        Calendar calendar = DataspaceDateTime.tempCalGMT;
        synchronized (calendar) {
            DataspaceDateTime.setTimeInMillis(DataspaceDateTime.tempCalGMT, source.getMilliseconds());
            DataspaceDateTime.tempCalGMT.add(2, months);
            TimestampData ts = new TimestampData(DataspaceDateTime.tempCalGMT.getTimeInMillis(), n, source.getZone());
            return ts;
        }
    }

    public static TimestampData addSeconds(TimestampData source, long seconds, int nanos) {
        seconds += (long)((nanos += source.getNanos()) / 1000000000);
        if ((nanos %= 1000000000) < 0) {
            nanos += 1000000000;
            --seconds;
        }
        long newMillieSeconds = source.getMilliseconds() + seconds * 1000L;
        TimestampData ts = new TimestampData(newMillieSeconds, nanos, source.getZone());
        return ts;
    }

    @Override
    public boolean canBeAssignedFrom(Type otherType) {
        if (otherType == null) {
            return super.canBeAssignedFrom(otherType);
        }
        if (otherType.isCharacterType()) {
            return true;
        }
        return super.canBeAssignedFrom(otherType);
    }
}

