/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.cli.ds.DataCollection;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.stable.rplmethod.RPLMethod;
import com.streamscape.ds.stable.rplmethod.RPLMethodHidden;
import com.streamscape.ds.types.AccessorTypeWrapper;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import java.util.function.Supplier;

public class DataspaceTypeWrapper
implements AccessorTypeWrapper {
    private transient Supplier<DataspaceAccessor> accessorSupplier;
    @RPLMethodHidden
    private transient DataspaceAccessor accessor = null;
    @RPLMethodHidden
    private transient Supplier<Session> currentSessionSupplier = null;
    @RPLMethodHidden
    private transient long replyTimeout = -1L;
    private static final String ACCESSOR_QUERY_ADDITIONAL_HELP = "If query is executed in THIS function unit, then there is a single accessor per this session.\nIf dataspace accessor was created using sys.lookup method then new accessor is created on each lookup invocation.\nAll accessors are closed when current session is closed.\nAccessor timeout will be derived from the current session timeout(method session.getTimeout()) or can be set using setReplyTimeout() method.\n";

    public DataspaceTypeWrapper(Supplier<DataspaceAccessor> accessorSupplier, Supplier<Session> currentSessionSupplier) {
        this.accessorSupplier = accessorSupplier;
        this.currentSessionSupplier = currentSessionSupplier;
    }

    public DataspaceTypeWrapper(DataspaceAccessor accessor, Supplier<Session> currentSessionSupplier) {
        this.accessor = accessor;
        this.currentSessionSupplier = currentSessionSupplier;
    }

    public DataspaceAccessor getAccessor() {
        DataspaceAccessor accessorToReturn = this.accessor;
        if (accessorToReturn == null) {
            accessorToReturn = this.accessorSupplier.get();
        }
        if (this.replyTimeout != -1L) {
            accessorToReturn.setRequestTimeout(this.replyTimeout);
        } else {
            accessorToReturn.setRequestTimeout(this.currentSessionSupplier.get().getRequestTimeout());
        }
        return accessorToReturn;
    }

    public DataspaceTypeWrapper getCurrentDataspace() {
        return new DataspaceTypeWrapper(() -> this.accessorSupplier.get(), this.currentSessionSupplier);
    }

    public DataCollection lookupCollection(String name) {
        DataspaceAccessor accessor = this.getAccessor();
        if (accessor != null) {
            try {
                DataCollection collection = accessor.lookupCollection(name);
                if (collection == null) {
                    throw new DataspaceException("Collection '" + name + "' does not exist.");
                }
                return collection;
            }
            catch (Exception error) {
                throw new DataspaceException(error.getMessage());
            }
        }
        return null;
    }

    @RPLMethod(description="Executes statement in dataspace accessor slang session.\n\nIf query is executed in THIS function unit, then there is a single accessor per this session.\nIf dataspace accessor was created using sys.lookup method then new accessor is created on each lookup invocation.\nAll accessors are closed when current session is closed.\nAccessor timeout will be derived from the current session timeout(method session.getTimeout()) or can be set using setReplyTimeout() method.\n")
    public RowSet query(String sql) throws Throwable {
        SLResponse response = null;
        DataspaceAccessor accessor = this.getAccessor();
        if (accessor != null) {
            try {
                response = accessor.invokeLanguageRequest(sql);
            }
            catch (Exception error) {
                throw new DataspaceException(error.getMessage());
            }
        }
        if (response != null && !response.isOK()) {
            if (response.getException() != null && response.getException().getMessage().equals("Execution interrupted.")) {
                accessor.close();
                throw response.getException();
            }
            String error = null;
            error = response.getException() != null ? response.getException().getMessage() : response.getText();
            Object nodeName = accessor.getActualNodeName();
            if (nodeName == null) {
                nodeName = accessor.getNodeName();
            }
            nodeName = nodeName == null ? "" : (String)nodeName + "://";
            throw new DataspaceException("Failed to execute query '" + sql + "' on " + (String)nodeName + accessor.getComponentType() + "." + accessor.getComponentName() + " dataspace. " + error);
        }
        if (response != null && response.isOK() && response.getRowSet() != null) {
            return response.getRowSet();
        }
        return null;
    }

    @RPLMethod(description="Executes DSQL query in dataspace accessor.\n\nIf query is executed in THIS function unit, then there is a single accessor per this session.\nIf dataspace accessor was created using sys.lookup method then new accessor is created on each lookup invocation.\nAll accessors are closed when current session is closed.\nAccessor timeout will be derived from the current session timeout(method session.getTimeout()) or can be set using setReplyTimeout() method.\n")
    public RowSet executeQuery(String sql) throws Throwable {
        return this.executeQuery(sql, null);
    }

    @RPLMethod(description="Executes DSQL query with parameters in dataspace accessor.\n\nIf query is executed in THIS function unit, then there is a single accessor per this session.\nIf dataspace accessor was created using sys.lookup method then new accessor is created on each lookup invocation.\nAll accessors are closed when current session is closed.\nAccessor timeout will be derived from the current session timeout(method session.getTimeout()) or can be set using setReplyTimeout() method.\n")
    public RowSet executeQuery(String sql, Object ... params) throws Throwable {
        DataspaceAccessor accessor = this.getAccessor();
        if (accessor != null) {
            try {
                if (params == null || params.length == 0) {
                    return accessor.executeQuery(sql);
                }
                return accessor.executeQuery(sql, params);
            }
            catch (Exception exception) {
                Object nodeName;
                if (exception instanceof InterruptedException) {
                    Thread.interrupted();
                }
                if ((nodeName = accessor.getActualNodeName()) == null) {
                    nodeName = accessor.getNodeName();
                }
                nodeName = nodeName == null ? "" : (String)nodeName + "://";
                throw new DataspaceException("Failed to execute query '" + sql + "' on " + (String)nodeName + accessor.getComponentType() + "." + accessor.getComponentName() + " dataspace. " + Utils.formatExceptionWithUnrepeatedCauses(exception));
            }
        }
        throw new DataspaceException("Accessor is null.");
    }

    @RPLMethod(description="Returns current reply timeout in milliseconds for this accessor.\n   0 means there is no timeout and request can wait indefinitely.\n  -1 means that timeout was not set for this accessor then it is taken from session.getTimeout().\nTimeout can be set using setReplyTimeout() method.\n")
    public long getReplyTimeout() {
        return this.replyTimeout;
    }

    @RPLMethod(description="Sets reply timeout in milliseconds for this accessor.\n   0 means then there is no timeout and request can wait indefinitely.\n  -1 means that timeout was not set for this accessor then it is taken from session.getTimeout().\nTimeout will be used for all subsequent requests using this accessor.\n")
    public void setReplyTimeout(long replyTimeout) {
        this.replyTimeout = replyTimeout;
    }

    public int getFetchSize() throws DataspaceComponentException {
        DataspaceAccessor accessor = this.getAccessor();
        if (accessor != null) {
            return accessor.getFetchSize();
        }
        return 0;
    }

    public void setFetchSize(int size) throws DataspaceComponentException {
        DataspaceAccessor accessor = this.getAccessor();
        if (accessor != null) {
            accessor.setFetchSize(size);
        }
    }

    @Override
    public void close() {
        if (this.accessor != null) {
            this.accessor.close();
            this.accessor = null;
        }
    }
}

