/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.TypeInvariants;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HashMap;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.StringUtil;
import com.streamscape.ds.lib.java.JavaSystem;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Charset;
import java.text.Collator;
import java.util.Locale;

public class Collation
implements SchemaObject {
    public static final HashMap nameToJavaName = new HashMap(101);
    public static final HashMap dbNameToJavaName = new HashMap(101);
    public static final HashMap dbNameToCollation = new HashMap(11);
    static final Collation defaultCollation;
    final NameManager.ObjectName name;
    Collator collator;
    transient Locale locale;
    boolean equalIsIdentical = true;
    boolean isFinal;
    Charset charset;
    NameManager.ObjectName sourceName;
    private boolean padSpace = false;

    private Collation() {
        this.locale = Locale.ENGLISH;
        String language = this.locale.getDisplayLanguage(Locale.ENGLISH);
        this.name = NameManager.newInfoSchemaObjectName(language, true, 16);
        this.isFinal = true;
    }

    private Collation(String name, String language, String country) {
        this.locale = new Locale(language, country);
        this.collator = Collator.getInstance(this.locale);
        this.equalIsIdentical = false;
        this.name = NameManager.newInfoSchemaObjectName(name, true, 16);
        this.charset = TypeInvariants.SQL_TEXT;
        this.isFinal = true;
    }

    public Collation(NameManager.ObjectName name, Collation source, Charset charset) {
        this.name = name;
        this.locale = source.locale;
        this.collator = source.collator;
        this.equalIsIdentical = source.equalIsIdentical;
        this.isFinal = true;
        this.charset = charset;
        this.sourceName = source.name;
    }

    public static Collation getDefaultInstance() {
        return defaultCollation;
    }

    public static Collation getDatabaseInstance() {
        return defaultCollation;
    }

    public static Iterator getCollationsIterator() {
        return nameToJavaName.keySet().iterator();
    }

    public static Iterator getLocalesIterator() {
        return nameToJavaName.values().iterator();
    }

    public static synchronized Collation getCollation(String name) {
        Collation collation = (Collation)dbNameToCollation.get(name);
        if (collation != null) {
            return collation;
        }
        String javaName = (String)dbNameToJavaName.get(name);
        if (javaName == null && (javaName = (String)nameToJavaName.get(name)) == null) {
            throw Error.error(5501, javaName);
        }
        String[] parts = StringUtil.split(javaName, "-");
        String language = parts[0];
        String country = parts.length == 2 ? parts[1] : "";
        collation = new Collation(name, language, country);
        dbNameToCollation.put(name, collation);
        return collation;
    }

    public void setCollationAsLocale() {
        Locale locale = Locale.getDefault();
        String language = locale.getDisplayLanguage(Locale.ENGLISH);
        try {
            this.setCollation(language);
        }
        catch (DataspaceException dataspaceException) {
            // empty catch block
        }
    }

    public void setCollation(String newName) {
        String jname = (String)nameToJavaName.get(newName);
        if (jname == null) {
            jname = (String)dbNameToJavaName.get(newName);
        }
        if (jname == null) {
            throw Error.error(5501, newName);
        }
        if (this.isFinal) {
            throw Error.error(5503, newName);
        }
        this.name.rename(newName, true);
        String[] parts = StringUtil.split(jname, "-");
        String language = parts[0];
        String country = parts.length == 2 ? parts[1] : "";
        this.locale = new Locale(language, country);
        this.collator = Collator.getInstance(this.locale);
        this.equalIsIdentical = false;
    }

    public void setPadding(boolean temp) {
        this.padSpace = temp;
    }

    public boolean isEqualAlwaysIdentical() {
        return this.collator == null;
    }

    public int compare(String a, String b) {
        int i = this.collator == null ? a.compareTo(b) : this.collator.compare(a, b);
        return i == 0 ? 0 : (i < 0 ? -1 : 1);
    }

    public int compareIgnoreCase(String a, String b) {
        int i = this.collator == null ? JavaSystem.compareIngnoreCase(a, b) : this.collator.compare(this.toUpperCase(a), this.toUpperCase(b));
        return i == 0 ? 0 : (i < 0 ? -1 : 1);
    }

    public String toUpperCase(String s) {
        return s.toUpperCase(this.locale);
    }

    public String toLowerCase(String s) {
        return s.toLowerCase(this.locale);
    }

    public boolean isDefaultCollation() {
        return this.collator == null;
    }

    public boolean isObjectCollation() {
        return this.isFinal && this.collator != null;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public int getObjectType() {
        return 16;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    public boolean isPadSpace() {
        return this.padSpace;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.name.getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ');
        sb.append("COLLATION").append(' ');
        sb.append(name).append(' ');
        sb.append("FOR").append(' ');
        sb.append(this.charset.name.getSchemaQualifiedStatementName()).append(' ');
        sb.append("FROM").append(' ');
        sb.append(this.sourceName.statementName);
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    static {
        nameToJavaName.put("Afrikaans", "af-ZA");
        nameToJavaName.put("Amharic", "am-ET");
        nameToJavaName.put("Arabic", "ar");
        nameToJavaName.put("Assamese", "as-IN");
        nameToJavaName.put("Azerbaijani_Latin", "az-AZ");
        nameToJavaName.put("Azerbaijani_Cyrillic", "az-cyrillic");
        nameToJavaName.put("Belarusian", "be-BY");
        nameToJavaName.put("Bulgarian", "bg-BG");
        nameToJavaName.put("Bengali", "bn-IN");
        nameToJavaName.put("Tibetan", "bo-CN");
        nameToJavaName.put("Bosnian", "bs-BA");
        nameToJavaName.put("Catalan", "ca-ES");
        nameToJavaName.put("Czech", "cs-CZ");
        nameToJavaName.put("Welsh", "cy-GB");
        nameToJavaName.put("Danish", "da-DK");
        nameToJavaName.put("German", "de-DE");
        nameToJavaName.put("Greek", "el-GR");
        nameToJavaName.put("Latin1_General", "en-US");
        nameToJavaName.put("English", "en-US");
        nameToJavaName.put("Spanish", "es-ES");
        nameToJavaName.put("Estonian", "et-EE");
        nameToJavaName.put("Basque", "eu");
        nameToJavaName.put("Finnish", "fi-FI");
        nameToJavaName.put("French", "fr-FR");
        nameToJavaName.put("Guarani", "gn-PY");
        nameToJavaName.put("Gujarati", "gu-IN");
        nameToJavaName.put("Hausa", "ha-NG");
        nameToJavaName.put("Hebrew", "he-IL");
        nameToJavaName.put("Hindi", "hi-IN");
        nameToJavaName.put("Croatian", "hr-HR");
        nameToJavaName.put("Hungarian", "hu-HU");
        nameToJavaName.put("Armenian", "hy-AM");
        nameToJavaName.put("Indonesian", "id-ID");
        nameToJavaName.put("Igbo", "ig-NG");
        nameToJavaName.put("Icelandic", "is-IS");
        nameToJavaName.put("Italian", "it-IT");
        nameToJavaName.put("Inuktitut", "iu-CA");
        nameToJavaName.put("Japanese", "ja-JP");
        nameToJavaName.put("Georgian", "ka-GE");
        nameToJavaName.put("Kazakh", "kk-KZ");
        nameToJavaName.put("Khmer", "km-KH");
        nameToJavaName.put("Kannada", "kn-IN");
        nameToJavaName.put("Korean", "ko-KR");
        nameToJavaName.put("Konkani", "kok-IN");
        nameToJavaName.put("Kashmiri", "ks");
        nameToJavaName.put("Kirghiz", "ky-KG");
        nameToJavaName.put("Lao", "lo-LA");
        nameToJavaName.put("Lithuanian", "lt-LT");
        nameToJavaName.put("Latvian", "lv-LV");
        nameToJavaName.put("Maori", "mi-NZ");
        nameToJavaName.put("Macedonian", "mk-MK");
        nameToJavaName.put("Malayalam", "ml-IN");
        nameToJavaName.put("Mongolian", "mn-MN");
        nameToJavaName.put("Manipuri", "mni-IN");
        nameToJavaName.put("Marathi", "mr-IN");
        nameToJavaName.put("Malay", "ms-MY");
        nameToJavaName.put("Maltese", "mt-MT");
        nameToJavaName.put("Burmese", "my-MM");
        nameToJavaName.put("Danish_Norwegian", "nb-NO");
        nameToJavaName.put("Nepali", "ne-NP");
        nameToJavaName.put("Dutch", "nl-NL");
        nameToJavaName.put("Norwegian", "nn-NO");
        nameToJavaName.put("Oriya", "or-IN");
        nameToJavaName.put("Punjabi", "pa-IN");
        nameToJavaName.put("Polish", "pl-PL");
        nameToJavaName.put("Pashto", "ps-AF");
        nameToJavaName.put("Portuguese", "pt-PT");
        nameToJavaName.put("Romanian", "ro-RO");
        nameToJavaName.put("Russian", "ru-RU");
        nameToJavaName.put("Sanskrit", "sa-IN");
        nameToJavaName.put("Sindhi", "sd-IN");
        nameToJavaName.put("Slovak", "sk-SK");
        nameToJavaName.put("Slovenian", "sl-SI");
        nameToJavaName.put("Somali", "so-SO");
        nameToJavaName.put("Albanian", "sq-AL");
        nameToJavaName.put("Serbian_Cyrillic", "sr-YU");
        nameToJavaName.put("Serbian_Latin", "sh-BA");
        nameToJavaName.put("Swedish", "sv-SE");
        nameToJavaName.put("Swahili", "sw-KE");
        nameToJavaName.put("Tamil", "ta-IN");
        nameToJavaName.put("Telugu", "te-IN");
        nameToJavaName.put("Tajik", "tg-TJ");
        nameToJavaName.put("Thai", "th-TH");
        nameToJavaName.put("Turkmen", "tk-TM");
        nameToJavaName.put("Tswana", "tn-BW");
        nameToJavaName.put("Turkish", "tr-TR");
        nameToJavaName.put("Tatar", "tt-RU");
        nameToJavaName.put("Ukrainian", "uk-UA");
        nameToJavaName.put("Urdu", "ur-PK");
        nameToJavaName.put("Uzbek_Latin", "uz-UZ");
        nameToJavaName.put("Venda", "ven-ZA");
        nameToJavaName.put("Vietnamese", "vi-VN");
        nameToJavaName.put("Yoruba", "yo-NG");
        nameToJavaName.put("Chinese", "zh-CN");
        nameToJavaName.put("Zulu", "zu-ZA");
        Iterator it = nameToJavaName.values().iterator();
        while (it.hasNext()) {
            String javaName = (String)it.next();
            String dbName = javaName.replace('-', '_').toUpperCase(Locale.ENGLISH);
            dbNameToJavaName.put(dbName, javaName);
        }
        defaultCollation = new Collation();
        Collation.defaultCollation.isFinal = false;
        Collation.defaultCollation.charset = TypeInvariants.SQL_TEXT;
    }
}

