/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.java.JavaSystem;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.ClobData;
import java.io.IOException;
import java.io.Reader;

public final class ClobInputStream
extends Reader {
    final ClobData clob;
    long availableLength;
    long bufferOffset;
    long currentPosition;
    char[] buffer;
    boolean isClosed;
    int streamBlockSize;
    public SessionInterface session;

    public ClobInputStream(SessionInterface session, ClobData clob, long offset, long length) {
        long clobLength = clob.length(session);
        this.session = session;
        this.clob = clob;
        this.availableLength = offset + Math.min(length, clobLength - offset);
        this.currentPosition = offset;
        this.streamBlockSize = session.getStreamBlockSize();
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.buffer == null || this.currentPosition >= this.bufferOffset + (long)this.buffer.length) {
            try {
                this.checkClosed();
                this.readIntoBuffer();
            }
            catch (Exception e) {
                throw JavaSystem.toIOException(e);
            }
        }
        char val = this.buffer[(int)(this.currentPosition - this.bufferOffset)];
        ++this.currentPosition;
        return val;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.checkClosed();
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.currentPosition + (long)len > this.availableLength) {
            len = (int)(this.availableLength - this.currentPosition);
        }
        long initialCurrentPosition = this.currentPosition;
        for (int i = off; i < len; ++i) {
            cbuf[i] = (char)this.read();
            if (initialCurrentPosition + (long)len <= this.availableLength) continue;
            len = (int)(this.availableLength - initialCurrentPosition);
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkClosed();
        if (n <= 0L) {
            if (this.currentPosition - this.bufferOffset + n < 0L) {
                n = -(this.currentPosition - this.bufferOffset);
            }
        } else if (this.currentPosition + n > this.availableLength) {
            n = this.availableLength - this.currentPosition;
        }
        this.currentPosition += n;
        return n;
    }

    public int available() {
        long avail = this.availableLength - this.currentPosition;
        if (avail > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)avail;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException(Error.getMessage(3475));
        }
    }

    private void readIntoBuffer() {
        long readLength = this.availableLength - this.currentPosition;
        if (readLength <= 0L) {
            // empty if block
        }
        if (readLength > (long)this.streamBlockSize) {
            readLength = this.streamBlockSize;
        }
        this.buffer = this.clob.getChars(this.session, this.currentPosition, (int)readLength);
        this.bufferOffset = this.currentPosition;
        if ((long)this.buffer.length != readLength) {
            this.availableLength -= readLength - (long)this.buffer.length;
        }
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return pos >= 0L && len >= 0L && pos + len <= fullLength;
    }
}

