/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.lib.StringUtil;
import com.streamscape.ds.lib.java.JavaSystem;
import com.streamscape.ds.schema.procedure.AbstractLazyFlobFunctionExpression;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.Charset;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.ClobDataID;
import com.streamscape.ds.types.ClobType;
import com.streamscape.ds.types.Collation;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobType;
import com.streamscape.ds.types.LobData;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class CharacterType
extends Type {
    static final int defaultCharPrecision = 256;
    static final int defaultVarcharPrecision = 32768;
    static final long maxCharPrecision = Integer.MAX_VALUE;
    Collation collation;
    Charset charset;
    boolean isEqualIdentical;
    String nameString;
    private static final int fixedTypesLength = 32;
    static CharacterType[] charArray = new CharacterType[32];

    public CharacterType(Collation collation, int type, long precision) {
        super(12, type, precision, 0);
        if (collation == null) {
            collation = Collation.getDatabaseInstance();
        }
        this.collation = collation;
        this.charset = Charset.getDefaultInstance();
        this.isEqualIdentical = this.collation.isEqualAlwaysIdentical() && type != 100;
        this.nameString = this.getNameStringPrivate();
    }

    @Override
    public boolean canBeAssignedFrom(Type otherType) {
        if (otherType instanceof NumberType) {
            return true;
        }
        if (otherType instanceof FlobType) {
            return true;
        }
        return super.canBeAssignedFrom(otherType);
    }

    public CharacterType(int type, long precision) {
        super(12, type, precision, 0);
        this.collation = Collation.getDefaultInstance();
        this.charset = Charset.getDefaultInstance();
        this.isEqualIdentical = type != 100;
        this.nameString = this.getNameStringPrivate();
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        switch (this.typeCode) {
            case 1: {
                return 1;
            }
            case 12: 
            case 100: 
            case 1112: 
            case 1121: {
                return 12;
            }
            case 40: {
                return 2005;
            }
            case -1: {
                return -1;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    public Class getJDBCClass() {
        return String.class;
    }

    public Class getInternalClass(Session session) {
        return String.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.lang.String";
    }

    @Override
    public int getSQLGenericTypeCode() {
        return this.typeCode == 1 ? this.typeCode : 12;
    }

    @Override
    public String getNameString() {
        return this.nameString;
    }

    private String getNameStringPrivate() {
        switch (this.typeCode) {
            case 1: {
                return "CHARACTER";
            }
            case 12: {
                return "VARCHAR";
            }
            case -9: {
                return "NVARCHAR";
            }
            case 100: {
                return "VARCHAR_IGNORECASE";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 40: {
                return ClobType.NAME_STRING;
            }
            case 1112: {
                return "STRING";
            }
            case 1121: {
                return "CATEGORY";
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public String getFullNameString() {
        switch (this.typeCode) {
            case 1: {
                return "CHARACTER";
            }
            case 12: {
                return "VARCHAR";
            }
            case 1112: {
                return "STRING";
            }
            case 1121: {
                return "CATEGORY";
            }
            case 100: {
                return "VARCHAR_IGNORECASE";
            }
            case 40: {
                return ClobType.NAME_FULL_STRING;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public String getDefinition() {
        if (this.precision == 0L || this.typeCode == 1112 || this.typeCode == 1121) {
            return this.getNameString();
        }
        StringBuffer sb = new StringBuffer(16);
        sb.append(this.getNameString());
        sb.append('(');
        sb.append(this.precision);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean hasCollation() {
        return false;
    }

    @Override
    public String getCollationDefinition() {
        if (this.hasCollation()) {
            return this.collation.getObjectName().getSchemaQualifiedStatementName();
        }
        return "";
    }

    @Override
    public boolean isCharacterType() {
        return true;
    }

    @Override
    public long getMaxPrecision() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean acceptsPrecision() {
        return true;
    }

    @Override
    public boolean requiresPrecision() {
        return this.typeCode == 12 || this.typeCode == 100;
    }

    @Override
    public int precedenceDegree(Type other) {
        if (other.typeCode == this.typeCode) {
            return 0;
        }
        if (!other.isCharacterType()) {
            return Integer.MIN_VALUE;
        }
        switch (this.typeCode) {
            case 1: {
                return other.typeCode == 40 ? 4 : 2;
            }
            case 12: 
            case 100: 
            case 1112: 
            case 1121: {
                if (other.typeCode == 12 || other.typeCode == 100) {
                    return 0;
                }
                return other.typeCode == 40 ? 4 : 2;
            }
            case 40: {
                return other.typeCode == 1 ? -4 : -2;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public Type getAggregateType(Type other) {
        if (other == null) {
            return this;
        }
        if (other == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == other.typeCode) {
            return this.precision >= other.precision ? this : other;
        }
        switch (other.typeCode) {
            case 1: {
                return this.precision >= other.precision ? this : CharacterType.getCharacterType(this.typeCode, other.precision, other.getCollation());
            }
            case 12: 
            case 1112: 
            case 1121: {
                if (this.typeCode == 40 || this.typeCode == 100) {
                    return this.precision >= other.precision ? this : CharacterType.getCharacterType(this.typeCode, other.precision, other.getCollation());
                }
                return other.precision >= this.precision ? other : CharacterType.getCharacterType(other.typeCode, this.precision, other.getCollation());
            }
            case 100: {
                if (this.typeCode == 40) {
                    return this.precision >= other.precision ? this : CharacterType.getCharacterType(this.typeCode, other.precision, this.getCollation());
                }
                return other.precision >= this.precision ? other : CharacterType.getCharacterType(other.typeCode, this.precision, other.getCollation());
            }
            case 40: {
                return other.precision >= this.precision ? other : CharacterType.getCharacterType(other.typeCode, this.precision, other.getCollation());
            }
            case 14: 
            case 15: 
            case 30: 
            case 60: 
            case 61: 
            case 1111: 
            case 1113: {
                throw Error.error(5562);
            }
        }
        throw Error.error(5562);
    }

    @Override
    public Type getCombinedType(Session session, Type other, int operation) {
        Type newType;
        if (operation != 36) {
            return this.getAggregateType(other);
        }
        long newPrecision = this.precision + other.precision;
        switch (other.typeCode) {
            case 0: {
                return this;
            }
            case 1: {
                newType = this;
                break;
            }
            case 12: {
                newType = this.typeCode == 40 || this.typeCode == 100 ? this : other;
                break;
            }
            case 100: {
                newType = this.typeCode == 40 ? this : other;
                break;
            }
            case 40: {
                newType = other;
                break;
            }
            case 1112: {
                newType = this;
                break;
            }
            case 1121: {
                newType = this;
                break;
            }
            default: {
                throw Error.error(5562);
            }
        }
        if (newPrecision > Integer.MAX_VALUE) {
            if (this.typeCode == 60) {
                newPrecision = Integer.MAX_VALUE;
            } else if (this.typeCode == 1) {
                newPrecision = Integer.MAX_VALUE;
            }
        }
        return CharacterType.getCharacterType(newType.typeCode, newPrecision);
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        int lb;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (b instanceof ClobData) {
            return -session.dataspaceStore.lobManager.compare((ClobData)b, (String)a);
        }
        String as = (String)OtherTypeWrapper.unwrap(a);
        String bs = (String)OtherTypeWrapper.unwrap(b);
        int la = as.length();
        if (la != (lb = bs.length())) {
            if (la > lb) {
                if (this.collation.isPadSpace()) {
                    char[] buffer = new char[la];
                    bs.getChars(0, lb, buffer, 0);
                    ArrayUtil.fillArray(buffer, lb, ' ');
                    bs = String.valueOf(buffer);
                }
            } else if (this.collation.isPadSpace()) {
                char[] buffer = new char[lb];
                as.getChars(0, la, buffer, 0);
                ArrayUtil.fillArray(buffer, la, ' ');
                as = String.valueOf(buffer);
            }
        }
        if (this.typeCode == 100) {
            return this.collation.compareIgnoreCase(as, bs);
        }
        return this.collation.compare(as, bs);
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        if (a == null) {
            return a;
        }
        if (this.precision == 0L) {
            return a;
        }
        switch (this.typeCode) {
            case 1: {
                int slen = ((String)a).length();
                if ((long)slen == this.precision) {
                    return a;
                }
                if ((long)slen > this.precision) {
                    if ((long)CharacterType.getRightTrimSise((String)a, ' ') <= this.precision) {
                        return ((String)a).substring(0, (int)this.precision);
                    }
                    throw Error.error(3401);
                }
                if (this.precision != Integer.MAX_VALUE) {
                    char[] b = new char[(int)this.precision];
                    ((String)a).getChars(0, slen, b, 0);
                    int i = slen;
                    while ((long)i < this.precision) {
                        b[i] = 32;
                        ++i;
                    }
                    return new String(b);
                }
                return a;
            }
            case 12: 
            case 100: 
            case 1112: 
            case 1121: {
                int slen = ((String)a).length();
                if ((long)slen > this.precision) {
                    if ((long)CharacterType.getRightTrimSise((String)a, ' ') <= this.precision) {
                        return ((String)a).substring(0, (int)this.precision);
                    }
                    throw Error.error(3401);
                }
                return a;
            }
            case 40: {
                if (a instanceof ClobData) {
                    return a;
                }
                ClobDataID clob = session.createClob(((String)a).length());
                clob.setString(session, 0L, (String)a);
                return clob;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public Object castToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        return this.castOrConvertToType(session, a, otherType, true);
    }

    public Object castOrConvertToType(SessionInterface session, Object a, Type otherType, boolean cast) {
        if (otherType instanceof OtherType && a != null && (a = OtherTypeWrapper.unwrap(a)) != null) {
            otherType = Types.getParameterSQLType((Session)session, a.getClass());
        }
        switch (otherType.typeCode) {
            case 1: 
            case 12: 
            case 100: 
            case 1112: 
            case 1121: {
                int length = ((String)a).length();
                if (this.precision != 0L && (long)length > this.precision) {
                    if ((long)StringUtil.rightTrimSize((String)a) > this.precision) {
                        if (!cast) {
                            throw Error.error(3401);
                        }
                        session.addWarning(Error.error(1004));
                    }
                    a = ((String)a).substring(0, (int)this.precision);
                }
                switch (this.typeCode) {
                    case 1: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 12: 
                    case 100: 
                    case 1112: 
                    case 1121: {
                        return a;
                    }
                    case 40: {
                        ClobDataID clob = session.createClob(((String)a).length());
                        clob.setString(session, 0L, (String)a);
                        return clob;
                    }
                }
                throw Error.runtimeError(201, "CharacterType");
            }
            case 40: 
            case 1119: {
                if (a instanceof AbstractLazyFlobFunctionExpression) {
                    a = ((AbstractLazyFlobFunctionExpression)a).getLazyFlobData((Session)session);
                    a = ((Session)session).sessionData.readFlobString((FlobData)a, otherType);
                } else {
                    if (a instanceof FlobData) {
                        a = ((FlobData)a).getClobAdapter();
                    }
                    long length = ((ClobData)a).length(session);
                    if (this.precision != 0L && length > this.precision && ((ClobData)a).nonSpaceLength(session) > this.precision) {
                        if (!cast) {
                            throw Error.error(3401);
                        }
                        session.addWarning(Error.error(1004));
                    }
                    switch (this.typeCode) {
                        case 1: 
                        case 12: 
                        case 100: 
                        case 1112: 
                        case 1121: {
                            if (length > Integer.MAX_VALUE) {
                                if (!cast) {
                                    throw Error.error(3401);
                                }
                                length = Integer.MAX_VALUE;
                            }
                            a = ((ClobData)a).getSubString(session, 0L, (int)length);
                            return this.convertToTypeLimits(session, a);
                        }
                        case 40: {
                            if (this.precision != 0L && length > this.precision) {
                                return ((ClobData)a).getClob(session, 0L, this.precision);
                            }
                            return a;
                        }
                    }
                    throw Error.runtimeError(201, "CharacterType");
                }
            }
            case 1111: 
            case 1113: {
                Object obj = OtherTypeWrapper.unwrap(a);
                if (obj != null) {
                    return obj.toString();
                }
                return null;
            }
            case 30: {
                long blobLength = ((BlobData)a).length(session);
                if (this.precision != 0L && blobLength * 2L > this.precision) {
                    throw Error.error(3401);
                }
                byte[] bytes = ((BlobData)a).getBytes(session, 0L, (int)blobLength);
                a = StringConverter.byteArrayToHexString(bytes);
                return this.convertToTypeLimits(session, a);
            }
        }
        String s = otherType.convertToString(a);
        if (this.precision != 0L && (long)s.length() > this.precision) {
            throw Error.error(3401);
        }
        a = s;
        return this.convertToTypeLimits(session, a);
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        return this.castOrConvertToType(session, a, otherType, false);
    }

    @Override
    public Object convertToTypeJDBC(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        if (otherType.typeCode == 30) {
            throw Error.error(5561);
        }
        return this.convertToType(session, a, otherType);
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        String s;
        if (a == null) {
            return a;
        }
        if ((a = OtherTypeWrapper.unwrap(a)) instanceof Boolean) {
            s = a.toString();
        } else if (a instanceof BigDecimal) {
            s = JavaSystem.toString((BigDecimal)a);
        } else if (a instanceof Number) {
            s = a.toString();
        } else if (a instanceof String) {
            s = (String)a;
        } else if (a instanceof Date) {
            s = ((Date)a).toString();
        } else if (a instanceof Time) {
            s = ((Time)a).toString();
        } else if (a instanceof Timestamp) {
            s = ((Timestamp)a).toString();
        } else if (a instanceof java.util.Date) {
            s = DataspaceDateTime.getJavaDateTimeString((java.util.Date)((Date)a), session.getTimeZone());
        } else {
            throw Error.error(5561);
        }
        return s;
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        return this.convertToDefaultType(session, a);
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 1: {
                int slen = ((String)a).length();
                if (this.precision == 0L || (long)slen == this.precision) {
                    return (String)a;
                }
                char[] b = new char[(int)this.precision];
                ((String)a).getChars(0, slen, b, 0);
                int i = slen;
                while ((long)i < this.precision) {
                    b[i] = 32;
                    ++i;
                }
                return new String(b);
            }
            case 12: 
            case 100: 
            case 1112: 
            case 1121: {
                return (String)a;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        String s = this.convertToString(a);
        return StringConverter.toQuotedString(s, '\'', true);
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        return !otherType.isArrayType();
    }

    @Override
    public int canMoveFrom(Type otherType) {
        if (otherType == this) {
            return 0;
        }
        if (!otherType.isCharacterType()) {
            return -1;
        }
        switch (this.typeCode) {
            case 12: 
            case 1112: 
            case 1121: {
                if (otherType.typeCode == this.typeCode) {
                    return this.precision >= otherType.precision ? 0 : 1;
                }
                if (otherType.typeCode == 1) {
                    return this.precision >= otherType.precision ? 0 : -1;
                }
                return -1;
            }
            case 40: {
                if (otherType.typeCode == 40) {
                    return this.precision >= otherType.precision ? 0 : 1;
                }
                return -1;
            }
            case 1: {
                return otherType.typeCode == 1 && this.precision == otherType.precision ? 0 : -1;
            }
        }
        return -1;
    }

    @Override
    public Collation getCollation() {
        return this.collation;
    }

    @Override
    public Charset getCharacterSet() {
        return this.charset;
    }

    public boolean isEqualIdentical() {
        return this.isEqualIdentical;
    }

    public boolean isCaseInsensitive() {
        return this.typeCode == 100;
    }

    public long position(SessionInterface session, Object data, Object otherData, Type otherType, long offset) {
        if (data == null || otherData == null) {
            return -1L;
        }
        if (otherType.typeCode == 40 || otherType.typeCode == 1119) {
            long otherLength = ((ClobData)otherData).length(session);
            if (offset + otherLength > (long)((String)data).length()) {
                return -1L;
            }
            if (otherLength > Integer.MAX_VALUE) {
                throw Error.error(3459);
            }
            String otherString = ((ClobData)otherData).getSubString(session, 0L, (int)otherLength);
            return ((String)data).indexOf(otherString, (int)offset);
        }
        if (otherType.isCharacterType()) {
            long otherLength = ((String)otherData).length();
            if (offset + otherLength > (long)((String)data).length()) {
                return -1L;
            }
            return ((String)data).indexOf((String)otherData, (int)offset);
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    public Object substring(SessionInterface session, Object data, long offset, long length, boolean hasLength, boolean trailing) {
        long end;
        long dataLength;
        long l = dataLength = data instanceof LobData ? ((LobData)data).length(session) : (long)((String)data).length();
        if (trailing) {
            end = dataLength;
            if (length > dataLength) {
                offset = 0L;
                length = dataLength;
            } else {
                offset = dataLength - length;
            }
        } else if (hasLength) {
            end = offset + length;
        } else {
            long l2 = end = dataLength > offset ? dataLength : offset;
        }
        if (end < offset) {
            throw Error.error(3431);
        }
        if (offset > end || end < 0L) {
            offset = 0L;
            end = 0L;
        }
        if (offset < 0L) {
            offset = 0L;
        }
        if (end > dataLength) {
            end = dataLength;
        }
        length = end - offset;
        if (data instanceof String) {
            return ((String)data).substring((int)offset, (int)(offset + length));
        }
        if (data instanceof LobData) {
            ClobData clob = null;
            clob = data instanceof FlobData ? ((FlobData)data).getClobAdapter() : (ClobData)data;
            return clob.getSubString(session, offset, (int)length);
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    public Object upper(Session session, Object data) {
        if (data == null) {
            return null;
        }
        if (this.typeCode == 40) {
            String result = ((ClobData)data).getSubString(session, 0L, (int)((ClobData)data).length(session));
            result = this.collation.toUpperCase(result);
            ClobDataID clob = session.createClob(result.length());
            clob.setString(session, 0L, result);
            return clob;
        }
        return this.collation.toUpperCase((String)data);
    }

    public Object lower(Session session, Object data) {
        if (data == null) {
            return null;
        }
        if (this.typeCode == 40) {
            String result = ((ClobData)data).getSubString(session, 0L, (int)((ClobData)data).length(session));
            result = this.collation.toLowerCase(result);
            ClobDataID clob = session.createClob(result.length());
            clob.setString(session, 0L, result);
            return clob;
        }
        return this.collation.toLowerCase((String)data);
    }

    public Object trim(SessionInterface session, Object data, int trim, boolean leading, boolean trailing) {
        int startindex;
        String s;
        if (data == null) {
            return null;
        }
        if (this.typeCode == 40) {
            long length = ((ClobData)data).length(session);
            if (length > Integer.MAX_VALUE) {
                throw Error.error(3459);
            }
            s = ((ClobData)data).getSubString(session, 0L, (int)length);
        } else {
            s = (String)data;
        }
        int endindex = s.length();
        if (trailing) {
            --endindex;
            while (endindex >= 0 && s.charAt(endindex) == trim) {
                --endindex;
            }
            ++endindex;
        }
        if (leading) {
            for (startindex = 0; startindex < endindex && s.charAt(startindex) == trim; ++startindex) {
            }
        }
        if (startindex != 0 || endindex != s.length()) {
            s = s.substring(startindex, endindex);
        }
        if (this.typeCode == 40) {
            ClobDataID clob = session.createClob(s.length());
            clob.setString(session, 0L, s);
            return clob;
        }
        return s;
    }

    public Object overlay(SessionInterface session, Object data, Object overlay, long offset, long length, boolean hasLength) {
        if (data == null || overlay == null) {
            return null;
        }
        if (!hasLength) {
            length = this.typeCode == 40 ? ((ClobData)overlay).length(session) : (long)((String)overlay).length();
        }
        Object temp = this.concat(null, this.substring(session, data, 0L, offset, true, false), overlay);
        return this.concat(null, temp, this.substring(session, data, offset + length, 0L, false, false));
    }

    @Override
    public Object concat(Session session, Object a, Object b) {
        String left = a instanceof ClobData ? ((ClobData)a).getSubString(session, 0L, (int)((ClobData)a).length(session)) : (String)a;
        String right = b instanceof ClobData ? ((ClobData)b).getSubString(session, 0L, (int)((ClobData)b).length(session)) : (String)b;
        if (this.typeCode == 40) {
            ClobDataID clob = session.createClob(left.length() + right.length());
            clob.setString(session, 0L, left);
            clob.setString(session, left.length(), right);
            return clob;
        }
        return left + right;
    }

    public long size(SessionInterface session, Object data) {
        if (this.typeCode == 40) {
            return ((ClobData)data).length(session);
        }
        return ((String)data).length();
    }

    public Boolean match(Session session, String string, String[] array) {
        if (string == null || array == null) {
            return null;
        }
        String s = null;
        int offset = 0;
        boolean match = true;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                ++offset;
                match = true;
            } else if (array[i].length() == 0) {
                match = false;
            }
            if (match) {
                if (offset + array[i].length() > string.length()) {
                    return Boolean.FALSE;
                }
                s = string.substring(offset, offset + array[i].length());
                if (this.collation.compare(s, array[i]) != 0) {
                    return Boolean.FALSE;
                }
                offset += array[i].length();
                continue;
            }
            int index = string.indexOf(array[i], offset);
            if (index < 0) {
                return Boolean.FALSE;
            }
            offset = index + array[i].length();
            match = true;
        }
        return Boolean.TRUE;
    }

    public Type getCharacterType(long length) {
        if (length == this.precision) {
            return this;
        }
        return new CharacterType(this.collation, this.typeCode, length);
    }

    public static int getRightTrimSise(String s, char trim) {
        int endindex = s.length();
        --endindex;
        while (endindex >= 0 && s.charAt(endindex) == trim) {
            --endindex;
        }
        return ++endindex;
    }

    public static CharacterType getCharacterType(int type, long length) {
        switch (type) {
            case 1: {
                if (length < 32L) {
                    return charArray[(int)length];
                }
            }
            case 12: 
            case 100: 
            case 1112: 
            case 1121: {
                return new CharacterType(type, (int)length);
            }
            case 40: {
                return new ClobType(length);
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    public static CharacterType getCharacterType(int type, long precision, Collation collation) {
        if (collation == null) {
            collation = Collation.defaultCollation;
        }
        switch (type) {
            case -9: {
                type = 12;
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: 
            case 1112: 
            case 1121: {
                return new CharacterType(collation, type, (int)precision);
            }
            case 40: {
                ClobType typeObject = new ClobType(precision);
                typeObject.collation = collation;
                return typeObject;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    static {
        for (int i = 0; i < charArray.length; ++i) {
            CharacterType.charArray[i] = new CharacterType(1, i);
        }
    }
}

