/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.jdbc.JDBCBlobClient;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BinaryType;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.Type;
import java.sql.Blob;

public final class BlobType
extends BinaryType {
    public static final long maxBlobPrecision = 0x10000000000L;
    public static final int defaultBlobSize = 0x1000000;
    public static String NAME_STRING = "BLOB";
    public static String NAME_FULL_STRING = "binary large object";

    public BlobType(long precision) {
        super(30, precision);
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        return 2004;
    }

    @Override
    public Class getJDBCClass() {
        return Blob.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.Blob";
    }

    @Override
    public String getNameString() {
        return NAME_STRING;
    }

    @Override
    public String getFullNameString() {
        return NAME_FULL_STRING;
    }

    @Override
    public String getDefinition() {
        long factor = this.precision;
        String multiplier = null;
        if (this.precision % 0x40000000L == 0L) {
            factor = this.precision / 0x40000000L;
            multiplier = "G";
        } else if (this.precision % 0x100000L == 0L) {
            factor = this.precision / 0x100000L;
            multiplier = "M";
        } else if (this.precision % 1024L == 0L) {
            factor = this.precision / 1024L;
            multiplier = "K";
        }
        StringBuffer sb = new StringBuffer(16);
        sb.append(this.getNameString());
        sb.append('(');
        sb.append(factor);
        if (multiplier != null) {
            sb.append(multiplier);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean acceptsPrecision() {
        return true;
    }

    @Override
    public boolean requiresPrecision() {
        return false;
    }

    @Override
    public long getMaxPrecision() {
        return 0x10000000000L;
    }

    @Override
    public boolean isBinaryType() {
        return true;
    }

    @Override
    public boolean isLobType() {
        return true;
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (b instanceof BinaryData) {
            return session.dataspaceStore.lobManager.compare((BlobData)a, ((BlobData)b).getBytes());
        }
        return session.dataspaceStore.lobManager.compare((BlobData)a, (BlobData)b);
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        return a;
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return null;
        }
        if (otherType.typeCode == 30) {
            return a;
        }
        if (otherType.typeCode == 1119) {
            byte[] bytes;
            BlobData b = ((FlobData)a).getBlobAdapter();
            long length = b.length(session);
            BlobDataID blob = session.createBlob(length);
            int pos = 0;
            int bufferSize = 0xA00000;
            while ((long)pos < length && (bytes = b.getBytes(session, pos, bufferSize)) != null && bytes.length != 0) {
                blob.setBytes(session, pos, bytes);
                pos += bytes.length;
            }
            return blob;
        }
        if (otherType.typeCode == 60 || otherType.typeCode == 61) {
            BlobData b = (BlobData)a;
            BlobDataID blob = session.createBlob(b.length(session));
            blob.setBytes(session, 0L, b.getBytes());
            return blob;
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        if (a == null) {
            return a;
        }
        if (a instanceof BlobData) {
            return a;
        }
        if (a instanceof byte[]) {
            return new BinaryData((byte[])a, false);
        }
        throw Error.error(5561);
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        byte[] bytes = ((BlobData)a).getBytes();
        return StringConverter.byteArrayToHexString(bytes);
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        byte[] bytes = ((BlobData)a).getBytes();
        return StringConverter.byteArrayToSQLHexString(bytes);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof JDBCBlobClient) {
            return ((JDBCBlobClient)a).getBlob();
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertSQLToJava(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof BlobDataID) {
            BlobDataID blob = (BlobDataID)a;
            return new JDBCBlobClient(session, blob);
        }
        throw Error.error(5561);
    }
}

