/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.java.JavaSystem;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.BlobData;
import java.io.IOException;
import java.io.InputStream;

public class BlobInputStream
extends InputStream {
    final BlobData blob;
    final long availableLength;
    long bufferOffset;
    long currentPosition;
    byte[] buffer;
    boolean isClosed;
    int streamBlockSize;
    public final SessionInterface session;

    public BlobInputStream(SessionInterface session, BlobData blob, long offset, long length) {
        long blobLength = blob.length(session);
        this.session = session;
        this.blob = blob;
        this.availableLength = offset + Math.min(length, blobLength - offset);
        this.currentPosition = offset;
        this.streamBlockSize = session.getStreamBlockSize();
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.buffer == null || this.currentPosition >= this.bufferOffset + (long)this.buffer.length) {
            try {
                this.checkClosed();
                this.readIntoBuffer();
            }
            catch (Exception e) {
                throw JavaSystem.toIOException(e);
            }
        }
        int val = this.buffer[(int)(this.currentPosition - this.bufferOffset)] & 0xFF;
        ++this.currentPosition;
        return val;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkClosed();
        if (n <= 0L) {
            if (this.currentPosition - this.bufferOffset + n < 0L) {
                n = -(this.currentPosition - this.bufferOffset);
            }
        } else if (this.currentPosition + n > this.availableLength) {
            n = this.availableLength - this.currentPosition;
        }
        this.currentPosition += n;
        return n;
    }

    @Override
    public int available() {
        long avail = this.availableLength - this.currentPosition;
        if (avail > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)avail;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed || this.blob.isClosed()) {
            throw new IOException(Error.getMessage(3475));
        }
    }

    private void readIntoBuffer() {
        long readLength = this.availableLength - this.currentPosition;
        if (readLength <= 0L) {
            // empty if block
        }
        if (readLength > (long)this.streamBlockSize) {
            readLength = this.streamBlockSize;
        }
        this.buffer = this.blob.getBytes(this.session, this.currentPosition, (int)readLength);
        this.bufferOffset = this.currentPosition;
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return pos >= 0L && len >= 0L && pos + len <= fullLength;
    }
}

