/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultLob;
import com.streamscape.ds.result.ResultLobFactory;
import com.streamscape.ds.result.ResultLobFactoryFactory;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.BlobInputStream;
import java.io.InputStream;

public class BlobDataID
implements BlobData {
    long id;
    long length = -1L;

    public BlobDataID(long id) {
        this.id = id;
    }

    protected ResultLobFactory getResultLobFactory() {
        return ResultLobFactoryFactory.getLobResultFactory();
    }

    @Override
    public BlobData duplicate(SessionInterface session) {
        ResultLob resultOut = this.getResultLobFactory().newLobDuplicateRequest(this.id);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        long lobID = ((ResultLob)resultIn).getLobID();
        return new BlobDataID(lobID);
    }

    @Override
    public void free() {
    }

    @Override
    public InputStream getBinaryStream(SessionInterface session) {
        long length = this.length(session);
        return new BlobInputStream(session, this, 0L, length);
    }

    @Override
    public InputStream getBinaryStream(SessionInterface session, long pos, long length) {
        return new BlobInputStream(session, this, pos, length);
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public byte[] getBytes(SessionInterface session, long pos, int length) {
        ResultLob resultOut = this.getResultLobFactory().newLobGetBytesRequest(this.id, pos, length);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw Error.error(resultIn);
        }
        return ((ResultLob)resultIn).getByteArray();
    }

    @Override
    public BlobData getBlob(SessionInterface session, long pos, long length) {
        ResultLob resultOut = this.getResultLobFactory().newLobGetRequest(this.id, pos, length);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw Error.error(resultIn);
        }
        long lobID = ((ResultLob)resultIn).getLobID();
        return new BlobDataID(lobID);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public int getStreamBlockSize() {
        return 0;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public long length(SessionInterface session) {
        if (this.length > -1L) {
            return this.length;
        }
        ResultLob resultOut = this.getResultLobFactory().newLobGetLengthRequest(this.id);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        this.length = ((ResultLob)resultIn).getBlockLength();
        return this.length;
    }

    @Override
    public long bitLength(SessionInterface session) {
        return this.length(session) * 8L;
    }

    @Override
    public boolean isBits() {
        return false;
    }

    @Override
    public long position(SessionInterface session, BlobData pattern, long start) {
        ResultLob resultOut = this.getResultLobFactory().newLobGetCharPatternPositionRequest(this.id, pattern.getId(), start);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getOffset();
    }

    @Override
    public long position(SessionInterface session, byte[] pattern, long start) {
        ResultLob resultOut = this.getResultLobFactory().newLobGetBytePatternPositionRequest(this.id, pattern, start);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getOffset();
    }

    @Override
    public long nonZeroLength(SessionInterface session) {
        ResultLob resultOut = this.getResultLobFactory().newLobGetTruncateLength(this.id);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getBlockLength();
    }

    @Override
    public void setBytes(SessionInterface session, long pos, byte[] bytes, int offset, int len) {
        ResultLob resultOut;
        Result resultIn;
        if (offset != 0 || len != bytes.length) {
            if (!BinaryData.isInLimits(bytes.length, offset, len)) {
                throw new IndexOutOfBoundsException();
            }
            byte[] newbytes = new byte[len];
            System.arraycopy(bytes, offset, newbytes, 0, len);
            bytes = newbytes;
        }
        if ((resultIn = session.execute(resultOut = this.getResultLobFactory().newLobSetBytesRequest(this.id, pos, bytes))).isError()) {
            throw resultIn.getException();
        }
        this.length = ((ResultLob)resultIn).getBlockLength();
    }

    @Override
    public void setBytes(SessionInterface session, long pos, byte[] bytes) {
        this.setBytes(session, pos, bytes, 0, bytes.length);
    }

    @Override
    public void setBinaryStream(SessionInterface session, long pos, InputStream in) {
    }

    @Override
    public void truncate(SessionInterface session, long len) {
        ResultLob resultOut = this.getResultLobFactory().newLobTruncateRequest(this.id, len);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            return this.id == ((BlobDataID)other).id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }
}

