/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.BlobInputStream;
import com.streamscape.ds.types.Type;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;

public class BinaryData
implements BlobData {
    public static final BinaryData singleBitZero = new BinaryData(new byte[]{0}, 1L);
    public static final BinaryData singleBitOne = new BinaryData(new byte[]{-128}, 1L);
    public static final byte[] zeroLengthBytes = new byte[0];
    public static final BinaryData zeroLengthBinary = new BinaryData(zeroLengthBytes, false);
    long id;
    protected byte[] data;
    private boolean isBits;
    private long bitLength;
    private int hashCode = 0;

    public static BinaryData getBitData(byte[] data, long bitLength) {
        if (bitLength == 1L) {
            return data[0] == 0 ? singleBitZero : singleBitOne;
        }
        return new BinaryData(data, bitLength);
    }

    public BinaryData(byte[] data, boolean clone) {
        if (clone) {
            data = (byte[])ArrayUtil.duplicateArray(data);
        }
        this.data = data;
        this.bitLength = data.length * 8;
    }

    public BinaryData(SessionInterface session, BlobData b1, BlobData b2) {
        long length = b1.length(session) + b2.length(session);
        if (length > Integer.MAX_VALUE) {
            throw Error.error(3401);
        }
        this.data = new byte[(int)length];
        System.arraycopy(b1.getBytes(), 0, this.data, 0, (int)b1.length(session));
        System.arraycopy(b2.getBytes(), 0, this.data, (int)b1.length(session), (int)b2.length(session));
        this.bitLength = (b1.length(session) + b2.length(session)) * 8L;
    }

    public BinaryData(byte[] data, long bitLength) {
        this.data = data;
        this.bitLength = bitLength;
        this.isBits = true;
    }

    public BinaryData(long length, DataInput stream) {
        this.data = new byte[(int)length];
        this.bitLength = this.data.length * 8;
        try {
            stream.readFully(this.data);
        }
        catch (IOException e) {
            throw Error.error(467, e);
        }
    }

    public static byte[] unwrap(Object object) {
        if (object instanceof BinaryData) {
            return ((BinaryData)object).getBytes();
        }
        return (byte[])object;
    }

    @Override
    public byte[] getBytes() {
        return this.data;
    }

    @Override
    public long length(SessionInterface session) {
        return this.data.length;
    }

    @Override
    public long bitLength(SessionInterface session) {
        return this.bitLength;
    }

    @Override
    public boolean isBits() {
        return this.isBits;
    }

    @Override
    public byte[] getBytes(SessionInterface session, long pos, int length) {
        if (!BinaryData.isInLimits(this.data.length, pos, length)) {
            throw new IndexOutOfBoundsException();
        }
        byte[] bytes = new byte[length];
        System.arraycopy(this.data, (int)pos, bytes, 0, length);
        return bytes;
    }

    @Override
    public BlobData getBlob(SessionInterface session, long pos, long length) {
        throw Error.runtimeError(201, "BinaryData");
    }

    @Override
    public InputStream getBinaryStream(SessionInterface session) {
        return new BlobInputStream(session, this, 0L, this.length(session));
    }

    @Override
    public InputStream getBinaryStream(SessionInterface session, long pos, long length) {
        if (!BinaryData.isInLimits(this.data.length, pos, length)) {
            throw new IndexOutOfBoundsException();
        }
        return new BlobInputStream(session, this, pos, this.length(session));
    }

    @Override
    public void setBytes(SessionInterface session, long pos, byte[] bytes, int offset, int length) {
        if (!BinaryData.isInLimits(this.data.length, pos, 0L)) {
            throw new IndexOutOfBoundsException();
        }
        if (!BinaryData.isInLimits(this.data.length, pos, length)) {
            this.data = (byte[])ArrayUtil.resizeArray(this.data, (int)pos + length);
        }
        System.arraycopy(bytes, offset, this.data, (int)pos, length);
        this.bitLength = this.data.length * 8;
    }

    @Override
    public void setBytes(SessionInterface session, long pos, byte[] bytes) {
        this.setBytes(session, pos, bytes, 0, bytes.length);
    }

    @Override
    public void setBinaryStream(SessionInterface session, long pos, InputStream in) {
    }

    @Override
    public void truncate(SessionInterface session, long len) {
        if ((long)this.data.length > len) {
            this.data = (byte[])ArrayUtil.resizeArray(this.data, (int)len);
            this.bitLength = this.data.length * 8;
        }
    }

    @Override
    public BlobData duplicate(SessionInterface session) {
        return new BinaryData(this.data, true);
    }

    @Override
    public long position(SessionInterface session, byte[] pattern, long start) {
        if (pattern.length > this.data.length) {
            return -1L;
        }
        if (start >= (long)this.data.length) {
            return -1L;
        }
        return ArrayUtil.find(this.data, (int)start, this.data.length, pattern);
    }

    @Override
    public long position(SessionInterface session, BlobData pattern, long start) {
        if (pattern.length(session) > (long)this.data.length) {
            return -1L;
        }
        byte[] bytes = pattern.getBytes();
        return this.position(session, bytes, start);
    }

    @Override
    public long nonZeroLength(SessionInterface session) {
        return this.data.length;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public int getStreamBlockSize() {
        return 524288;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void free() {
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return pos >= 0L && len >= 0L && pos + len <= fullLength;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    public boolean equals(Object other) {
        if (other instanceof BinaryData) {
            return Type.SQL_VARBINARY.compare(null, this, other) == 0;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int code = 0;
            for (int i = 0; i < this.data.length && i < 32; ++i) {
                code = code * 31 + (0xFF & this.data[i]);
            }
            this.hashCode = code += this.data.length;
        }
        return this.hashCode;
    }

    public static Byte[] convertToByte(byte[] bytes) {
        Byte[] bytes1 = new Byte[bytes.length];
        for (int i = 0; i < bytes1.length; ++i) {
            bytes1[i] = bytes[i];
        }
        return bytes1;
    }

    public static byte[] convertTobyte(Byte[] bytes) {
        byte[] bytes1 = new byte[bytes.length];
        for (int i = 0; i < bytes1.length; ++i) {
            bytes1[i] = bytes[i];
        }
        return bytes1;
    }
}

