/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;

public class AspectsSchemaObject
implements SchemaObject {
    private NameManager.ObjectName name;
    private Type type;
    private boolean isIndexed;
    private boolean isStatic;
    private String description;

    public AspectsSchemaObject(NameManager.ObjectName name, Type type, boolean isIndexed, boolean isStatic, String description) {
        this.name = name;
        this.type = type;
        this.isIndexed = isIndexed;
        this.isStatic = isStatic;
        this.description = description;
    }

    @Override
    public int getObjectType() {
        return 42;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        return set;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.name.getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ').append("ASPECTS").append(' ');
        sb.append(name);
        sb.append('(').append(this.type.getDefinition()).append(") ");
        if (this.isIndexed) {
            sb.append("INDEXED ");
        }
        if (this.isStatic) {
            sb.append("STATIC ");
        }
        if (this.description != null) {
            sb.append("DESCRIPTION '").append(this.description).append("'");
        }
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getDescription() {
        return this.description;
    }

    public Type getType() {
        return this.type;
    }
}

