/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.jdbc.JDBCArray;
import com.streamscape.ds.jdbc.JDBCArrayBasic;
import com.streamscape.ds.lib.ArraySort;
import com.streamscape.ds.parser.expression.SortAndSlice;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import java.lang.reflect.Array;
import java.util.Collection;

public class ArrayType
extends Type {
    public static final int defaultArrayCardinality = -1;
    public static final int defaultLargeArrayCardinality = Integer.MAX_VALUE;
    final Type dataType;
    public int maxCardinality;

    public ArrayType(Type dataType, int cardinality) {
        super(50, 50, 0L, 0);
        if (dataType == null) {
            dataType = Type.SQL_ALL_TYPES;
        }
        this.dataType = dataType;
        this.maxCardinality = cardinality;
    }

    protected ArrayType(int typeGroup, int type, Type dataType, int cardinality) {
        super(typeGroup, type, 0L, 0);
        if (dataType == null) {
            dataType = Type.SQL_ALL_TYPES;
        }
        this.dataType = dataType;
        this.maxCardinality = cardinality;
    }

    @Override
    public int displaySize() {
        return 7 + (this.dataType.displaySize() + 1) * this.getMaxCardinality();
    }

    @Override
    public int getJDBCTypeCode() {
        return 2003;
    }

    @Override
    public Class<?> getJDBCClass() {
        return java.sql.Array.class;
    }

    public void setMaxCardinality(int cardinality) {
        this.maxCardinality = cardinality;
    }

    public int getMaxCardinality() {
        return this.maxCardinality == -1 ? Integer.MAX_VALUE : this.maxCardinality;
    }

    @Override
    public Class<?> getInternalClass(Session session) {
        return Object[].class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.Array";
    }

    @Override
    public int getJDBCScale() {
        return 0;
    }

    @Override
    public int getJDBCPrecision() {
        return 0;
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 0;
    }

    @Override
    public String getNameString() {
        return this.getDefinitionInternal(this.dataType != Type.SQL_ALL_TYPES ? this.dataType.getTypeDefinition() : "");
    }

    @Override
    public String getFullNameString() {
        return this.getDefinitionInternal(this.dataType != Type.SQL_ALL_TYPES ? this.dataType.getFullNameString() : "");
    }

    @Override
    public String getSQL() {
        return this.getDefinition();
    }

    @Override
    public String getDefinition() {
        return this.getDefinitionInternal(this.dataType != Type.SQL_ALL_TYPES ? this.dataType.getTypeDefinition() : "");
    }

    private String getDefinitionInternal(String dataTypeName) {
        StringBuilder builder = new StringBuilder();
        builder.append(dataTypeName);
        if (dataTypeName == null || dataTypeName.length() > 0) {
            builder.append(' ');
        }
        builder.append("ARRAY");
        String maxCardinal = this.maxCardinality == -1 ? "" : Integer.toString(this.maxCardinality);
        builder.append('[').append(maxCardinal).append(']');
        return builder.toString();
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        Object[] arrb = (Object[])b;
        Object[] arra = (Object[])a;
        int length = arra.length;
        if (arrb.length < length) {
            length = arrb.length;
        }
        for (int i = 0; i < length; ++i) {
            int result = this.dataType.compare(session, arra[i], arrb[i]);
            if (result == 0) continue;
            return result;
        }
        if (arra.length > arrb.length) {
            return 1;
        }
        if (arra.length < arrb.length) {
            return -1;
        }
        return 0;
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        Object[] arra = (Object[])a;
        if (arra.length > this.getMaxCardinality()) {
            throw Error.error(3491);
        }
        Object[] arrb = new Object[arra.length];
        for (int i = 0; i < arra.length; ++i) {
            arrb[i] = this.dataType.convertToTypeLimits(session, arra[i]);
        }
        return arrb;
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return null;
        }
        if (otherType == null) {
            return a;
        }
        if (!(otherType.isArrayType() || otherType.isCollectionType() || otherType.isObjectType() || otherType.isBinaryType())) {
            throw Error.error(5562);
        }
        if ((a = OtherTypeWrapper.unwrap(a)) instanceof BinaryData) {
            a = ((BinaryData)a).getBytes();
        }
        if (a instanceof Collection) {
            if (((Collection)a).size() > this.getMaxCardinality()) {
                throw Error.error(3491);
            }
            Object[] arra = ((Collection)a).toArray();
            for (int i = 0; i < arra.length; ++i) {
                arra[i] = this.dataType.convertToDefaultType(session, arra[i]);
            }
            return arra;
        }
        if (a.getClass().isArray()) {
            int i;
            if (Array.getLength(a) > this.getMaxCardinality()) {
                throw Error.error(3491);
            }
            Type otherComponent = otherType.collectionBaseType();
            if (otherType.isBinaryType()) {
                otherComponent = TINYINT;
            } else if (otherComponent == null) {
                otherComponent = OTHER;
            }
            if (this.dataType.equals(otherComponent)) {
                boolean allwrapped = true;
                for (i = 0; i < Array.getLength(a); ++i) {
                    if (!this.dataType.isObjectType() || Array.get(a, i) instanceof OtherTypeWrapper) continue;
                    allwrapped = false;
                    break;
                }
                if (allwrapped) {
                    return a;
                }
            }
            Object[] arrb = new Object[Array.getLength(a)];
            for (i = 0; i < Array.getLength(a); ++i) {
                arrb[i] = this.dataType.convertToType(session, Array.get(a, i), otherComponent);
            }
            return arrb;
        }
        throw Error.error(5562);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        Object[] data;
        boolean convert = false;
        if (a == null) {
            return null;
        }
        if (a instanceof Object[]) {
            data = (Object[])a;
            convert = true;
        } else if (a instanceof JDBCArray) {
            data = ((JDBCArray)a).getArrayInternal();
        } else if (a instanceof JDBCArrayBasic) {
            data = (Object[])((JDBCArrayBasic)a).getArray();
            convert = true;
        } else if (a instanceof java.sql.Array) {
            try {
                data = (Object[])((java.sql.Array)a).getArray();
                convert = true;
            }
            catch (Exception e) {
                throw Error.error(5561);
            }
        } else {
            throw Error.error(5561);
        }
        if (convert) {
            Object[] array = new Object[data.length];
            for (int i = 0; i < data.length; ++i) {
                array[i] = this.dataType.convertJavaToSQL(session, data[i]);
                array[i] = this.dataType.convertToTypeLimits(session, data[i]);
            }
            return array;
        }
        return data;
    }

    @Override
    public Object convertSQLToJava(SessionInterface session, Object a) {
        if (a == null || a instanceof Object[]) {
            return a;
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertSQLToJDBC(SessionInterface session, Object a) {
        if (a instanceof Object[]) {
            Object[] data = (Object[])a;
            return new JDBCArray(data, this.collectionBaseType(), (Type)this, session);
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object o) {
        return o;
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return this.convertToSQLString(a);
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        Object[] arra = (Object[])a;
        StringBuilder builder = new StringBuilder();
        builder.append("ARRAY");
        builder.append('[');
        for (int i = 0; i < arra.length; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(this.dataType.convertToSQLString(arra[i]));
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        if (otherType == null) {
            return true;
        }
        if (otherType.isBinaryType()) {
            return this.dataType.canConvertFrom(TINYINT);
        }
        if (!otherType.isArrayType()) {
            return false;
        }
        Type otherComponent = otherType.collectionBaseType();
        return this.dataType.canConvertFrom(otherComponent);
    }

    @Override
    public int canMoveFrom(Type otherType) {
        if (otherType == this) {
            return 0;
        }
        if (!otherType.isArrayType()) {
            return -1;
        }
        if (this.getMaxCardinality() >= ((ArrayType)otherType).getMaxCardinality()) {
            return this.dataType.canMoveFrom(otherType);
        }
        if (this.dataType.canMoveFrom(otherType) == -1) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean canBeAssignedFrom(Type otherType) {
        if (otherType == null) {
            return true;
        }
        if (otherType.isBinaryType()) {
            return this.dataType.canBeAssignedFrom(TINYINT);
        }
        Type otherComponent = otherType.isArrayType() ? otherType.collectionBaseType() : otherType;
        return otherComponent != null && this.dataType.canBeAssignedFrom(otherComponent);
    }

    @Override
    public Type collectionBaseType() {
        return this.dataType;
    }

    @Override
    public int arrayLimitCardinality() {
        return this.getMaxCardinality();
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public Type getAggregateType(Type other) {
        if (other == null) {
            return this;
        }
        if (other == SQL_ALL_TYPES) {
            return this;
        }
        if (this == other) {
            return this;
        }
        if (!other.isArrayType()) {
            throw Error.error(5562);
        }
        Type otherComponent = other.collectionBaseType();
        if (this.dataType.equals(otherComponent)) {
            return ((ArrayType)other).getMaxCardinality() > this.getMaxCardinality() ? other : this;
        }
        Type newComponent = this.dataType.getAggregateType(otherComponent);
        int cardinality = ((ArrayType)other).getMaxCardinality() > this.getMaxCardinality() ? ((ArrayType)other).maxCardinality : this.maxCardinality;
        return new ArrayType(newComponent, cardinality);
    }

    @Override
    public Type getCombinedType(Session session, Type other, int operation) {
        ArrayType type = (ArrayType)this.getAggregateType(other);
        if (other == null) {
            return type;
        }
        if (operation != 36) {
            return type;
        }
        if (type.getMaxCardinality() == Integer.MAX_VALUE) {
            return type;
        }
        long card = (long)((ArrayType)other).getMaxCardinality() + (long)this.getMaxCardinality();
        if (card > Integer.MAX_VALUE) {
            card = Integer.MAX_VALUE;
        }
        return new ArrayType(this.dataType, (int)card);
    }

    @Override
    public int cardinality(Session session, Object a) {
        if (a == null) {
            return 0;
        }
        return ((Object[])a).length;
    }

    @Override
    public Object concat(Session session, Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        int size = ((Object[])a).length + ((Object[])b).length;
        Object[] array = new Object[size];
        System.arraycopy(a, 0, array, 0, ((Object[])a).length);
        System.arraycopy(b, 0, array, ((Object[])a).length, ((Object[])b).length);
        return array;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Type) {
            if (((Type)other).typeCode != 50) {
                return false;
            }
            return this.maxCardinality == ((ArrayType)other).maxCardinality && this.dataType.equals(((ArrayType)other).dataType);
        }
        return false;
    }

    public void sort(Session session, Object a, SortAndSlice sort) {
        Object[] array = (Object[])a;
        Type.TypedComparator comparator = session.getComparator();
        comparator.setType(this.dataType, sort);
        ArraySort.sort(array, 0, array.length, comparator);
    }

    public int deDuplicate(Session session, Object a, SortAndSlice sort) {
        Object[] array = (Object[])a;
        Type.TypedComparator comparator = session.getComparator();
        comparator.setType(this.dataType, sort);
        return ArraySort.deDuplicate(array, 0, array.length, comparator);
    }
}

