/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultLob;
import com.streamscape.ds.result.ResultLobFactory;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.ClobDataID;
import com.streamscape.ds.types.ClobInputStream;
import com.streamscape.ds.types.LobData;
import java.io.Reader;

abstract class AbstractClobDataID
implements ClobData {
    long id;
    long length = -1L;

    public AbstractClobDataID(long id) {
        this.id = id;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    protected abstract ResultLobFactory getResultLobFactory();

    @Override
    public char[] getChars(SessionInterface session, long position, int length) {
        ResultLob resultOut = this.getResultLobFactory().newLobGetCharsRequest(this.id, position, length);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getCharArray();
    }

    @Override
    public long length(SessionInterface session) {
        if (this.length > -1L) {
            return this.length;
        }
        ResultLob resultOut = this.getResultLobFactory().newLobGetLengthRequest(this.id);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        this.length = ((ResultLob)resultIn).getBlockLength();
        return this.length;
    }

    @Override
    public String getSubString(SessionInterface session, long pos, int length) {
        char[] chars = this.getChars(session, pos, length);
        return new String(chars);
    }

    @Override
    public ClobData duplicate(SessionInterface session) {
        ResultLob resultOut = this.getResultLobFactory().newLobDuplicateRequest(this.id);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        long lobID = ((ResultLob)resultIn).getLobID();
        return new ClobDataID(lobID);
    }

    @Override
    public ClobData getClob(SessionInterface session, long position, long length) {
        ResultLob resultOut = this.getResultLobFactory().newLobGetRequest(this.id, position, length);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        long lobID = ((ResultLob)resultIn).getLobID();
        return new ClobDataID(lobID);
    }

    @Override
    public void truncate(SessionInterface session, long len) {
        ResultLob resultOut = this.getResultLobFactory().newLobTruncateRequest(this.id, len);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        this.length = ((ResultLob)resultIn).getBlockLength();
    }

    @Override
    public Reader getCharacterStream(SessionInterface session) {
        long length = this.length(session);
        return new ClobInputStream(session, this, 0L, length);
    }

    @Override
    public void setCharacterStream(SessionInterface session, long pos, Reader in) {
    }

    @Override
    public void setString(SessionInterface session, long pos, String str) {
        ResultLob resultOut = this.getResultLobFactory().newLobSetCharsRequest(this.id, pos, str.toCharArray());
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        this.length = ((ResultLob)resultIn).getBlockLength();
    }

    @Override
    public void setClob(SessionInterface session, long pos, ClobData clob, long offset, long len) {
    }

    @Override
    public void setChars(SessionInterface session, long pos, char[] chars, int offset, int len) {
        ResultLob resultOut;
        Result resultIn;
        if (offset != 0 || len != chars.length) {
            if (!AbstractClobDataID.isInLimits(chars.length, offset, len)) {
                throw Error.error(3401);
            }
            if (offset != 0 || len != chars.length) {
                char[] newChars = new char[len];
                System.arraycopy(chars, offset, newChars, 0, len);
                chars = newChars;
            }
        }
        if ((resultIn = session.execute(resultOut = this.getResultLobFactory().newLobSetCharsRequest(this.id, pos, chars))).isError()) {
            throw resultIn.getException();
        }
        this.length = ((ResultLob)resultIn).getBlockLength();
    }

    @Override
    public long position(SessionInterface session, String searchstr, long start) {
        ResultLob resultOut = this.getResultLobFactory().newLobGetCharPatternPositionRequest(this.id, searchstr.toCharArray(), start);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getOffset();
    }

    @Override
    public long position(SessionInterface session, ClobData searchstr, long start) {
        ResultLob resultOut = this.getResultLobFactory().newLobGetCharPatternPositionRequest(this.id, searchstr.getId(), start);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getOffset();
    }

    @Override
    public long nonSpaceLength(SessionInterface session) {
        ResultLob resultOut = this.getResultLobFactory().newLobGetTruncateLength(this.id);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getBlockLength();
    }

    @Override
    public Reader getCharacterStream(SessionInterface session, long pos, long length) {
        return new ClobInputStream(session, this, pos, length);
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return pos >= 0L && len >= 0L && pos + len <= fullLength;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            return this.id == ((LobData)other).getId();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }
}

