/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.window;

import com.streamscape.Trace;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.CollectionWindowType;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.window.CollectionWindowTrigger;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import java.util.ArrayList;

public class SlidingSizeQueueWindowTrigger
extends CollectionWindowTrigger {
    long windowSize;
    int eventColumnIndex = -1;

    public SlidingSizeQueueWindowTrigger(NameManager.ObjectName name, Collection collection, long windowSize) {
        super(name, collection, CollectionWindowType.SLIDING_SIZE_WINDOW, 50);
        this.windowSize = windowSize;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
        this.bindEvent();
        this.eventColumnIndex = this.table.findColumn("Event");
    }

    @Override
    public synchronized void pushPair(Session session, Object[] oldData, Object[] newData) {
        PersistentStore store = this.table.getRowStore(session);
        long elementCount = store.elementCount();
        if (elementCount <= this.windowSize) {
            return;
        }
        RowIterator it = this.table.getPrimaryIndex().firstRow(store);
        if (!it.hasNext()) {
            return;
        }
        Row row = it.getNextRow();
        ImmutableEventDatagram oldEvent = this.collection.unwrapEvent(session, row.getData()[this.eventColumnIndex]);
        ArrayList<ImmutableEventDatagram> oldEventList = new ArrayList<ImmutableEventDatagram>();
        oldEventList.add(oldEvent);
        ImmutableEventDatagram newEvent = this.collection.unwrapEvent(session, newData[this.eventColumnIndex]);
        ArrayList<ImmutableEventDatagram> newEventList = new ArrayList<ImmutableEventDatagram>();
        newEventList.add(newEvent);
        session.addDeleteAction((Table)row.getTable(), row, null);
        try {
            this.collection.getBaseTable().fireWindowTriggers(session, oldEventList, newEventList);
            MapEvent changeEvent = (MapEvent)EventDatagramFactory.getInstance().createEvent("event.CollectionWindowChange");
            changeEvent.setEventStringProperty("collectionName", this.collection.getObjectName().name);
            changeEvent.setEventStringProperty("windowType", this.windowType.name());
            this.dataspace.raiseSystemEvent(changeEvent);
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
        }
    }
}

