/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.window;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.CollectionWindowType;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.ds.utils.SourceEventFlowData;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventFlowEntity;
import java.util.HashMap;

public class CollectionWindowTrigger
extends TriggerDef
implements SourceEventFlowData {
    public static final String COLLECTION_WINDOW_CHANGE_EVENT_ID = "event.CollectionWindowChange";
    protected AbstractDataspace dataspace;
    protected Collection collection;
    protected CollectionWindowType windowType;

    CollectionWindowTrigger(NameManager.ObjectName name, Collection collection, CollectionWindowType windowType, int statType) {
        super(name, 6, statType, true, collection.getBaseTable(), new Table[5], new RangeVariable[5], null, null, null);
        this.collection = collection;
        this.windowType = windowType;
        this.enabled = true;
        this.dataspace = (AbstractDataspace)this.table.database.schemaManager.findSchema(collection.getObjectName().schema.name);
    }

    @Override
    public void enable(Session session) {
        super.enable(session);
    }

    @Override
    public void disable() {
        super.disable();
    }

    void bindEvent() {
        try {
            this.dataspace.bindProducerForSystem(COLLECTION_WINDOW_CHANGE_EVENT_ID, this);
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to bind event id for collection window change event.");
        }
    }

    public void destroy() {
        try {
            this.dataspace.unbindProducerFor(COLLECTION_WINDOW_CHANGE_EVENT_ID, this);
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to bind event id for collection window change event.");
        }
    }

    @Override
    public String getSQL() {
        return "";
    }

    @Override
    public EventFlowEntity getEntity() {
        return EventFlowEntity.DATASPACE_WINDOW_TRIGGER;
    }

    @Override
    public String getEntityName() {
        return this.getObjectName().name;
    }

    @Override
    public EventScope getEntityScope() {
        return this.dataspace.getEventScope();
    }

    @Override
    public HashMap<String, String> getEntityParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("collection", this.collection.getCollectionName());
        result.put("windowType", this.windowType.name());
        return result;
    }
}

