/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.window;

import com.streamscape.Trace;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.CollectionWindowType;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.window.CollectionWindowTrigger;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.timer.FabricTimer;
import com.streamscape.lib.timer.FabricTimerManager;
import com.streamscape.lib.timer.FabricTimerTask;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;

public class BatchTimeTableWindowTrigger
extends CollectionWindowTrigger {
    long actualWindowSize = 0L;
    Session windowCheckSession = null;
    FabricTimer timer = null;
    RowMetaData metaData;
    Type[] types;

    public BatchTimeTableWindowTrigger(NameManager.ObjectName name, Collection collection, long windowSizeInMillis) {
        super(name, collection, CollectionWindowType.BATCH_TIME_WINDOW, 50);
        this.actualWindowSize = windowSizeInMillis;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
        this.windowCheckSession = this.dataspace.createSession();
        this.windowCheckSession.setAutoCommit(false);
        this.bindEvent();
        this.metaData = SqlUtils.getCollectionMeta(this.collection);
        this.types = this.collection.getBaseTable().getColumnTypes();
    }

    @Override
    public synchronized void pushPair(Session session, Object[] oldData, Object[] newData) {
        PersistentStore store = this.table.getRowStore(session);
        long currentSize = store.elementCount();
        try {
            if (currentSize == 1L) {
                this.timer = FabricTimerManager.getInstance().createTimer("DataspaceBatchTimeWindow", this.name.name + "Timer", new BatchTimerCaller(), this.actualWindowSize, 1);
                this.timer.start();
            }
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to initiate the time batch processing. " + error.getMessage());
        }
    }

    private void expireBatch() {
        RowSet oldRowSet = new RowSet(this.metaData);
        try {
            this.windowCheckSession.startTransaction();
            PersistentStore tableStore = this.table.getRowStore(this.windowCheckSession);
            RowIterator it = this.table.getPrimaryIndex().firstRow(tableStore);
            while (it.hasNext()) {
                Row row = it.getNextRow();
                Object[] oldRowSetData = row.getData();
                oldRowSet.addToRowSet(SqlUtils.convertSqlToJava(this.windowCheckSession, oldRowSetData, this.types));
                this.windowCheckSession.addDeleteAction((Table)row.getTable(), row, null);
            }
            this.windowCheckSession.commit(true);
            if (oldRowSet.getRowCount() > 0) {
                try {
                    this.collection.getBaseTable().fireWindowTriggers(this.windowCheckSession, oldRowSet, null);
                    MapEvent changeEvent = (MapEvent)EventDatagramFactory.getInstance().createEvent("event.CollectionWindowChange");
                    changeEvent.setEventStringProperty("collectionName", this.collection.getObjectName().name);
                    changeEvent.setEventStringProperty("windowType", this.windowType.name());
                    this.dataspace.raiseSystemEvent(changeEvent);
                }
                catch (Exception error) {
                    Trace.logException(this, error, true);
                }
            }
        }
        catch (Throwable ex) {
            this.windowCheckSession.rollback(true);
            Trace.logException(this, ex, true);
        }
    }

    @Override
    public void destroy() {
        if (this.windowCheckSession != null) {
            this.windowCheckSession.close();
            this.windowCheckSession = null;
        }
        super.destroy();
    }

    class BatchTimerCaller
    implements FabricTimerTask {
        BatchTimerCaller() {
        }

        @Override
        public void onSuspend(FabricTimer timer) {
        }

        @Override
        public void onStop(FabricTimer timer) {
        }

        @Override
        public void onStart(FabricTimer timer) {
        }

        @Override
        public void onResume(FabricTimer timer) {
        }

        @Override
        public void onReset(FabricTimer timer) {
        }

        @Override
        public void onCancel(FabricTimer timer) {
        }

        @Override
        public void execute(FabricTimer timer) {
            BatchTimeTableWindowTrigger.this.expireBatch();
        }
    }
}

