/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.window;

import com.streamscape.Trace;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.CollectionWindowType;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.window.CollectionWindowTrigger;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;

public class BatchSizeTableWindowTrigger
extends CollectionWindowTrigger {
    long windowSize;
    RowMetaData metaData;
    Type[] types;

    public BatchSizeTableWindowTrigger(NameManager.ObjectName name, Collection collection, long windowSize) {
        super(name, collection, CollectionWindowType.BATCH_SIZE_WINDOW, 50);
        this.windowSize = windowSize;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
        this.bindEvent();
        this.metaData = SqlUtils.getCollectionMeta(this.collection);
        this.types = this.collection.getBaseTable().getColumnTypes();
    }

    @Override
    public synchronized void pushPair(Session session, Object[] oldData, Object[] newData) {
        PersistentStore store = this.table.getRowStore(session);
        long elementCount = store.elementCount();
        if (elementCount < this.windowSize) {
            return;
        }
        RowSet oldRowSet = new RowSet(this.metaData);
        try {
            RowIterator it = this.table.getPrimaryIndex().firstRow(store);
            while (it.hasNext()) {
                Row row = it.getNextRow();
                Object[] oldRowSetData = row.getData();
                oldRowSet.addToRowSet(SqlUtils.convertSqlToJava(session, oldRowSetData, this.types));
                session.addDeleteAction((Table)row.getTable(), row, null);
            }
            this.collection.getBaseTable().fireWindowTriggers(session, oldRowSet, null);
            MapEvent changeEvent = (MapEvent)EventDatagramFactory.getInstance().createEvent("event.CollectionWindowChange");
            changeEvent.setEventStringProperty("collectionName", this.collection.getObjectName().name);
            changeEvent.setEventStringProperty("windowType", this.windowType.name());
            this.dataspace.raiseSystemEvent(changeEvent);
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
        }
    }
}

