/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.window;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.CollectionWindowType;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.window.CollectionWindowTrigger;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import java.util.ArrayList;

public class BatchSizeQueueWindowTrigger
extends CollectionWindowTrigger {
    int eventColumnIndex = -1;
    long windowSize;

    public BatchSizeQueueWindowTrigger(NameManager.ObjectName name, Collection collection, long windowSize) {
        super(name, collection, CollectionWindowType.BATCH_SIZE_WINDOW, 50);
        this.windowSize = windowSize;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
        this.eventColumnIndex = this.table.findColumn("Event");
        if (this.eventColumnIndex < 0) {
            throw new DataspaceException("Unable to initialize window mechanism because column with Event is missing.");
        }
        this.bindEvent();
    }

    @Override
    public synchronized void pushPair(Session session, Object[] oldData, Object[] newData) {
        if (this.eventColumnIndex < 0) {
            return;
        }
        PersistentStore store = this.table.getRowStore(session);
        long elementCount = store.elementCount();
        if (elementCount < this.windowSize) {
            return;
        }
        ArrayList<ImmutableEventDatagram> oldEventList = new ArrayList<ImmutableEventDatagram>();
        RowIterator it = this.table.getPrimaryIndex().firstRow(store);
        while (it.hasNext()) {
            Row row = it.getNextRow();
            Object event = row.getData()[this.eventColumnIndex];
            if (event != null) {
                oldEventList.add(this.collection.unwrapEvent(session, event));
            }
            session.addDeleteAction((Table)row.getTable(), row, null);
        }
        try {
            this.collection.getBaseTable().fireWindowTriggers(session, oldEventList, null);
            MapEvent changeEvent = (MapEvent)EventDatagramFactory.getInstance().createEvent("event.CollectionWindowChange");
            changeEvent.setEventStringProperty("collectionName", this.collection.getObjectName().name);
            changeEvent.setEventStringProperty("windowType", this.windowType.name());
            this.dataspace.raiseSystemEvent(changeEvent);
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
        }
    }
}

