/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.event;

import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.EventTriggerDefSQL;
import com.streamscape.ds.trigger.event.AbstractFunctionUnitEntry;
import com.streamscape.ds.trigger.event.FunctionUnit;
import com.streamscape.ds.types.DataspaceTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.ds.utils.schemaserialization.ObjectType;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.expression.function.ThisFunctionsUnit;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import java.util.StringTokenizer;

public class ThisFunctionUnit
extends FunctionUnit {
    ThisFunctionUnit() {
        super(FunctionsUnitType.THIS);
        this.addEntry(new GetCurrentEventEntry(this));
        this.addEntry(new GetCurrentDataspaceEntry(this));
        this.addEntry(new SetCurrentEventEntry(this));
        this.addEntry(new HasCurrentEventEntry(this));
        this.addEntry(new SetCurrentDataspaceEntry(this));
        this.addEntry(new DisableEntry(this));
        this.addEntry(new InvalidateEntry(this));
        this.addEntry(new GetCurrentCollectionEntry(this));
    }

    class GetCurrentEventEntry
    extends AbstractThisFunctionUnitEntry {
        GetCurrentEventEntry(ThisFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return ThisFunctionsUnit.GetCurrentEventFunction.metadata;
        }

        @Override
        public String getName() {
            return "getCurrentEvent";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            String eventId = session.sessionContext.triggerEventId;
            if (eventId != null) {
                return SqlUtils.getEventDataType(session, eventId);
            }
            return Types.getParameterSQLType(session, ImmutableEventDatagram.class);
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            return session.sessionContext.rplBlockCurrentEvent;
        }
    }

    class GetCurrentDataspaceEntry
    extends AbstractThisFunctionUnitEntry {
        GetCurrentDataspaceEntry(ThisFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return ThisFunctionsUnit.GetCurrentDataspaceFunction.metadata;
        }

        @Override
        public String getName() {
            return "getCurrentDataspace";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.DATASPACE;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 772};
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            DataspaceSchema dataspace = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name);
            if (dataspace != null) {
                DataspaceAccessor accessor;
                try {
                    accessor = dataspace.createDataspaceAccessor(dataspace.getDataspaceType(), dataspace.getName());
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to retrieve current dataspace reference.", error);
                }
                DataspaceTypeWrapper wrapper = new DataspaceTypeWrapper(accessor, () -> session);
                return wrapper;
            }
            return null;
        }
    }

    class SetCurrentEventEntry
    extends AbstractThisFunctionUnitEntry {
        SetCurrentEventEntry(ThisFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return ThisFunctionsUnit.SetCurrentEventFunction.metadata;
        }

        @Override
        public String getName() {
            return "setCurrentEvent";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            if (args[0] instanceof ImmutableEventDatagram) {
                session.sessionContext.rplBlockCurrentEvent = (ImmutableEventDatagram)args[0];
            }
            return null;
        }
    }

    class HasCurrentEventEntry
    extends AbstractThisFunctionUnitEntry {
        HasCurrentEventEntry(ThisFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return ThisFunctionsUnit.HasCurrentEventFunction.metadata;
        }

        @Override
        public String getName() {
            return "hasCurrentEvent";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_BOOLEAN;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            return session.sessionContext.rplBlockCurrentEvent != null;
        }
    }

    class SetCurrentDataspaceEntry
    extends AbstractThisFunctionUnitEntry {
        SetCurrentDataspaceEntry(ThisFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return ThisFunctionsUnit.SetCurrentDataspaceFunction.metadata;
        }

        @Override
        public String getName() {
            return "setCurrentDataspace";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            if (args == null || args.length < 1 || !(args[0] instanceof String)) {
                throw new DataspaceException("Dataspace name should be specified for '" + this.getName() + "' function unit call.");
            }
            String name = (String)args[0];
            String componentName = null;
            StringTokenizer tokenizer = new StringTokenizer(name, ".");
            if (tokenizer.countTokens() == 3) {
                tokenizer.nextToken();
                tokenizer.nextToken();
                componentName = tokenizer.nextToken();
            } else if (tokenizer.countTokens() == 2) {
                tokenizer.nextToken();
                componentName = tokenizer.nextToken();
            } else if (tokenizer.countTokens() == 1) {
                componentName = tokenizer.nextToken();
            } else {
                throw new DataspaceException("Invalid dataspace name '" + name + "' specified.");
            }
            DataspaceSchema dataspace = session.dataspaceStore.schemaManager.findSchema(componentName);
            if (dataspace == null) {
                throw new DataspaceException("Dataspace '" + name + "' does not exist.");
            }
            session.currentDataspace = dataspace.getObjectName();
            return null;
        }
    }

    class DisableEntry
    extends AbstractThisFunctionUnitEntry {
        DisableEntry(ThisFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return ThisFunctionsUnit.DisableFunction.metadata;
        }

        @Override
        public String getName() {
            return "disable";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            if (session.sessionContext.rplObject != null) {
                session.sessionContext.rplObject.disable();
            }
            return null;
        }
    }

    class InvalidateEntry
    extends AbstractThisFunctionUnitEntry {
        InvalidateEntry(ThisFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return ThisFunctionsUnit.InvalidateFunction.metadata;
        }

        @Override
        public String getName() {
            return "invalidate";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            if (session.sessionContext.rplObject != null) {
                String message = null;
                if (args != null && args.length > 0 && args[1] instanceof String) {
                    message = (String)args[1];
                }
                session.sessionContext.rplObject.invalidate(message);
            }
            return null;
        }
    }

    class GetCurrentCollectionEntry
    extends AbstractThisFunctionUnitEntry {
        GetCurrentCollectionEntry(ThisFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return new FunctionMetaData("getCurrentCollection", TypeFactory.STRING, FunctionMetaData.Arguments.builder().build(), "Returns collection name on which this trigger was executed. Collection name format: [<Dataspace Name>].[<Collection Name>]");
        }

        @Override
        public String getName() {
            return "getCurrentCollection";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.STRING;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            if (session.sessionContext.rplObject instanceof EventTriggerDefSQL) {
                Collection collection = ((EventTriggerDefSQL)session.sessionContext.rplObject).getCollection();
                if (collection != null) {
                    return "[" + collection.getSchemaName().getNameString() + "].[" + collection.getCollectionName() + "]";
                }
                throw new DataspaceException("Collection is not set for this trigger.");
            }
            if (session.sessionContext.rplObject != null) {
                throw new DataspaceException("Collection name can be get for triggers only and not for " + ObjectType.getNameByCode(session.sessionContext.rplObject.getObjectName().type) + ".");
            }
            throw new DataspaceException("Collection name can be get for triggers only.");
        }
    }

    abstract class AbstractThisFunctionUnitEntry
    extends AbstractFunctionUnitEntry {
        AbstractThisFunctionUnitEntry(ThisFunctionUnit this$0) {
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 772};
        }
    }
}

