/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.event;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.procedure.FunctionUnitCall;
import com.streamscape.ds.schema.server.ServerObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionData;
import com.streamscape.ds.trigger.event.AbstractFunctionUnitEntry;
import com.streamscape.ds.trigger.event.FunctionUnit;
import com.streamscape.ds.types.DataspaceTypeWrapper;
import com.streamscape.ds.types.DropboxType;
import com.streamscape.ds.types.DropboxTypeWrapper;
import com.streamscape.ds.types.RuntimeType;
import com.streamscape.ds.types.RuntimeTypeWrapper;
import com.streamscape.ds.types.ServerType;
import com.streamscape.ds.types.ServerTypeWrapper;
import com.streamscape.ds.types.ServiceType;
import com.streamscape.ds.types.ServiceTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.lib.utils.Utils;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.dispatcher.AccessorParentSessionLink;
import com.streamscape.sef.dropbox.DropBoxFileSystem;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.expression.function.SysFunctionsUnit;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.slex.AbstractLexiconProcessor;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.slang.SLSession;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;

public class SysFunctionUnit
extends FunctionUnit {
    private static Method GET_BY_INDEX_METHOD;

    SysFunctionUnit() {
        super(FunctionsUnitType.SYS);
        this.addEntry(new LookupEntry(this));
        this.addEntry(new GetGlobalVariableEntry(this));
        this.addEntry(new GetSystemVariableEntry(this));
        this.addEntry(new GetHostnameEntry(this));
        this.addEntry(new GetTypeEntry(this));
        this.addEntry(new QueryEntry());
        this.addEntry(new GetEntry());
        this.addEntry(new GetNodeNameEntry(this));
        this.addEntry(new ShutdownEntry(this));
        this.addEntry(new UseCurrentDataspaceSessionEntry());
    }

    static {
        try {
            GET_BY_INDEX_METHOD = NetworkInterface.class.getDeclaredMethod("getByIndex", Integer.TYPE);
            if (GET_BY_INDEX_METHOD != null) {
                GET_BY_INDEX_METHOD.setAccessible(true);
            }
        }
        catch (Exception exception) {
            Trace.logError(GetHostnameEntry.class, "Initialization of NetworkInterface.getByIndex method failed. Cause: " + String.valueOf(exception));
        }
    }

    public class LookupEntry
    extends AbstractSysFunctionUnitEntry {
        public LookupEntry(SysFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return SysFunctionsUnit.LookupFunction.metadata;
        }

        @Override
        public String getName() {
            return "lookup";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Types.getParameterSQLType(session, Object.class);
        }

        @Override
        public Object getResult(Session session, FunctionUnitCall parent, Object[] args, Expression[] nodes) {
            String name = this.checkArgumentType(args, 0, String.class);
            String nodeName = ModeratorUtils.extractNodeName(name);
            String componentType = ModeratorUtils.extractComponentNameType(name);
            String componentName = ModeratorUtils.extractComponentNameName(name);
            componentName = StringUtils.strip((String)componentName, (String)"[]");
            DataspaceSchema dataspace = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name);
            Type type = null;
            if (parent != null) {
                type = parent.getDataType();
            }
            if (type == null) {
                throw new DataspaceException("Unable to resolve '" + name + "' component type. ");
            }
            if (type instanceof com.streamscape.ds.types.DataspaceType) {
                DataspaceAccessor accessor;
                if (componentType == null || componentName == null) {
                    throw new DataspaceException("Invalid dataspace name '" + name + "' specified.");
                }
                DataspaceType dsType = null;
                try {
                    dsType = DataspaceType.valueOf(componentType.toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    throw new DataspaceException("Invalid dataspace type '" + componentType + "' specified. ");
                }
                try {
                    accessor = dataspace.getAccessorsPool().createDataspaceAccessor(nodeName, dsType, componentName, session.getUsername());
                    ((AccessorParentSessionLink)((Object)accessor)).setParentSession(session);
                    accessor.setRequestTimeout(session.getRequestTimeout());
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to get reference to dataspace '" + name + "'. " + Utils.formatException(error), error);
                }
                return new DataspaceTypeWrapper(accessor, () -> session);
            }
            if (type instanceof ServiceType) {
                if (componentType == null || componentName == null) {
                    throw new DataspaceException("Invalid service name '" + name + "' specified.");
                }
                ServiceAccessor accessor = null;
                try {
                    accessor = dataspace.getAccessorsPool().createServiceAccessor(nodeName, componentType, componentName);
                    ((AccessorParentSessionLink)((Object)accessor)).setParentSession(session);
                    accessor.setRequestTimeout(session.getRequestTimeout());
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to get reference to service '" + name + "'. " + Utils.formatException(error), error);
                }
                return new ServiceTypeWrapper(accessor);
            }
            if (type instanceof RuntimeType) {
                if (nodeName == null && componentType == null && componentName != null) {
                    nodeName = componentName;
                }
                SLSession slSession = null;
                try {
                    slSession = dataspace.getAccessorsPool().createSLSession(dataspace.getSystemConnection(), nodeName);
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to get reference to runtime '" + nodeName + "'. " + Utils.formatException(error), error);
                }
                return new RuntimeTypeWrapper(slSession);
            }
            if (type instanceof ServerType) {
                ServerObject serverObject;
                if (nodeName != null) {
                    throw new DataspaceException("It is not allowed to get reference to the server in another node.");
                }
                if (componentType == null) {
                    componentType = session.currentDataspace.name;
                }
                if ((serverObject = (ServerObject)session.dataspaceStore.schemaManager.getSchemaObject(componentName, componentType, 27)) == null) {
                    throw new DataspaceException("Server '" + name + "' not found.");
                }
                return new ServerTypeWrapper(serverObject, session);
            }
            if (type instanceof DropboxType) {
                if (nodeName != null && !nodeName.equalsIgnoreCase("dropbox")) {
                    throw new DataspaceException("Invalid DropBox reference. Should be just DropBox name or in format dropbox://<dropbox name>.");
                }
                DropBoxFileSystem fileSystem = SessionData.createDropBoxFileSystem(session, new String[]{DropBoxUtils.getDropBoxURL(componentName, "")});
                return new DropboxTypeWrapper(fileSystem, session);
            }
            throw new DataspaceException("Unable to resolve component '" + name + "' type. ");
        }
    }

    class GetGlobalVariableEntry
    extends AbstractSysFunctionUnitEntry {
        GetGlobalVariableEntry(SysFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return SysFunctionsUnit.GetGlobalVariableFunction.metadata;
        }

        @Override
        public String getName() {
            return "getGlobalVariable";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.STRING;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String variableName = this.checkArgumentType(args, 0, String.class);
            try {
                String value = this.getSystemVariable(variableName);
                if (value == null) {
                    value = DataspaceManager.getContext().getGlobalVariableFactory().getVariable(variableName);
                }
                return value;
            }
            catch (Exception exception) {
                Trace.logError(this, "Unable to resolve '" + variableName + "' global variable.");
                return null;
            }
        }

        private String getSystemVariable(String variableName) {
            String value;
            int pos = ((String)variableName).indexOf(".");
            if (pos != -1) {
                variableName = ((String)variableName).substring(0, pos) + "_" + ((String)variableName).substring(pos + 1);
            }
            if ((value = System.getenv((String)variableName)) != null && value.trim().length() == 0) {
                value = null;
            }
            return value;
        }
    }

    class GetSystemVariableEntry
    extends AbstractSysFunctionUnitEntry {
        GetSystemVariableEntry(SysFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return SysFunctionsUnit.GetSystemVariableFunction.metadata;
        }

        @Override
        public String getName() {
            return "getSystemVariable";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.STRING;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String variableName = this.checkArgumentType(args, 0, String.class);
            return System.getProperty(variableName);
        }
    }

    class GetHostnameEntry
    extends AbstractSysFunctionUnitEntry {
        GetHostnameEntry(SysFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return SysFunctionsUnit.GetHostnameFunction.metadata;
        }

        @Override
        public String getName() {
            return "getHostname";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 842, 1, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.STRING;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            NetworkInterface nic;
            String result = null;
            if (args.length <= 0) return System.getProperty("hostname");
            if (!(args[0] instanceof Number)) return System.getProperty("hostname");
            int interfaceIndex = ((Number)args[0]).intValue();
            if (GET_BY_INDEX_METHOD == null) {
                throw new DataspaceException("Obtaining interface with index '" + interfaceIndex + "' failed. Cause: NetworkInterface.getByIndex method not initialized.");
            }
            try {
                nic = (NetworkInterface)GET_BY_INDEX_METHOD.invoke(null, interfaceIndex);
            }
            catch (Exception exception) {
                throw new DataspaceException("Obtaining interface with index '" + interfaceIndex + "'. failed.");
            }
            if (nic == null) throw new DataspaceException("Interface with index '" + interfaceIndex + "' does not exist.");
            Enumeration<InetAddress> addresses = nic.getInetAddresses();
            while (result == null && addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                result = address.getHostAddress();
            }
            if (result != null) return result;
            Trace.logError(this, "Interface with index " + interfaceIndex + " '" + nic.getDisplayName() + "' does not have inet addresses.");
            return result;
        }
    }

    class GetTypeEntry
    extends AbstractSysFunctionUnitEntry {
        GetTypeEntry(SysFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return SysFunctionsUnit.GetTypeFunction.metadata;
        }

        @Override
        public String getName() {
            return "getType";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.STRING;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            Object objectForCheck = args[0];
            Type dataType = nodes[0].getDataType();
            if (dataType != null) {
                objectForCheck = dataType.convertSQLToJava(session, objectForCheck);
            }
            if (objectForCheck == null) {
                return "unassigned";
            }
            SemanticType type = session.sessionContext.typeAnalyzer.getSemanticTypeCache().lookupSemanticClass(objectForCheck.getClass());
            if (type != null) {
                return type.getTypeName();
            }
            return objectForCheck.getClass().getName();
        }
    }

    static class QueryEntry
    extends AbstractGetQueryEntry {
        public static final FunctionMetaData metadata = QueryEntry.createMetaData();

        QueryEntry() {
        }

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("query", TypeFactory.createSemanticTypeType(RowSet.class.getSimpleName(), RowSet.class.getName()), FunctionMetaData.Arguments.builder().add("query", TypeFactory.STRING, "slang query or semicolon delimited queries ").build(), "Executes slang query(queries) in parent(runtime or service) context in system session.\nIf parent slang session doesn't then new system slang session is created. By default dataspace session in system slang session points to SDS.\nTo have dataspace session which points to the current dataspace session execute sys.useCurrentDataspaceSession(true).\nRowSet result of last query returned.\nIf result is error result exception thrown. If result is not RowSet then RowSet with one column Response and one row returned.\nIf left side operand type is not RowSet then result is tried to be cast to left side type.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public String getName() {
            return "query";
        }

        @Override
        protected Object convertSLResponse(Session session, FunctionUnitCall parent, SLResponse slResponse) throws SQLException {
            RowSet rowSet = null;
            if (slResponse.getRowSet() != null) {
                rowSet = slResponse.getRowSet();
            } else {
                RowMetaData meta = new RowMetaData();
                meta.addColumn("Response", SQLType.STRING);
                rowSet = new RowSet(meta);
                if (slResponse.getText() != null) {
                    rowSet.addToRowSet(new Object[]{slResponse.getText()});
                } else {
                    rowSet.addToRowSet(new Object[]{"OK"});
                }
            }
            return rowSet;
        }
    }

    public static class GetEntry
    extends AbstractGetQueryEntry {
        public static final FunctionMetaData metadata = GetEntry.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("get", TypeFactory.createSemanticTypeType("object", Object.class.getName()), FunctionMetaData.Arguments.builder().add("query", TypeFactory.STRING, "slang query or semicolon delimited queries ").build(), "Executes slang query(queries) in parent(runtime or service) context in system session.\nIf parent slang session doesn't then new system slang session is created. By default dataspace session in system slang session points to SDS.\nTo have dataspace session which points to the current dataspace session execute sys.useCurrentDataspaceSession(true).\nReturns the object depending on return value of the last query:\n   - if value is object this object is returned\n   - if value is RowSet with one row and one column the object from first row and first column is returned\n   - if there is a string object it is tried to be deserialized to left side object type\n   - if the is a RowSet with more than one row or more than one column this RowSet is returned\nIf result is error result exception thrown.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public String getName() {
            return "get";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        protected Object convertSLResponse(Session session, FunctionUnitCall parent, SLResponse slResponse) throws SQLException, SerializerException {
            if (slResponse.getObject() != null) {
                return slResponse.getObject();
            }
            Class<?> clazz = null;
            if (parent != null && parent.getDataType() != null) {
                clazz = parent.getDataType().getInternalClass(session);
            }
            return GetEntry.convertSLResponseTextOrRowSet(clazz, slResponse);
        }

        public static Object convertSLResponseTextOrRowSet(Class clazz, SLResponse slResponse) throws SerializerException, SQLException {
            if (slResponse.getText() != null) {
                return GetEntry.deserializeText(clazz, slResponse.getText());
            }
            if (slResponse.getRowSet() != null) {
                RowSet rowSet = slResponse.getRowSet();
                if (clazz == RowSet.class) {
                    return rowSet;
                }
                if (rowSet.getMeta().getColumnCount() == 1) {
                    if (rowSet.getRowCount() == 1) {
                        rowSet.next();
                        Object object = rowSet.getObject(1);
                        if (object instanceof String) {
                            return GetEntry.deserializeText(clazz, (String)object);
                        }
                        return object;
                    }
                    if (rowSet.getRowCount() == 0) {
                        return null;
                    }
                }
                return rowSet;
            }
            return null;
        }

        public static Object deserializeText(Class<?> clazz, String text) throws SerializerException {
            if (clazz == String.class) {
                return text;
            }
            if (text.trim().startsWith("<")) {
                return GetEntry.deserializeTextXml(clazz, text);
            }
            return GetEntry.deserializeTextJson(clazz, text);
        }

        public static Object deserializeTextXml(Class<?> clazz, String text) throws SerializerException {
            XSerializer serializer = DataspaceStore.getContext().getXSerializer();
            if (clazz == null || clazz == Object.class) {
                return serializer.deserialize(text);
            }
            try {
                Object result = serializer.deserialize(text);
                if (result != null && !clazz.isAssignableFrom(result.getClass())) {
                    return serializer.deserialize(clazz, text);
                }
                return result;
            }
            catch (Exception exception) {
                return serializer.deserialize(clazz, text);
            }
        }

        public static Object deserializeTextJson(Class<?> clazz, String text) throws SerializerException {
            if (clazz == null || clazz == Object.class) {
                Object result = null;
                try {
                    result = DataspaceStore.getContext().getJSONSerializer().deserialize(text);
                    if (result instanceof Map) {
                        throw new Exception("fake");
                    }
                    return result;
                }
                catch (Exception exception) {
                    try {
                        Object result1 = HTTPUtils.getJsonSerializerForRestNoRoot().deserialize(text);
                        if (result1 instanceof Map) {
                            if (result == null) {
                                result1 = result;
                            }
                            throw new Exception("fake");
                        }
                        return result1;
                    }
                    catch (Exception exception1) {
                        try {
                            return HTTPUtils.getJsonSerializerForRest().deserialize(text);
                        }
                        catch (Exception exception2) {
                            if (result != null) {
                                return result;
                            }
                            throw exception2;
                        }
                    }
                }
            }
            try {
                return DataspaceStore.getContext().getJSONSerializer().deserialize(clazz, text);
            }
            catch (Exception exception) {
                try {
                    return HTTPUtils.getJsonSerializerForRestNoRoot().deserialize(clazz, text);
                }
                catch (Exception exception1) {
                    return HTTPUtils.getJsonSerializerForRest().deserialize(clazz, text);
                }
            }
        }
    }

    class GetNodeNameEntry
    extends AbstractSysFunctionUnitEntry {
        GetNodeNameEntry(SysFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return SysFunctionsUnit.GetGlobalVariableFunction.metadata;
        }

        @Override
        public String getName() {
            return "getNodeName";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.STRING;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            return DataspaceManager.getContext().getName();
        }
    }

    class ShutdownEntry
    extends AbstractSysFunctionUnitEntry {
        ShutdownEntry(SysFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return new FunctionMetaData("shutdown", TypeFactory.VOIDTYPE, "Shutdown current node.");
        }

        @Override
        public String getName() {
            return "shutdown";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.OTHER;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            Executors.newSingleThreadExecutor().execute(() -> RuntimeContext.getInstance().shutdown());
            return null;
        }
    }

    static class UseCurrentDataspaceSessionEntry
    extends AbstractSysFunctionUnitEntry {
        public static final FunctionMetaData metadata = UseCurrentDataspaceSessionEntry.createMetaData();

        UseCurrentDataspaceSessionEntry() {
        }

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("useCurrentDataspaceSession", TypeFactory.BOOLEAN, FunctionMetaData.Arguments.builder().add("value", TypeFactory.BOOLEAN, "use current dataspace session or not ").build(), "Sets use current dataspace or not for sys.query and sys.get operations.\nReturns previous value. By default SDS dataspace session is used in sys.query.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public String getName() {
            return "useCurrentDataspaceSession";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Types.getParameterSQLType(session, Boolean.class);
        }

        @Override
        public Object getResult(Session session, FunctionUnitCall parent, Object[] args, Expression[] nodes) {
            Boolean value = this.checkArgumentType(args, 0, Boolean.class);
            return session.setUseCurrentDataspaceSessionInSysQuery(value);
        }
    }

    public static abstract class AbstractGetQueryEntry
    extends AbstractSysFunctionUnitEntry {
        private static ThreadLocal<AbstractLexiconProcessor> lexiconProcessorThreadLocal = new ThreadLocal();
        private static ThreadLocal<MFSession> mfSessionThreadLocal = new ThreadLocal();
        private static Map<String, Session> dataspaceSessionForSysQuery = new ConcurrentHashMap<String, Session>();
        SLSession slSession = null;
        MacroProcessor processor = new MacroProcessor();

        public static boolean setLexiconProcessorIfNotSet(AbstractLexiconProcessor lexiconProcessor, MFSession session) {
            if (lexiconProcessorThreadLocal.get() != null) {
                return false;
            }
            lexiconProcessorThreadLocal.set(lexiconProcessor);
            mfSessionThreadLocal.set(session);
            return true;
        }

        public static void resetServiceLexiconProcessor() {
            lexiconProcessorThreadLocal.set(null);
            mfSessionThreadLocal.set(null);
        }

        public static void setDataspaceSessionForSysQuery(String sessionName, Session session) {
            dataspaceSessionForSysQuery.put(sessionName, session);
        }

        public static void resetDataspaceSessionForSysQuery(String sessionName) {
            dataspaceSessionForSysQuery.remove(sessionName);
        }

        public static Session getDataspaceSessionForSysQuery(String sessionName) {
            return dataspaceSessionForSysQuery.get(sessionName);
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Types.getParameterSQLType(session, Object.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getResult(Session session, FunctionUnitCall parent, Object[] args, Expression[] nodes) {
            String query = this.checkArgumentType(args, 0, String.class);
            String temp = this.processor.process(query);
            Trace.logDebug(this, "Executing SLANG operation '{}'", temp);
            try {
                SLResponse slResponse = null;
                if (lexiconProcessorThreadLocal.get() != null) {
                    slResponse = lexiconProcessorThreadLocal.get().invoke(temp, mfSessionThreadLocal.get(), 0L);
                } else if (session.isUseCurrentDataspaceSessionInSysQuery()) {
                    if (session.slSessionForSysQuery == null) {
                        session.slSessionForSysQuery = session.dataspaceStore.schemaManager.findSchema("SDS").getSystemConnection().createSLSession();
                    }
                    try {
                        AbstractGetQueryEntry.setDataspaceSessionForSysQuery(session.slSessionForSysQuery.getName(), session);
                        slResponse = session.slSessionForSysQuery.slangRequest(temp, 0L);
                    }
                    finally {
                        AbstractGetQueryEntry.resetDataspaceSessionForSysQuery(session.slSessionForSysQuery.getName());
                    }
                } else {
                    slResponse = this.checkSLSession(session).slangRequest(temp, 0L);
                }
                if (!slResponse.isOK()) {
                    throw slResponse.getException() != null ? new DataspaceException(slResponse.getException()) : new DataspaceException(slResponse.getText());
                }
                return this.convertSLResponse(session, parent, slResponse);
            }
            catch (Exception error) {
                throw new DataspaceException(Utils.formatExceptionWithUnrepeatedCauses(error));
            }
        }

        protected abstract Object convertSLResponse(Session var1, FunctionUnitCall var2, SLResponse var3) throws SQLException, SerializerException;

        private synchronized SLSession checkSLSession(Session session) {
            if (this.slSession != null && !this.slSession.isOpened()) {
                this.slSession = null;
            }
            if (this.slSession == null) {
                try {
                    DataspaceSchema dataspace = session.dataspaceStore.schemaManager.findSchema("SDS");
                    this.slSession = dataspace.getSystemConnection().createSLSession();
                }
                catch (Exception exception) {
                    throw new DataspaceException("Creation of SLANG session failed.", exception);
                }
            }
            return this.slSession;
        }
    }

    static abstract class AbstractSysFunctionUnitEntry
    extends AbstractFunctionUnitEntry {
        AbstractSysFunctionUnitEntry() {
        }
    }
}

