/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.event;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.statement.StatementProcedure;
import com.streamscape.ds.parser.statement.StatementRplExec;
import com.streamscape.ds.schema.event.Actor;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.event.AbstractFunctionUnitEntry;
import com.streamscape.ds.trigger.event.FunctionUnit;
import com.streamscape.ds.types.Type;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.slex.file.SLFileSessionContext;

public class SessionFunctionUnit
extends FunctionUnit {
    SessionFunctionUnit() {
        super(FunctionsUnitType.SESSION);
        this.addEntry(new GetFetchSizeEntry());
        this.addEntry(new SetFetchSizeEntry());
        this.addEntry(new IsServerContextEntry());
        this.addEntry(new IsClientContextEntry());
        this.addEntry(new SetServerContextEntry());
        this.addEntry(new SetClientContextEntry());
        this.addEntry(new SetTimeoutEntry());
        this.addEntry(new GetTimeoutEntry());
    }

    private static DataspaceException notInRPLContextException() {
        return new DataspaceException("Session package settings can only be changed in RPL context.");
    }

    private static boolean isInsideFunction(Session session) {
        return session.sessionContext.currentStatement instanceof StatementProcedure || session.sessionContext.currentStatement instanceof StatementRplExec || session.sessionContext.rplObject instanceof RplScript || session.sessionContext.rplObject instanceof Actor;
    }

    static class GetFetchSizeEntry
    extends AbstractFunctionUnitEntry {
        public static final FunctionMetaData metadata = GetFetchSizeEntry.createMetaData();

        GetFetchSizeEntry() {
        }

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("getFetchSize", TypeFactory.INT, "Returns current session fetch size.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public String getName() {
            return "getFetchSize";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_INTEGER;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 772};
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            return session.getFetchSize();
        }
    }

    static class SetFetchSizeEntry
    extends AbstractFunctionUnitEntry {
        public static final FunctionMetaData metadata = SetFetchSizeEntry.createMetaData();

        SetFetchSizeEntry() {
        }

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("setFetchSize", TypeFactory.INT, FunctionMetaData.Arguments.builder().add("fetchSize", TypeFactory.INT, "Fetch size to set.").build(), "Sets current session fetch size for the current function call statement.\nShould be used in RPL context only.. Returns old fetch size.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public String getName() {
            return "setFetchSize";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_INTEGER;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            if (args == null || args.length < 1 || !(args[0] instanceof Integer)) {
                throw new DataspaceException("Fetch size should be specified for '" + this.getName() + "' function unit call.");
            }
            if (!SessionFunctionUnit.isInsideFunction(session)) {
                throw SessionFunctionUnit.notInRPLContextException();
            }
            Integer fetchSize = (Integer)args[0];
            int oldFetchSize = session.getFetchSize();
            session.setStatementFetchSize(fetchSize);
            return oldFetchSize;
        }
    }

    static class IsServerContextEntry
    extends AbstractFunctionUnitEntry {
        public static final FunctionMetaData metadata = IsServerContextEntry.createMetaData();

        IsServerContextEntry() {
        }

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("isServerContext", TypeFactory.BOOLEAN, "Returns true if server context is set.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public String getName() {
            return "isServerContext";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_BOOLEAN;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 772};
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            return session.getSLFileSessionContext() == SLFileSessionContext.SERVER;
        }
    }

    static class IsClientContextEntry
    extends AbstractFunctionUnitEntry {
        public static final FunctionMetaData metadata = IsClientContextEntry.createMetaData();

        IsClientContextEntry() {
        }

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("isClientContext", TypeFactory.BOOLEAN, "Returns true if client context is set.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public String getName() {
            return "isClientContext";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_BOOLEAN;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 772};
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            return session.getSLFileSessionContext() == SLFileSessionContext.CLIENT;
        }
    }

    static class SetServerContextEntry
    extends AbstractFunctionUnitEntry {
        public static final FunctionMetaData metadata = SetServerContextEntry.createMetaData();

        SetServerContextEntry() {
        }

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("setServerContext", TypeFactory.VOIDTYPE, "Sets current session context to SERVER. Should be used in RPL context only.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public String getName() {
            return "setServerContext";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 772};
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            if (!SessionFunctionUnit.isInsideFunction(session)) {
                throw SessionFunctionUnit.notInRPLContextException();
            }
            session.setStatementSLFileSessionContext(SLFileSessionContext.SERVER);
            return null;
        }
    }

    static class SetClientContextEntry
    extends AbstractFunctionUnitEntry {
        public static final FunctionMetaData metadata = SetClientContextEntry.createMetaData();

        SetClientContextEntry() {
        }

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("setClientContext", TypeFactory.VOIDTYPE, "Sets current session context to CLIENT. Should be used in RPL context only.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public String getName() {
            return "setClientContext";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 772};
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            if (!SessionFunctionUnit.isInsideFunction(session)) {
                throw SessionFunctionUnit.notInRPLContextException();
            }
            session.setStatementSLFileSessionContext(SLFileSessionContext.CLIENT);
            return null;
        }
    }

    static class SetTimeoutEntry
    extends AbstractFunctionUnitEntry {
        public static final FunctionMetaData metadata = SetTimeoutEntry.createMetaData();

        SetTimeoutEntry() {
        }

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("setTimeout", TypeFactory.LONG, FunctionMetaData.Arguments.builder().add("timeout", TypeFactory.LONG, "Timeout in milliseconds.").build(), "Sets current session timeout. This timeout will be derived by accessors created in this session.\nNOTE: This is applicable for executions in RPL only. When this request is executed from SLANG or another accessor\n      then timeout is derived from parent slang session or accessor.\n      I.e. if we execute it in slang then timeout will be timeout of slang session(get reply timeout).");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public String getName() {
            return "setTimeout";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.LONG;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            if (args == null || args.length < 1 || !(args[0] instanceof Number)) {
                throw new DataspaceException("Timeout should be specified for '" + this.getName() + "' function unit call.");
            }
            if (!SessionFunctionUnit.isInsideFunction(session)) {
                throw SessionFunctionUnit.notInRPLContextException();
            }
            Long timeout = ((Number)args[0]).longValue();
            long oldTimeout = session.getRequestTimeout();
            session.setRequestTimeout(timeout);
            return oldTimeout;
        }
    }

    static class GetTimeoutEntry
    extends AbstractFunctionUnitEntry {
        public static final FunctionMetaData metadata = GetTimeoutEntry.createMetaData();

        GetTimeoutEntry() {
        }

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("getTimeout", TypeFactory.LONG, "Returns current session timeout.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public String getName() {
            return "getTimeout";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.LONG;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 772};
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            return session.getRequestTimeout();
        }
    }
}

