/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.event;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.event.AbstractFunctionUnitEntry;
import com.streamscape.ds.trigger.event.FunctionUnit;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.expression.function.RepositoryFunctionsUnit;

class RepositoryFunctionUnit
extends FunctionUnit {
    RepositoryFunctionUnit() {
        super(FunctionsUnitType.REPOSITORY);
        this.addEntry(new LookupEntry(this));
    }

    class LookupEntry
    extends AbstractRepositoryFunctionUnitEntry {
        LookupEntry(RepositoryFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return RepositoryFunctionsUnit.LookupFunction.metadata;
        }

        @Override
        public String getName() {
            return "lookup";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Types.getParameterSQLType(session, Object.class);
        }

        @Override
        Object doGetResult(Session session, Object[] args, Expression[] nodes, RepositoryAccessor repository) {
            String namespace = this.checkArgumentType(args, 0, String.class);
            String objectName = this.checkArgumentType(args, 1, String.class);
            try {
                return repository.lookupObject(namespace, objectName);
            }
            catch (Exception error) {
                throw new DataspaceException("Unable to lookup object '" + objectName + "' from '" + namespace + "' namespace.", error);
            }
        }
    }

    abstract class AbstractRepositoryFunctionUnitEntry
    extends AbstractFunctionUnitEntry {
        AbstractRepositoryFunctionUnitEntry(RepositoryFunctionUnit this$0) {
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            RepositoryAccessor repository = DataspaceManager.getContext().getRepositoryAccessor();
            return this.doGetResult(session, args, nodes, repository);
        }

        abstract Object doGetResult(Session var1, Object[] var2, Expression[] var3, RepositoryAccessor var4);
    }
}

