/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.event;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.event.AbstractFunctionUnitEntry;
import com.streamscape.ds.trigger.event.FunctionUnit;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.omf.mapper.SemanticMap;
import com.streamscape.omf.mapper.SemanticMapRepositoryUtils;
import com.streamscape.omf.mapper.SemanticMapperImpl;
import com.streamscape.omf.mapper.parser.LocalSemanticMapperContext;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;

class MapperFunctionUnit
extends FunctionUnit {
    MapperFunctionUnit() {
        super(FunctionsUnitType.MAPPER);
        this.addEntry(new LookupEntry(this));
    }

    class LookupEntry
    extends AbstractMapperFunctionUnitEntry {
        private final FunctionMetaData metadata = new FunctionMetaData("lookup", TypeFactory.createObjectType(), FunctionMetaData.Arguments.builder().add("name", TypeFactory.STRING, "name of the mapper.").build(), "Finds and returns reference to the mapper with specified name.");

        LookupEntry(MapperFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return this.metadata;
        }

        @Override
        public String getName() {
            return "lookup";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Types.getParameterSQLType(session, SemanticMap.class);
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String objectName = this.checkArgumentType(args, 0, String.class);
            try {
                SemanticMap map = SemanticMapRepositoryUtils.lookupSemanticMap(objectName);
                if (!(map instanceof SemanticMap)) {
                    throw new IllegalArgumentException("Unable to load specified semantic map '" + objectName + "'.");
                }
                try {
                    DataspaceSchema schema = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name);
                    if (schema == null) {
                        throw new DataspaceException("Unable to init semantic mapper.");
                    }
                    LocalSemanticMapperContext semanticMapperContext = new LocalSemanticMapperContext(null, schema);
                    SemanticMapperImpl mapper = new SemanticMapperImpl(semanticMapperContext);
                    mapper.setSemanticMap(map);
                    mapper.init();
                    return mapper;
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to initialize semantic mapper '" + objectName + "'. Cause: " + error.getMessage(), error);
                }
            }
            catch (Exception error) {
                if (error instanceof DataspaceException) {
                    throw (DataspaceException)error;
                }
                throw new DataspaceException("Unable to initialize semantic mapper '" + objectName + "'. Cause: " + error.getMessage(), error);
            }
        }
    }

    abstract class AbstractMapperFunctionUnitEntry
    extends AbstractFunctionUnitEntry {
        AbstractMapperFunctionUnitEntry(MapperFunctionUnit this$0) {
        }
    }
}

