/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.event;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceLogger;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.event.AbstractFunctionUnitEntry;
import com.streamscape.ds.trigger.event.FunctionUnit;
import com.streamscape.ds.types.Type;
import com.streamscape.omf.serializer.AbstractSerializer;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.expression.function.LogFunctionsUnit;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;

public class LogFunctionUnit
extends FunctionUnit {
    LogFunctionUnit() {
        super(FunctionsUnitType.LOG);
        this.addEntry(new LogDebugEntry(this));
        this.addEntry(new LogErrorEntry(this));
        this.addEntry(new LogInfoEntry(this));
    }

    class LogDebugEntry
    extends AbstractLogFunctionUnitEntry {
        LogDebugEntry(LogFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return LogFunctionsUnit.LogDebugFunction.metadata;
        }

        @Override
        public String getName() {
            return "debug";
        }

        @Override
        void logMessage(Logger logger, String message) {
            logger.logDebug(message);
        }

        @Override
        void logMessage(DataspaceLogger logger, String entity, String message) {
            logger.logDebug(entity, message);
        }
    }

    class LogErrorEntry
    extends AbstractLogFunctionUnitEntry {
        LogErrorEntry(LogFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return LogFunctionsUnit.LogErrorFunction.metadata;
        }

        @Override
        public String getName() {
            return "error";
        }

        @Override
        void logMessage(Logger logger, String message) {
            logger.logError(message);
        }

        @Override
        void logMessage(DataspaceLogger logger, String entity, String message) {
            logger.logError(entity, message);
        }
    }

    class LogInfoEntry
    extends AbstractLogFunctionUnitEntry {
        LogInfoEntry(LogFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return LogFunctionsUnit.LogInfoFunction.metadata;
        }

        @Override
        public String getName() {
            return "info";
        }

        @Override
        void logMessage(Logger logger, String message) {
            logger.logInfo(message);
        }

        @Override
        void logMessage(DataspaceLogger logger, String entity, String message) {
            logger.logInfo(entity, message);
        }
    }

    abstract class AbstractLogFunctionUnitEntry
    extends AbstractFunctionUnitEntry {
        AbstractLogFunctionUnitEntry(LogFunctionUnit this$0) {
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            DataspaceLogger logger;
            String message = null;
            String content = null;
            if (args[0] != null) {
                message = args[0].toString();
            }
            if (args.length > 1 && args[1] != null) {
                AbstractSerializer serializer;
                Object result2 = args[1];
                boolean asXml = true;
                if (args.length > 2 && args[2] != null) {
                    Object result3 = args[2];
                    if (result3 instanceof String) {
                        if (((String)result3).equalsIgnoreCase("json")) {
                            asXml = false;
                        } else if (!((String)result3).equalsIgnoreCase("xml")) {
                            throw new DataspaceException("Invalid parameter '" + String.valueOf(result3) + "' value specified. Should be either 'xml' or 'json'.");
                        }
                    } else {
                        throw new DataspaceException("Invalid parameter value specified. Should be either 'xml' or 'json'.");
                    }
                }
                if (asXml) {
                    XSerializerFactory factory = DataspaceStore.getContext().getXSerializerFactory();
                    XSerializer xSerializer = factory.createSerializer("LogFunctionXmlSerializer");
                    xSerializer.mapAttribute("SemanticType", "class");
                    serializer = xSerializer;
                } else {
                    serializer = HTTPUtils.getJsonSerializerForRest(DataspaceStore.getContext()).withPrettyPrint(true);
                }
                try {
                    content = serializer.serialize(result2);
                }
                catch (Exception exception) {
                    Trace.logError(this, "Failed to serialize object log." + this.getName() + " function.", exception);
                }
            }
            String entity = session.sessionContext.rplObject != null ? session.sessionContext.rplObject.getObjectName().name : null;
            StringBuilder buffer = new StringBuilder();
            buffer.append(message);
            if (content != null) {
                buffer.append('\n').append(content);
            }
            message = buffer.toString();
            DataspaceSchema schema = session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name);
            DataspaceLogger dataspaceLogger = logger = schema != null ? schema.getLogger() : null;
            if (logger instanceof DataspaceLogger) {
                this.logMessage(logger, entity, message);
            } else {
                StringBuilder buffer2 = new StringBuilder();
                if (schema != null) {
                    buffer2.append('[');
                    buffer2.append(schema.getType()).append('/').append(schema.getName());
                    buffer2.append("] ");
                }
                if (entity != null) {
                    buffer2.append("[");
                    buffer2.append(entity);
                    buffer2.append("] ");
                }
                buffer2.append(message);
                message = buffer2.toString();
                if (logger != null) {
                    this.logMessage(logger, message);
                } else if (this instanceof LogDebugEntry) {
                    Trace.logDebug(this, message);
                } else if (this instanceof LogErrorEntry) {
                    Trace.logError(this, message);
                } else {
                    Trace.logInfo(this, message);
                }
            }
            return null;
        }

        abstract void logMessage(Logger var1, String var2);

        abstract void logMessage(DataspaceLogger var1, String var2, String var3);
    }
}

