/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.event;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.schema.procedure.FunctionUnitCall;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.stable.rplmethod.RPLMethodsCache;
import com.streamscape.ds.stable.rplmethod.RPLMethodsCacheImpl;
import com.streamscape.ds.trigger.event.FunctionUnit;
import com.streamscape.ds.trigger.event.FunctionUnitEntry;
import com.streamscape.ds.types.Type;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.evtrigger.function.SemanticTypeLookupContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContextImpl;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.fields.FieldsMethodsAllowedForCompletion;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.stream.Collectors;

public class FunctionUnitBasedOnType
extends FunctionUnit {
    private final Class clazz;

    public FunctionUnitBasedOnType(FunctionsUnitType type, Class clazz) {
        super(type);
        this.clazz = clazz;
        this.initEntries();
    }

    private void initEntries() {
        for (Method method : this.clazz.getMethods()) {
            try {
                if (!FieldsMethodsAllowedForCompletion.isMethodAllowed(this.clazz, method, false)) continue;
                this.addEntry(new FunctionUnitEntryBasedOnMethod(method));
            }
            catch (Exception exception) {
                Trace.logError(FunctionUnitBasedOnType.class, "Failed to initialize method " + String.valueOf(method) + " on class " + String.valueOf(this.clazz) + ": " + String.valueOf(exception));
            }
        }
    }

    public static class FunctionUnitEntryBasedOnMethod
    implements FunctionUnitEntry {
        private final Method method;
        private final FunctionMetaData metaData;

        public FunctionUnitEntryBasedOnMethod(Method method) {
            this.method = method;
            TriggerFunctionParserContextImpl context = new TriggerFunctionParserContextImpl(DataspaceManager.getContext());
            FunctionMetaData.Arguments.Builder builder = FunctionMetaData.Arguments.builder();
            for (Parameter parameter : method.getParameters()) {
                builder.add(parameter.getName(), TypeFactory.resolveType(parameter.getType(), (SemanticTypeLookupContext)context), "");
            }
            RPLMethodsCache.RPLMethodInfo rplMethodInfo = RPLMethodsCacheImpl.getRPLMethodInfo(method);
            Object description = "";
            if (rplMethodInfo != null) {
                description = rplMethodInfo.description();
                if (rplMethodInfo.samples() != null && rplMethodInfo.samples().size() > 0) {
                    description = (String)description + "\nSamples:\n\n" + rplMethodInfo.samples().stream().collect(Collectors.joining("\n"));
                }
            }
            this.metaData = new FunctionMetaData(method.getName(), TypeFactory.resolveType(method.getReturnType(), (SemanticTypeLookupContext)context), builder.build(), (String)description);
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public FunctionMetaData getMetaData() {
            return this.metaData;
        }

        @Override
        public short[] getParameters() {
            return new short[0];
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            throw new DataspaceException("resolveReturnDataType not supported for this functon unit");
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            throw new DataspaceException("getResult not supported for this functon unit");
        }

        @Override
        public Object getResult(Session session, FunctionUnitCall parent, Object[] args, Expression[] nodes) {
            throw new DataspaceException("getResult not supported for this functon unit");
        }
    }
}

