/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.event;

import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.event.FunctionUnitEntry;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.slex.lang.completion.DSLCompletion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FunctionUnit {
    FunctionsUnitType type;
    Map<String, FunctionUnitEntry> entries = new HashMap<String, FunctionUnitEntry>();

    FunctionUnit(FunctionsUnitType type) {
        this.type = type;
    }

    public FunctionsUnitType getType() {
        return this.type;
    }

    void addEntry(FunctionUnitEntry entry) {
        this.entries.put(entry.getName(), entry);
    }

    public FunctionUnitEntry getEntry(String entryName) {
        return this.entries.get(entryName);
    }

    public Collection<FunctionUnitEntry> listEntries() {
        return this.entries.values();
    }

    public Set<String> listEntryNames() {
        return this.entries.keySet();
    }

    public DSLCompletion complete(Session session, String prefix) {
        ArrayList<String> functions = new ArrayList<String>();
        for (String function : this.entries.keySet()) {
            if (prefix != null && !function.startsWith(prefix)) continue;
            functions.add(function);
        }
        DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, functions);
        if (completion != null) {
            for (String function : functions) {
                FunctionUnitEntry entry = this.getEntry(function);
                if (entry == null) continue;
                completion.addSuggestion(entry.getMetaData().buildMethodSuggestion().setOffset(prefix));
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }
}

