/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.event;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.info.HelpRegistry;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionData;
import com.streamscape.ds.trigger.event.AbstractFunctionUnitEntry;
import com.streamscape.ds.trigger.event.FunctionUnit;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.fs.client.FilePermissions;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.FileSystemProvider;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.GzipUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.lib.utils.Utils;
import com.streamscape.lib.utils.ZipUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.sys.Void;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.evtrigger.file.CopyFileActionStrategy;
import com.streamscape.sef.evtrigger.file.DeleteFileActionStrategy;
import com.streamscape.sef.evtrigger.file.FileActionStrategy;
import com.streamscape.sef.evtrigger.file.MoveFileActionStrategy;
import com.streamscape.sef.evtrigger.file.RenameFileActionStrategy;
import com.streamscape.sef.evtrigger.function.expression.function.FileFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.tools.lexer.BufferUtils;
import com.streamscape.tools.lexer.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class FileFunctionUnit
extends FunctionUnit {
    private static final String tempDir = System.getProperty("EVFSDaemon.txlog.dir", ".txlog");

    FileFunctionUnit() {
        super(FunctionsUnitType.FILE);
        this.addEntry(new CopyFileUnitEntry(this));
        this.addEntry(new MoveFileUnitEntry(this));
        this.addEntry(new RenameFileUnitEntry(this));
        this.addEntry(new DeleteFileUnitEntry(this));
        this.addEntry(new ZipFileUnitEntry(this));
        this.addEntry(new UnzipFileUnitEntry(this));
        this.addEntry(new CreateFileFunctionUnitEntry(this));
        this.addEntry(new CreateDirectoryFunctionUnitEntry(this));
        this.addEntry(new SizeFileUnitEntry(this));
        this.addEntry(new ListUnitEntry(this));
        this.addEntry(new ListDirsUnitEntry(this));
        this.addEntry(new LineCountFileUnitEntry(this));
        this.addEntry(new ExistsFunctionUnitEntry(this));
        this.addEntry(new GzipFileUnitEntry(this));
        this.addEntry(new GunzipFileUnitEntry(this));
        this.addEntry(new ExtractFilePartUnitEntry(this));
        this.addEntry(new SplitFileUnitEntry(this));
        this.addEntry(new ListZipEntriesUnitEntry(this));
    }

    class CopyFileUnitEntry
    extends AbstractTransactionalFileFunctionUnitEntry {
        CopyFileUnitEntry(FileFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return FileFunctionsUnit.CopyFunction.metadata;
        }

        @Override
        public String getName() {
            return "copy";
        }

        @Override
        protected FileActionStrategy createStrategy(Object[] args) {
            String fileName = this.checkArgumentType(args, 1, String.class);
            return new CopyFileActionStrategy(BufferUtils.unslashPath(fileName), tempDir, false);
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String sourceFile = BufferUtils.unslashPath((String)args[0]);
            String targetFile = BufferUtils.unslashPath((String)args[1]);
            sourceFile = SessionData.checkDataspaceFileAccess(session, sourceFile);
            targetFile = SessionData.checkDataspaceFileAccess(session, targetFile);
            if (DropBoxUtils.isDropBoxURL(sourceFile) || DropBoxUtils.isDropBoxURL(targetFile)) {
                FileSystem sourceFileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, sourceFile);
                FileSystem targetFileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, targetFile);
                try (InputStream inputStream = sourceFileSystem.open(sourceFile);
                     OutputStream outputStream = targetFileSystem.create(targetFile);){
                    FileIOUtils.copy(inputStream, outputStream);
                }
                catch (IOException e) {
                    throw new DataspaceException(e);
                }
                catch (UtilitiesException e) {
                    throw new DataspaceException(e);
                }
                return new Void();
            }
            return super.getResult(session, args, nodes);
        }
    }

    class MoveFileUnitEntry
    extends AbstractTransactionalFileFunctionUnitEntry {
        MoveFileUnitEntry(FileFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return FileFunctionsUnit.MoveFunction.metadata;
        }

        @Override
        public String getName() {
            return "move";
        }

        @Override
        protected FileActionStrategy createStrategy(Object[] args) {
            String fileName = this.checkArgumentType(args, 1, String.class);
            return new MoveFileActionStrategy(BufferUtils.unslashPath(fileName), tempDir, false);
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String sourceFile = BufferUtils.unslashPath((String)args[0]);
            String targetFile = BufferUtils.unslashPath((String)args[1]);
            sourceFile = SessionData.checkDataspaceFileAccess(session, sourceFile);
            targetFile = SessionData.checkDataspaceFileAccess(session, targetFile);
            if (DropBoxUtils.isDropBoxURL(sourceFile) || DropBoxUtils.isDropBoxURL(targetFile)) {
                FileSystem sourceFileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, sourceFile);
                FileSystem targetFileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, targetFile);
                try (InputStream inputStream = sourceFileSystem.open(sourceFile);
                     OutputStream outputStream = targetFileSystem.create(targetFile);){
                    FileIOUtils.copy(inputStream, outputStream);
                }
                catch (IOException e) {
                    throw new DataspaceException(e);
                }
                catch (UtilitiesException e) {
                    throw new DataspaceException(e);
                }
                try {
                    sourceFileSystem.delete(sourceFile, false);
                }
                catch (IOException e) {
                    throw new DataspaceException(e);
                }
                return new Void();
            }
            return super.getResult(session, args, nodes);
        }
    }

    class RenameFileUnitEntry
    extends AbstractTransactionalFileFunctionUnitEntry {
        RenameFileUnitEntry(FileFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return FileFunctionsUnit.RenameFunction.metadata;
        }

        @Override
        public String getName() {
            return "rename";
        }

        @Override
        protected FileActionStrategy createStrategy(Object[] args) {
            String fileName = this.checkArgumentType(args, 1, String.class);
            return new RenameFileActionStrategy(BufferUtils.unslashPath(fileName), tempDir, false);
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String sourceFile = BufferUtils.unslashPath((String)args[0]);
            String targetFile = BufferUtils.unslashPath((String)args[1]);
            sourceFile = SessionData.checkDataspaceFileAccess(session, sourceFile);
            targetFile = SessionData.checkDataspaceFileAccess(session, targetFile);
            if (DropBoxUtils.isDropBoxURL(sourceFile) || DropBoxUtils.isDropBoxURL(targetFile)) {
                FileSystem sourceFileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, sourceFile);
                FileSystem targetFileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, targetFile);
                try (InputStream inputStream = sourceFileSystem.open(sourceFile);
                     OutputStream outputStream = targetFileSystem.create(targetFile);){
                    FileIOUtils.copy(inputStream, outputStream);
                }
                catch (IOException e) {
                    throw new DataspaceException(e);
                }
                catch (UtilitiesException e) {
                    throw new DataspaceException(e);
                }
                try {
                    sourceFileSystem.delete(sourceFile, false);
                }
                catch (IOException e) {
                    throw new DataspaceException(e);
                }
                return new Void();
            }
            return super.getResult(session, args, nodes);
        }
    }

    class DeleteFileUnitEntry
    extends AbstractTransactionalFileFunctionUnitEntry {
        DeleteFileUnitEntry(FileFunctionUnit this$0) {
            super(this$0);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return FileFunctionsUnit.DeleteFunction.metadata;
        }

        @Override
        public String getName() {
            return "delete";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        protected FileActionStrategy createStrategy(Object[] args) {
            return new DeleteFileActionStrategy(tempDir, false);
        }

        protected FileActionStrategy createStrategy() {
            return new DeleteFileActionStrategy(tempDir, false);
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String sourceFile = BufferUtils.unslashPath((String)args[0]);
            if (DropBoxUtils.isDropBoxURL(sourceFile = SessionData.checkDataspaceFileAccess(session, sourceFile))) {
                FileSystem sourceFileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, sourceFile);
                try {
                    sourceFileSystem.delete(sourceFile, true);
                }
                catch (IOException e) {
                    throw new DataspaceException(e);
                }
                return new Void();
            }
            return super.getResult(session, args, nodes);
        }
    }

    class ZipFileUnitEntry
    extends AbstractFunctionUnitEntry {
        ZipFileUnitEntry(FileFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return FileFunctionsUnit.ZipFunction.metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public String getName() {
            return "zip";
        }

        protected FileActionStrategy createStrategy(Object[] args) {
            return null;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            try {
                String sourcePath = BufferUtils.unslashPath(this.checkArgumentType(args, 0, String.class));
                String resultPath = BufferUtils.unslashPath(this.checkArgumentType(args, 1, String.class));
                sourcePath = SessionData.checkDataspaceFileAccess(session, sourcePath);
                resultPath = SessionData.checkDataspaceFileAccess(session, resultPath);
                ZipUtils.compress(sourcePath, resultPath, new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, sourcePath), new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, resultPath));
            }
            catch (IOException exception) {
                throw new DataspaceException("Failed to evaluate function. Cause: " + exception.getMessage());
            }
            return new Void();
        }
    }

    class UnzipFileUnitEntry
    extends AbstractFunctionUnitEntry {
        UnzipFileUnitEntry(FileFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return FileFunctionsUnit.UnzipFunction.metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public String getName() {
            return "unzip";
        }

        protected FileActionStrategy createStrategy(Object[] args) {
            return null;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            try {
                String sourceFile = BufferUtils.unslashPath(this.checkArgumentType(args, 0, String.class));
                String resultFolder = BufferUtils.unslashPath(this.checkArgumentType(args, 1, String.class));
                sourceFile = SessionData.checkDataspaceFileAccess(session, sourceFile);
                resultFolder = SessionData.checkDataspaceFileAccess(session, resultFolder);
                ZipUtils.extract(sourceFile, resultFolder, new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, sourceFile), new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, resultFolder));
            }
            catch (IOException exception) {
                throw new DataspaceException("Failed to evaluate function. Cause: " + exception.getMessage());
            }
            return new Void();
        }
    }

    class CreateFileFunctionUnitEntry
    extends AbstractCreateFileDirectoryFunctionUnitEntry {
        public final FunctionMetaData metadata = this.createMetaData();

        CreateFileFunctionUnitEntry(FileFunctionUnit this$0) {
            super(this$0);
        }

        private FunctionMetaData createMetaData() {
            return new FunctionMetaData("createFile", TypeFactory.STRING, FunctionMetaData.Arguments.builder().add("path", TypeFactory.STRING, "directory path").addOptional("permission", TypeFactory.STRING, "permission in format -rwxrwxrwx").build(), "Creates file on specified path with specified permissions. If permission not specified default will be used.\n\n" + HelpRegistry.dropboxHelp("Path "));
        }

        @Override
        public FunctionMetaData getMetaData() {
            return this.metadata;
        }

        @Override
        public String getName() {
            return "createFile";
        }

        @Override
        protected void doAction(Session session, String originalPath, String path, FilePermissions permissions) {
            try {
                FileSystem fileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, path);
                fileSystem.createNewFile(path, permissions);
            }
            catch (IOException exception) {
                throw new DataspaceException("Failed to file '" + originalPath + "'. Cause: " + exception.toString());
            }
        }
    }

    class CreateDirectoryFunctionUnitEntry
    extends AbstractCreateFileDirectoryFunctionUnitEntry {
        public final FunctionMetaData metadata = this.createMetaData();

        CreateDirectoryFunctionUnitEntry(FileFunctionUnit this$0) {
            super(this$0);
        }

        private FunctionMetaData createMetaData() {
            return new FunctionMetaData("createDirectory", TypeFactory.STRING, FunctionMetaData.Arguments.builder().add("path", TypeFactory.STRING, "file path").addOptional("permission", TypeFactory.STRING, "permission in format -rwxrwxrwx").build(), "Creates directory on specified path with specified permissions. If permission not specified default will be used.\n\n" + HelpRegistry.dropboxHelp("Path "));
        }

        @Override
        public FunctionMetaData getMetaData() {
            return this.metadata;
        }

        @Override
        public String getName() {
            return "createDirectory";
        }

        @Override
        protected void doAction(Session session, String originalPath, String path, FilePermissions permissions) {
            try {
                new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, path).mkdir(path, permissions);
            }
            catch (IOException exception) {
                throw new DataspaceException("Failed to create directory '" + originalPath + "'. Cause: " + exception.toString());
            }
        }
    }

    class SizeFileUnitEntry
    extends AbstractFunctionUnitEntry {
        SizeFileUnitEntry(FileFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return FileFunctionsUnit.SizeFunction.metadata;
        }

        @Override
        public String getName() {
            return "size";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.LONG;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String filepath = BufferUtils.unslashPath((String)args[0]);
            filepath = SessionData.checkDataspaceFileAccess(session, filepath);
            FileSystem fileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, filepath);
            try {
                if (!fileSystem.exists(filepath)) {
                    throw new DataspaceException("File '" + filepath + "' doesn't exist.");
                }
                return fileSystem.getSize(filepath);
            }
            catch (IOException e) {
                throw new DataspaceException(e);
            }
        }
    }

    class ListUnitEntry
    extends AbstractFunctionUnitEntry {
        ListUnitEntry(FileFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return new FunctionMetaData("list", TypeFactory.LIST, FunctionMetaData.Arguments.builder().add("directory", TypeFactory.STRING, "directory to list").addOptional("recursive", TypeFactory.BOOLEAN, "recursive or not").build(), "Gets file list.\n\n" + HelpRegistry.dropboxHelp("Directory "));
        }

        @Override
        public String getName() {
            return "list";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 842, 2, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.OTHER;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String filepath = BufferUtils.unslashPath((String)args[0]);
            filepath = SessionData.checkDataspaceFileAccess(session, filepath);
            boolean recursive = args[1] == null ? false : (Boolean)args[1];
            FileSystem fileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, filepath);
            try {
                if (!fileSystem.exists(filepath)) {
                    throw new DataspaceException("File '" + filepath + "' doesn't exist.");
                }
                return fileSystem.list(filepath, recursive);
            }
            catch (IOException e) {
                throw new DataspaceException(e);
            }
        }
    }

    class ListDirsUnitEntry
    extends AbstractFunctionUnitEntry {
        ListDirsUnitEntry(FileFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return new FunctionMetaData("listDirs", TypeFactory.LIST, FunctionMetaData.Arguments.builder().add("directory", TypeFactory.STRING, "directory to list").addOptional("recursive", TypeFactory.BOOLEAN, "recursive or not").build(), "Gets directory list.\n\n" + HelpRegistry.dropboxHelp("Directory "));
        }

        @Override
        public String getName() {
            return "listDirs";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 842, 2, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.OTHER;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String filepath = BufferUtils.unslashPath((String)args[0]);
            filepath = SessionData.checkDataspaceFileAccess(session, filepath);
            boolean recursive = args[1] == null ? false : (Boolean)args[1];
            FileSystem fileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, filepath);
            try {
                if (!fileSystem.exists(filepath)) {
                    throw new DataspaceException("File '" + filepath + "' doesn't exist.");
                }
                return new ArrayList(fileSystem.list(filepath, recursive).stream().filter(i -> i.isDirectory()).collect(Collectors.toList()));
            }
            catch (IOException e) {
                throw new DataspaceException(e);
            }
        }
    }

    class LineCountFileUnitEntry
    extends AbstractFunctionUnitEntry {
        LineCountFileUnitEntry(FileFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return FileFunctionsUnit.LineCountFunction.metadata;
        }

        @Override
        public String getName() {
            return "lineCount";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.LONG;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            Long l;
            block10: {
                Path path = Paths.get(BufferUtils.unslashPath((String)args[0]), new String[0]);
                Charset charset = StandardCharsets.UTF_8;
                if (args.length >= 2 && args[1] instanceof String) {
                    charset = Charset.forName((String)args[1]);
                }
                long lineCountToAnalyze = 0L;
                if (args.length >= 3 && args[2] instanceof Number) {
                    lineCountToAnalyze = ((Number)args[2]).longValue();
                }
                long[] length = new long[1];
                InputStream inputStream = SessionData.createFileInputStream(session, path.toString(), false, true, length);
                try {
                    l = FileUtils.getFileCharactersInfo(inputStream, charset, lineCountToAnalyze, length[0]).getLinesCount();
                    if (inputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        throw new DataspaceException("IO error:" + ex.getMessage());
                    }
                }
                inputStream.close();
            }
            return l;
        }
    }

    class ExistsFunctionUnitEntry
    extends AbstractFunctionUnitEntry {
        public final FunctionMetaData metadata = this.createMetaData();

        ExistsFunctionUnitEntry(FileFunctionUnit this$0) {
        }

        private FunctionMetaData createMetaData() {
            return new FunctionMetaData("exists", TypeFactory.BOOLEAN, FunctionMetaData.Arguments.builder().add("path", TypeFactory.STRING, "file path").build(), "Check if specified file or directory exists.\n\n" + HelpRegistry.dropboxHelp("File path "));
        }

        @Override
        public FunctionMetaData getMetaData() {
            return this.metadata;
        }

        @Override
        public String getName() {
            return "exists";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_BOOLEAN;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String filepath = BufferUtils.unslashPath((String)args[0]);
            try {
                return new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, filepath).exists(filepath);
            }
            catch (IOException e) {
                throw new DataspaceException(e);
            }
        }
    }

    class GzipFileUnitEntry
    extends AbstractFunctionUnitEntry {
        GzipFileUnitEntry(FileFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return new FunctionMetaData("gzip", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("sourceFile", TypeFactory.STRING, "source file path").add("resultFile", TypeFactory.STRING, "result gzip file path").build(), "Compresses file 'sourceFile' and creates GZIP archive.\n\n" + HelpRegistry.dropboxHelp("Files "));
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public String getName() {
            return "gzip";
        }

        protected FileActionStrategy createStrategy(Object[] args) {
            return null;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            try {
                String sourceFile = BufferUtils.unslashPath(this.checkArgumentType(args, 0, String.class));
                String resultFile = BufferUtils.unslashPath(this.checkArgumentType(args, 1, String.class));
                sourceFile = SessionData.checkDataspaceFileAccess(session, sourceFile);
                resultFile = SessionData.checkDataspaceFileAccess(session, resultFile);
                GzipUtils.compress(sourceFile, resultFile, new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, sourceFile), new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, resultFile));
            }
            catch (IOException exception) {
                throw new DataspaceException("Failed to evaluate function. Cause: " + exception.getMessage());
            }
            return new Void();
        }
    }

    class GunzipFileUnitEntry
    extends AbstractFunctionUnitEntry {
        GunzipFileUnitEntry(FileFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return new FunctionMetaData("gunzip", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("sourceFile", TypeFactory.STRING, "source GZIP file path").add("resultFile", TypeFactory.STRING, "result file").build(), "Uncompresses file 'sourceFile' and extracts it to 'resultFile'.\n\n" + HelpRegistry.dropboxHelp("Files "));
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public String getName() {
            return "gunzip";
        }

        protected FileActionStrategy createStrategy(Object[] args) {
            return null;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            try {
                String sourceFile = BufferUtils.unslashPath(this.checkArgumentType(args, 0, String.class));
                String resultFile = BufferUtils.unslashPath(this.checkArgumentType(args, 1, String.class));
                sourceFile = SessionData.checkDataspaceFileAccess(session, sourceFile);
                resultFile = SessionData.checkDataspaceFileAccess(session, resultFile);
                GzipUtils.extract(sourceFile, resultFile, new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, sourceFile), new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, resultFile));
            }
            catch (IOException exception) {
                throw new DataspaceException("Failed to evaluate function. Cause: " + exception.getMessage());
            }
            return new Void();
        }
    }

    class ExtractFilePartUnitEntry
    extends AbstractFunctionUnitEntry {
        public final FunctionMetaData metadata = this.createMetaData();

        ExtractFilePartUnitEntry(FileFunctionUnit this$0) {
        }

        private FunctionMetaData createMetaData() {
            return new FunctionMetaData("extractFilePart", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("sourceFile", TypeFactory.STRING, "source file path").add("targetFile", TypeFactory.STRING, "target file path").add("startLine", TypeFactory.INT, "start line starting at 1").add("endLine", TypeFactory.INT, "end line including").addOptional("charset", TypeFactory.STRING, "charset").build(), "Reads sources file from start line to end line and writes to target file.\n\n" + HelpRegistry.dropboxHelp("Files "));
        }

        @Override
        public FunctionMetaData getMetaData() {
            return this.metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 774, 788, 774, 788, 842, 2, 774, 788, 772};
        }

        @Override
        public String getName() {
            return "extractFilePart";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            try {
                InputStream inputStream;
                String sourceFile = BufferUtils.unslashPath((String)args[0]);
                String targetFile = BufferUtils.unslashPath((String)args[1]);
                long startLine = ((Number)args[2]).longValue();
                long endLine = ((Number)args[3]).longValue();
                Charset charset = StandardCharsets.UTF_8;
                if (args.length > 4 && args[4] instanceof String) {
                    charset = Charset.forName((String)args[4]);
                }
                if (startLine < 0L || endLine < 0L) {
                    inputStream = SessionData.createFileInputStream(session, sourceFile, false, true, null);
                    try {
                        long totalLinesCount = FileUtils.getFileCharactersInfo(inputStream, charset).getLinesCount();
                        if (startLine < 0L) {
                            startLine = totalLinesCount + startLine;
                        }
                        if (endLine < 0L) {
                            endLine = totalLinesCount + endLine;
                        }
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                inputStream = SessionData.createFileInputStream(session, sourceFile, false, true, null);
                try (OutputStream outputStream = SessionData.createFileOutputStream(session, targetFile, false, false);){
                    FileUtils.extractFilePart(inputStream, outputStream, startLine, endLine, charset);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Exception exception) {
                throw new DataspaceException("Failed to extract file part: " + Utils.formatExceptionWithUnrepeatedCauses(exception));
            }
            return new Void();
        }
    }

    class SplitFileUnitEntry
    extends AbstractFunctionUnitEntry {
        public final FunctionMetaData metadata = this.createMetaData();

        SplitFileUnitEntry(FileFunctionUnit this$0) {
        }

        private FunctionMetaData createMetaData() {
            return new FunctionMetaData("splitFile", TypeFactory.LONG, FunctionMetaData.Arguments.builder().add("sourceFile", TypeFactory.STRING, "source file path").add("targetFileDirectory", TypeFactory.STRING, TypeFactory.LIST, "target file directory or directories").add("preserveFirstLine", TypeFactory.BOOLEAN, "write first line to each file").add("numberOfSlices", TypeFactory.INT, "number of slices").add("suffixId", TypeFactory.STRING, "suffix id").add("slicesToWrite", TypeFactory.STRING, "number of slices to write").addOptional("charset", TypeFactory.STRING, "charset").build(), "Splits file to specified number of slices and writes to the to specified target directory or directories.\n\n" + HelpRegistry.dropboxHelp("Files ") + "\n\nSamples:\n\n   list targets = new list\n   targets.add('dropbox://myfiles1/root')\n   targets.add('dropbox://myfiles2/root')\n   file.splitFile('dropbox://myfiles/root/largefile.txt', targets, true, 10, null, 0)\n   \n   file.splitFile('myfile.txt', './splitted', false, 10, null, 3)");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return this.metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 774, 788, 774, 788, 774, 788, 842, 2, 774, 788, 772};
        }

        @Override
        public String getName() {
            return "splitFile";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.LONG;
        }

        @Override
        public Object getResult(final Session session, Object[] args, Expression[] nodes) {
            Integer n;
            block12: {
                String sourceFile = BufferUtils.unslashPath((String)args[0]);
                final ArrayList<String> targetFileDirectories = new ArrayList<String>();
                if (args[1] instanceof List) {
                    for (Object d : (List)args[1]) {
                        targetFileDirectories.add(BufferUtils.unslashPath((String)d));
                    }
                } else {
                    targetFileDirectories.add(BufferUtils.unslashPath((String)args[1]));
                }
                boolean preserveFirstLine = (Boolean)args[2];
                int numberOfSlices = ((Number)args[3]).intValue();
                String suffixId = (String)args[4];
                int slicesToWrite = ((Number)args[5]).intValue();
                Charset charset = StandardCharsets.UTF_8;
                if (args.length > 6 && args[6] instanceof String) {
                    charset = Charset.forName((String)args[6]);
                }
                long[] length = new long[1];
                final String sourceFileName = new File(sourceFile).getName();
                InputStream inputStream = SessionData.createFileInputStream(session, sourceFile, false, true, length);
                try {
                    final Charset finalCharset = charset;
                    FileUtils.NextSliceOutputStreamProvider provider = new FileUtils.NextSliceOutputStreamProvider(){

                        @Override
                        public String createSliceName(int index, int maxIndex) throws IOException {
                            String filename = sourceFileName;
                            String extension = "";
                            int dotPos = filename.lastIndexOf(".");
                            if (dotPos > 0) {
                                extension = filename.substring(dotPos);
                                filename = filename.substring(0, dotPos);
                            }
                            int zeroCount = (int)Math.log10(maxIndex) + 1;
                            String sliceFilename = filename + "_" + String.format("%0" + zeroCount + "d", index) + extension;
                            String targetFileDirectory = (String)targetFileDirectories.get(index % targetFileDirectories.size());
                            return targetFileDirectory + "/" + sliceFilename;
                        }

                        @Override
                        public OutputStream createNextSliceOutputStream(int index, int maxIndex) {
                            return null;
                        }

                        @Override
                        public OutputStreamWriter createNextSliceOutputStreamWriter(int index, int maxIndex) throws IOException {
                            String slicePath = this.createSliceName(index, maxIndex);
                            Trace.logInfo(this, "new slice created " + slicePath);
                            return new OutputStreamWriter(SessionData.createFileOutputStream(session, slicePath, true, false), finalCharset);
                        }
                    };
                    FileUtils.SlicesInfo result = FileUtils.sliceFile(inputStream, length[0], charset, provider, preserveFirstLine, numberOfSlices, slicesToWrite);
                    n = result.getTotalLineCount();
                    if (inputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        throw new DataspaceException("Failed to slice file: " + Utils.formatExceptionWithUnrepeatedCauses(exception));
                    }
                }
                inputStream.close();
            }
            return n;
        }
    }

    class ListZipEntriesUnitEntry
    extends AbstractFunctionUnitEntry {
        ListZipEntriesUnitEntry(FileFunctionUnit this$0) {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return new FunctionMetaData("ListZipEntries", TypeFactory.LIST, FunctionMetaData.Arguments.builder().add("zipFile", TypeFactory.STRING, "ZIP file path").build(), "Gets ZIP files without extraction.\n\n" + HelpRegistry.dropboxHelp("File "));
        }

        @Override
        public String getName() {
            return "listZipEntries";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.OTHER;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            try {
                String filepath = BufferUtils.unslashPath((String)args[0]);
                filepath = SessionData.checkDataspaceFileAccess(session, filepath);
                FileSystem fileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, filepath);
                if (!fileSystem.exists(filepath)) {
                    throw new DataspaceException("File '" + String.valueOf(args[0]) + "' doesn't exist.");
                }
                return ZipUtils.listZipFileEntries(filepath, fileSystem);
            }
            catch (IOException e) {
                throw new DataspaceException("Failed to evaluate function. Cause: " + e.getMessage());
            }
        }
    }

    abstract class AbstractCreateFileDirectoryFunctionUnitEntry
    extends AbstractFunctionUnitEntry {
        AbstractCreateFileDirectoryFunctionUnitEntry(FileFunctionUnit this$0) {
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 842, 2, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String securePath;
            String path = BufferUtils.unslashPath((String)args[0]);
            String permissions = null;
            if (args.length > 1) {
                permissions = (String)args[1];
            }
            if (!DropBoxUtils.isDropBoxURL(securePath = SessionData.checkDataspaceFileAccess(session, path))) {
                Path securePathPath = Paths.get(securePath, new String[0]);
                Path dscahePathPath = Paths.get(".dscache", new String[0]).normalize().toAbsolutePath();
                Path tfcachePathPath = Paths.get(".tfcache", new String[0]).normalize().toAbsolutePath();
                if (securePathPath.startsWith(dscahePathPath) || securePathPath.startsWith(tfcachePathPath)) {
                    throw Error.error(457, "It is not allowed to create/delete files/directories in .dscache and .tfcache.");
                }
            }
            FilePermissions filePermissions = null;
            if (permissions != null) {
                filePermissions = FilePermissions.parse(permissions);
            }
            this.doAction(session, path, securePath, filePermissions);
            return new Void();
        }

        protected abstract void doAction(Session var1, String var2, String var3, FilePermissions var4);
    }

    abstract class AbstractTransactionalFileFunctionUnitEntry
    extends AbstractFunctionUnitEntry {
        AbstractTransactionalFileFunctionUnitEntry(FileFunctionUnit this$0) {
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            try {
                FileActionStrategy trigger = this.createStrategy(args);
                trigger.setDatagramFactory(session.sessionContext.eventDatagramFactory);
                if (args[0] instanceof String) {
                    trigger.setSourceFilePath(BufferUtils.unslashPath((String)args[0]));
                    trigger.invokeAction(null);
                } else if (args[0] instanceof ImmutableEventDatagram) {
                    trigger.invokeAction((ImmutableEventDatagram)args[1]);
                } else {
                    throw new DataspaceException("Invalid argument is passed to '" + this.getName() + "'.");
                }
                if (!trigger.isSuccessed()) {
                    String errorMsg = trigger.getErrorMessage() != null ? trigger.getErrorMessage() : "File function failed.";
                    throw new DataspaceException(errorMsg);
                }
            }
            catch (FabricEventException exception) {
                throw new DataspaceException("Failed to evaluate function.", exception);
            }
            return new Void();
        }

        protected abstract FileActionStrategy createStrategy(Object[] var1);
    }
}

