/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.event;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.event.AbstractFunctionUnitEntry;
import com.streamscape.ds.trigger.event.FunctionUnit;
import com.streamscape.ds.types.EventType;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.omf.mapper.ConverterPlugin;
import com.streamscape.omf.mapper.mf.ConverterPluginManager;
import com.streamscape.omf.mapper.mf.ConverterPluginManagerException;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.AcknowledgeAction;
import com.streamscape.sdo.enums.FileState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.event.AuditEvent;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.ExceptionEvent;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.event.MailEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.evtrigger.function.expression.function.EventFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;

public class EventsFunctionUnit
extends FunctionUnit {
    EventsFunctionUnit() {
        super(FunctionsUnitType.EVENTS);
        this.addEntry(new CreateAckUnitEntry());
        this.addEntry(new CreateAckForEventIdUnitEntry());
        this.addEntry(new CreateEventUnitEntry());
        this.addEntry(new CreateAuditEventUnitEntry());
        this.addEntry(new CreateMailEventUnitEntry());
        this.addEntry(new CreateFileEventUnitEntry());
        this.addEntry(new CreateFileContentUnitEntry());
        this.addEntry(new CreateExceptionEventUnitEntry());
        this.addEntry(new CloneEventUnitEntry());
        this.addEntry(new CopyEIMUnitEntry());
        this.addEntry(new ConvertUnitEntry());
    }

    private static void copyEIM(ImmutableEventDatagram from, ImmutableEventDatagram to) {
        String eventKey = null;
        String eventGroupId = null;
        byte[] correlationIdAsBytes = null;
        if (from instanceof EventDatagram) {
            correlationIdAsBytes = ((EventDatagram)from).getCorrelationIdAsBytes();
            eventGroupId = from.getEventGroupId();
            eventKey = from.getEventKey();
        } else if (from instanceof ExceptionEventDatagram) {
            correlationIdAsBytes = ((ExceptionEventDatagram)from).getCorrelationIdAsBytes();
            eventGroupId = from.getEventGroupId();
            eventKey = from.getEventKey();
        } else if (from instanceof AdvisoryEventDatagram) {
            correlationIdAsBytes = ((AdvisoryEventDatagram)from).getCorrelationIdAsBytes();
            eventGroupId = from.getEventGroupId();
            eventKey = from.getEventKey();
        } else if (from instanceof OpaqueDatagram) {
            eventGroupId = from.getEventGroupId();
            eventKey = from.getEventKey();
        }
        if (to instanceof EventDatagram) {
            ((EventDatagram)to).setCorrelationIdAsBytes(correlationIdAsBytes);
            ((EventDatagram)to).setEventGroupId(eventGroupId);
            ((EventDatagram)to).setEventKey(eventKey);
        } else if (to instanceof ExceptionEventDatagram) {
            ((ExceptionEventDatagram)to).setCorrelationIdAsBytes(correlationIdAsBytes);
            ((ExceptionEventDatagram)to).setEventGroupId(eventGroupId);
            ((ExceptionEventDatagram)to).setEventKey(eventKey);
        } else if (to instanceof AdvisoryEventDatagram) {
            ((AdvisoryEventDatagram)to).setCorrelationIdAsBytes(correlationIdAsBytes);
            ((AdvisoryEventDatagram)to).setEventGroupId(eventGroupId);
            ((AdvisoryEventDatagram)to).setEventKey(eventKey);
        } else if (to instanceof OpaqueDatagram) {
            ((OpaqueDatagram)to).setEventGroupId(eventGroupId);
            ((OpaqueDatagram)to).setEventKey(eventKey);
        }
    }

    static class CreateAckUnitEntry
    extends AbstractEventFunctionUnitEntry<AcknowledgementEvent> {
        CreateAckUnitEntry() {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return EventFunctionsUnit.CreateAckFunction.metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 842, 2, 774, 788, 772};
        }

        @Override
        public String getName() {
            return "createAck";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Types.getParameterSQLType(session, AcknowledgementEvent.class);
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            if (!(args[0] instanceof EventDatagram)) {
                throw new DataspaceException("Invalid data type passed to 'createAck' function at first parameter. Should be EventDatagram type.");
            }
            if (!(args[1] instanceof Boolean)) {
                throw new DataspaceException("Invalid data type passed to 'createAck' function at second parameter. Should be Boolean type.");
            }
            try {
                AcknowledgementEvent result = session.sessionContext.eventDatagramFactory.createAcknowledgement((EventDatagram)args[0], (Boolean)args[1]);
                if (args.length > 2 && args[2] instanceof AcknowledgeAction) {
                    result.setAction((AcknowledgeAction)((Object)args[2]));
                }
                return result;
            }
            catch (Exception exception) {
                throw new DataspaceException("Creating Acknowledgement Event failed.", exception);
            }
        }
    }

    static class CreateAckForEventIdUnitEntry
    extends AbstractEventFunctionUnitEntry<AcknowledgementEvent> {
        CreateAckForEventIdUnitEntry() {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return EventFunctionsUnit.CreateAckForEventIdFunction.metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public String getName() {
            return "createAckForEventId";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Types.getParameterSQLType(session, AcknowledgementEvent.class);
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            if (!(args[0] instanceof String)) {
                throw new DataspaceException("Invalid data type passed to 'createAckForEventId' function at second parameter. Should be String type.");
            }
            try {
                return session.sessionContext.eventDatagramFactory.createAcknowledgement((String)args[0]);
            }
            catch (Exception exception) {
                throw new DataspaceException("Creating Acknowledgement Event failed.", exception);
            }
        }
    }

    static class CreateEventUnitEntry
    extends AbstractEventFunctionUnitEntry<ImmutableEventDatagram> {
        private final FunctionMetaData metadata = new FunctionMetaData("createEvent", TypeFactory.createEventType(), FunctionMetaData.Arguments.builder().add("eventId", TypeFactory.STRING, "result Event Id").build(), "Creates and returns an instance of an event with specified eventId.");

        CreateEventUnitEntry() {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return this.metadata;
        }

        @Override
        public String getName() {
            return "createEvent";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            Type type = Types.getParameterSQLType(session, ImmutableEventDatagram.class);
            String eventId = (String)params[0].getValue(session);
            ((EventType)type).setEventId(eventId);
            return type;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String eventId = this.checkArgumentType(args, 0, String.class);
            return this.createEvent(session, eventId);
        }
    }

    static class CreateAuditEventUnitEntry
    extends AbstractEventFunctionUnitEntry<AuditEvent> {
        CreateAuditEventUnitEntry() {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return EventFunctionsUnit.CreateAuditEventFunction.metadata;
        }

        @Override
        public String getName() {
            return "createAuditEvent";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 774, 788, 842, 2, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            Type type = Types.getParameterSQLType(session, AuditEvent.class);
            String eventId = (String)params[0].getValue(session);
            ((EventType)type).setEventId(this.transformEventId(eventId));
            return type;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String eventId = this.checkArgumentType(args, 0, String.class);
            if (!(args[1] instanceof String)) {
                throw new DataspaceException("Invalid argument is passed as the second parameter to 'createAuditEvent'. Should be string.");
            }
            String auditMessage = (String)args[1];
            if (!(args[2] instanceof Severity)) {
                throw new DataspaceException("Invalid argument is passed as the third parameter to 'createAuditEvent'. Should be string.");
            }
            Severity severity = (Severity)((Object)args[2]);
            AuditEvent auditEvent = (AuditEvent)this.createEvent(session, this.transformEventId(eventId));
            try {
                auditEvent.setAuditData(auditMessage);
                auditEvent.setSeverity(severity);
            }
            catch (SecurityViolationException exception) {
                throw new DataspaceException("Failed to set audit event [" + this.transformEventId(eventId) + "] properties.", exception);
            }
            if (args.length > 3 && args[3] instanceof ImmutableEventDatagram) {
                EventsFunctionUnit.copyEIM((ImmutableEventDatagram)args[3], auditEvent);
            }
            return auditEvent;
        }

        protected String transformEventId(String eventId) {
            if (eventId.equals("default")) {
                return "event.audit";
            }
            if (eventId.equals("sql")) {
                return "event.audit.sql";
            }
            if (eventId.equals("process")) {
                return "event.audit.process";
            }
            if (eventId.equals("user")) {
                return "event.audit.user";
            }
            return eventId;
        }
    }

    static class CreateMailEventUnitEntry
    extends AbstractEventFunctionUnitEntry<MailEvent> {
        CreateMailEventUnitEntry() {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return EventFunctionsUnit.CreateMailEventFunction.metadata;
        }

        @Override
        public String getName() {
            return "createMailEvent";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 774, 788, 774, 788, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            Type type = Types.getParameterSQLType(session, MailEvent.class);
            String eventId = (String)params[0].getValue(session);
            ((EventType)type).setEventId(eventId);
            return type;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String eventId = this.checkArgumentType(args, 0, String.class);
            String subject = this.checkArgumentType(args, 1, String.class);
            String body = this.checkArgumentType(args, 2, String.class);
            String contentType = this.checkArgumentType(args, 3, String.class);
            String toRecipients = this.checkArgumentType(args, 4, String.class);
            String ccRecipients = null;
            if (args.length > 5) {
                ccRecipients = this.checkArgumentType(args, 5, String.class);
            }
            if (contentType == null) {
                contentType = "text/html";
            }
            if (toRecipients == null || toRecipients.isEmpty()) {
                throw new DataspaceException("Recipients are not set for 'createMailEvent'.");
            }
            MailEvent mailEvent = (MailEvent)this.createEvent(session, eventId);
            try {
                mailEvent.setSubject(subject);
                mailEvent.setBody(body);
                mailEvent.setContentType(contentType);
                mailEvent.setTo(Arrays.asList(toRecipients.split(",")));
                if (ccRecipients != null && !ccRecipients.isEmpty()) {
                    mailEvent.setCc(Arrays.asList(ccRecipients.split(",")));
                }
            }
            catch (SecurityViolationException exception) {
                throw new DataspaceException("Failed to set mail event [" + eventId + "] properties.", exception);
            }
            if (args.length > 6 && args[6] instanceof ImmutableEventDatagram) {
                EventsFunctionUnit.copyEIM((ImmutableEventDatagram)args[6], mailEvent);
            }
            return mailEvent;
        }
    }

    static class CreateFileEventUnitEntry
    extends AbstractEventFunctionUnitEntry<FileEvent> {
        CreateFileEventUnitEntry() {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return EventFunctionsUnit.CreateFileEventFunction.metadata;
        }

        @Override
        public String getName() {
            return "createFileEvent";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            Type type = Types.getParameterSQLType(session, FileEvent.class);
            String eventId = (String)params[0].getValue(session);
            ((EventType)type).setEventId(eventId);
            return type;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String eventId = this.checkArgumentType(args, 0, String.class);
            String filepath = this.checkArgumentType(args, 1, String.class);
            FileEvent fileEvent = (FileEvent)this.createEvent(session, eventId);
            try {
                fileEvent.init(new File(filepath), FileState.STATIC);
            }
            catch (Exception exception) {
                throw new DataspaceException("Failed to init file event [" + eventId + "].", exception);
            }
            return fileEvent;
        }
    }

    static class CreateFileContentUnitEntry
    extends AbstractEventFunctionUnitEntry<BytesEvent> {
        CreateFileContentUnitEntry() {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return EventFunctionsUnit.CreateFileContentFunction.metadata;
        }

        @Override
        public String getName() {
            return "createFileContent";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            Type type = Types.getParameterSQLType(session, BytesEvent.class);
            String eventId = (String)params[0].getValue(session);
            ((EventType)type).setEventId(eventId);
            return type;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            String eventId = this.checkArgumentType(args, 0, String.class);
            String filepath = null;
            FileEvent fileEvent = null;
            if (args[1] instanceof FileEvent) {
                fileEvent = (FileEvent)args[1];
                try {
                    filepath = fileEvent.getAbsoluteFileName();
                }
                catch (SecurityViolationException exception) {
                    throw new DataspaceException("Failed to extract filename.", exception);
                }
            } else if (args[1] instanceof String) {
                filepath = (String)args[1];
            } else {
                String type = args[1] != null ? args[1].getClass().getSimpleName() : "null";
                throw new DataspaceException("Invalid argument type, should be String or FileEvent, but passed '" + type + "'.");
            }
            BytesEvent bytesEvent = (BytesEvent)this.createEvent(session, eventId);
            try {
                bytesEvent.setBytes(FileIOUtils.getFileContent(new File(filepath)));
                if (fileEvent != null) {
                    EventsFunctionUnit.copyEIM(fileEvent, bytesEvent);
                }
            }
            catch (Exception exception) {
                Throwable cause = Utils.getCause(exception, FileNotFoundException.class);
                if (cause instanceof FileNotFoundException) {
                    throw new DataspaceException("Failed to init file event [" + eventId + "]. Cause: File '" + filepath + "' not found.\n\nIn Windows systems, make sure to escape paths using \\\\ characters.", "00000", 452);
                }
                throw new DataspaceException("Failed to init file event [" + eventId + "].", exception);
            }
            return bytesEvent;
        }
    }

    static class CreateExceptionEventUnitEntry
    extends AbstractEventFunctionUnitEntry<ExceptionEvent> {
        CreateExceptionEventUnitEntry() {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return EventFunctionsUnit.CreateExceptionEventFunction.metadata;
        }

        @Override
        public String getName() {
            return "createExceptionEvent";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 842, 2, 774, 788, 842, 2, 774, 788, 842, 2, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            Type type = Types.getParameterSQLType(session, ExceptionEvent.class);
            ((EventType)type).setEventId("event.exception");
            return type;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            ExceptionEvent exceptionEvent = (ExceptionEvent)this.createEvent(session, "event.exception");
            if (args[0] instanceof String) {
                exceptionEvent.setErrorMessage((String)args[0]);
            }
            if (args.length > 1 && args[1] instanceof Number) {
                exceptionEvent.setErrorCode(((Number)args[1]).intValue());
            }
            if (args.length > 2 && args[2] instanceof Severity) {
                exceptionEvent.setSeverity((Severity)((Object)args[2]));
            }
            if (args.length > 3 && args[3] instanceof ImmutableEventDatagram) {
                EventsFunctionUnit.copyEIM((ImmutableEventDatagram)args[3], exceptionEvent);
            }
            return exceptionEvent;
        }
    }

    static class CloneEventUnitEntry
    extends AbstractEventFunctionUnitEntry<ImmutableEventDatagram> {
        private final FunctionMetaData metadata = new FunctionMetaData("cloneEvent", TypeFactory.createEventType(), FunctionMetaData.Arguments.builder().add("event", TypeFactory.createEventType(), "event to be cloned").build(), "Returns a clone of the specified event. The result clone will be in uncoalesced state.");

        CloneEventUnitEntry() {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return this.metadata;
        }

        @Override
        public String getName() {
            return "cloneEvent";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Types.getParameterSQLType(session, ImmutableEventDatagram.class);
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            ImmutableEventDatagram event = this.checkArgumentType(args, 0, ImmutableEventDatagram.class);
            try {
                return session.sessionContext.eventDatagramFactory.cloneEvent(event);
            }
            catch (DatagramFactoryException exception) {
                throw new DataspaceException("Failed to clone event.", exception);
            }
        }
    }

    static class CopyEIMUnitEntry
    extends AbstractEventFunctionUnitEntry<ImmutableEventDatagram> {
        CopyEIMUnitEntry() {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return EventFunctionsUnit.CopyEIMFunction.metadata;
        }

        @Override
        public String getName() {
            return "copyEIM";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 842, 2, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            ImmutableEventDatagram fromEvent = this.checkArgumentType(args, 0, ImmutableEventDatagram.class);
            ImmutableEventDatagram toEvent = this.checkArgumentType(args, 1, ImmutableEventDatagram.class);
            EventsFunctionUnit.copyEIM(fromEvent, toEvent);
            return null;
        }
    }

    static class ConvertUnitEntry
    extends AbstractEventFunctionUnitEntry<Object> {
        ConvertUnitEntry() {
        }

        @Override
        public FunctionMetaData getMetaData() {
            return EventFunctionsUnit.ConvertFunction.metadata;
        }

        @Override
        public String getName() {
            return "convert";
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.OTHER;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            ConverterPlugin<?, ?> converterPlugin = null;
            String converterName = this.checkArgumentType(args, 0, String.class);
            if (converterName == null) {
                throw new DataspaceException("Unable to resolve converter name for '" + this.getName() + "'.");
            }
            ConverterPluginManager converterPluginManager = DataspaceManager.getContext().getConverterPluginManager();
            if (converterPluginManager == null) {
                throw new DataspaceException("Converter plugin manager is not available.");
            }
            if (!converterPluginManager.existsConverterPlugin(converterName)) {
                throw new DataspaceException("Converter plugin '" + converterName + "' does not exist.");
            }
            try {
                converterPlugin = converterPluginManager.createConverterPlugin(converterName);
            }
            catch (ConverterPluginManagerException exception) {
                throw new DataspaceException("Unable to create converter '" + converterName + "'.", exception);
            }
            try {
                return converterPlugin.convert(args[1]);
            }
            catch (Exception exception) {
                throw new DataspaceException("Conversion failed.", exception);
            }
        }
    }

    static abstract class AbstractEventFunctionUnitEntry<T>
    extends AbstractFunctionUnitEntry {
        AbstractEventFunctionUnitEntry() {
        }

        protected T createEvent(Session session, String eventId) {
            EventDatagram event = null;
            try {
                event = session.sessionContext.eventDatagramFactory.createEvent(eventId);
            }
            catch (DatagramFactoryException exception) {
                throw new DataspaceException("Failed to create event [" + eventId + "] instance.", exception);
            }
            return (T)event;
        }
    }
}

