/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.event;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionData;
import com.streamscape.ds.trigger.event.AbstractFunctionUnitEntry;
import com.streamscape.ds.trigger.event.FunctionUnit;
import com.streamscape.ds.trigger.event.FunctionUnitEntry;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.FileSystemProvider;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.sys.Void;
import com.streamscape.sef.dropbox.DropBoxFileSystem;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.tools.lexer.BufferUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DropBoxFunctionUnit
extends FunctionUnit {
    public DropBoxFunctionUnit() {
        super(FunctionsUnitType.DROPBOX);
        this.addEntry(new LsFunctionUnitEntry());
        this.addEntry(new PutFunctionUnitEntry());
        this.addEntry(new GetFunctionUnitEntry());
        this.addEntry(new CopyFunctionUnitEntry());
        this.addEntry(new MoveFunctionUnitEntry());
        this.addEntry(new RenameFunctionUnitEntry());
        this.addEntry(new DeleteFunctionUnitEntry());
        this.addEntry(new CreateFileFunctionUnitEntry());
        this.addEntry(new CreateDirectoryFunctionUnitEntry());
        this.addEntry(new ExistsFunctionUnitEntry());
        this.addEntry(new GetInfoFunctionUnitEntry());
    }

    public static class LsFunctionUnitEntry
    extends AbstractDropBoxFunctionUnitEntry {
        private static final FunctionMetaData metadata = LsFunctionUnitEntry.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("ls", TypeFactory.LIST, FunctionMetaData.Arguments.builder().add("directory", TypeFactory.STRING, "directory to list").addOptional("recursive", TypeFactory.BOOLEAN, "recursive or not").build(), "Returns list of files in specified folder.\n\nSamples:\n\n   ls('.')\n   ls('.', true)\n   ls('*.txt')\n   ls('some/path/*.csv')");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 842, 2, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.OTHER;
        }

        @Override
        public Object doGetResult(FileSystem fileSystem, Session session, Object[] args, Expression[] nodes) throws IOException {
            boolean recursive = false;
            if (!(args[0] instanceof String)) {
                throw new DataspaceException("First argument should be a path.");
            }
            if (args.length > 1 && args[1] != null) {
                if (!(args[1] instanceof Boolean)) {
                    throw new DataspaceException("Seconds argument should be a boolean.");
                }
                recursive = (Boolean)args[1];
            }
            String path = BufferUtils.unslashPath((String)args[0]);
            return fileSystem.list(path, recursive);
        }
    }

    public static class PutFunctionUnitEntry
    extends AbstractDropBoxFunctionUnitEntry {
        private static final FunctionMetaData metadata = PutFunctionUnitEntry.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("put", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("localFile", TypeFactory.STRING, "source local file").add("targetFile", TypeFactory.STRING, "target file or directory").build(), "Copies local file to target dropbox file or directory.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object doGetResult(FileSystem fileSystem, Session session, Object[] args, Expression[] nodes) throws IOException {
            if (!(args[0] instanceof String)) {
                throw new DataspaceException("First argument should be a path.");
            }
            if (!(args[1] instanceof String)) {
                throw new DataspaceException("Second argument should be a path.");
            }
            File sourceFile = new File(BufferUtils.unslashPath((String)args[0]));
            File targetFile = new File(BufferUtils.unslashPath((String)args[1]));
            if (fileSystem.exists(targetFile.getPath())) {
                FileInfo info = fileSystem.getInfo(targetFile.getPath());
                if (info.isFile()) {
                    throw new IOException("Target file already exist.");
                }
                if (fileSystem.exists((targetFile = new File(targetFile.getPath(), sourceFile.getName())).getPath())) {
                    throw new IOException("Target file already exist.");
                }
            }
            try (InputStream sourceInputStream = SessionData.createFileInputStream(session, sourceFile.getPath(), false, true, null);){
                try (OutputStream outputStream = fileSystem.create(targetFile.getPath());
                     BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
                    FileIOUtils.copy((InputStream)new BufferedInputStream(sourceInputStream), (OutputStream)bufferedOutputStream);
                }
                catch (UtilitiesException e) {
                    throw new IOException(e);
                }
            }
            return new Void();
        }
    }

    public static class GetFunctionUnitEntry
    extends AbstractDropBoxFunctionUnitEntry {
        private static final FunctionMetaData metadata = GetFunctionUnitEntry.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("get", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("remoteFile", TypeFactory.STRING, "remote source file").add("localFile", TypeFactory.STRING, "target local file or directory").build(), "Copies remote file to target local file or directory.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object doGetResult(FileSystem fileSystem, Session session, Object[] args, Expression[] nodes) throws IOException {
            if (!(args[0] instanceof String)) {
                throw new DataspaceException("First argument should be a path.");
            }
            if (!(args[1] instanceof String)) {
                throw new DataspaceException("Second argument should be a path.");
            }
            File sourceFile = new File(BufferUtils.unslashPath((String)args[0]));
            File targetFile = new File(BufferUtils.unslashPath((String)args[1]));
            try (FileSystem targetFileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, targetFile.getPath());){
                if (targetFileSystem.exists(targetFile.getPath())) {
                    FileInfo info = targetFileSystem.getInfo(targetFile.getPath());
                    if (info.isFile()) {
                        throw new IOException("Target file already exist.");
                    }
                    if (targetFileSystem.exists((targetFile = new File(targetFile.getPath(), sourceFile.getName())).getPath())) {
                        throw new IOException("Target file already exist.");
                    }
                }
                try (InputStream sourceInputStream = fileSystem.open(sourceFile.getPath());){
                    try (OutputStream outputStream = targetFileSystem.create(targetFile.getPath());
                         BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
                        FileIOUtils.copy((InputStream)new BufferedInputStream(sourceInputStream), outputStream);
                    }
                    catch (UtilitiesException e) {
                        throw new IOException(e);
                    }
                }
            }
            return new Void();
        }
    }

    public static class CopyFunctionUnitEntry
    extends AbstractDropBoxFunctionUnitEntry {
        private static final FunctionMetaData metadata = CopyFunctionUnitEntry.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("copy", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("src", TypeFactory.STRING, "source file").add("target", TypeFactory.STRING, "target file or directory").build(), "Copies source file to target file or  directory.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object doGetResult(FileSystem fileSystem, Session session, Object[] args, Expression[] nodes) throws IOException {
            if (!(args[0] instanceof String)) {
                throw new DataspaceException("First argument should be a path.");
            }
            if (!(args[1] instanceof String)) {
                throw new DataspaceException("Second argument should be a path.");
            }
            fileSystem.copy(BufferUtils.unslashPath((String)args[0]), BufferUtils.unslashPath((String)args[1]));
            return new Void();
        }
    }

    public static class MoveFunctionUnitEntry
    extends AbstractDropBoxFunctionUnitEntry {
        private static final FunctionMetaData metadata = MoveFunctionUnitEntry.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("move", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("src", TypeFactory.STRING, "source file").add("target", TypeFactory.STRING, "target file or directory").build(), "Moves source file to target file or  directory.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object doGetResult(FileSystem fileSystem, Session session, Object[] args, Expression[] nodes) throws IOException {
            if (!(args[0] instanceof String)) {
                throw new DataspaceException("First argument should be a path.");
            }
            if (!(args[1] instanceof String)) {
                throw new DataspaceException("Second argument should be a path.");
            }
            fileSystem.move(BufferUtils.unslashPath((String)args[0]), BufferUtils.unslashPath((String)args[1]));
            return new Void();
        }
    }

    public static class RenameFunctionUnitEntry
    extends AbstractDropBoxFunctionUnitEntry {
        private static final FunctionMetaData metadata = RenameFunctionUnitEntry.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("rename", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("src", TypeFactory.STRING, "source file").add("target", TypeFactory.STRING, "target file").build(), "Renames source file to target file.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object doGetResult(FileSystem fileSystem, Session session, Object[] args, Expression[] nodes) throws IOException {
            if (!(args[0] instanceof String)) {
                throw new DataspaceException("First argument should be a path.");
            }
            if (!(args[1] instanceof String)) {
                throw new DataspaceException("Second argument should be a path.");
            }
            fileSystem.rename(BufferUtils.unslashPath((String)args[0]), BufferUtils.unslashPath((String)args[1]));
            return new Void();
        }
    }

    public static class DeleteFunctionUnitEntry
    extends AbstractDropBoxFunctionUnitEntry {
        private static final FunctionMetaData metadata = DeleteFunctionUnitEntry.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("delete", TypeFactory.BOOLEAN, FunctionMetaData.Arguments.builder().add("<file or directory>", TypeFactory.STRING, "file or directory to delete").add("recursive", TypeFactory.BOOLEAN, "delete subdirectories or not").build(), "Deletes specified file or directory.\n\nSamples:\n\n  delete('file1.txt', false)\n  delete('myfolder', true)\n  delete('*.xml', false)\n  delete('somefolder/*.xml', false)\n");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 774, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_BOOLEAN;
        }

        @Override
        public Object doGetResult(FileSystem fileSystem, Session session, Object[] args, Expression[] nodes) throws IOException {
            if (!(args[0] instanceof String)) {
                throw new DataspaceException("First argument should be a path.");
            }
            if (!(args[1] instanceof Boolean)) {
                throw new DataspaceException("Second argument should be a boolean.");
            }
            return fileSystem.delete(BufferUtils.unslashPath((String)args[0]), (Boolean)args[1]);
        }
    }

    public static class CreateFileFunctionUnitEntry
    extends AbstractDropBoxFunctionUnitEntry {
        private static final FunctionMetaData metadata = CreateFileFunctionUnitEntry.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("createFile", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("filepath", TypeFactory.STRING, "file path").build(), "Creates file with specified name.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object doGetResult(FileSystem fileSystem, Session session, Object[] args, Expression[] nodes) throws IOException {
            if (!(args[0] instanceof String)) {
                throw new DataspaceException("First argument should be a path.");
            }
            fileSystem.createNewFile(BufferUtils.unslashPath((String)args[0]));
            return new Void();
        }
    }

    public static class CreateDirectoryFunctionUnitEntry
    extends AbstractDropBoxFunctionUnitEntry {
        private static final FunctionMetaData metadata = CreateDirectoryFunctionUnitEntry.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("createDirectory", TypeFactory.VOIDTYPE, FunctionMetaData.Arguments.builder().add("directoryPath", TypeFactory.STRING, "directory path").build(), "Creates directory with specified name.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_ALL_TYPES;
        }

        @Override
        public Object doGetResult(FileSystem fileSystem, Session session, Object[] args, Expression[] nodes) throws IOException {
            if (!(args[0] instanceof String)) {
                throw new DataspaceException("First argument should be a path.");
            }
            fileSystem.mkdir(BufferUtils.unslashPath((String)args[0]));
            return new Void();
        }
    }

    public static class ExistsFunctionUnitEntry
    extends AbstractDropBoxFunctionUnitEntry {
        private static final FunctionMetaData metadata = ExistsFunctionUnitEntry.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("exists", TypeFactory.BOOLEAN, FunctionMetaData.Arguments.builder().add("path", TypeFactory.STRING, "file or directory path").build(), "Check if specified file or directory exist.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.SQL_BOOLEAN;
        }

        @Override
        public Object doGetResult(FileSystem fileSystem, Session session, Object[] args, Expression[] nodes) throws IOException {
            if (!(args[0] instanceof String)) {
                throw new DataspaceException("First argument should be a path.");
            }
            return fileSystem.exists(BufferUtils.unslashPath((String)args[0]));
        }
    }

    public static class GetInfoFunctionUnitEntry
    extends AbstractDropBoxFunctionUnitEntry {
        private static final FunctionMetaData metadata = GetInfoFunctionUnitEntry.createMetaData();

        private static FunctionMetaData createMetaData() {
            return new FunctionMetaData("getInfo", TypeFactory.createSemanticTypeType(FileInfo.class), FunctionMetaData.Arguments.builder().add("path", TypeFactory.STRING, "file or directory path").build(), "Returns info for specified entry.");
        }

        @Override
        public FunctionMetaData getMetaData() {
            return metadata;
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 772};
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.OTHER;
        }

        @Override
        public Object doGetResult(FileSystem fileSystem, Session session, Object[] args, Expression[] nodes) throws IOException {
            if (!(args[0] instanceof String)) {
                throw new DataspaceException("First argument should be a path.");
            }
            return fileSystem.getInfo(BufferUtils.unslashPath((String)args[0]));
        }
    }

    public static abstract class AbstractDropBoxFunctionUnitEntry
    extends AbstractFunctionUnitEntry {
        protected String dropBoxName;

        @Override
        public String getName() {
            return this.getMetaData().getFunctionName();
        }

        public FunctionUnitEntry withDropBoxName(String dropBoxName) {
            AbstractDropBoxFunctionUnitEntry result = this.clone();
            result.dropBoxName = dropBoxName;
            return result;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            Object object;
            block9: {
                if (this.dropBoxName == null) {
                    throw new DataspaceException("DropBox name is not specified.");
                }
                DropBoxFileSystem fileSystem = SessionData.createDropBoxFileSystem(session, new String[]{DropBoxUtils.getDropBoxURL(this.dropBoxName, "")});
                try {
                    object = this.doGetResult(fileSystem, session, args, nodes);
                    if (fileSystem == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (fileSystem != null) {
                            try {
                                fileSystem.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new DataspaceException(e);
                    }
                }
                fileSystem.close();
            }
            return object;
        }

        protected abstract Object doGetResult(FileSystem var1, Session var2, Object[] var3, Expression[] var4) throws IOException;

        protected AbstractDropBoxFunctionUnitEntry clone() {
            try {
                return (AbstractDropBoxFunctionUnitEntry)this.getClass().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

