/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger.event;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.event.AbstractFunctionUnitEntry;
import com.streamscape.ds.trigger.event.FunctionUnit;
import com.streamscape.ds.types.Type;
import com.streamscape.omf.json.jackson.JsonDateTimeSerializers;
import com.streamscape.sef.evtrigger.function.expression.function.DateFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionMetaData;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateFunctionUnit
extends FunctionUnit {
    DateFunctionUnit() {
        super(FunctionsUnitType.DATE);
        this.addEntry(new ToStringUnitEntry());
        this.addEntry(new FromStringUnitEntry());
    }

    class ToStringUnitEntry
    extends AbstractDateFunctionUnitEntry {
        ToStringUnitEntry() {
            super(DateFunctionUnit.this);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return DateFunctionsUnit.ToStringFunction.metadata;
        }

        @Override
        public String getName() {
            return "toString";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.STRING;
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            if (!(args[0] instanceof Date)) {
                throw new DataspaceException("Invalid first parameter is passed to 'toString' function of '" + DateFunctionUnit.this.getType().name() + "' function unit.");
            }
            Date date = (Date)args[0];
            if (args[1] != null && !(args[1] instanceof String)) {
                throw new DataspaceException("Invalid second parameter is passed to 'toString' function of '" + DateFunctionUnit.this.getType().name() + "' function unit.");
            }
            String pattern = (String)args[1];
            if (pattern == null && ((pattern = session.dataspaceStore.getProperties().getStringProperty("dtspace.serializer.sqltimestamp_format")) == null || "millis".equals(pattern))) {
                pattern = "yyyy-MM-dd HH:mm:ss.SSS";
            }
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            format.setTimeZone(session.getTimeZone());
            return JsonDateTimeSerializers.formatDateOrTimestampMillis(date.getTime(), format);
        }
    }

    class FromStringUnitEntry
    extends AbstractDateFunctionUnitEntry {
        FromStringUnitEntry() {
            super(DateFunctionUnit.this);
        }

        @Override
        public FunctionMetaData getMetaData() {
            return DateFunctionsUnit.FromStringFunction.metadata;
        }

        @Override
        public String getName() {
            return "fromString";
        }

        @Override
        public Type resolveReturnDataType(Session session, Expression[] params) {
            return Type.getSystemType(Date.class.getSimpleName());
        }

        @Override
        public Object getResult(Session session, Object[] args, Expression[] nodes) {
            if (!(args[0] instanceof String)) {
                throw new DataspaceException("Invalid first parameter is passed to 'fromString' function of '" + DateFunctionUnit.this.getType().name() + "' function unit.");
            }
            String dateRep = (String)args[0];
            if (args[1] != null && !(args[1] instanceof String)) {
                throw new DataspaceException("Invalid second parameter is passed to 'fromString' function of '" + DateFunctionUnit.this.getType().name() + "' function unit.");
            }
            String pattern = (String)args[1];
            if (pattern == null && ((pattern = session.dataspaceStore.getProperties().getStringProperty("dtspace.serializer.sqltimestamp_format")) == null || "millis".equals(pattern))) {
                pattern = "yyyy-MM-dd HH:mm:ss.SSS";
            }
            JsonDateTimeSerializers.validJavaDateFormatOrThrowException(pattern);
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            format.setTimeZone(session.getTimeZone());
            try {
                return new Date(JsonDateTimeSerializers.parseDateOrTimestampToMillis(dateRep, format));
            }
            catch (IOException | ParseException ex) {
                throw new DataspaceException("Unable to parse date '" + dateRep + "' using the '" + pattern + "' pattern.");
            }
        }
    }

    abstract class AbstractDateFunctionUnitEntry
    extends AbstractFunctionUnitEntry {
        AbstractDateFunctionUnitEntry(DateFunctionUnit this$0) {
        }

        @Override
        public short[] getParameters() {
            return new short[]{786, 788, 842, 2, 774, 788, 772};
        }
    }
}

