/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.ds.parser.ParserCommand;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.trigger.RecompiledTrigger;
import com.streamscape.ds.trigger.TriggerDefSQL;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.utils.SourceEventFlowData;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerCompiledDefinition;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.moderator.EventFlowEntity;
import java.util.HashMap;

public class WindowTriggerDefSQL
extends TriggerDefSQL
implements SourceEventFlowData,
RecompiledTrigger {
    public static final String DEFAULT_OLD_DATA_NAME = "oldWindowData";
    public static final String DEFAULT_NEW_DATA_NAME = "newWindowData";
    protected Collection collection = null;
    protected AbstractDataspace dataspace = null;
    protected EventScope eventScope = null;
    protected NameManager.ObjectName oldDataName = null;
    protected NameManager.ObjectName newDataName = null;
    protected EventTriggerCompiledDefinition triggerDefinition = null;
    protected DataspaceStateHolder stateHolder = new DataspaceStateHolder();
    private long triggerRecompileTime = -1L;
    private long triggerCreationTime = -1L;
    private String rpl;

    public WindowTriggerDefSQL(NameManager.ObjectName name, Collection collection, RplScript routine, EventScope eventScope, NameManager.ObjectName oldDataName, NameManager.ObjectName newDataName) {
        super(name, 8, 3143, false, collection.getBaseTable(), new Table[5], new RangeVariable[5], null, null, null, routine);
        this.collection = collection;
        this.eventScope = eventScope;
        this.oldDataName = oldDataName;
        this.newDataName = newDataName;
        this.dataspace = (AbstractDataspace)this.table.database.schemaManager.findSchema(collection.getObjectName().schema.name);
        if (this.dataspace == null) {
            throw new DataspaceException("Unable to bind trigger. Can't get reference to parent dataspace.");
        }
        this.triggerCreationTime = System.currentTimeMillis();
        try {
            EventTriggerDefinition definition = new EventTriggerDefinition();
            definition.setName(name.name);
            definition.setEventScope(eventScope != null ? eventScope : EventScope.INHERITED);
            this.triggerDefinition = new EventTriggerCompiledDefinition(definition);
            if (routine != null && routine.eventIds != null && routine.eventIds.size() > 0) {
                this.triggerDefinition.setRaisedEventIds(routine.eventIds);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            this.stateHolder.setSuspectState(DataspaceStateHolder.syntax, exception, "Try to alter the trigger.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processWindowChange(Session session, Object oldData, Object newData) {
        if (!this.enabled) {
            return;
        }
        if (this.stateHolder.isSuspectState()) {
            throw new DataspaceException("Event trigger is invalid. Execution failed.");
        }
        Result result = Result.updateZeroResult;
        session.sessionContext.push();
        try {
            int variableCount = this.routine.getVariableCount();
            session.sessionContext.routineVariables = new Object[variableCount];
            session.sessionContext.rplArguments = new Object[2];
            if (oldData != null) {
                session.sessionContext.rplArguments[0] = new OtherTypeWrapper(oldData);
            }
            if (newData != null) {
                session.sessionContext.rplArguments[1] = new OtherTypeWrapper(newData);
            }
            result = this.routine.statement.execute(session);
            session.sessionContext.closeRoutineVariables();
        }
        finally {
            session.sessionContext.pop();
        }
        if (result.isError()) {
            this.stateHolder.setLastError(result.getException().getMessage());
            throw result.getException();
        }
        session.commit(false);
        this.stateHolder.setLastError("");
    }

    @Override
    public void enable(Session session) {
        this.shouldBeEnabled = true;
        if (this.stateHolder.isSuspectState()) {
            this.recompileTriggerInternal(session);
            if (this.stateHolder.isSuspectState()) {
                return;
            }
        } else if (this.enabled) {
            return;
        }
        this.enableInternal(session);
    }

    @Override
    public void disable() {
        this.shouldBeEnabled = false;
        this.triggerDefinition.setAutoEnable(false);
        if (!this.enabled) {
            return;
        }
        this.disableInternal();
    }

    protected void disableInternal() {
        this.enabled = false;
        if (this.routine != null) {
            this.routine.close(this);
        }
    }

    protected void enableInternal(Session session) {
        if (this.routine != null) {
            this.routine.open(session, this);
        }
        this.enabled = true;
        this.triggerDefinition.setAutoEnable(true);
    }

    @Override
    public void recompileTrigger(Session session) {
        boolean isInvalidOriginally = this.stateHolder.isSuspectState();
        if (isInvalidOriginally) {
            this.disableInternal();
        }
        this.recompileTriggerInternal(session);
        if (this.stateHolder.isSuspectState()) {
            this.disableInternal();
        } else if (isInvalidOriginally && this.shouldBeEnabled) {
            this.disableInternal();
            this.enableInternal(session);
        } else if (this.isAutoEnable && !session.isProcessingLog() && !session.isProcessingRecoveryLog()) {
            this.disableInternal();
            this.enableInternal(session);
        }
    }

    protected boolean recompileTriggerInternal(Session session) {
        try {
            this.triggerRecompileTime = System.currentTimeMillis();
            RplScript newRoutine = (RplScript)RoutineSchema.executeInDataspace(session, this.getObjectName().schema, s -> {
                String routineSql = this.rpl;
                if (this.routine != null && this.routine.statement != null) {
                    routineSql = this.routine.statement.getSQL();
                }
                ParserCommand parser = new ParserCommand(session, new Scanner(routineSql));
                if (parser.token.tokenType == 849) {
                    parser.read();
                }
                return parser.compileRplRoutine(this.name, this.rangeVars);
            });
            if (newRoutine != null) {
                if (this.routine != null) {
                    this.routine.close();
                }
                newRoutine.resolveReferences(session);
                this.routine = newRoutine;
                session.dataspaceStore.schemaManager.replaceReferences(this, this);
                this.stateHolder = new DataspaceStateHolder();
            }
            this.resetState();
        }
        catch (Exception error) {
            this.logError(session, "Unable to recompile object. " + Utils.formatExceptionWithUnrepeatedCauses(error));
            this.stateHolder.setSuspectState(DataspaceStateHolder.syntax, error, "Try to alter the trigger.");
            return false;
        }
        return true;
    }

    public EventTriggerState getTriggerState() {
        if (this.stateHolder.isSuspectState()) {
            return EventTriggerState.INVALID;
        }
        if (this.enabled) {
            return EventTriggerState.ENABLED;
        }
        return EventTriggerState.DISABLED;
    }

    public void destroy() {
        this.disable();
    }

    @Override
    public String getPrettyPrintedSQL() {
        boolean newDataNameSpecified;
        StringBuffer sb = new StringBuffer(256);
        sb.append("CREATE").append(' ');
        sb.append("WINDOW").append(' ');
        sb.append("TRIGGER").append(' ');
        sb.append(this.name.getSchemaQualifiedStatementName()).append(' ');
        sb.append("ON").append(' ');
        sb.append(this.collection.getObjectName().getSchemaQualifiedStatementName());
        sb.append(' ');
        sb.append("\n");
        sb.append("\t");
        sb.append("EVENT").append(' ');
        sb.append("SCOPE").append(' ');
        sb.append(this.eventScope.name()).append(' ');
        sb.append("\n");
        boolean oldDataNameSpecified = !this.oldDataName.name.equals(DEFAULT_OLD_DATA_NAME);
        boolean bl = newDataNameSpecified = !this.newDataName.name.equals(DEFAULT_NEW_DATA_NAME);
        if (oldDataNameSpecified || newDataNameSpecified) {
            sb.append("\t");
            sb.append("REFERENCING").append(' ');
            if (oldDataNameSpecified) {
                sb.append("OLD").append(' ');
                sb.append("AS").append(' ');
                sb.append(this.oldDataName.name);
                sb.append(' ');
            }
            if (newDataNameSpecified) {
                sb.append("NEW").append(' ');
                sb.append("AS").append(' ');
                sb.append(this.newDataName.name);
                sb.append(' ');
            }
            sb.append("\n");
        }
        if (this.routine != null && this.routine.statement != null) {
            sb.append('\n').append("AS").append('\n');
            sb.append(this.routine.statement.getSQL());
        } else {
            sb.append('\n').append("AS").append('\n');
            sb.append(this.rpl);
        }
        if (this.isAutoEnable() || this.shouldBeEnabled) {
            sb.append(" ").append("ENABLE");
        }
        return sb.toString();
    }

    @Override
    public String getSQL() {
        boolean newDataNameSpecified;
        StringBuffer sb = new StringBuffer(256);
        sb.append("CREATE").append(' ');
        sb.append("WINDOW").append(' ');
        sb.append("TRIGGER").append(' ');
        sb.append(this.name.getSchemaQualifiedStatementName()).append(' ');
        sb.append("ON").append(' ');
        sb.append(this.collection.getObjectName().getSchemaQualifiedStatementName());
        sb.append(' ');
        sb.append("EVENT").append(' ');
        sb.append("SCOPE").append(' ');
        sb.append(this.eventScope.name());
        boolean oldDataNameSpecified = !this.oldDataName.name.equals(DEFAULT_OLD_DATA_NAME);
        boolean bl = newDataNameSpecified = !this.newDataName.name.equals(DEFAULT_NEW_DATA_NAME);
        if (oldDataNameSpecified || newDataNameSpecified) {
            sb.append(' ');
            sb.append("REFERENCING");
            if (oldDataNameSpecified) {
                sb.append(' ');
                sb.append("OLD").append(' ');
                sb.append("AS").append(' ');
                sb.append(this.oldDataName.name);
            }
            if (newDataNameSpecified) {
                sb.append(' ');
                sb.append("NEW").append(' ');
                sb.append("AS").append(' ');
                sb.append(this.newDataName.name);
            }
        }
        if (this.routine != null && this.routine.statement != null) {
            sb.append(' ').append("AS").append(' ');
            sb.append(this.routine.statement.getSQL());
        } else {
            sb.append(' ').append("AS").append(' ');
            sb.append(this.rpl);
        }
        if (this.isAutoEnable() || this.shouldBeEnabled) {
            sb.append(" ").append("ENABLE");
        }
        return sb.toString();
    }

    @Override
    public EventFlowEntity getEntity() {
        return EventFlowEntity.DATASPACE_WINDOW_TRIGGER;
    }

    @Override
    public String getEntityName() {
        return this.getObjectName().name;
    }

    @Override
    public EventScope getEntityScope() {
        return this.eventScope;
    }

    @Override
    public HashMap<String, String> getEntityParameters() {
        return Utils.createMap("collection", this.collection.getCollectionName());
    }

    public void setRpl(String rpl) {
        this.rpl = rpl;
    }

    @Override
    public void invalidate(String lastError) {
        this.stateHolder.setSuspectState(DataspaceStateHolder.invalid, lastError);
    }

    @Override
    public DataspaceStateHolder getStateHolder() {
        return this.stateHolder;
    }

    @Override
    public DataspaceStateHolder aggregateStateHolder() {
        DataspaceStateHolder state = (DataspaceStateHolder)this.getStateHolder().clone();
        if (this.dataspace != null) {
            DataspaceStateHolder.aggregateState(state, this.getReferences(), this.dataspace.getStore().schemaManager);
        } else {
            state.setRecoveryFailedState();
        }
        return state;
    }

    @Override
    public String getStateName(DataspaceStoreState state) {
        if (state == DataspaceStoreState.SUSPECT) {
            return state.toString();
        }
        if (this.isEnabled()) {
            return "ENABLED";
        }
        return "DISABLED";
    }

    public void resetState() {
        this.stateHolder = new DataspaceStateHolder();
    }

    @Override
    public String getOperationTypeString() {
        switch (this.operationType) {
            case 3143: {
                return "WINDOW CHANGE";
            }
        }
        return "unknown";
    }

    public EventScope getEventScope() {
        return this.eventScope;
    }

    public Collection getCollection() {
        return this.collection;
    }
}

