/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.statement.RejectException;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.Trigger;
import com.streamscape.ds.trigger.TriggerDef;

public class TriggerDefSQL
extends TriggerDef {
    TriggerDefSQL() {
    }

    public TriggerDefSQL(NameManager.ObjectName name, int when, int operation, boolean forEachRow, Table table, Table[] transitions, RangeVariable[] rangeVars, Expression condition, String conditionSQL, int[] updateColumns, RplScript routine) {
        super(name, when, operation, forEachRow, table, transitions, rangeVars, condition, conditionSQL, updateColumns);
        this.routine = routine;
    }

    @Override
    public OrderedHashSet getReferences() {
        if (this.routine != null) {
            return this.routine.getReferences();
        }
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getClassName() {
        return null;
    }

    @Override
    public boolean hasOldTable() {
        return this.transitions[2] != null;
    }

    @Override
    public boolean hasNewTable() {
        return this.transitions[3] != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void pushPair(Session session, Object[] oldData, Object[] newData) {
        Result result = Result.updateZeroResult;
        session.sessionContext.push();
        try {
            session.sessionContext.triggerArguments = new Object[][]{null, null, null, null, null, null, null};
            if (this.triggerType != Trigger.Type.AFTER_MALFORMED_DATA && this.rangeVars[0] != null) {
                session.sessionContext.triggerArguments[0] = oldData;
            }
            if (this.rangeVars[1] != null) {
                session.sessionContext.triggerArguments[1] = newData;
            }
            result = this.executeTriggerLogic(session, oldData, newData);
        }
        finally {
            session.sessionContext.pop();
        }
        if (result.isError()) {
            throw result.getException();
        }
    }

    protected Result executeTriggerLogic(Session session, Object[] oldData, Object[] newData) {
        if (this.condition.testCondition(session)) {
            int variableCount = this.routine.getVariableCount();
            session.sessionContext.routineVariables = new Object[variableCount];
            Result result = this.routine.statement.execute(session);
            session.sessionContext.closeRoutineVariables();
            if (result.isError() && !(result.getException() instanceof RejectException)) {
                this.logError(session, "Event trigger execution failure. " + result.getException().getMessage());
            }
            return result;
        }
        return Result.updateZeroResult;
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.getObjectName().getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        StringBuffer sb = this.getSQLMain(name);
        if (this.routine != null && this.routine.statement != null) {
            sb.append(this.routine.statement.getSQL());
        }
        return sb.toString();
    }
}

