/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceLogger;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.HsqlDeque;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.Trigger;
import java.util.function.BiConsumer;

public class TriggerDef
implements Runnable,
SchemaObject {
    public static final int OLD_DATA = 0;
    public static final int NEW_DATA = 1;
    public static final int RANGE_COUNT = 2;
    public static final int OLD_COLLECTION = 2;
    public static final int NEW_COLLECTION = 3;
    public static final int ACTIONABLE_EVENT = 4;
    public static final int REPLICATION_DATA = 2;
    public static final int OLD_REPLICA_DATA = 2;
    public static final int NEW_REPLICA_DATA = 3;
    public static final int BEFORE = 5;
    public static final int AFTER = 6;
    public static final int INSTEAD = 7;
    public static final int ON = 8;
    public static final int AFTER_COMMIT = 9;
    public static final int ACTION_TIMING_INDEX_BEFORE = 5;
    public static final int ACTION_TIMING_INDEX_INSTEAD = 6;
    public static final int ACTION_TIMING_INDEX_ON = 7;
    public static final int ACTION_TIMING_INDEX_AFTER = 8;
    public static final int ACTION_TIMING_INDEX_AFTER_COMMIT = 9;
    public static final TriggerDef[] emptyArray = new TriggerDef[0];
    Table[] transitions;
    RangeVariable[] rangeVars;
    Expression condition;
    boolean hasTransitionTables;
    boolean hasTransitionRanges;
    boolean hasActionableEventRange;
    String conditionSQL;
    public RplScript routine;
    int[] updateColumns;
    protected NameManager.ObjectName name;
    long changeTimestamp;
    int actionTiming;
    public int operationType;
    boolean isSystem;
    boolean forEachRow;
    boolean nowait;
    int maxRowsQueued;
    public Table table;
    Trigger trigger;
    String triggerClassName;
    public Trigger.Type triggerType;
    Thread thread;
    protected boolean enabled = false;
    protected boolean shouldBeEnabled = false;
    protected HsqlDeque pendingQueue;
    protected int rowsQueued;
    protected boolean valid = true;
    protected volatile boolean keepGoing = true;
    protected boolean isAutoEnable = false;
    public static final int TRIGGER_ORDER_FIRST = Integer.MIN_VALUE;
    public static final int TRIGGER_ORDER_LAST = Integer.MAX_VALUE;
    public int triggerOrder;

    TriggerDef() {
    }

    public TriggerDef(NameManager.ObjectName name, int when, int operation, boolean forEach, Table table, Table[] transitions, RangeVariable[] rangeVars, Expression condition, String conditionSQL, int[] updateColumns, String triggerClassName, boolean noWait, int queueSize) {
        this(name, when, operation, forEach, table, transitions, rangeVars, condition, conditionSQL, updateColumns);
        this.triggerClassName = triggerClassName;
        this.nowait = noWait;
        this.maxRowsQueued = queueSize;
        this.rowsQueued = 0;
        this.pendingQueue = new HsqlDeque();
        Class<?> cl = null;
        try {
            cl = Class.forName(triggerClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable t1) {
            try {
                cl = Class.forName(triggerClassName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (cl == null) {
            this.valid = false;
            this.trigger = new DefaultTrigger();
        } else {
            try {
                this.trigger = (Trigger)cl.newInstance();
            }
            catch (Throwable t1) {
                this.valid = false;
                this.trigger = new DefaultTrigger();
            }
        }
    }

    public TriggerDef(NameManager.ObjectName name, int when, int operation, boolean forEachRow, Table table, Table[] transitions, RangeVariable[] rangeVars, Expression condition, String conditionSQL, int[] updateColumns) {
        this.name = name;
        this.actionTiming = when;
        this.operationType = operation;
        this.forEachRow = forEachRow;
        this.table = table;
        this.transitions = transitions;
        this.rangeVars = rangeVars;
        this.condition = condition == null ? Expression.EXPR_TRUE : condition;
        this.updateColumns = updateColumns;
        this.conditionSQL = conditionSQL;
        this.hasTransitionRanges = rangeVars[0] != null || rangeVars[1] != null;
        this.hasTransitionTables = transitions[2] != null || transitions[3] != null;
        this.hasActionableEventRange = rangeVars[4] != null;
        this.setUpIndexesAndTypes();
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public int getObjectType() {
        return 9;
    }

    @Override
    public NameManager.ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public NameManager.ObjectName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    public void validateActionableEventPrototype() {
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.getObjectName().getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        StringBuffer sb = this.getSQLMain(name);
        if (this.maxRowsQueued != 0) {
            sb.append("QUEUE").append(' ');
            sb.append(this.maxRowsQueued).append(' ');
            if (this.nowait) {
                sb.append("NOWAIT").append(' ');
            }
        }
        sb.append("CALL").append(' ');
        sb.append(NameManager.quoteName(this.triggerClassName));
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    public StringBuffer getSQLMain() {
        return this.getSQLMain(this.name.getSchemaQualifiedStatementName());
    }

    public StringBuffer getSQLMain(String name) {
        StringBuffer sb = new StringBuffer(256);
        sb.append("CREATE").append(' ');
        sb.append("TRIGGER").append(' ');
        sb.append(name).append(' ');
        sb.append(this.getActionTimingString()).append(' ');
        sb.append(this.getOperationTypeString()).append(' ');
        if (this.updateColumns != null && this.table != null) {
            sb.append("OF").append(' ');
            for (int i = 0; i < this.updateColumns.length; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                NameManager.ObjectName columnName = this.table.getColumn(this.updateColumns[i]).getObjectName();
                sb.append(columnName.statementName);
            }
            sb.append(' ');
        }
        sb.append("ON").append(' ');
        sb.append(this.table.getObjectName().getSchemaQualifiedStatementName());
        sb.append(' ');
        if (this.hasTransitionRanges || this.hasTransitionTables) {
            sb.append("REFERENCING").append(' ');
            if (this.rangeVars[0] != null) {
                sb.append("OLD").append(' ').append("DATA");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.rangeVars[0].getTableAlias().getStatementName());
                sb.append(' ');
            }
            if (this.rangeVars[1] != null) {
                sb.append("NEW").append(' ').append("DATA");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.rangeVars[1].getTableAlias().getStatementName());
                sb.append(' ');
            }
            if (this.transitions[2] != null) {
                sb.append("OLD").append(' ').append("COLLECTION");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.transitions[2].getObjectName().statementName);
                sb.append(' ');
            }
            if (this.transitions[3] != null) {
                sb.append("OLD").append(' ').append("COLLECTION");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.transitions[3].getObjectName().statementName);
                sb.append(' ');
            }
        }
        if (!this.forEachRow) {
            sb.append("FOR").append(' ');
            sb.append("EACH").append(' ');
            sb.append("STATEMENT").append(' ');
        }
        if (this.condition != Expression.EXPR_TRUE) {
            sb.append("WHEN").append(' ');
            sb.append("(").append(this.conditionSQL);
            sb.append(")").append(' ');
        }
        if (!this.getTriggerOrderString().equals("0")) {
            sb.append("ORDER").append(' ').append(this.getTriggerOrderString()).append(' ');
        }
        return sb;
    }

    public String getClassName() {
        return this.trigger.getClass().getName();
    }

    public int getActionTimingIndex() {
        switch (this.actionTiming) {
            case 5: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 6: {
                return 8;
            }
            case 9: {
                return 9;
            }
        }
        throw Error.runtimeError(201, "TriggerDef");
    }

    public String getActionTimingString() {
        switch (this.actionTiming) {
            case 5: {
                return "BEFORE";
            }
            case 6: {
                return "AFTER";
            }
            case 9: {
                return "AFTER COMMIT";
            }
            case 8: {
                return "ON";
            }
            case 7: {
                return "INSTEAD OF";
            }
        }
        throw Error.runtimeError(201, "TriggerDef");
    }

    public String getOperationTypeString() {
        switch (this.operationType) {
            case 50: {
                return "INSERT";
            }
            case 19: {
                return "DELETE";
            }
            case 82: {
                return "UPDATE";
            }
            case 3001: {
                return "PUT";
            }
            case 3031: {
                return "ADD";
            }
            case 3030: {
                return "GET";
            }
            case 1205: {
                return "TRUNCATE";
            }
            case 1206: {
                return "MALFORMED DATA";
            }
        }
        throw Error.runtimeError(201, "TriggerDef");
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public boolean isForEachRow() {
        return this.forEachRow;
    }

    public String getConditionSQL() {
        return this.conditionSQL;
    }

    public String getProcedureSQL() {
        return this.routine == null ? null : this.routine.getSQLBodyDefinition();
    }

    public int[] getUpdateColumnIndexes() {
        return this.updateColumns;
    }

    public boolean hasOldTable() {
        return false;
    }

    public boolean hasNewTable() {
        return false;
    }

    public String getOldTransitionRowName() {
        if (this.rangeVars != null && this.rangeVars[0] != null) {
            return this.rangeVars[0].getTableAlias().name;
        }
        return null;
    }

    public String getNewTransitionRowName() {
        if (this.rangeVars != null && this.rangeVars[1] != null) {
            return this.rangeVars[1].getTableAlias().name;
        }
        return null;
    }

    public String getOldTransitionTableName() {
        if (this.transitions != null && this.transitions[2] != null) {
            return this.transitions[2].getObjectName().name;
        }
        return null;
    }

    public String getNewTransitionTableName() {
        if (this.transitions != null && this.transitions[3] != null) {
            return this.transitions[3].getObjectName().name;
        }
        return null;
    }

    void setUpIndexesAndTypes() {
        switch (this.operationType) {
            case 50: 
            case 3001: 
            case 3031: {
                this.triggerType = Trigger.Type.INSERT_AFTER;
                if (this.forEachRow) {
                    this.triggerType = Trigger.Type.INSERT_AFTER_ROW;
                    if (this.actionTiming == 9) {
                        this.triggerType = Trigger.Type.INSERT_AFTER_ROW_COMMIT;
                    }
                } else if (this.actionTiming == 9) {
                    this.triggerType = Trigger.Type.INSERT_AFTER_COMMIT;
                }
                if (this.actionTiming != 5 && this.actionTiming != 7) break;
                this.triggerType = Trigger.Type.INSERT_BEFORE_ROW;
                break;
            }
            case 19: 
            case 3032: {
                this.triggerType = Trigger.Type.DELETE_AFTER;
                if (this.forEachRow) {
                    this.triggerType = Trigger.Type.DELETE_AFTER_ROW;
                    if (this.actionTiming == 9) {
                        this.triggerType = Trigger.Type.DELETE_AFTER_ROW_COMMIT;
                    }
                } else if (this.actionTiming == 9) {
                    this.triggerType = Trigger.Type.DELETE_AFTER_COMMIT;
                }
                if (this.actionTiming != 5 && this.actionTiming != 7) break;
                this.triggerType = Trigger.Type.DELETE_BEFORE_ROW;
                break;
            }
            case 82: {
                this.triggerType = Trigger.Type.UPDATE_AFTER;
                if (this.forEachRow) {
                    this.triggerType = Trigger.Type.UPDATE_AFTER_ROW;
                    if (this.actionTiming == 9) {
                        this.triggerType = Trigger.Type.UPDATE_AFTER_ROW_COMMIT;
                    }
                } else if (this.actionTiming == 9) {
                    this.triggerType = Trigger.Type.UPDATE_AFTER_COMMIT;
                }
                if (this.actionTiming != 5 && this.actionTiming != 7) break;
                this.triggerType = Trigger.Type.UPDATE_BEFORE_ROW;
                break;
            }
            case 1205: {
                this.triggerType = Trigger.Type.TRUNCATE;
                break;
            }
            case 3143: {
                this.triggerType = Trigger.Type.WINDOW_CHANGE;
                return;
            }
            case 3245: {
                this.triggerType = Trigger.Type.VALIDATION_TRIGGER;
                return;
            }
            case 3250: {
                this.triggerType = Trigger.Type.REPLICATION_MODIFY_TRIGGER;
                return;
            }
            case 1206: {
                this.triggerType = Trigger.Type.AFTER_MALFORMED_DATA;
                return;
            }
            default: {
                throw Error.runtimeError(201, "TriggerDef");
            }
        }
        if (this.actionTiming == 8 && this.operationType == 82) {
            this.triggerType = Trigger.Type.CHANGE_AFTER_ROW;
        }
    }

    public static String getEventTypeString(int token) {
        switch (token) {
            case 50: {
                return "Insert";
            }
            case 19: {
                return "Delete";
            }
            case 82: {
                return "Update";
            }
            case 3001: {
                return "Put";
            }
            case 3031: {
                return "Add";
            }
            case 3032: {
                return "Remove";
            }
            case 1205: {
                return "Truncate";
            }
            case 1206: {
                return "Malformed";
            }
        }
        throw Error.runtimeError(201, "TriggerDef");
    }

    public static String getTimingString(int token) {
        switch (token) {
            case 5: {
                return "before";
            }
            case 6: {
                return "after";
            }
            case 9: {
                return "afterCommit";
            }
            case 7: {
                return "instead";
            }
            case 8: {
                return "on";
            }
        }
        throw Error.runtimeError(201, "TriggerDef");
    }

    public int getStatementType() {
        return this.operationType;
    }

    @Override
    public void run() {
        String tableName;
        String string = tableName = this.table != null ? this.table.getObjectName().name : "";
        while (this.keepGoing) {
            TriggerData triggerData = this.popPair();
            if (triggerData == null || triggerData.username == null) continue;
            this.trigger.fire(this.triggerType, this.name.name, tableName, triggerData.oldRow, triggerData.newRow);
        }
        try {
            this.thread.setContextClassLoader(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void start() {
        if (this.maxRowsQueued != 0) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public synchronized void terminate() {
        this.keepGoing = false;
        this.notify();
    }

    synchronized TriggerData popPair() {
        if (this.rowsQueued == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        --this.rowsQueued;
        this.notify();
        if (this.pendingQueue.size() == 0) {
            return null;
        }
        return (TriggerData)this.pendingQueue.removeFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pushPair(Session session, Object[] row1, Object[] row2) {
        if (this.maxRowsQueued == 0) {
            session.getInternalConnection();
            try {
                this.trigger.fire(this.triggerType, this.name.name, this.table.getObjectName().name, row1, row2);
            }
            finally {
                session.releaseInternalConnection();
            }
            return;
        }
        if (this.rowsQueued >= this.maxRowsQueued) {
            if (this.nowait) {
                this.pendingQueue.removeLast();
            } else {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this.rowsQueued;
            }
        } else {
            ++this.rowsQueued;
        }
        this.pendingQueue.add(new TriggerData(session, row1, row2));
        this.notify();
    }

    public boolean isBusy() {
        return this.rowsQueued != 0;
    }

    public Table getTable() {
        return this.table;
    }

    public String getActionOrientationString() {
        return this.forEachRow ? "ROW" : "STATEMENT";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable(Session session) {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public void setAutoEnable(boolean value) {
        this.isAutoEnable = value;
    }

    public boolean isAutoEnable() {
        return this.isAutoEnable;
    }

    public void logInfo(Session session, String message) {
        this.log(session, message, (l, m) -> l.logInfo(this.getObjectName().name, message));
    }

    public void logDebug(Session session, String message) {
        this.log(session, message, (l, m) -> l.logDebug(this.getObjectName().name, message));
    }

    public void logError(Session session, String message) {
        this.log(session, message, (l, m) -> l.logError(this.getObjectName().name, message));
    }

    private void log(Session session, String message, BiConsumer<DataspaceLogger, String> logFunction) {
        DataspaceSchema schema;
        DataspaceSchema dataspaceSchema = schema = session != null ? session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name) : null;
        if (schema != null && schema.getLogger() != null) {
            logFunction.accept(schema.getLogger(), message);
        } else {
            Object prefix = "";
            if (session != null) {
                prefix = (String)prefix + "[" + session.currentDataspace.name + "] ";
            } else if (this.getObjectName().schema != null) {
                prefix = (String)prefix + "[" + this.getObjectName().schema.name + "] ";
            }
            prefix = (String)prefix + "[" + this.getObjectName().name + "] ";
            Trace.logError(this, (String)prefix + message);
        }
    }

    public String getTriggerOrderString() {
        if (this.triggerOrder == Integer.MIN_VALUE) {
            return "first";
        }
        if (this.triggerOrder == Integer.MAX_VALUE) {
            return "last";
        }
        return "" + this.triggerOrder;
    }

    static class DefaultTrigger
    implements Trigger {
        DefaultTrigger() {
        }

        @Override
        public void fire(Trigger.Type i, String name, String table, Object[] row1, Object[] row2) {
        }
    }

    static class TriggerData {
        public Object[] oldRow;
        public Object[] newRow;
        public String username;

        public TriggerData(Session session, Object[] oldRow, Object[] newRow) {
            this.oldRow = oldRow;
            this.newRow = newRow;
            this.username = session.getUsername();
        }
    }
}

