/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.parser.ParserCommand;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.RplSchemaObject;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.trigger.EventTriggerDefSQL;
import com.streamscape.ds.trigger.SystemEventTriggerType;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerCompiledDefinition;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.moderator.EventFlowEntity;

public class SystemEventTrigger
extends EventTriggerDefSQL
implements RplSchemaObject {
    protected SystemEventTriggerType systemTriggerType = null;

    public SystemEventTrigger(NameManager.ObjectName name, SystemEventTriggerType systemTriggerType, RplScript routine, EventScope eventScope) {
        this.name = name;
        this.routine = routine;
        this.systemTriggerType = systemTriggerType;
        this.enabled = false;
        try {
            EventTriggerDefinition definition = new EventTriggerDefinition();
            definition.setName(name.name);
            definition.setEventScope(eventScope);
            this.triggerDefinition = new EventTriggerCompiledDefinition(definition);
            if (routine != null && routine.eventIds != null && routine.eventIds.size() > 0) {
                this.triggerDefinition.setRaisedEventIds(routine.eventIds);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            this.stateHolder.setSuspectState(DataspaceStateHolder.syntax, exception, "Try to alter trigger.");
        }
    }

    public SystemEventTriggerType getSystemTriggerType() {
        return this.systemTriggerType;
    }

    @Override
    protected boolean recompileTriggerInternal(Session session) {
        if (this.rpl == null) {
            return false;
        }
        try {
            RplScript newRoutine = (RplScript)RoutineSchema.executeInDataspace(session, this.getObjectName().schema, s -> {
                String routineSql = this.rpl;
                ParserCommand parser = new ParserCommand(session, new Scanner(routineSql));
                if (parser.token.tokenType == 849) {
                    parser.read();
                }
                return parser.compileRplRoutine(this.name, this.rangeVars);
            });
            if (newRoutine != null) {
                if (this.routine != null) {
                    this.routine.close();
                }
                newRoutine.resolveReferences(session);
                this.routine = newRoutine;
                session.dataspaceStore.schemaManager.replaceReferences(this, this);
            }
            this.resetState();
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to recompile object. " + error.getMessage());
            this.stateHolder.setSuspectState(DataspaceStateHolder.syntax, error, "Try to alter the trigger.");
            return false;
        }
        return true;
    }

    public void execute(Session session) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.stateHolder.isSuspectState()) {
            Trace.logError(this, "Unable to execute system trigger " + this.name.name + " (" + this.systemTriggerType.name() + "). Skipped.");
            return;
        }
        NameManager.ObjectName currentDataspace = session.currentDataspace;
        try {
            session.sessionContext.rplObject = this;
            session.sessionContext.triggerDefinition = this.triggerDefinition;
            session.currentDataspace = this.name.schema;
            int variableCount = this.routine.getVariableCount();
            session.sessionContext.routineVariables = new Object[variableCount];
            Result result = this.routine.statement.execute(session);
            session.sessionContext.closeRoutineVariables();
            if (result.isError()) {
                Trace.logError(this, "System event trigger " + this.name.name + " (" + this.systemTriggerType.name() + ") execution failure. " + result.getException().getMessage());
            }
        }
        catch (Throwable error) {
            Trace.logException(this, error, true);
            this.stateHolder.setLastError(error.getMessage());
            throw new DataspaceException(error);
        }
        finally {
            session.sessionContext.rplObject = null;
            session.sessionContext.triggerDefinition = null;
            session.currentDataspace = currentDataspace;
        }
        this.stateHolder.setLastError("");
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("CREATE").append(' ');
        sb.append("EVENT").append(' ');
        sb.append("TRIGGER").append(' ');
        sb.append(this.name.getSchemaQualifiedStatementName()).append(' ');
        sb.append("ON").append(' ');
        sb.append(this.systemTriggerType.name());
        sb.append(' ');
        sb.append("EVENT").append(' ');
        sb.append("SCOPE").append(' ');
        sb.append(this.triggerDefinition.getEventScope().name()).append(' ');
        if (this.routine != null && this.routine.statement != null) {
            sb.append(' ').append("AS").append(' ');
            sb.append(this.routine.statement.getSQL());
        } else {
            sb.append(' ').append("AS").append(' ');
            sb.append(this.rpl);
        }
        if (this.isAutoEnable()) {
            sb.append(" ").append("ENABLE");
        }
        return sb.toString();
    }

    @Override
    public int getActionTimingIndex() {
        return 7;
    }

    @Override
    public String getActionTimingString() {
        return "ON";
    }

    @Override
    public String getOperationTypeString() {
        return this.systemTriggerType.name();
    }

    @Override
    public EventFlowEntity getEntity() {
        return EventFlowEntity.DATASPACE_SYSTEM_TRIGGER;
    }
}

