/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.parser.statement.StatementRplExec;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.replication.ReplicationData;
import com.streamscape.ds.replication.ReplicationOperationType;
import com.streamscape.ds.replication.ReplicationSourceInfo;
import com.streamscape.ds.replication.ReplicationTarget;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.AbstractReplicationEventTrigger;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.utils.Utils;

public class ReplicationValidateTrigger
extends AbstractReplicationEventTrigger {
    protected Type type;
    protected ReplicationTarget replicationTarget;

    public ReplicationValidateTrigger(NameManager.ObjectName name, Type triggerType, ReplicationTarget replicationTarget, RplScript routine, RangeVariable[] rangeVars, StatementRplExec stat, EventScope eventScope) {
        super(name, routine, rangeVars, stat, eventScope);
        this.type = triggerType;
        this.replicationTarget = replicationTarget;
        this.dataspace = replicationTarget.getDataspace();
    }

    public boolean execute(Session session, ReplicationData replicationData) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (this.type.ordinal()) {
            case 0: {
                if (replicationData.getOperationType() == ReplicationOperationType.INSERT) break;
                return false;
            }
            case 1: {
                if (replicationData.getOperationType() == ReplicationOperationType.UPDATE) break;
                return false;
            }
            case 2: {
                if (replicationData.getOperationType() == ReplicationOperationType.DELETE) break;
                return false;
            }
        }
        if (this.stateHolder.isSuspectState()) {
            Trace.logError(this, "Replication validate trigger '" + this.name.name + "' is in suspect state.");
            throw new DataspaceException("Replication validate trigger '" + this.name.name + "' is in suspect state.");
        }
        boolean exceptionLogged = false;
        NameManager.ObjectName currentDataspace = session.currentDataspace;
        try {
            session.sessionContext.rplObject = this;
            session.sessionContext.triggerDefinition = this.triggerDefinition;
            session.currentDataspace = this.name.schema;
            int variableCount = this.routine.getVariableCount();
            session.sessionContext.routineVariables = new Object[variableCount];
            session.sessionContext.triggerArguments = new Object[][]{null, null, null, null, null};
            Object[] oldData = null;
            Object[] newData = null;
            switch (replicationData.getOperationType()) {
                case INSERT: {
                    newData = replicationData.getRow();
                    break;
                }
                case DELETE: {
                    oldData = replicationData.getRow();
                    break;
                }
                case UPDATE: {
                    Object[] rows = replicationData.getRow();
                    oldData = (Object[])rows[0];
                    newData = (Object[])rows[1];
                    break;
                }
                default: {
                    boolean bl = false;
                    return bl;
                }
            }
            Object[] oldDataTmp = oldData;
            oldData = this.fillDataColumns(oldData, replicationData);
            if (this.rangeVars[0] != null) {
                session.sessionContext.triggerArguments[0] = oldData;
            }
            if (this.rangeVars[1] != null) {
                session.sessionContext.triggerArguments[1] = newData;
            }
            Result result = session.executeCompiledStatement(this.stat, new Object[0]);
            if (oldDataTmp != oldData) {
                this.fillDataColumnsBack(oldDataTmp, oldData, replicationData);
            }
            session.sessionContext.closeRoutineVariables();
            if (result.isError()) {
                if (result.getException() != null) {
                    Trace.logError(this, "Replication validate trigger '{}' execution failure. Cause: {}", this.name.name, Utils.formatExceptionWithUnrepeatedCauses(result.getException()));
                    this.stateHolder.setLastError(Utils.formatExceptionWithUnrepeatedCauses(result.getException()));
                    if (Trace.isDebugEnabled(this.getClass())) {
                        Trace.logException(this, result.getException(), true);
                    }
                    exceptionLogged = true;
                    throw result.getException();
                }
                Trace.logError(this, "Replication validate trigger '{}' execution failure.", this.name.name);
                this.stateHolder.setLastError("Replication validate trigger '" + this.getObjectName().getStatementName() + "' execution error.");
                exceptionLogged = true;
                throw new DataspaceException("Replication validate trigger '" + this.getObjectName().getStatementName() + "' execution error.");
            }
            this.stateHolder.setLastError("");
            if (result.getErrorCode() == 3247) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable exception) {
            if (exceptionLogged) {
                throw exception;
            }
            Trace.logError(this, "Replication validate trigger '" + this.name.name + "' execution failure.");
            Trace.logException(this, exception, true);
            this.stateHolder.setLastError(Utils.formatExceptionWithUnrepeatedCauses(exception));
            throw exception;
        }
        finally {
            session.sessionContext.rplObject = null;
            session.sessionContext.triggerDefinition = null;
            session.currentDataspace = currentDataspace;
        }
        return false;
    }

    private void fillDataColumnsBack(Object[] data, Object[] dataUpdated, ReplicationData replicationData) {
        int columnsCount;
        int n = this.rangeVars[0] != null ? this.rangeVars[0].getVariables().size() : (columnsCount = this.rangeVars[1] != null ? this.rangeVars[1].getVariables().size() : -1);
        if (replicationData.getPrimaryKey() != null && replicationData.getPrimaryKey().size() > 0 && columnsCount != -1 && data != null && data.length != columnsCount) {
            for (int i = 0; i < replicationData.getPrimaryKey().size(); ++i) {
                data[i] = dataUpdated[replicationData.getPrimaryKey().get(i)];
            }
        }
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE").append(' ');
        builder.append("REPLICATION").append(' ');
        builder.append("VALIDATE").append(' ');
        builder.append("TRIGGER").append(' ');
        builder.append(this.name.getSchemaQualifiedStatementName()).append(' ');
        builder.append("ON").append(' ');
        builder.append("[").append(this.replicationTarget.getTargetEntityName().getFullNameNoDataspaceTypeNoNodeName()).append("]");
        builder.append(' ');
        builder.append("BEFORE").append(' ');
        if (this.type == Type.INSERT) {
            builder.append("INSERT").append(' ');
        } else if (this.type == Type.UPDATE) {
            builder.append("UPDATE").append(' ');
        } else if (this.type == Type.DELETE) {
            builder.append("DELETE").append(' ');
        }
        builder.append("EVENT").append(' ');
        builder.append("SCOPE").append(' ');
        builder.append(this.triggerDefinition.getEventScope().name()).append(' ');
        if (this.rangeVars != null && this.rangeVars[0] != null) {
            builder.append("OLD").append(' ').append("DATA");
            builder.append(' ').append("AS").append(' ');
            if (this.rangeVars[0].getTableAlias() != null) {
                builder.append(this.rangeVars[0].getTableAlias().getNameString());
            } else {
                builder.append(this.rangeVars[0].getColumn(0).getNameString());
            }
            builder.append(' ');
        }
        if (this.rangeVars != null && this.rangeVars[1] != null) {
            builder.append("NEW").append(' ').append("DATA");
            builder.append(' ').append("AS").append(' ');
            if (this.rangeVars[1].getTableAlias() != null) {
                builder.append(this.rangeVars[1].getTableAlias().getNameString());
            } else {
                builder.append(this.rangeVars[1].getColumn(0).getNameString());
            }
            builder.append(' ');
        }
        if (this.routine != null && this.routine.statement != null) {
            builder.append(' ').append("AS").append(' ');
            builder.append(this.routine.statement.getSQL());
        } else {
            builder.append(' ').append("AS").append(' ');
            builder.append(this.rpl);
        }
        if (this.isAutoEnable()) {
            builder.append(" ").append("ENABLE");
        }
        return builder.toString();
    }

    @Override
    public int getActionTimingIndex() {
        return 7;
    }

    @Override
    public String getActionTimingString() {
        return "BEFORE";
    }

    public ReplicationTarget getReplicationTarget() {
        return this.replicationTarget;
    }

    public Type getReplicationTriggerType() {
        return this.type;
    }

    @Override
    public String getOperationTypeString() {
        return this.type.name();
    }

    @Override
    public EventFlowEntity getEntity() {
        return EventFlowEntity.DATASPACE_REPLICATION_VALIDATE_TRIGGER;
    }

    @Override
    public void updateRangeVariables(Session session, ReplicationSourceInfo replicationSourceInfo) {
        this.updateSourceRangeVariables(session, replicationSourceInfo, 0);
        this.updateSourceRangeVariables(session, replicationSourceInfo, 1);
    }

    private void updateSourceRangeVariables(Session session, ReplicationSourceInfo replicationSourceInfo, int position) {
        if (this.rangeVars[position] != null) {
            ReplicationValidateTrigger.fillSourceRangeVariable(session, replicationSourceInfo, this.rangeVars[position].getTableAlias() != null ? this.rangeVars[position].getTableAlias() : this.rangeVars[position].getColumn(0).getObjectName(), position, this.rangeVars);
        }
    }

    public static enum Type {
        INSERT,
        UPDATE,
        DELETE;

    }
}

