/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.parser.statement.StatementRplExec;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.replication.ReplicationData;
import com.streamscape.ds.replication.ReplicationOperationType;
import com.streamscape.ds.replication.ReplicationSourceInfo;
import com.streamscape.ds.replication.ReplicationTarget;
import com.streamscape.ds.replication.SimpleColumnDescriptor;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.trigger.AbstractReplicationEventTrigger;
import com.streamscape.omf.java.Utils;
import com.streamscape.omf.mapper.SemanticMap;
import com.streamscape.omf.mapper.SemanticMapRepositoryUtils;
import com.streamscape.omf.mapper.SemanticMapperImpl;
import com.streamscape.omf.mapper.parser.LocalSemanticMapperContext;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventFlowEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ReplicationModifyTrigger
extends AbstractReplicationEventTrigger {
    protected ReplicationTarget replicationTarget;
    private String mapperName;
    private SemanticMapperImpl mapper;

    public ReplicationModifyTrigger(NameManager.ObjectName name, ReplicationTarget replicationTarget, RplScript routine, RangeVariable[] rangeVars, StatementRplExec stat, EventScope eventScope) {
        super(name, routine, rangeVars, stat, eventScope);
        this.replicationTarget = replicationTarget;
        this.dataspace = replicationTarget.getDataspace();
    }

    public ReplicationModifyTrigger(NameManager.ObjectName name, ReplicationTarget replicationTarget, String mapperName) {
        super(name, null, null, null, null);
        this.replicationTarget = replicationTarget;
        this.dataspace = replicationTarget.getDataspace();
        this.mapperName = mapperName;
    }

    @Override
    public void enable(Session session) {
        if (this.mapperName != null) {
            if (this.mapper == null) {
                try {
                    this.initSemanticMap();
                }
                catch (Exception error) {
                    this.stateHolder.setSuspectState(DataspaceStateHolder.syntax, Utils.formatExceptionWithUnrepeatedCauses(error));
                    return;
                }
                this.resetState();
            }
            this.enabled = true;
        } else {
            super.enable(session);
        }
    }

    @Override
    public void disable() {
        if (this.mapperName != null) {
            if (this.mapper != null) {
                this.mapper.close();
            }
            this.mapper = null;
            this.enabled = false;
        } else {
            super.disable();
        }
    }

    @Override
    protected boolean recompileTriggerInternal(Session session) {
        if (this.mapperName != null) {
            if (this.mapper != null) {
                this.mapper.close();
            }
            this.mapper = null;
            try {
                this.initSemanticMap();
            }
            catch (Exception error) {
                this.stateHolder.setSuspectState(DataspaceStateHolder.syntax, Utils.formatExceptionWithUnrepeatedCauses(error));
                return false;
            }
            this.resetState();
            if (this.isAutoEnable) {
                this.enabled = true;
            }
            return true;
        }
        return super.recompileTriggerInternal(session);
    }

    private void initSemanticMap() {
        try {
            SemanticMap semanticMap = SemanticMapRepositoryUtils.lookupSemanticMap(this.mapperName);
            this.validateSemanticMap(semanticMap);
            LocalSemanticMapperContext semanticMapperContext = new LocalSemanticMapperContext(null, this.dataspace);
            this.mapper = new SemanticMapperImpl(semanticMapperContext);
            this.mapper.setSemanticMap(semanticMap);
            this.mapper.init();
        }
        catch (Exception exception) {
            this.mapper = null;
            this.stateHolder.setLastError(com.streamscape.sef.utils.Utils.formatExceptionWithUnrepeatedCauses(exception));
            throw new DataspaceException("Failed to initialize semantic mapper. " + Utils.formatExceptionWithUnrepeatedCauses(exception));
        }
    }

    private void validateSemanticMap(SemanticMap semanticMap) throws Exception {
        Collection targetCollection;
        int i;
        List<ColumnDescriptor> mapColumns;
        if (semanticMap.getSources().size() != 1 || !"ROW".equalsIgnoreCase(semanticMap.getSources().get(0).getSemanticType())) {
            throw new Exception("Replication modify trigger semantic map should have one source of ROW type.");
        }
        if (semanticMap.getTarget() == null || !"ROW".equalsIgnoreCase(semanticMap.getTarget().getSemanticType())) {
            throw new Exception("Replication modify trigger semantic map should have one target of ROW type.");
        }
        ReplicationSourceInfo replicationSourceInfo = this.replicationTarget.getReplicationSourceInfo();
        if (replicationSourceInfo != null) {
            List<SimpleColumnDescriptor> sourceColumns = replicationSourceInfo.getColumnList();
            mapColumns = semanticMap.getSources().get(0).getColumns();
            if (sourceColumns.size() != mapColumns.size()) {
                throw new Exception("Semantic mapper source row columns count(" + mapColumns.size() + ") doesn't match to replication source columns count(" + sourceColumns.size() + ").");
            }
            for (i = 0; i < mapColumns.size(); ++i) {
                if (!Objects.equals(sourceColumns.get(i).getColumnName(), mapColumns.get(i).getName())) {
                    throw new Exception("Semantic mapper source row column name(" + mapColumns.get(i).getName() + ") doesn't match to replication source column name(" + sourceColumns.get(i).getColumnName() + ").");
                }
                if (sourceColumns.get(i).getJdbcType() == mapColumns.get(i).getSQLType()) continue;
                throw new Exception("Semantic mapper source row column '" + mapColumns.get(i).getName() + "' type(" + mapColumns.get(i).getTypeName() + ") doesn't match to replication source column type(" + sourceColumns.get(i).getTypeName() + ").");
            }
        }
        if ((targetCollection = this.replicationTarget.getCollection()) != null) {
            HashMappedList targetColumns = targetCollection.getBaseTable().columnList;
            mapColumns = semanticMap.getTarget().getColumns();
            if (targetColumns.size() != mapColumns.size()) {
                throw new Exception("Semantic mapper target row columns count(" + mapColumns.size() + ") doesn't match to replica columns count(" + targetColumns.size() + ").");
            }
            for (i = 0; i < mapColumns.size(); ++i) {
                ColumnSchema targetColumn = (ColumnSchema)targetColumns.get(i);
                if (!Objects.equals(targetColumn.getNameString(), mapColumns.get(i).getName())) {
                    throw new Exception("Semantic mapper target row column name(" + mapColumns.get(i).getName() + ") doesn't match to replica column name(" + targetColumn.getNameString() + ").");
                }
                if (targetColumn.getDataType().getJDBCTypeCode() == mapColumns.get(i).getSQLType()) continue;
                throw new Exception("Semantic mapper target row column '" + mapColumns.get(i).getName() + "' type(" + mapColumns.get(i).getTypeName() + ") doesn't match to replica column type(" + targetColumn.getDataType().getNameString() + ").");
            }
        }
    }

    public ReplicationData execute(Session session, ReplicationData replicationData) {
        if (!this.isEnabled()) {
            return replicationData;
        }
        if (this.stateHolder.isSuspectState()) {
            Trace.logError(this, "Replication modify trigger '" + this.name.name + "' is in suspect state.");
            throw new DataspaceException("Replication modify trigger '" + this.name.name + "' is in suspect state.");
        }
        if (this.mapperName != null) {
            if (this.mapper == null) {
                throw new DataspaceException("Mapper in replication modify trigger '" + this.name.name + "' is not initialized.");
            }
            Object[] oldData = null;
            Object[] newData = null;
            try {
                switch (replicationData.getOperationType()) {
                    case INSERT: {
                        newData = ((Row)this.mapper.convert(replicationData.getRow())).getRawData();
                        return new ReplicationData(ReplicationOperationType.INSERT, newData, replicationData.getGroupId());
                    }
                    case DELETE: {
                        oldData = ((Row)this.mapper.convert(replicationData.getRow())).getRawData();
                        return new ReplicationData(ReplicationOperationType.DELETE, oldData, replicationData.getGroupId());
                    }
                    case UPDATE: {
                        Object[] rows = replicationData.getRow();
                        oldData = ((Row)this.mapper.convert(rows[0])).getRawData();
                        newData = ((Row)this.mapper.convert(rows[1])).getRawData();
                        return new ReplicationData(ReplicationOperationType.UPDATE, oldData, newData, replicationData.getGroupId(), null);
                    }
                }
                return replicationData;
            }
            catch (Exception exception) {
                Trace.logError(this, "Replication modify trigger '" + this.name.name + "' execution failure.");
                Trace.logException(this, exception, true);
                this.stateHolder.setLastError(com.streamscape.sef.utils.Utils.formatExceptionWithUnrepeatedCauses(exception));
                throw new DataspaceException("Replication modify trigger '" + this.getObjectName().getStatementName() + "' execution failure.", exception);
            }
        }
        boolean exceptionLogged = false;
        NameManager.ObjectName currentDataspace = session.currentDataspace;
        try {
            session.sessionContext.rplObject = this;
            session.sessionContext.triggerDefinition = this.triggerDefinition;
            session.currentDataspace = this.name.schema;
            int variableCount = this.routine.getVariableCount();
            session.sessionContext.routineVariables = new Object[variableCount];
            session.sessionContext.triggerArguments = new Object[][]{null, null, null, null};
            Object[] oldData = null;
            Object[] newData = null;
            Object[] oldReplicaData = null;
            Object[] newReplicaData = null;
            switch (replicationData.getOperationType()) {
                case INSERT: {
                    newData = replicationData.getRow();
                    break;
                }
                case DELETE: {
                    oldData = replicationData.getRow();
                    break;
                }
                case UPDATE: {
                    Object[] rows = replicationData.getRow();
                    oldData = (Object[])rows[0];
                    newData = (Object[])rows[1];
                    break;
                }
                default: {
                    ReplicationData replicationData2 = replicationData;
                    return replicationData2;
                }
            }
            if (this.rangeVars[0] != null) {
                session.sessionContext.triggerArguments[0] = oldData;
                if (session.sessionContext.triggerArguments[0] == null) {
                    session.sessionContext.triggerArguments[0] = new Object[newData.length];
                }
            }
            if (this.rangeVars[1] != null) {
                session.sessionContext.triggerArguments[1] = newData;
                if (session.sessionContext.triggerArguments[1] == null) {
                    session.sessionContext.triggerArguments[1] = new Object[oldData.length];
                }
            }
            if (this.rangeVars[2] != null) {
                oldReplicaData = new Object[this.replicationTarget.getCollection().getBaseTable().getColumnCount()];
                session.sessionContext.triggerArguments[2] = oldReplicaData;
            } else {
                oldReplicaData = oldData;
            }
            if (this.rangeVars[3] != null) {
                newReplicaData = new Object[this.replicationTarget.getCollection().getBaseTable().getColumnCount()];
                session.sessionContext.triggerArguments[3] = newReplicaData;
            } else {
                newReplicaData = newData;
            }
            Result result = session.executeCompiledStatement(this.stat, new Object[0]);
            session.sessionContext.closeRoutineVariables();
            if (result.isError()) {
                if (result.getException() != null) {
                    Trace.logError(this, "Replication modify trigger '{}' execution failure. Cause: {}", this.name.name, com.streamscape.sef.utils.Utils.formatExceptionWithUnrepeatedCauses(result.getException()));
                    this.stateHolder.setLastError(com.streamscape.sef.utils.Utils.formatExceptionWithUnrepeatedCauses(result.getException()));
                    if (Trace.isDebugEnabled(this.getClass())) {
                        Trace.logException(this, result.getException(), true);
                    }
                    exceptionLogged = true;
                    throw new DataspaceException("Replication modify trigger '" + this.getObjectName().getStatementName() + "' execution failure.", result.getException());
                }
                Trace.logError(this, "Replication modify trigger '{}' execution failure.", this.name.name);
                this.stateHolder.setLastError("Replication modify trigger '" + this.getObjectName().getStatementName() + "' execution error.");
                exceptionLogged = true;
                throw new DataspaceException("Replication modify trigger '" + this.getObjectName().getStatementName() + "' execution error.");
            }
            this.stateHolder.setLastError("");
            ReplicationData replicationData3 = new ReplicationData(replicationData.getOperationType(), oldReplicaData, newReplicaData, replicationData.getGroupId(), replicationData.getPrimaryKey());
            return replicationData3;
        }
        catch (Throwable exception) {
            if (exceptionLogged) {
                throw exception;
            }
            Trace.logError(this, "Replication modify trigger '" + this.name.name + "' execution failure.");
            Trace.logException(this, exception, true);
            this.stateHolder.setLastError(com.streamscape.sef.utils.Utils.formatExceptionWithUnrepeatedCauses(exception));
            throw exception;
        }
        finally {
            session.sessionContext.rplObject = null;
            session.sessionContext.triggerDefinition = null;
            session.currentDataspace = currentDataspace;
        }
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE").append(' ');
        builder.append("REPLICATION").append(' ');
        builder.append("MODIFY").append(' ');
        builder.append("TRIGGER").append(' ');
        builder.append(this.name.getSchemaQualifiedStatementName()).append(' ');
        builder.append("ON").append(' ');
        builder.append("[").append(this.replicationTarget.getTargetEntityName().getFullNameNoDataspaceTypeNoNodeName()).append("]");
        builder.append(' ');
        if (this.mapperName != null) {
            builder.append("USING").append(' ').append("MAPPER").append(" '").append(this.mapperName).append("'");
        } else {
            builder.append("EVENT").append(' ');
            builder.append("SCOPE").append(' ');
            builder.append(this.triggerDefinition.getEventScope().name()).append(' ');
            if (this.rangeVars != null && this.rangeVars[0] != null) {
                builder.append("OLD").append(' ').append("SOURCE").append(' ').append("DATA");
                builder.append(' ').append("AS").append(' ');
                if (this.rangeVars[0].getTableAlias() != null) {
                    builder.append(this.rangeVars[0].getTableAlias().getNameString());
                } else {
                    builder.append(this.rangeVars[0].getColumn(0).getNameString());
                }
                builder.append(' ');
            }
            if (this.rangeVars != null && this.rangeVars[2] != null) {
                builder.append("OLD").append(' ').append("REPLICA").append(' ').append("DATA");
                builder.append(' ').append("AS").append(' ');
                if (this.rangeVars[2].getTableAlias() != null) {
                    builder.append(this.rangeVars[2].getTableAlias().getNameString());
                } else {
                    builder.append(this.rangeVars[2].getColumn(0).getNameString());
                }
                builder.append(' ');
            }
            if (this.rangeVars != null && this.rangeVars[1] != null) {
                builder.append("NEW").append(' ').append("SOURCE").append(' ').append("DATA");
                builder.append(' ').append("AS").append(' ');
                if (this.rangeVars[1].getTableAlias() != null) {
                    builder.append(this.rangeVars[1].getTableAlias().getNameString());
                } else {
                    builder.append(this.rangeVars[1].getColumn(0).getNameString());
                }
                builder.append(' ');
            }
            if (this.rangeVars != null && this.rangeVars[3] != null) {
                builder.append("NEW").append(' ').append("REPLICA").append(' ').append("DATA");
                builder.append(' ').append("AS").append(' ');
                if (this.rangeVars[3].getTableAlias() != null) {
                    builder.append(this.rangeVars[3].getTableAlias().getNameString());
                } else {
                    builder.append(this.rangeVars[3].getColumn(0).getNameString());
                }
                builder.append(' ');
            }
            if (this.routine != null && this.routine.statement != null) {
                builder.append(' ').append("AS").append(' ');
                builder.append(this.routine.statement.getSQL());
            } else {
                builder.append(' ').append("AS").append(' ');
                builder.append(this.rpl);
            }
        }
        if (this.isAutoEnable()) {
            builder.append(" ").append("ENABLE");
        }
        return builder.toString();
    }

    @Override
    public int getActionTimingIndex() {
        return 7;
    }

    @Override
    public String getActionTimingString() {
        return "ON";
    }

    public ReplicationTarget getReplicationTarget() {
        return this.replicationTarget;
    }

    @Override
    public String getOperationTypeString() {
        return this.mapperName != null ? "MAP" : "REPLICATION MODIFY";
    }

    @Override
    public EventFlowEntity getEntity() {
        return EventFlowEntity.DATASPACE_REPLICATION_MODIFY_TRIGGER;
    }

    @Override
    public void updateRangeVariables(Session session, ReplicationSourceInfo replicationSourceInfo) {
        this.updateSourceRangeVariables(session, replicationSourceInfo, 0);
        this.updateSourceRangeVariables(session, replicationSourceInfo, 1);
        this.updateReplicaRangeVariables(session, 2);
        this.updateReplicaRangeVariables(session, 3);
    }

    private void updateSourceRangeVariables(Session session, ReplicationSourceInfo replicationSourceInfo, int position) {
        if (this.rangeVars != null && this.rangeVars[position] != null) {
            ReplicationModifyTrigger.fillSourceRangeVariable(session, replicationSourceInfo, this.rangeVars[position].getTableAlias() != null ? this.rangeVars[position].getTableAlias() : this.rangeVars[position].getColumn(0).getObjectName(), position, this.rangeVars);
        }
    }

    private void updateReplicaRangeVariables(Session session, int position) {
        if (this.rangeVars != null && this.rangeVars[position] != null) {
            ReplicationModifyTrigger.fillReplicaRangeVariable(session, this.replicationTarget.getCollection(), this.rangeVars[position].getTableAlias() != null ? this.rangeVars[position].getTableAlias() : this.rangeVars[position].getColumn(0).getObjectName(), position, this.rangeVars);
        }
    }

    public String getMapperName() {
        return this.mapperName;
    }

    public List<String> getMapperNames() {
        if (this.mapperName == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(this.mapperName));
    }
}

