/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.parser.statement.StatementRplExec;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.replication.AbstractReplicationEntity;
import com.streamscape.ds.replication.ReplicationData;
import com.streamscape.ds.replication.ReplicationDataTransaction;
import com.streamscape.ds.replication.ReplicationSource;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.AbstractReplicationEventTrigger;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.utils.Utils;

public class ReplicationEventTrigger
extends AbstractReplicationEventTrigger {
    public static final int OPERATION = 3;
    public static final int EXCEPTION = 4;
    public static final String OP_FIELD_NAME = "operation";
    public static final String OP_TYPE_FIELD_NAME = "type";
    public static final int OP_TYPE_UNKNOWN = 0;
    public static final int OP_TYPE_INSERT = 1;
    public static final int OP_TYPE_DELETE = 2;
    public static final int OP_TYPE_UPDATE = 3;
    public static final int OP_TYPE_TRUNCATE = 4;
    protected Type type;
    protected AbstractReplicationEntity replicationEntity;

    public ReplicationEventTrigger(NameManager.ObjectName name, Type triggerType, AbstractReplicationEntity replicationEntity, RplScript routine, RangeVariable[] rangeVars, StatementRplExec stat, EventScope eventScope) {
        super(name, routine, rangeVars, stat, eventScope);
        this.type = triggerType;
        this.replicationEntity = replicationEntity;
        if (replicationEntity != null) {
            this.dataspace = replicationEntity.getDataspace();
        }
    }

    public void execute(Session session, ReplicationDataTransaction transaction, Throwable exception) {
        transaction.getData().forEach(data -> this.execute(session, (ReplicationData)data, exception));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Session session, ReplicationData replicationData, Throwable error) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.stateHolder.isSuspectState()) {
            Trace.logError(this, "Unable to execute system trigger " + this.name.name + ". Skipped.");
            return;
        }
        NameManager.ObjectName currentDataspace = session.currentDataspace;
        try {
            session.sessionContext.rplObject = this;
            session.sessionContext.triggerDefinition = this.triggerDefinition;
            session.currentDataspace = this.name.schema;
            int variableCount = this.routine.getVariableCount();
            session.sessionContext.routineVariables = new Object[variableCount];
            session.sessionContext.triggerArguments = new Object[][]{null, null, null, null, null};
            Object[] oldData = null;
            Object[] newData = null;
            int operationType = 0;
            switch (replicationData.getOperationType()) {
                case INSERT: {
                    newData = replicationData.getRow();
                    operationType = 1;
                    break;
                }
                case DELETE: {
                    oldData = replicationData.getRow();
                    operationType = 2;
                    break;
                }
                case UPDATE: {
                    Object[] rows = replicationData.getRow();
                    oldData = (Object[])rows[0];
                    newData = (Object[])rows[1];
                    operationType = 3;
                    break;
                }
                case TRUNCATE: {
                    operationType = 4;
                }
            }
            newData = this.fillDataColumns(newData, replicationData);
            oldData = this.fillDataColumns(oldData, replicationData);
            if (this.rangeVars[0] != null) {
                session.sessionContext.triggerArguments[0] = oldData;
            }
            if (this.rangeVars[1] != null) {
                session.sessionContext.triggerArguments[1] = newData;
            }
            if (this.rangeVars[3] != null) {
                session.sessionContext.triggerArguments[3] = new Object[]{operationType, 1, 2, 3, 4};
            }
            if (this.rangeVars[4] != null && error != null) {
                int state = 0;
                String severity = "";
                if (error instanceof IAbstractExceptionEvent) {
                    IAbstractExceptionEvent appEvent = (IAbstractExceptionEvent)error;
                    state = appEvent.getErrorCode();
                    severity = appEvent.getSeverity().name();
                }
                session.sessionContext.triggerArguments[4] = new Object[]{error.getMessage(), state, severity};
            }
            if (this.stat.getArguments().length > 0 && this.stat.getArguments()[0] != null) {
                this.stat.getArguments()[0].valueData = replicationData;
            }
            Result result = session.executeCompiledStatement(this.stat, new Object[0]);
            session.sessionContext.closeRoutineVariables();
            if (result.isError()) {
                this.replicationEntity.raiseReplicationException(new DataspaceException("Replication event trigger '" + this.name.name + "' execution failed.", result.getException() != null ? result.getException() : new DataspaceException(result)), true);
                Trace.logError(this, "Replication event trigger '" + this.name.name + "' execution failure.");
                if (result.getException() != null) {
                    this.stateHolder.setLastError(Utils.formatExceptionWithUnrepeatedCauses(result.getException()));
                    Trace.logException(this, result.getException(), true);
                } else {
                    this.stateHolder.setLastError("Trigger execution error.");
                }
            } else {
                this.stateHolder.setLastError("");
            }
        }
        catch (Throwable exception) {
            this.replicationEntity.raiseReplicationException(new DataspaceException("Replication event trigger '" + this.name.name + "' execution failed.", exception), true);
            Trace.logError(this, "Replication event trigger " + this.name.name + " execution failure.");
            Trace.logException(this, exception, true);
            this.stateHolder.setLastError(Utils.formatExceptionWithUnrepeatedCauses(exception));
        }
        finally {
            session.sessionContext.rplObject = null;
            session.sessionContext.triggerDefinition = null;
            session.currentDataspace = currentDataspace;
        }
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("CREATE").append(' ');
        builder.append("REPLICATION").append(' ');
        builder.append("TRIGGER").append(' ');
        builder.append(this.name.getSchemaQualifiedStatementName()).append(' ');
        builder.append("ON").append(' ');
        if (this.replicationEntity instanceof ReplicationSource) {
            builder.append("SOURCE").append(' ');
        } else {
            builder.append("REPLICA").append(' ');
        }
        builder.append(this.replicationEntity.getName());
        builder.append(' ');
        if (this.type == Type.ROLLBACK) {
            builder.append("ON").append(' ');
            builder.append(this.type.name());
            builder.append(' ');
        } else {
            builder.append("AFTER").append(' ');
            builder.append(this.type.name());
            builder.append(' ');
        }
        builder.append("EVENT").append(' ');
        builder.append("SCOPE").append(' ');
        builder.append(this.triggerDefinition.getEventScope().name()).append(' ');
        if (this.rangeVars != null && this.rangeVars[0] != null) {
            builder.append("OLD").append(' ').append("DATA");
            builder.append(' ').append("AS").append(' ');
            builder.append(this.rangeVars[0].getTableAlias().getNameString());
            builder.append(' ');
        }
        if (this.rangeVars != null && this.rangeVars[1] != null) {
            builder.append("NEW").append(' ').append("DATA");
            builder.append(' ').append("AS").append(' ');
            builder.append(this.rangeVars[1].getTableAlias().getNameString());
            builder.append(' ');
        }
        if (this.rangeVars != null && this.rangeVars[2] != null) {
            builder.append("REPLICA").append(' ').append("DATA");
            builder.append(' ').append("AS").append(' ');
            builder.append(this.rangeVars[2].getVariables().getKey(0));
            builder.append(' ');
        }
        if (this.rangeVars != null && this.rangeVars[4] != null) {
            builder.append("EXCEPTION").append(' ').append("AS").append(' ');
            builder.append(this.rangeVars[4].getTableAlias().getNameString());
            builder.append(' ');
        }
        if (this.routine != null && this.routine.statement != null) {
            builder.append(' ').append("AS").append(' ');
            builder.append(this.routine.statement.getSQL());
        } else {
            builder.append(' ').append("AS").append(' ');
            builder.append(this.rpl);
        }
        if (this.isAutoEnable()) {
            builder.append(" ").append("ENABLE");
        }
        return builder.toString();
    }

    @Override
    public int getActionTimingIndex() {
        return 7;
    }

    @Override
    public String getActionTimingString() {
        return "ON";
    }

    public AbstractReplicationEntity getReplicationEntity() {
        return this.replicationEntity;
    }

    public Type getReplicationTriggerType() {
        return this.type;
    }

    @Override
    public String getOperationTypeString() {
        return this.type.name();
    }

    @Override
    public EventFlowEntity getEntity() {
        return EventFlowEntity.DATASPACE_REPLICATION_TRIGGER;
    }

    public static enum Type {
        SUCCESS,
        FAIL,
        ROLLBACK;

    }
}

