/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.ParserCommand;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.statement.RejectException;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.RplSchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.trigger.RecompiledTrigger;
import com.streamscape.ds.trigger.Trigger;
import com.streamscape.ds.trigger.TriggerDefSQL;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.utils.EventPropertiesMapper;
import com.streamscape.ds.utils.SourceEventFlowData;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.SystemEvents;
import com.streamscape.sdo.mf.admin.PrototypeFactory;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerCompiledDefinition;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.service.osf.config.ActiveEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public class EventTriggerDefSQL
extends TriggerDefSQL
implements RplSchemaObject,
SourceEventFlowData,
RecompiledTrigger {
    public static final int EVENT_ID_COLUMN = 0;
    public static final int CORRELATION_ID_COLUMN = 1;
    public static final int EVENT_GROUP_ID_COLUMN = 2;
    public static final int EVENT_KEY_ID_COLUMN = 3;
    protected Collection collection = null;
    protected AbstractDataspace dataspace = null;
    protected EventTriggerCompiledDefinition triggerDefinition = null;
    protected DataspaceStateHolder stateHolder = new DataspaceStateHolder();
    protected String rpl = null;

    public EventTriggerDefSQL() {
    }

    public EventTriggerDefSQL(NameManager.ObjectName name, int when, int operation, boolean forEachRow, Collection collection, Table[] transitions, RangeVariable[] rangeVars, Expression whenClause, String conditionSQL, int[] updateColumns, RplScript routine, EventScope eventScope) {
        super(name, when, operation, forEachRow, collection == null ? null : collection.getBaseTable(), transitions, rangeVars, whenClause, conditionSQL, updateColumns, routine);
        this.enabled = false;
        this.collection = collection;
        if (this.table != null) {
            this.dataspace = (AbstractDataspace)this.table.database.schemaManager.findSchema(name.schema.name);
            if (this.dataspace == null) {
                throw new DataspaceException("Unable to complete event trigger initialization. Can not get reference to the parent dataspace.");
            }
        }
        try {
            EventTriggerDefinition definition = new EventTriggerDefinition();
            definition.setName(name.name);
            definition.setEventScope(eventScope);
            String actionableEventId = collection.getTriggerEventId(when, operation);
            if (actionableEventId != null) {
                definition.setActionableEventId(actionableEventId);
            }
            this.triggerDefinition = new EventTriggerCompiledDefinition(definition);
            if (routine != null && routine.eventIds != null && routine.eventIds.size() > 0) {
                this.triggerDefinition.setRaisedEventIds(routine.eventIds);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            this.stateHolder.setSuspectState(DataspaceStateHolder.syntax, exception, "Try to alter trigger.");
            return;
        }
        try {
            this.dataspace.bindProducerForSystem("advisory.exec.EventTrigger");
        }
        catch (FabricEventDispatcherException error) {
            Trace.logException(EventTriggerDefSQL.class, error, false);
            this.stateHolder.setSuspectState(DataspaceStateHolder.syntax, error, "Try to alter trigger.");
        }
    }

    public Collection getCollection() {
        return this.collection;
    }

    public EventTriggerDefinition getTriggerDefinition() {
        return this.triggerDefinition;
    }

    @Override
    public void validateActionableEventPrototype() {
        if (this.collection != null) {
            String triggerEventPrototype = this.collection.getTriggerEventId(this.actionTiming, this.operationType);
            try {
                if (!SystemEvents.isSystem(triggerEventPrototype) && !SystemEvents.isPredefined(triggerEventPrototype)) {
                    PrototypeFactory.removeEventPrototype(triggerEventPrototype);
                    this.collection.getTriggerEventId(this.actionTiming, this.operationType);
                }
            }
            catch (Exception error) {
                this.logError(null, "Unable to update event prototype " + StringUtils.wrapEventId(triggerEventPrototype) + " for " + this.collection.getObjectName().name + " collection. " + error.getMessage());
            }
        }
    }

    @Override
    public void enable(Session session) {
        this.shouldBeEnabled = true;
        if (this.stateHolder.isSuspectState()) {
            this.recompileTriggerInternal(session);
            if (this.stateHolder.isSuspectState()) {
                return;
            }
        } else if (this.enabled) {
            return;
        }
        this.enableInternal(session);
    }

    protected void enableInternal(Session session) {
        if (this.routine != null) {
            this.routine.open(session, this);
        }
        this.enabled = true;
        this.triggerDefinition.setAutoEnable(true);
    }

    @Override
    public void disable() {
        this.shouldBeEnabled = false;
        this.triggerDefinition.setAutoEnable(false);
        if (!this.enabled) {
            return;
        }
        this.disableInternal();
    }

    protected void disableInternal() {
        this.enabled = false;
        if (this.routine != null) {
            this.routine.close(this);
        }
    }

    @Override
    public void recompileTrigger(Session session) {
        boolean isInvalidOriginally = this.stateHolder.isSuspectState();
        if (isInvalidOriginally) {
            this.disableInternal();
        }
        this.recompileTriggerInternal(session);
        if (this.stateHolder.isSuspectState()) {
            this.disableInternal();
        } else if (isInvalidOriginally && this.shouldBeEnabled) {
            this.disableInternal();
            this.enableInternal(session);
        } else if (this.isAutoEnable && !session.isProcessingLog() && !session.isProcessingRecoveryLog()) {
            this.disableInternal();
            this.enableInternal(session);
        }
    }

    protected boolean recompileTriggerInternal(Session session) {
        try {
            RplScript newRoutine = (RplScript)RoutineSchema.executeInDataspace(session, this.getObjectName().schema, s -> {
                String triggerEventPrototype = this.collection != null ? this.collection.getTriggerEventId(this.actionTiming, this.operationType) : null;
                String routineSql = this.rpl;
                ParserCommand parser = new ParserCommand(session, new Scanner(routineSql));
                if (parser.token.tokenType == 849) {
                    parser.read();
                }
                RplScript result = null;
                if (this.collection != null) {
                    session.sessionContext.triggerEventId = triggerEventPrototype;
                    result = parser.compileTriggerRoutine(this.name, this.collection.getBaseTable(), this.rangeVars, true);
                    session.sessionContext.triggerEventId = null;
                } else {
                    result = parser.compileRplRoutine(this.name, this.rangeVars);
                }
                return result;
            });
            if (newRoutine != null) {
                if (this.routine != null) {
                    this.routine.close();
                }
                if (newRoutine != null) {
                    newRoutine.resolveReferences(session);
                }
                this.routine = newRoutine;
                session.dataspaceStore.schemaManager.replaceReferences(this, this);
                this.stateHolder = new DataspaceStateHolder();
            }
            this.resetState();
        }
        catch (Exception error) {
            this.logError(session, "Unable to recompile object. " + Utils.formatExceptionWithUnrepeatedCauses(error));
            this.stateHolder.setSuspectState(DataspaceStateHolder.syntax, error, "Try to alter or check the trigger.");
            return false;
        }
        return true;
    }

    public EventTriggerState getTriggerState() {
        if (this.stateHolder.isSuspectState()) {
            return EventTriggerState.INVALID;
        }
        if (this.enabled) {
            return EventTriggerState.ENABLED;
        }
        return EventTriggerState.DISABLED;
    }

    public void destroy() {
        this.disable();
    }

    @Override
    protected Result executeTriggerLogic(Session session, Object[] oldData, Object[] newData) {
        if (this.stateHolder.isSuspectState()) {
            return Result.newErrorResult(new IllegalStateException("Event trigger is invalid. Execution failed."));
        }
        ImmutableEventDatagram currentRplEvent = session.sessionContext.rplBlockCurrentEvent;
        ImmutableEventDatagram currentTriggerEvent = session.sessionContext.currentCollectionEventForTrigger;
        RplSchemaObject rplObject = session.sessionContext.rplObject;
        Object[] rplArgs = session.sessionContext.rplArguments;
        try {
            if (session.sessionContext.currentCollectionEventForTrigger == null && this.triggerType != Trigger.Type.TRUNCATE) {
                session.sessionContext.currentCollectionEventForTrigger = this.collection.getEventForTrigger(session, oldData, newData, this.actionTiming, this.operationType);
            }
            session.sessionContext.rplBlockCurrentEvent = session.sessionContext.currentCollectionEventForTrigger;
            if (this.rangeVars[4] != null) {
                session.sessionContext.rplArguments = new Object[]{new OtherTypeWrapper(session.sessionContext.currentCollectionEventForTrigger)};
            }
            if (this.condition != null && !this.condition.testCondition(session)) {
                Result result = Result.updateZeroResult;
                return result;
            }
            session.sessionContext.rplObject = this;
            session.sessionContext.triggerDefinition = this.triggerDefinition;
            Result result = super.executeTriggerLogic(session, oldData, newData);
            if (result.isError() && result.getException() != null && !(result.getException() instanceof RejectException)) {
                this.stateHolder.setLastError(result.getException().getMessage());
            } else if (!result.isError()) {
                this.stateHolder.setLastError("");
            }
            Result result2 = result;
            return result2;
        }
        catch (Throwable error) {
            Trace.logException(this, error, true);
            this.stateHolder.setLastError(error.getMessage());
            throw new DataspaceException(error);
        }
        finally {
            session.sessionContext.triggerDefinition = null;
            session.sessionContext.currentCollectionEventForTrigger = currentTriggerEvent;
            session.sessionContext.rplBlockCurrentEvent = currentRplEvent;
            session.sessionContext.rplObject = rplObject;
            session.sessionContext.rplArguments = rplArgs;
        }
    }

    public static Object[] extractEventPropertiesForEventTrigger(Session session, EventDatagram datagram) {
        EventPropertiesMapper mapper = new EventPropertiesMapper(datagram.getEventId(), null, null, null);
        mapper.compile(null);
        Object[] eventProperties = new Object[mapper.getColumnsCount()];
        int index = -1;
        try {
            mapper.setColumnValues(session, datagram, eventProperties, index, null);
        }
        catch (SQLException error) {
            throw new DataspaceException(error);
        }
        return eventProperties;
    }

    @Override
    public String getSQLInSchema(String schemaName) {
        return this.getSQLInternal(schemaName);
    }

    @Override
    public String getSQL() {
        return this.getSQLInternal(this.name.schema.getStatementName());
    }

    public String getSQLInternal(String schemaName) {
        StringBuffer sb = new StringBuffer(256);
        sb.append("CREATE").append(' ');
        sb.append("EVENT").append(' ');
        sb.append("TRIGGER").append(' ');
        sb.append(this.name.getSchemaQualifiedStatementName(schemaName)).append(' ');
        sb.append("ON").append(' ');
        sb.append(this.collection.getObjectName().getSchemaQualifiedStatementName(schemaName));
        sb.append(' ');
        sb.append("EVENT").append(' ');
        sb.append("SCOPE").append(' ');
        sb.append(this.triggerDefinition.getEventScope().name()).append(' ');
        sb.append(this.getActionTimingString()).append(' ');
        sb.append(this.getOperationTypeString()).append(' ');
        if (this.updateColumns != null && this.table != null) {
            sb.append("OF").append(' ');
            for (int i = 0; i < this.updateColumns.length; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                NameManager.ObjectName name = this.table.getColumn(this.updateColumns[i]).getObjectName();
                sb.append(name.statementName);
            }
            sb.append(' ');
        }
        if (!this.forEachRow) {
            sb.append("FOR").append(' ');
            sb.append("EACH").append(' ');
            sb.append("STATEMENT").append(' ');
        }
        if (this.hasTransitionRanges || this.hasTransitionTables || this.hasActionableEventRange) {
            if (this.rangeVars[0] != null) {
                sb.append("OLD").append(' ').append("DATA");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.rangeVars[0].getTableAlias().getStatementName());
                sb.append(' ');
            }
            if (this.rangeVars[1] != null) {
                sb.append("NEW").append(' ').append("DATA");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.rangeVars[1].getTableAlias().getStatementName());
                sb.append(' ');
            }
            if (this.transitions[2] != null) {
                sb.append("OLD").append(' ').append("COLLECTION");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.transitions[2].getObjectName().statementName);
                sb.append(' ');
            }
            if (this.transitions[3] != null) {
                sb.append("NEW").append(' ').append("COLLECTION");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.transitions[3].getObjectName().statementName);
                sb.append(' ');
            }
            if (this.rangeVars[4] != null) {
                sb.append("ACTIONABLE").append(' ').append("EVENT");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.rangeVars[4].getColumnAlias(0).getStatementName());
                sb.append(' ');
            }
        }
        if (this.condition != Expression.EXPR_TRUE) {
            sb.append("WHEN").append(' ');
            sb.append("(").append(this.conditionSQL);
            sb.append(")").append(' ');
        }
        if (!this.getTriggerOrderString().equals("0")) {
            sb.append("ORDER").append(' ').append(this.getTriggerOrderString()).append(' ');
        }
        if (this.routine != null && this.routine.statement != null) {
            sb.append(' ').append("AS").append(' ');
            sb.append(this.routine.statement.getSQL());
        } else {
            sb.append(' ').append("AS").append(' ');
            sb.append(this.rpl);
        }
        if (this.isAutoEnable() || this.shouldBeEnabled) {
            sb.append(" ").append("ENABLE");
        }
        return sb.toString();
    }

    @Override
    public String getPrettyPrintedSQL() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("CREATE").append(' ');
        sb.append("EVENT").append(' ');
        sb.append("TRIGGER").append(' ');
        sb.append(this.name.getSchemaQualifiedStatementName()).append(' ');
        sb.append("ON").append(' ');
        sb.append(this.collection.getObjectName().getSchemaQualifiedStatementName());
        sb.append(' ');
        sb.append("EVENT").append(' ');
        sb.append("SCOPE").append(' ');
        sb.append(this.triggerDefinition.getEventScope().name()).append(' ');
        sb.append(this.getActionTimingString()).append(' ');
        sb.append(this.getOperationTypeString()).append(' ');
        if (this.updateColumns != null && this.table != null) {
            sb.append("OF").append(' ');
            for (int i = 0; i < this.updateColumns.length; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                NameManager.ObjectName name = this.table.getColumn(this.updateColumns[i]).getObjectName();
                sb.append(name.statementName);
            }
            sb.append(' ');
        }
        sb.append("\n");
        if (!this.forEachRow) {
            sb.append("\t");
            sb.append("FOR").append(' ');
            sb.append("EACH").append(' ');
            sb.append("STATEMENT").append(' ');
            sb.append("\n");
        }
        if (this.hasTransitionRanges || this.hasTransitionTables || this.hasActionableEventRange) {
            sb.append("\t");
            if (this.rangeVars[0] != null) {
                sb.append("OLD").append(' ').append("DATA");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.rangeVars[0].getTableAlias().getStatementName());
                sb.append(' ');
            }
            if (this.rangeVars[1] != null) {
                sb.append("NEW").append(' ').append("DATA");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.rangeVars[1].getTableAlias().getStatementName());
                sb.append(' ');
            }
            if (this.transitions[2] != null) {
                sb.append("OLD").append(' ').append("COLLECTION");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.transitions[2].getObjectName().statementName);
                sb.append(' ');
            }
            if (this.transitions[3] != null) {
                sb.append("OLD").append(' ').append("COLLECTION");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.transitions[3].getObjectName().statementName);
                sb.append(' ');
            }
            if (this.rangeVars[4] != null) {
                sb.append("ACTIONABLE").append(' ').append("EVENT");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.rangeVars[4].getColumnAlias(0).getStatementName());
                sb.append(' ');
            }
            sb.append("\n");
        }
        if (this.condition != Expression.EXPR_TRUE) {
            sb.append("\t");
            sb.append("WHEN").append(' ');
            sb.append("(").append(this.conditionSQL);
            sb.append(")").append(' ');
            sb.append("\n");
        }
        if (!this.getTriggerOrderString().equals("0")) {
            sb.append("\t").append("ORDER").append(' ').append(this.getTriggerOrderString()).append('\n');
        }
        if (this.routine != null && this.routine.statement != null) {
            sb.append('\n').append("AS").append('\n');
            sb.append(this.routine.statement.getSQL());
        } else {
            sb.append('\n').append("AS").append('\n');
            sb.append(this.rpl);
        }
        if (this.isAutoEnable() || this.shouldBeEnabled) {
            sb.append(" ").append("ENABLE");
        }
        return sb.toString();
    }

    public List<ActiveEvent> getEvents() {
        return this.routine.getEvents(this.getObjectName().name, this.dataspace.getEventScope());
    }

    @Override
    public void invalidate(String lastError) {
        this.stateHolder.setSuspectState(DataspaceStateHolder.invalid, lastError);
    }

    @Override
    public DataspaceStateHolder getStateHolder() {
        return this.stateHolder;
    }

    @Override
    public DataspaceStateHolder aggregateStateHolder() {
        DataspaceStateHolder state = (DataspaceStateHolder)this.getStateHolder().clone();
        if (this.dataspace != null) {
            DataspaceStateHolder.aggregateState(state, this.getReferences(), this.dataspace.getStore().schemaManager);
        } else {
            state.setRecoveryFailedState();
        }
        return state;
    }

    @Override
    public String getStateName(DataspaceStoreState state) {
        if (state == DataspaceStoreState.SUSPECT) {
            return state.toString();
        }
        if (this.isEnabled()) {
            return "ENABLED";
        }
        return "DISABLED";
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = super.getReferences();
        if (this.collection != null) {
            set.add(this.collection.getObjectName());
        }
        return set;
    }

    public void resetState() {
        this.stateHolder = new DataspaceStateHolder();
    }

    public void setRpl(String rpl) {
        this.rpl = rpl;
    }

    @Override
    public EventFlowEntity getEntity() {
        return EventFlowEntity.DATASPACE_EVENT_TRIGGER;
    }

    @Override
    public String getEntityName() {
        return this.triggerDefinition.getName();
    }

    @Override
    public EventScope getEntityScope() {
        return this.triggerDefinition.getEventScope();
    }

    @Override
    public HashMap<String, String> getEntityParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("collection", this.collection.getCollectionName());
        return result;
    }
}

