/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.trigger;

import com.streamscape.Trace;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.parser.ParserCommand;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.statement.StatementRplExec;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.replication.ReplicationData;
import com.streamscape.ds.replication.ReplicationSourceInfo;
import com.streamscape.ds.replication.SimpleColumnDescriptor;
import com.streamscape.ds.schema.RplSchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.trigger.EventTriggerDefSQL;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SourceEventFlowData;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerCompiledDefinition;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;

public abstract class AbstractReplicationEventTrigger
extends EventTriggerDefSQL
implements RplSchemaObject,
SourceEventFlowData {
    protected StatementRplExec stat = null;
    protected Expression[] arguments = null;
    private long triggerRecompileTime = -1L;
    private long triggerCreationTime = -1L;

    public AbstractReplicationEventTrigger(NameManager.ObjectName name, RplScript routine, RangeVariable[] rangeVars, StatementRplExec stat, EventScope eventScope) {
        this.name = name;
        this.routine = routine;
        this.stat = stat;
        this.rangeVars = rangeVars;
        this.enabled = false;
        this.triggerCreationTime = System.currentTimeMillis();
        try {
            EventTriggerDefinition definition = new EventTriggerDefinition();
            definition.setName(name.name);
            definition.setEventScope(eventScope != null ? eventScope : EventScope.INHERITED);
            this.triggerDefinition = new EventTriggerCompiledDefinition(definition);
            if (routine != null && routine.eventIds != null && routine.eventIds.size() > 0) {
                this.triggerDefinition.setRaisedEventIds(routine.eventIds);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            this.stateHolder.setSuspectState(DataspaceStateHolder.syntax, exception, "Try to alter the trigger.");
        }
    }

    @Override
    protected boolean recompileTriggerInternal(Session session) {
        try {
            this.triggerRecompileTime = System.currentTimeMillis();
            RplScript newRoutine = (RplScript)RoutineSchema.executeInDataspace(session, this.getObjectName().schema, s -> {
                String routineSql = this.rpl;
                if (this.routine != null && this.routine.statement != null) {
                    routineSql = this.routine.statement.getSQL();
                }
                ParserCommand parser = new ParserCommand(session, new Scanner(routineSql));
                if (parser.token.tokenType == 849) {
                    parser.read();
                }
                return parser.compileRplRoutine(this.name, this.rangeVars);
            });
            if (newRoutine != null) {
                if (this.routine != null) {
                    this.routine.close();
                }
                newRoutine.resolveReferences(session);
                this.routine = newRoutine;
                if (this.stat != null) {
                    this.stat.procedure = this.routine;
                }
                session.dataspaceStore.schemaManager.replaceReferences(this, this);
                this.stateHolder = new DataspaceStateHolder();
            }
            this.resetState();
        }
        catch (Exception error) {
            this.logError(session, "Unable to recompile object. " + Utils.formatExceptionWithUnrepeatedCauses(error));
            this.stateHolder.setSuspectState(DataspaceStateHolder.syntax, error, "Try to alter the trigger.");
            return false;
        }
        return true;
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public StatementRplExec getRoutineStatement() {
        return this.stat;
    }

    public void setArguments(Expression[] arguments) {
        this.arguments = arguments;
    }

    protected Object[] fillDataColumns(Object[] data, ReplicationData replicationData) {
        int columnsCount;
        int n = this.rangeVars[0] != null ? this.rangeVars[0].getVariables().size() : (columnsCount = this.rangeVars[1] != null ? this.rangeVars[1].getVariables().size() : -1);
        if (replicationData.getPrimaryKey() != null && replicationData.getPrimaryKey().size() > 0 && columnsCount != -1 && data != null && data.length != columnsCount) {
            Object[] newData = new Object[columnsCount];
            for (int i = 0; i < replicationData.getPrimaryKey().size(); ++i) {
                newData[replicationData.getPrimaryKey().get((int)i).intValue()] = data[i];
            }
            data = newData;
        }
        return data;
    }

    public void updateRangeVariables(Session session, ReplicationSourceInfo replicationSourceInfo) {
    }

    public static void fillSourceRangeVariable(Session session, ReplicationSourceInfo replicationSourceInfo, NameManager.SimpleName rowName, int position, RangeVariable[] rangeVars) {
        if (replicationSourceInfo != null) {
            HashMappedList sourceCollectionColumnList = new HashMappedList();
            for (SimpleColumnDescriptor descriptor : replicationSourceInfo.getColumnList()) {
                NameManager.ObjectName columnName = session.dataspaceStore.nameManager.newObjectName(descriptor.getColumnName(), false, 10);
                ColumnSchema columnSchema = new ColumnSchema(columnName, Type.getDefaultType(descriptor.getJdbcType(), descriptor.getJdbcPrecision(), descriptor.getJdbcScale()), true, false, null);
                sourceCollectionColumnList.put(descriptor.getColumnName(), columnSchema);
            }
            RangeVariable range = new RangeVariable(sourceCollectionColumnList, rowName, false, 2);
            range.rangePosition = position;
            rangeVars[position] = range;
        } else {
            ColumnSchema repDataVariable = new ColumnSchema(session.dataspaceStore.nameManager.newObjectName(rowName.name, rowName.isNameQuoted, 10), new OtherType("object", Object.class), true, false, null);
            repDataVariable.setParameterMode((byte)1);
            HashMappedList aliases = new HashMappedList();
            aliases.add(rowName.name, repDataVariable);
            rangeVars[position] = new RangeVariable(aliases, null, false, 3);
        }
    }

    public static void fillReplicaRangeVariable(Session session, Collection replicationCollection, NameManager.SimpleName rowName, int position, RangeVariable[] rangeVars) {
        if (replicationCollection != null) {
            HashMappedList targetCollectionColumnList = replicationCollection.getBaseTable().columnList;
            RangeVariable range = new RangeVariable(targetCollectionColumnList, rowName, false, 2);
            range.rangePosition = position;
            rangeVars[position] = range;
        } else {
            ColumnSchema repDataVariable = new ColumnSchema(session.dataspaceStore.nameManager.newObjectName(rowName.name, rowName.isNameQuoted, 10), new OtherType("object", Object.class), true, false, null);
            repDataVariable.setParameterMode((byte)1);
            HashMappedList aliases = new HashMappedList();
            aliases.add(rowName.name, repDataVariable);
            rangeVars[position] = new RangeVariable(aliases, null, false, 3);
        }
    }

    public long getTriggerRecompileTime() {
        return this.triggerRecompileTime;
    }

    public boolean needsRecompile() {
        return this.triggerRecompileTime < this.triggerCreationTime;
    }
}

