/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.transaction;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.CountUpDownLatch;
import com.streamscape.ds.lib.HashMap;
import com.streamscape.ds.lib.HsqlDeque;
import com.streamscape.ds.lib.IntKeyHashMapConcurrent;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.LongDeque;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.expression.ReadTakeExpression;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementCommand;
import com.streamscape.ds.parser.statement.StatementDfetch;
import com.streamscape.ds.parser.statement.StatementExpression;
import com.streamscape.ds.parser.statement.StatementSchema;
import com.streamscape.ds.persist.CachedObject;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.RowStoreAVLDisk;
import com.streamscape.ds.persist.RowStoreAVLMemory;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.row.RowAction;
import com.streamscape.ds.persist.row.RowActionBase;
import com.streamscape.ds.replication.ReplicationEntityName;
import com.streamscape.ds.replication.ReplicationSource;
import com.streamscape.ds.replication.ReplicationTarget;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.transaction.TransactionManager;
import com.streamscape.ds.transaction.TransactionManagerCommon;
import com.streamscape.ds.trigger.Trigger;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.lib.utils.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class TransactionManagerMVCC
extends TransactionManagerCommon
implements TransactionManager {
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionTimestamps = new LongDeque();
    boolean isLockedMode;
    public Session catalogWriteSession;
    long lockTxTs;
    long lockSessionId;
    long unlockTxTs;
    long unlockSessionId;
    int redoCount = 0;
    HashMap lockedForMaterialization = new HashMap();
    private final CountUpDownLatch checkpointLatch = new CountUpDownLatch();

    public TransactionManagerMVCC(DataspaceStore db) {
        super(db);
        this.rowActionMap = new IntKeyHashMapConcurrent(10000);
        this.txModel = 2;
    }

    @Override
    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    @Override
    public boolean isMVRows() {
        return true;
    }

    @Override
    public boolean isMVCC() {
        return true;
    }

    @Override
    public int getTransactionControl() {
        return 2;
    }

    @Override
    public void setTransactionControl(Session session, int mode) {
        super.setTransactionControl(session, mode);
    }

    @Override
    public void completeActions(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareCommitActions(Session session) {
        Object[] list = session.rowActionList.getArray();
        int limit = session.rowActionList.size();
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            int i;
            for (i = 0; i < limit; ++i) {
                RowAction rowact = (RowAction)list[i];
                if (rowact.canCommit(session, session.tempSet)) continue;
                boolean bl = false;
                return bl;
            }
            session.actionTimestamp = this.nextChangeTimestamp();
            for (i = 0; i < limit; ++i) {
                RowAction action = (RowAction)list[i];
                action.prepareCommit(session);
            }
            for (i = 0; i < session.tempSet.size(); ++i) {
                Session current = ((RowActionBase)session.tempSet.get((int)i)).session;
                current.abortTransaction = true;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
            session.tempSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        if (this.checkIfAfterCommitTriggersOrReplicationPresent(session)) {
            return this.commitTransactionWith2PC(session);
        }
        int limit = session.rowActionList.size();
        Object[] list = session.rowActionList.getArray();
        this.writeLock.lock();
        try {
            int i;
            for (i = 0; i < limit; ++i) {
                RowAction rowact = (RowAction)list[i];
                if (rowact.canCommit(session, session.tempSet)) continue;
                boolean bl = false;
                return bl;
            }
            session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            this.endTransaction(session);
            for (i = 0; i < limit; ++i) {
                RowAction action = (RowAction)list[i];
                action.commit(session);
            }
            for (i = 0; i < session.tempSet.size(); ++i) {
                Session current = ((RowActionBase)session.tempSet.get((int)i)).session;
                current.abortTransaction = true;
            }
            this.adjustLobUsage(session, 0, limit, false);
            this.persistCommit(session, 0, session.rowActionList.size(), false);
            int newLimit = session.rowActionList.size();
            if (newLimit > limit) {
                list = session.rowActionList.getArray();
                this.mergeTransaction(session, list, limit, newLimit, session.actionTimestamp);
                this.finaliseRows(session, list, limit, newLimit, true);
                session.rowActionList.setSize(limit);
            }
            if (this.isLobSession(session) || this.getFirstLiveTransactionTimestamp() > session.actionTimestamp) {
                this.mergeTransaction(session, list, 0, limit, session.actionTimestamp);
                this.finaliseRows(session, list, 0, limit, true);
            } else if (session.rowActionList.size() > 0) {
                list = session.rowActionList.toArray();
                this.addToCommittedQueue(session, list);
            }
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
            this.enqueueCheckpoint(session);
        }
        finally {
            this.writeLock.unlock();
            session.tempSet.clear();
        }
        return true;
    }

    private void checkForCheckpoint(int statementType) {
        if (statementType == 1002) {
            this.checkpointLatch.setCount(0);
            return;
        }
        if (this.checkpointLatch.getCount() > 0) {
            Trace.logDebug(this, "Checkpoint latch > 0: {}", this.checkpointLatch.getCount());
            this.writeLock.unlock();
            try {
                if (!this.checkpointLatch.await(100L)) {
                    this.checkpointLatch.setCount(0);
                    Trace.logError(this, "WARNING: checkpoint latch is still 1, set it to 0.");
                }
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
            this.writeLock.lock();
        }
    }

    private void enqueueCheckpoint(Session session) {
        if (this.database.checkpointManager == null || !this.database.checkpointManager.isCheckpointManagedByMVCC()) {
            return;
        }
        if (session.sessionContext != null && session.sessionContext.currentStatement != null && session.sessionContext.currentStatement.type == 1002) {
            return;
        }
        OrderedHashSet set = new OrderedHashSet();
        this.getTransactionSessions(set);
        set.remove(session);
        this.getReplicationLockedSession(set);
        if (session.replicationLockObjectName == null) {
            set.remove(session);
        }
        this.removeDfetchSessionsFromList(set);
        if (set.size() == 0 && this.database.checkpointManager.enqueueCheckpointMVCC()) {
            this.checkpointLatch.setCount(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commitTransactionWith2PCPrepare(Session session, int start, int limit) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            int i;
            for (i = start; i < limit; ++i) {
                RowAction rowact = (RowAction)session.rowActionList.get(i);
                if (rowact.canCommit(session, session.tempSet)) continue;
                boolean bl = false;
                return bl;
            }
            if (start == 0) {
                session.actionTimestamp = this.nextChangeTimestamp();
            }
            for (i = start; i < limit; ++i) {
                RowAction action = (RowAction)session.rowActionList.get(i);
                action.prepareCommit(session);
            }
            for (i = 0; i < session.tempSet.size(); ++i) {
                Session current = ((RowActionBase)session.tempSet.get((int)i)).session;
                current.abortTransaction = true;
            }
            limit = this.adjustLobUsage(session, start, limit, true);
            this.commitTransactionWith2PCWriteRecoveryLog(session, start, limit);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
            session.tempSet.clear();
        }
    }

    private void commitTransactionWith2PCWriteRecoveryLog(Session session, int start, int limit) {
        boolean allRowsInMemory = true;
        for (int i = start; i < limit; ++i) {
            RowAction action = (RowAction)session.rowActionList.get(i);
            if (action.type == 0) continue;
            int type = action.getCommitTypeOn(session.actionTimestamp);
            Row row = action.memoryRow;
            if (row == null) {
                row = (Row)action.store.get(action.getPos(), false);
            }
            if (row.getTable().getTableType() != 4) {
                allRowsInMemory = false;
            }
            try {
                action.store.commitRowWith2PCLogOnly(session, row, type, this.txModel);
                continue;
            }
            catch (DataspaceException e) {
                this.database.dataspaceLogger.logWarningEvent("data commit failed", e);
            }
        }
        if (!allRowsInMemory) {
            this.database.dataspaceLogger.writePrepareCommitStatement(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commitTransactionWith2PCFinalCommit(Session session, List<Pair<Table, List<Object[]>>> insertedRows) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            int i;
            session.transactionEndTimestamp = session.actionTimestamp;
            this.endTransaction(session);
            for (i = 0; i < session.rowActionList.size(); ++i) {
                RowAction action = (RowAction)session.rowActionList.get(i);
                action.commit(session);
            }
            for (i = 0; i < session.tempSet.size(); ++i) {
                Session current = ((RowActionBase)session.tempSet.get((int)i)).session;
                current.abortTransaction = true;
            }
            this.commitTransactionWith2PCFinalCommitPersist(session, insertedRows);
            if (this.isLobSession(session) || this.getFirstLiveTransactionTimestamp() > session.actionTimestamp) {
                this.mergeTransaction(session, session.rowActionList.getArray(), 0, session.rowActionList.size(), session.actionTimestamp);
                this.finaliseRows(session, session.rowActionList.getArray(), 0, session.rowActionList.size(), true);
            } else if (session.rowActionList.size() > 0) {
                this.addToCommittedQueue(session, session.rowActionList.toArray());
            }
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
            this.enqueueCheckpoint(session);
        }
        finally {
            this.writeLock.unlock();
            session.tempSet.clear();
        }
        return true;
    }

    private boolean commitTransactionWith2PCFinalCommitPersist(Session session, List<Pair<Table, List<Object[]>>> insertedRows) {
        boolean allRowsInMemory = true;
        for (int i = 0; i < session.rowActionList.size(); ++i) {
            RowAction action = (RowAction)session.rowActionList.get(i);
            if (action.type == 0) continue;
            int type = action.getCommitTypeOn(session.actionTimestamp);
            Row row = action.memoryRow;
            if (row == null) {
                row = (Row)action.store.get(action.getPos(), false);
            }
            if (row.getTable().getTableType() != 4) {
                allRowsInMemory = false;
            }
            try {
                action.store.commitRowWith2PCNoLog(session, row, type, this.txModel);
            }
            catch (DataspaceException e) {
                this.database.dataspaceLogger.logWarningEvent("data commit failed", e);
            }
            if (type != 1 || row.getTable() == null || !(row.getTable() instanceof Table)) continue;
            Table table = (Table)row.getTable();
            Pair<Table, List<Object>> pair = null;
            for (Pair<Table, List<Object[]>> p : insertedRows) {
                pair = p.first == table ? p : null;
                if (pair == null) continue;
                break;
            }
            if (pair == null) {
                pair = new Pair(table, new ArrayList());
                insertedRows.add(pair);
            }
            ((List)pair.second).add(row.getData());
        }
        try {
            session.logSequences();
            if (!allRowsInMemory) {
                this.database.dataspaceLogger.writeCommitStatement(session);
            }
        }
        catch (DataspaceException e) {
            this.database.dataspaceLogger.logWarningEvent("data commit failed", e);
        }
        return true;
    }

    private boolean fireAfterCommitTriggers(Session session, int start, int limit) {
        session.sessionContext.onCommitFireTriggersException = null;
        try {
            LinkedHashMap tables = new LinkedHashMap();
            BiConsumer<Table, Trigger.Type> addTableForTrigger = (table, triggerType) -> {
                Pair pair = (Pair)tables.get(table.getObjectName());
                if (pair == null) {
                    pair = new Pair((Table)table, new HashSet());
                    tables.put(table.getObjectName(), pair);
                    pair.second = EnumSet.noneOf(Trigger.Type.class);
                }
                ((Set)pair.second).add(triggerType);
            };
            ArrayList deleteForUpdateActionsList = new ArrayList();
            ArrayList insertForUpdateActionsList = new ArrayList();
            ArrayList<RowAction> processedActions = new ArrayList<RowAction>();
            block7: for (int i = start; i < limit; ++i) {
                RowAction action = (RowAction)session.rowActionList.get(i);
                if (action.type == 0 || processedActions.contains(action)) continue;
                processedActions.add(action);
                int type = action.getCommitTypeOn(session.actionTimestamp);
                RowActionBase commitActionOn = action.getCommitActionOn(session.actionTimestamp);
                Row row = action.memoryRow == null ? (Row)action.store.get(action.getPos(), false) : action.memoryRow;
                Table table2 = (Table)row.getTable();
                if (table2.triggerLists[Trigger.Type.INSERT_AFTER_ROW_COMMIT.ordinal()].length == 0 && table2.triggerLists[Trigger.Type.UPDATE_AFTER_ROW_COMMIT.ordinal()].length == 0 && table2.triggerLists[Trigger.Type.DELETE_AFTER_ROW_COMMIT.ordinal()].length == 0 && table2.triggerLists[Trigger.Type.INSERT_AFTER_COMMIT.ordinal()].length == 0 && table2.triggerLists[Trigger.Type.UPDATE_AFTER_COMMIT.ordinal()].length == 0 && table2.triggerLists[Trigger.Type.DELETE_AFTER_COMMIT.ordinal()].length == 0 && table2.triggerLists[Trigger.Type.CHANGE_AFTER_ROW_COMMIT.ordinal()].length == 0) continue;
                BiConsumer<RowAction, Boolean> addInsertAction = (insertAction, forUpdate) -> {
                    if (insertAction.isTriggered()) {
                        return;
                    }
                    insertAction.setTriggered(true);
                    if (forUpdate.booleanValue()) {
                        insertForUpdateActionsList.add(insertAction);
                        if (deleteForUpdateActionsList.size() == insertForUpdateActionsList.size()) {
                            if (table.triggerLists[Trigger.Type.UPDATE_AFTER_ROW_COMMIT.ordinal()].length > 0 || table.triggerLists[Trigger.Type.CHANGE_AFTER_ROW_COMMIT.ordinal()].length > 0) {
                                for (int j = 0; j < deleteForUpdateActionsList.size(); ++j) {
                                    RowAction deleteAction = (RowAction)deleteForUpdateActionsList.get(j);
                                    Row oldRow = deleteAction.memoryRow;
                                    if (oldRow == null) {
                                        oldRow = (Row)deleteAction.store.get(deleteAction.getPos(), false);
                                    }
                                    RowAction insertAction1 = (RowAction)insertForUpdateActionsList.get(j);
                                    Row newRow = insertAction1.memoryRow;
                                    if (newRow == null) {
                                        newRow = (Row)insertAction1.store.get(insertAction1.getPos(), false);
                                    }
                                    if (table.triggerLists[Trigger.Type.UPDATE_AFTER_ROW_COMMIT.ordinal()].length > 0) {
                                        table2.fireTriggers(session, Trigger.Type.UPDATE_AFTER_ROW_COMMIT, oldRow.getData(), newRow.getData(), null);
                                    }
                                    if (table.triggerLists[Trigger.Type.CHANGE_AFTER_ROW_COMMIT.ordinal()].length <= 0) continue;
                                    table2.fireTriggers(session, Trigger.Type.CHANGE_AFTER_ROW_COMMIT, null, newRow.getData(), null);
                                }
                            }
                            if (table.triggerLists[Trigger.Type.UPDATE_AFTER_COMMIT.ordinal()].length > 0) {
                                addTableForTrigger.accept(table2, Trigger.Type.UPDATE_AFTER_COMMIT);
                            }
                            deleteForUpdateActionsList.clear();
                            insertForUpdateActionsList.clear();
                        } else if (deleteForUpdateActionsList.size() == 0) {
                            throw new DataspaceException("Invalid actions order. Insert_for_update action should follow right after delete_for_update action.");
                        }
                    } else {
                        if (table.triggerLists[Trigger.Type.INSERT_AFTER_ROW_COMMIT.ordinal()].length > 0) {
                            table2.fireTriggers(session, Trigger.Type.INSERT_AFTER_ROW_COMMIT, null, row.getData(), null);
                        }
                        if (table.triggerLists[Trigger.Type.CHANGE_AFTER_ROW_COMMIT.ordinal()].length > 0) {
                            table2.fireTriggers(session, Trigger.Type.CHANGE_AFTER_ROW_COMMIT, null, row.getData(), null);
                        }
                        if (table.triggerLists[Trigger.Type.INSERT_AFTER_COMMIT.ordinal()].length > 0) {
                            addTableForTrigger.accept(table2, Trigger.Type.INSERT_AFTER_COMMIT);
                        }
                    }
                };
                BiConsumer<RowAction, Boolean> addDeleteAction = (deleteAction, forUpdate) -> {
                    if (forUpdate.booleanValue()) {
                        deleteForUpdateActionsList.add(deleteAction);
                        if (insertForUpdateActionsList.size() > 0) {
                            throw new DataspaceException("Invalid actions order. No insert_for_update actions should be before delete_for_update.");
                        }
                    } else {
                        if (table.triggerLists[Trigger.Type.DELETE_AFTER_ROW_COMMIT.ordinal()].length > 0) {
                            table2.fireTriggers(session, Trigger.Type.DELETE_AFTER_ROW_COMMIT, row.getData(), null, null);
                        }
                        if (table.triggerLists[Trigger.Type.CHANGE_AFTER_ROW_COMMIT.ordinal()].length > 0) {
                            table2.fireTriggers(session, Trigger.Type.CHANGE_AFTER_ROW_COMMIT, row.getData(), null, null);
                        }
                        if (table.triggerLists[Trigger.Type.DELETE_AFTER_COMMIT.ordinal()].length > 0) {
                            addTableForTrigger.accept(table2, Trigger.Type.DELETE_AFTER_COMMIT);
                        }
                    }
                };
                switch (type) {
                    case 1: {
                        addInsertAction.accept(action, commitActionOn.isForUpdate());
                        continue block7;
                    }
                    case 2: {
                        addDeleteAction.accept(action, commitActionOn.isForUpdate());
                        continue block7;
                    }
                    case 4: {
                        if (action.getType() == 1 && (!action.prepared && action.commitTimestamp == session.actionTimestamp || action.prepared && action.preparedTimestamp == session.actionTimestamp)) {
                            addInsertAction.accept(action, action.isForUpdate());
                        } else if (action.getType() == 2 && (!action.prepared && action.commitTimestamp == session.actionTimestamp || action.prepared && action.preparedTimestamp == session.actionTimestamp)) {
                            addDeleteAction.accept(action, action.isForUpdate());
                        }
                        if (action.getNext() == null) continue block7;
                        if (action.getNext().type == 1 && (!action.prepared && action.commitTimestamp == session.actionTimestamp || action.prepared && action.preparedTimestamp == session.actionTimestamp)) {
                            addInsertAction.accept(action, action.getNext().isForUpdate());
                            continue block7;
                        }
                        if (action.getNext().type != 2 || (action.prepared || action.commitTimestamp != session.actionTimestamp) && (!action.prepared || action.preparedTimestamp != session.actionTimestamp)) continue block7;
                        addDeleteAction.accept(action, action.getNext().isForUpdate());
                        continue block7;
                    }
                }
            }
            for (Pair pair : tables.values()) {
                if (((Set)pair.second).contains((Object)Trigger.Type.INSERT_AFTER_COMMIT)) {
                    ((Table)pair.first).fireTriggers(session, Trigger.Type.INSERT_AFTER_COMMIT, (RowSetNavigator)null);
                }
                if (((Set)pair.second).contains((Object)Trigger.Type.UPDATE_AFTER_COMMIT)) {
                    ((Table)pair.first).fireTriggers(session, Trigger.Type.UPDATE_AFTER_COMMIT, (RowSetNavigator)null);
                }
                if (!((Set)pair.second).contains((Object)Trigger.Type.DELETE_AFTER_COMMIT)) continue;
                ((Table)pair.first).fireTriggers(session, Trigger.Type.DELETE_AFTER_COMMIT, (RowSetNavigator)null);
            }
            if (limit < session.rowActionList.size()) {
                if (!this.commitTransactionWith2PCPrepare(session, limit, session.rowActionList.size())) {
                    return false;
                }
                if (!this.fireAfterCommitTriggers(session, limit, session.rowActionList.size())) {
                    return false;
                }
            }
        }
        catch (Throwable exception) {
            session.sessionContext.onCommitFireTriggersException = exception;
            return false;
        }
        return true;
    }

    private boolean executeReplication(Session session, int start, int limit, Set<ReplicationSource> replicationSources) {
        Objects.requireNonNull(session);
        this.doExecuteReplicationUpdateAsUpdate(session, start, limit, replicationSources);
        replicationSources.forEach(replicationSource -> replicationSource.onBeforeCommit(session));
        return limit >= session.rowActionList.size() || this.commitTransactionWith2PCPrepare(session, limit, session.rowActionList.size());
    }

    private void doExecuteReplicationUpdateAsInsertDelete(Session session, int start, int limit, Set<ReplicationSource> replicationSources) {
        long actionTimestamp = session.actionTimestamp;
        block5: for (int i = start; i < limit; ++i) {
            Table table;
            RowAction action = (RowAction)session.rowActionList.get(i);
            if (action.type == 0) continue;
            int type = action.getCommitTypeOn(actionTimestamp);
            Row row = action.memoryRow;
            if (row == null) {
                row = (Row)action.store.get(action.getPos(), false);
            }
            if (!(table = (Table)row.getTable()).isReplicated() || !(action.store instanceof RowStoreAVLDisk) && !(action.store instanceof RowStoreAVLMemory)) continue;
            ReplicationSource replicationSource = ((Table)row.getTable()).getReplicationSource();
            switch (type) {
                case 2: {
                    replicationSources.add(replicationSource);
                    replicationSource.onDelete(session, table, row.getData(), true, null);
                    continue block5;
                }
                case 1: {
                    replicationSources.add(replicationSource);
                    replicationSource.onInsert(session, row.getData(), null);
                    continue block5;
                }
                case 4: {
                    continue block5;
                }
            }
        }
    }

    private void doExecuteReplicationUpdateAsUpdate(Session session, int start, int limit, Set<ReplicationSource> replicationSources) {
        ArrayList deleteForUpdateActionsList = new ArrayList();
        ArrayList insertForUpdateActionsList = new ArrayList();
        ArrayList<RowAction> processedActions = new ArrayList<RowAction>();
        block5: for (int i = start; i < limit; ++i) {
            RowAction action = (RowAction)session.rowActionList.get(i);
            if (action.type == 0 || processedActions.contains(action)) continue;
            processedActions.add(action);
            int type = action.getCommitTypeOn(session.actionTimestamp);
            RowActionBase commitActionOn = action.getCommitActionOn(session.actionTimestamp);
            Row row = action.memoryRow == null ? (Row)action.store.get(action.getPos(), false) : action.memoryRow;
            Table table = (Table)row.getTable();
            if (!table.isReplicated() || !(action.store instanceof RowStoreAVLDisk) && !(action.store instanceof RowStoreAVLMemory)) continue;
            ReplicationSource replicationSource = ((Table)row.getTable()).getReplicationSource();
            BiConsumer<RowAction, Boolean> addInsertAction = (insertAction, forUpdate) -> {
                if (insertAction.isTriggered()) {
                    return;
                }
                insertAction.setTriggered(true);
                if (forUpdate.booleanValue()) {
                    insertForUpdateActionsList.add(insertAction);
                    if (deleteForUpdateActionsList.size() == insertForUpdateActionsList.size()) {
                        for (int j = 0; j < deleteForUpdateActionsList.size(); ++j) {
                            RowAction deleteAction = (RowAction)deleteForUpdateActionsList.get(j);
                            Row oldRow = deleteAction.memoryRow;
                            if (oldRow == null) {
                                oldRow = (Row)deleteAction.store.get(deleteAction.getPos(), false);
                            }
                            RowAction insertAction1 = (RowAction)insertForUpdateActionsList.get(j);
                            Row newRow = insertAction1.memoryRow;
                            if (newRow == null) {
                                newRow = (Row)insertAction1.store.get(insertAction1.getPos(), false);
                            }
                            replicationSources.add(replicationSource);
                            replicationSource.onUpdate(session, table, oldRow.getData(), newRow.getData(), true, null);
                        }
                        deleteForUpdateActionsList.clear();
                        insertForUpdateActionsList.clear();
                    } else if (deleteForUpdateActionsList.size() == 0) {
                        throw new DataspaceException("Invalid actions order. Insert_for_update action should follow right after delete_for_update action.");
                    }
                } else {
                    replicationSources.add(replicationSource);
                    replicationSource.onInsert(session, row.getData(), null);
                }
            };
            BiConsumer<RowAction, Boolean> addDeleteAction = (deleteAction, forUpdate) -> {
                if (forUpdate.booleanValue()) {
                    deleteForUpdateActionsList.add(deleteAction);
                    if (insertForUpdateActionsList.size() > 0) {
                        throw new DataspaceException("Invalid actions order. No insert_for_update actions should be before delete_for_update.");
                    }
                } else {
                    replicationSources.add(replicationSource);
                    replicationSource.onDelete(session, table, row.getData(), true, null);
                }
            };
            switch (type) {
                case 1: {
                    addInsertAction.accept(action, commitActionOn.isForUpdate());
                    continue block5;
                }
                case 2: {
                    addDeleteAction.accept(action, commitActionOn.isForUpdate());
                    continue block5;
                }
                case 4: {
                    if (action.getType() == 1 && (!action.prepared && action.commitTimestamp == session.actionTimestamp || action.prepared && action.preparedTimestamp == session.actionTimestamp)) {
                        addInsertAction.accept(action, action.isForUpdate());
                    } else if (action.getType() == 2 && (!action.prepared && action.commitTimestamp == session.actionTimestamp || action.prepared && action.preparedTimestamp == session.actionTimestamp)) {
                        addDeleteAction.accept(action, action.isForUpdate());
                    }
                    if (action.getNext() == null) continue block5;
                    if (action.getNext().type == 1 && (!action.prepared && action.commitTimestamp == session.actionTimestamp || action.prepared && action.preparedTimestamp == session.actionTimestamp)) {
                        addInsertAction.accept(action, action.getNext().isForUpdate());
                        continue block5;
                    }
                    if (action.getNext().type != 2 || (action.prepared || action.commitTimestamp != session.actionTimestamp) && (!action.prepared || action.preparedTimestamp != session.actionTimestamp)) continue block5;
                    addDeleteAction.accept(action, action.getNext().isForUpdate());
                    continue block5;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commitTransactionWith2PC(Session session) {
        boolean result;
        HashSet<ReplicationSource> replicationSources = new HashSet<ReplicationSource>();
        ArrayList<Pair<Table, List<Object[]>>> insertedRows = new ArrayList<Pair<Table, List<Object[]>>>();
        try {
            result = this.commitTransactionWith2PCPrepare(session, 0, session.rowActionList.size());
            if (result) {
                result = this.fireAfterCommitTriggers(session, 0, session.rowActionList.size());
            }
            if (result) {
                result = this.executeReplication(session, 0, session.rowActionList.size(), replicationSources);
            }
            if (result) {
                result = this.commitTransactionWith2PCFinalCommit(session, insertedRows);
            }
            insertedRows.forEach(pair -> ((Table)pair.first).dfetchMonitor.rowsInserted(session, (List)pair.second));
            replicationSources.forEach(s -> s.onAfterCommit(session));
        }
        catch (Exception exception) {
            session.sessionContext.onCommitException = exception;
            result = false;
        }
        finally {
            replicationSources.forEach(s -> s.onAfterCommitConfirm(session));
        }
        if (session.sessionContext.onCommitFireTriggersException != null || session.sessionContext.onCommitException != null) {
            for (int i = 0; i < session.rowActionList.size(); ++i) {
                ((RowAction)session.rowActionList.get(i)).resetCommit(session);
            }
        }
        if (!(result &= session.sessionContext.onCommitFireTriggersException == null && session.sessionContext.onCommitException == null)) {
            this.database.dataspaceLogger.writeRollbackStatement(session);
        }
        return result;
    }

    private boolean checkIfAfterCommitTriggersOrReplicationPresent(Session session) {
        for (int i = 0; i < session.rowActionList.size(); ++i) {
            RowActionBase action;
            Table table = (Table)action.table;
            TriggerDef[][] triggerLists = table.triggerLists;
            if (!(table instanceof Table)) continue;
            Objects.requireNonNull(session);
            if (!table.isReplicated() && triggerLists[Trigger.Type.INSERT_AFTER_ROW_COMMIT.ordinal()].length <= 0 && triggerLists[Trigger.Type.UPDATE_AFTER_ROW_COMMIT.ordinal()].length <= 0 && triggerLists[Trigger.Type.DELETE_AFTER_ROW_COMMIT.ordinal()].length <= 0 && triggerLists[Trigger.Type.INSERT_AFTER_COMMIT.ordinal()].length <= 0 && triggerLists[Trigger.Type.UPDATE_AFTER_COMMIT.ordinal()].length <= 0 && triggerLists[Trigger.Type.DELETE_AFTER_ROW_COMMIT.ordinal()].length <= 0 && triggerLists[Trigger.Type.CHANGE_AFTER_ROW_COMMIT.ordinal()].length <= 0) continue;
            for (action = (RowAction)session.rowActionList.get(i); action != null; action = action.getNext()) {
                if (action.commitTimestamp != 0L || action.session != session) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            this.rollbackPartial(session, 0, session.transactionTimestamp);
            this.endTransaction(session);
            this.endTransactionTPL(session);
            session.isTransaction = false;
            session.isPreTransaction = false;
            this.countDownLatches(session);
            this.enqueueCheckpoint(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int index) {
        long timestamp = session.sessionContext.savepointTimestamps.get(index);
        Integer oi = (Integer)session.sessionContext.savepoints.get(index);
        int start = oi;
        while (session.sessionContext.savepoints.size() > index + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, start, timestamp);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackPartial(Session session, int start, long timestamp) {
        Object[] list = session.rowActionList.getArray();
        int limit = session.rowActionList.size();
        if (start == limit) {
            return;
        }
        for (int i = start; i < limit; ++i) {
            RowAction action = (RowAction)list[i];
            if (action != null) {
                action.rollback(session, timestamp);
                continue;
            }
            Trace.logError(this, "null action in rollback - start : " + start + ",limit : " + limit + ", current session : " + session.getId() + ", session user : " + session.getUsername() + ", connect time: " + session.getConnectTime() + ", current schema : " + session.getCurrentDataspaceName().name);
            try {
                throw new IllegalStateException();
            }
            catch (Exception error) {
                Trace.logException(this, error, true);
            }
        }
        this.writeLock.lock();
        try {
            this.mergeRolledBackTransaction(session, timestamp, list, start, limit);
            this.finaliseRows(session, list, start, limit, false);
        }
        finally {
            this.writeLock.unlock();
        }
        session.rowActionList.setSize(start);
    }

    @Override
    public RowAction addDeleteAction(Session session, Table table, Row row, int[] colMap, boolean forUpdate) {
        RowAction action = this.addDeleteActionToRow(session, table, row, colMap, forUpdate);
        Session actionSession = null;
        boolean redoAction = true;
        if (action == null) {
            this.writeLock.lock();
            try {
                if (session.sessionContext.depth > 0 && session.sessionContext.rowActionListStartIndex > 0) {
                    this.rollbackPartial(session, session.sessionContext.rowActionListStartIndex, session.actionTimestamp);
                } else {
                    this.rollbackAction(session);
                }
                if (session.isolationLevel == 4 || session.isolationLevel == 8) {
                    session.tempSet.clear();
                    session.redoAction = false;
                    session.abortTransaction = session.txConflictRollback;
                    this.logNoRedoWarning(session, actionSession, "DELETE");
                    throw Error.error(4871);
                }
                if (row.rowAction != null && row.rowAction.isDeleted()) {
                    session.tempSet.clear();
                    session.redoAction = true;
                    ++this.redoCount;
                    this.logRedoWarning(session, actionSession, "DELETE");
                    throw Error.error(4871);
                }
                boolean bl = redoAction = !session.tempSet.isEmpty();
                if (redoAction) {
                    actionSession = ((RowActionBase)session.tempSet.get((int)0)).session;
                    session.tempSet.clear();
                    if (actionSession != null) {
                        redoAction = this.checkDeadlock(session, actionSession);
                    }
                }
                if (redoAction) {
                    session.redoAction = true;
                    if (actionSession != null) {
                        actionSession.waitingSessions.add(session);
                        session.waitedSessions.add(actionSession);
                        session.latch.setCount(session.waitedSessions.size() + session.replicationWaitedSessions.size());
                    }
                    ++this.redoCount;
                    this.logRedoWarning(session, actionSession, "DELETE");
                } else {
                    this.logNoRedoWarning(session, actionSession, "DELETE");
                    session.redoAction = false;
                    session.abortTransaction = session.txConflictRollback;
                }
                throw Error.error(4871);
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
        }
        session.rowActionList.add(action);
        return action;
    }

    private Object dynamicArgumentsToString(Object[] dynamicArguments) {
        if (dynamicArguments == null) {
            return "null";
        }
        return Arrays.stream(dynamicArguments).map(a -> String.valueOf(a)).collect(Collectors.joining(","));
    }

    private void logNoRedoWarning(Session session, Session actionSession, String actionType) {
        this.logWarning(session, actionSession, "no redo", actionType);
    }

    private void logRedoWarning(Session session, Session actionSession, String actionType) {
        this.logWarning(session, actionSession, "execute redo", actionType);
    }

    private void logWarning(Session session, Session actionSession, String redoNoRedo, String actionType) {
        Trace.logInfo(this, "WARNING: {} for this {} action. Current sessionId: {}\n currentStatement: {}\n currentStatementValues: {}\n lastStatement: {}\n lastStatementsInTransaction: {}\n blockingSessionId: {}\n blockingCurrentStatement: {} blockingCurrentStatementValues: {}\n blockingLastStatement: {}\n blockingLastStatementsInTransaction: {}\n totalRedoCount: {}, thisSessionRedoCount: {}", redoNoRedo, actionType, session.getId(), session.sessionContext != null && session.sessionContext.currentStatement != null ? session.sessionContext.currentStatement.getSQL() : "n/a", session.sessionContext != null ? this.dynamicArgumentsToString(session.sessionContext.dynamicArguments) : "n/a", session.sessionContext != null ? session.sessionContext.lastStatement : "n/a", session.sessionContext != null && session.sessionContext.lastStatementsInTransaction != null ? session.sessionContext.lastStatementsInTransaction.stream().collect(Collectors.joining("\n")) : "n/a", actionSession != null ? Long.valueOf(actionSession.getId()) : "n/a", actionSession != null && actionSession.sessionContext.currentStatement != null ? actionSession.sessionContext.currentStatement.getSQL() : "n/a", actionSession != null && actionSession.sessionContext != null ? this.dynamicArgumentsToString(actionSession.sessionContext.dynamicArguments) : "n/a", actionSession != null && actionSession.sessionContext != null ? actionSession.sessionContext.lastStatement : "n/a", actionSession != null && actionSession.sessionContext != null && actionSession.sessionContext.lastStatementsInTransaction != null ? actionSession.sessionContext.lastStatementsInTransaction.stream().collect(Collectors.joining("\n")) : "n/a", this.redoCount, session.sessionRedoCount);
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore store, Row row, int[] changedColumns, boolean forUpdate) {
        RowAction action = row.rowAction;
        Session actionSession = null;
        boolean redoAction = false;
        boolean redoWait = true;
        DataspaceException cause = null;
        if (action == null) {
            System.out.println("null insert action " + String.valueOf(session) + " " + session.actionTimestamp);
        }
        action.setForUpdate(forUpdate);
        if (table.getTableType() == 6) {
            this.addTransactionInfo(row);
        }
        try {
            store.indexRow(session, row);
        }
        catch (DataspaceException e) {
            if (session.tempSet.isEmpty()) {
                throw e;
            }
            redoAction = true;
            cause = e;
        }
        if (!redoAction) {
            session.rowActionList.add(action);
            return;
        }
        this.writeLock.lock();
        try {
            this.rollbackAction(session);
            RowActionBase otherAction = (RowActionBase)session.tempSet.get(0);
            actionSession = otherAction.session;
            session.tempSet.clear();
            if (otherAction.commitTimestamp != 0L) {
                redoWait = false;
            }
            switch (session.isolationLevel) {
                case 4: 
                case 8: {
                    redoAction = false;
                    break;
                }
                default: {
                    redoAction = this.checkDeadlock(session, actionSession);
                }
            }
            if (redoAction) {
                session.redoAction = true;
                if (redoWait) {
                    actionSession.waitingSessions.add(session);
                    session.waitedSessions.add(actionSession);
                    session.latch.setCount(session.waitedSessions.size() + session.replicationWaitedSessions.size());
                }
                ++this.redoCount;
                this.logRedoWarning(session, actionSession, "INSERT");
            } else {
                this.logNoRedoWarning(session, actionSession, "INSERT");
                session.abortTransaction = session.txConflictRollback;
                session.redoAction = false;
            }
            throw Error.error(cause, 4871, null);
        }
        catch (Throwable throwable) {
            this.writeLock.unlock();
            throw throwable;
        }
    }

    @Override
    public boolean canRead(Session session, Row row, int mode, int[] colMap) {
        RowAction action = row.rowAction;
        if (mode == 0) {
            if (action == null) {
                return true;
            }
            return action.canRead(session, 0);
        }
        if (mode == 2) {
            boolean result = action == null ? true : action.canRead(session, 0);
            return result;
        }
        if (action == null) {
            return true;
        }
        return action.canRead(session, mode);
    }

    @Override
    public boolean canRead(Session session, int id, int mode) {
        RowAction action = (RowAction)this.rowActionMap.get(id);
        if (action == null) {
            return true;
        }
        return action.canRead(session, mode);
    }

    @Override
    public void setTransactionInfo(CachedObject object) {
        RowAction rowact;
        if (object.isMemory()) {
            return;
        }
        Row row = (Row)object;
        row.rowAction = rowact = (RowAction)this.rowActionMap.get(row.position);
    }

    @Override
    public void removeTransactionInfo(CachedObject object) {
        if (object.isMemory()) {
            return;
        }
        this.rowActionMap.remove(object.getPos());
    }

    void addToCommittedQueue(Session session, Object[] list) {
        this.committedTransactions.addLast(list);
        this.committedTransactionTimestamps.addLast(session.actionTimestamp);
    }

    void mergeExpiredTransactions(Session session) {
        long commitTimestamp;
        long timestamp = this.getFirstLiveTransactionTimestamp();
        while (!this.committedTransactionTimestamps.isEmpty() && (commitTimestamp = this.committedTransactionTimestamps.getFirst()) < timestamp) {
            this.committedTransactionTimestamps.removeFirst();
            Object[] actions = (Object[])this.committedTransactions.removeFirst();
            this.mergeTransaction(session, actions, 0, actions.length, commitTimestamp);
            this.finaliseRows(session, actions, 0, actions.length, true);
        }
    }

    @Override
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            if (!session.isTransaction) {
                this.checkForCheckpoint(111);
            }
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
                session.isTransaction = true;
                if (!this.isDfetchStatement(session)) {
                    this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                    ++this.transactionCount;
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement cs) {
        if (session.isTransaction) {
            return;
        }
        if (cs == null) {
            return;
        }
        this.writeLock.lock();
        try {
            this.checkForCheckpoint(cs.getType());
            if (cs.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
                session.sessionContext.currentStatement = cs = session.statementManager.getStatement(session, cs);
                if (cs == null) {
                    return;
                }
            }
            if (this.lockedForMaterialization.size() > 0 && cs.getTableNamesForWrite().length > 0) {
                session.tempSet.clear();
                for (NameManager.ObjectName writeTableName : cs.getTableNamesForWrite()) {
                    Session temp = (Session)this.lockedForMaterialization.get(writeTableName);
                    if (temp == null) continue;
                    session.tempSet.add(temp);
                }
                session.tempSet.remove(session);
                this.removeDfetchSessionsFromList(session.tempSet);
                if (!session.tempSet.isEmpty()) {
                    session.waitedSessions.addAll(session.tempSet);
                    this.setWaitingSessionTPL(session);
                }
                session.tempSet.clear();
                return;
            }
            NameManager.ObjectName[] nameList = cs.getTableNamesForWrite();
            for (int i = 0; i < nameList.length; ++i) {
                NameManager.ObjectName name = nameList[i];
                if (name.schema == SqlInvariants.SYSTEM_SCHEMA_NAME) continue;
                this.tableWriteLocks.put(name, session);
            }
            this.lockReplication(session);
            session.isPreTransaction = true;
            if (!this.isLockedMode && !cs.isCatalogLock()) {
                return;
            }
            this.beginActionTPL(session, cs);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            session.actionTimestamp = this.nextChangeTimestamp();
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp;
                session.isTransaction = true;
                if (!this.isDfetchStatement(session)) {
                    this.liveTransactionTimestamps.addLast(session.actionTimestamp);
                    ++this.transactionCount;
                }
            }
            session.isPreTransaction = false;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RowAction addDeleteActionToRow(Session session, Table table, Row row, int[] colMap, boolean forUpdate) {
        RowAction action = null;
        Row row2 = row;
        synchronized (row2) {
            if (table.getTableType() != 6) return RowAction.addDeleteAction(session, table, row, colMap, forUpdate);
            Lock mapLock = this.rowActionMap.getWriteLock();
            mapLock.lock();
            try {
                action = (RowAction)this.rowActionMap.get(row.getPos());
                if (action == null) {
                    action = RowAction.addDeleteAction(session, table, row, colMap, forUpdate);
                    if (action == null) return action;
                    this.addTransactionInfo(row);
                } else {
                    row.rowAction = action;
                    action = RowAction.addDeleteAction(session, table, row, colMap, forUpdate);
                }
            }
            finally {
                mapLock.unlock();
            }
            return action;
        }
    }

    public void addTransactionInfo(CachedObject object) {
        if (object.isMemory()) {
            return;
        }
        Row row = (Row)object;
        if (((Row)object).getTable().getTableType() == 6) {
            RowAction action = (RowAction)this.rowActionMap.get(object.getPos());
            if (action != null) {
                String error = "TXManager: row exists. Pos: " + object.getPos() + ", table name: " + ((Table)((Row)object).getTable()).getObjectName().getSchemaQualifiedStatementName();
                Trace.logError(this, error);
                throw Error.error(4871, error);
            }
            this.rowActionMap.put(object.getPos(), row.rowAction);
        }
    }

    void endTransaction(Session session) {
        long timestamp = session.transactionTimestamp;
        int index = this.liveTransactionTimestamps.indexOf(timestamp);
        if (index >= 0) {
            --this.transactionCount;
            this.liveTransactionTimestamps.remove(index);
            this.mergeExpiredTransactions(session);
        } else if (this.isDfetchStatement(session)) {
            this.mergeExpiredTransactions(session);
        }
    }

    private void countDownLatches(Session session) {
        int i;
        for (i = 0; i < session.waitingSessions.size(); ++i) {
            Session waitingSession = (Session)session.waitingSessions.get(i);
            waitingSession.waitedSessions.remove(session);
            waitingSession.latch.countDown();
        }
        for (i = 0; i < session.waitedSessions.size(); ++i) {
            Session waitedSession = (Session)session.waitedSessions.get(i);
            waitedSession.waitingSessions.remove(session);
        }
        session.waitedSessions.clear();
        session.waitingSessions.clear();
        this.unlockReplication(session);
        session.latch.setCount(0);
    }

    void getTransactionSessions(com.streamscape.ds.lib.HashSet set) {
        Session[] sessions = this.database.collectionSessionManager.getAllSessions();
        for (int i = 0; i < sessions.length; ++i) {
            long timestamp = sessions[i].getTransactionTimestamp();
            if (this.liveTransactionTimestamps.contains(timestamp)) {
                set.add(sessions[i]);
                continue;
            }
            if (sessions[i].isPreTransaction) {
                set.add(sessions[i]);
                continue;
            }
            if (!sessions[i].isTransaction) continue;
            set.add(sessions[i]);
        }
    }

    @Override
    void endTransactionTPL(Session session) {
        Session current;
        int i;
        Iterator it = this.tableWriteLocks.values().iterator();
        while (it.hasNext()) {
            Session s = (Session)it.next();
            if (s != session) continue;
            it.remove();
        }
        if (this.catalogWriteSession != session) {
            return;
        }
        Session nextSession = null;
        session.waitingSessions.size();
        for (i = 0; i < session.waitingSessions.size(); ++i) {
            current = (Session)session.waitingSessions.get(i);
            Statement st = current.sessionContext.currentStatement;
            if (st == null || !st.isCatalogLock()) continue;
            nextSession = current;
            break;
        }
        if (nextSession == null) {
            this.catalogWriteSession = null;
            this.isLockedMode = false;
        } else {
            for (i = 0; i < session.waitingSessions.size(); ++i) {
                current = (Session)session.waitingSessions.get(i);
                if (current == nextSession) continue;
                current.waitedSessions.add(nextSession);
                nextSession.waitingSessions.add(current);
                current.latch.setCount(current.waitedSessions.size() + current.replicationWaitedSessions.size());
            }
            this.catalogWriteSession = nextSession;
        }
        this.unlockTxTs = session.actionTimestamp;
        this.unlockSessionId = session.getId();
    }

    boolean beginActionTPL(Session session, Statement cs) {
        if (cs == null) {
            return true;
        }
        if (session.abortTransaction) {
            return false;
        }
        if (session == this.catalogWriteSession) {
            return true;
        }
        session.tempSet.clear();
        if (cs.isCatalogLock() && this.catalogWriteSession == null) {
            this.catalogWriteSession = session;
            this.isLockedMode = true;
            this.lockTxTs = session.actionTimestamp;
            this.lockSessionId = session.getId();
            this.getTransactionSessions(session.tempSet);
            session.tempSet.remove(session);
            this.removeDfetchSessionsFromList(session.tempSet);
            if (!session.tempSet.isEmpty()) {
                session.waitedSessions.addAll(session.tempSet);
                this.setWaitingSessionTPL(session);
            }
            session.tempSet.clear();
            this.getReplicationLockedSession(session.tempSet);
            session.tempSet.remove(session);
            this.removeDfetchSessionsFromList(session.tempSet);
            if (session.sessionContext.currentStatement != null && session.sessionContext.currentStatement.getType() == 1205) {
                Iterator iterator = session.tempSet.iterator();
                while (iterator.hasNext()) {
                    Session current = (Session)iterator.next();
                    if (session.getParentSessionId() != current.getId()) continue;
                    iterator.remove();
                }
            }
            this.setWaitingSessionTPLForReplication(session);
            return true;
        }
        if (!this.isLockedMode) {
            return true;
        }
        if (cs.getTableNamesForWrite().length > 0 ? cs.getTableNamesForWrite()[0].schema == SqlInvariants.LOBS_SCHEMA_NAME || cs.getTableNamesForWrite()[0].schema == SqlInvariants.FLOBS_SCHEMA_NAME : cs.getTableNamesForRead().length > 0 && (cs.getTableNamesForRead()[0].schema == SqlInvariants.LOBS_SCHEMA_NAME || cs.getTableNamesForRead()[0].schema == SqlInvariants.FLOBS_SCHEMA_NAME)) {
            return true;
        }
        if (session.waitingSessions.contains(this.catalogWriteSession) || session.replicationWaitingSessions.contains(this.catalogWriteSession)) {
            return true;
        }
        if (this.catalogWriteSession.sessionContext.currentStatement != null && this.catalogWriteSession.sessionContext.currentStatement.getType() == 1002) {
            if (this.catalogWriteSession.latch.getCount() > 0) {
                Iterator iter = this.catalogWriteSession.waitedSessions.iterator();
                boolean added = false;
                while (iter.hasNext()) {
                    Session tempSession = (Session)iter.next();
                    if ((tempSession.getCurrentThreadId() == -1L || tempSession.getCurrentThreadId() != Thread.currentThread().getId()) && session.getParentSessionId() != tempSession.getId() || !session.waitingSessions.add(this.catalogWriteSession)) continue;
                    this.catalogWriteSession.waitedSessions.add(session);
                    this.catalogWriteSession.latch.countUp();
                    added = true;
                }
                if (added) {
                    return true;
                }
            }
        } else if (session.getParentSessionId() == this.catalogWriteSession.getId()) {
            return true;
        }
        if (this.catalogWriteSession.waitingSessions.add(session)) {
            session.waitedSessions.add(this.catalogWriteSession);
            session.latch.setCount(session.waitedSessions.size() + session.replicationWaitedSessions.size());
        }
        return true;
    }

    private boolean isDfetchStatement(Session session) {
        return session.sessionContext.currentStatement instanceof StatementDfetch && !((StatementDfetch)session.sessionContext.currentStatement).isExecutingUpdate() || session.sessionContext.currentStatement instanceof StatementExpression && ((StatementExpression)session.sessionContext.currentStatement).expression instanceof ReadTakeExpression;
    }

    private void removeDfetchSessionsFromList(OrderedHashSet sessions) {
        Iterator iterator = sessions.iterator();
        while (iterator.hasNext()) {
            if (!this.isDfetchStatement((Session)iterator.next())) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean lockCollectionForWrite(Session session, NameManager.ObjectName name) {
        do {
            if (this.beginActionCollectionLockForWrite(session, name)) {
                return true;
            }
            if (session.abortTransaction) {
                return false;
            }
            try {
                session.latch.await();
            }
            catch (InterruptedException e) {
                session.abortTransaction = true;
            }
        } while (!session.abortTransaction);
        return false;
    }

    @Override
    public void unlockCollectionForWrite(Session session, NameManager.ObjectName name) {
        this.endActionCollectionLockForWrite(session, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beginActionCollectionLockForWrite(Session session, NameManager.ObjectName name) {
        this.writeLock.lock();
        try {
            boolean canProceed = this.setWaitedSessionsTPL123(session, name);
            if (canProceed) {
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL123(session, name);
                    boolean bl = true;
                    return bl;
                }
                this.setWaitingSessionTPL(session);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return false;
    }

    boolean setWaitedSessionsTPL123(Session session, NameManager.ObjectName name) {
        session.tempSet.clear();
        if (session.abortTransaction) {
            return false;
        }
        Session holder = (Session)this.tableWriteLocks.get(name);
        if (holder != null && holder != session) {
            session.tempSet.add(holder);
        }
        if (session.tempSet.isEmpty()) {
            return true;
        }
        if (this.checkDeadlock(session, session.tempSet)) {
            return true;
        }
        session.tempSet.clear();
        session.abortTransaction = true;
        return false;
    }

    void lockTablesTPL123(Session session, NameManager.ObjectName name) {
        this.lockedForMaterialization.put(name, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endActionCollectionLockForWrite(Session session, NameManager.ObjectName name) {
        this.writeLock.lock();
        this.lockedForMaterialization.remove(name);
        try {
            int waitingCount = session.waitingSessions.size();
            if (waitingCount == 0) {
                return;
            }
            session.tempSet.clear();
            session.tempSet.addAll(session.waitingSessions);
            session.waitingSessions.clear();
            for (int i = 0; i < waitingCount; ++i) {
                Session current = (Session)session.tempSet.get(i);
                current.latch.countDown();
            }
            session.tempSet.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getCatalogWriteSessionThreadId() {
        this.readLock.lock();
        try {
            if (this.catalogWriteSession != null) {
                long l = this.catalogWriteSession.getCurrentThreadId();
                return l;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return -1L;
    }

    private boolean lockReplication(Session session) {
        if (session.replicationLockObjectName != null) {
            return false;
        }
        Statement statement = session.sessionContext.currentStatement;
        if (statement == null) {
            return false;
        }
        NameManager.ObjectName replicaObjectName = null;
        switch (statement.getType()) {
            case 3063: {
                replicaObjectName = ((ReplicationTarget)((StatementSchema)statement).arguments[0]).getObjectName();
                break;
            }
            case 3064: {
                replicaObjectName = (NameManager.ObjectName)((StatementSchema)statement).arguments[0];
                break;
            }
            case 3188: 
            case 3220: 
            case 3229: 
            case 3230: 
            case 3231: 
            case 3232: 
            case 3248: 
            case 3249: {
                ReplicationEntityName entityName = (ReplicationEntityName)((StatementCommand)statement).getParameters()[0];
                replicaObjectName = session.dataspaceStore.schemaManager.getSchemaObject(entityName.getSourceOrReplicaName(), entityName.getDataspaceName(), 29).getObjectName();
            }
        }
        if (replicaObjectName == null) {
            return false;
        }
        session.replicationLockObjectName = replicaObjectName;
        session.replicationLockManualDepth = 0;
        session.tempSet.clear();
        this.getReplicationSessionsForObject(session.tempSet, replicaObjectName);
        session.tempSet.remove(session);
        this.removeDfetchSessionsFromList(session.tempSet);
        this.setWaitingSessionTPLForReplication(session);
        return true;
    }

    private boolean unlockReplication(Session session) {
        Session current;
        int i;
        if (session.replicationLockObjectName == null || session.replicationLockManualDepth > 0) {
            return false;
        }
        session.replicationLockObjectName = null;
        for (i = 0; i < session.replicationWaitedSessions.size(); ++i) {
            current = (Session)session.replicationWaitedSessions.get(i);
            current.replicationWaitingSessions.remove(session);
            session.latch.countDown();
        }
        session.replicationWaitedSessions.clear();
        for (i = 0; i < session.replicationWaitingSessions.size(); ++i) {
            current = (Session)session.replicationWaitingSessions.get(i);
            if (!current.replicationWaitedSessions.remove(session)) continue;
            current.latch.countDown();
        }
        session.replicationWaitingSessions.clear();
        return true;
    }

    private void getReplicationSessionsForObject(com.streamscape.ds.lib.HashSet set, NameManager.ObjectName objectName) {
        Session[] sessions = this.database.collectionSessionManager.getAllSessions();
        for (int i = 0; i < sessions.length; ++i) {
            if (sessions[i].replicationLockObjectName != objectName) continue;
            set.add(sessions[i]);
        }
    }

    private void getReplicationLockedSession(com.streamscape.ds.lib.HashSet set) {
        Session[] sessions = this.database.collectionSessionManager.getAllSessions();
        for (int i = 0; i < sessions.length; ++i) {
            if (sessions[i].replicationLockObjectName == null) continue;
            set.add(sessions[i]);
        }
    }

    public boolean lockReplicationManual(Session session, NameManager.ObjectName replicaObjectName) {
        do {
            if (this.beginLockReplicationManual(session, replicaObjectName)) {
                return true;
            }
            if (session.abortTransaction) {
                return false;
            }
            try {
                session.latch.await();
            }
            catch (InterruptedException e) {
                session.abortTransaction = true;
            }
        } while (!session.abortTransaction);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockReplicationManual(Session session, NameManager.ObjectName replicaObjectName) {
        this.writeLock.lock();
        try {
            if (session.replicationLockObjectName != replicaObjectName || session.replicationLockManualDepth == 0) {
                return;
            }
            --session.replicationLockManualDepth;
            if (session.replicationLockManualDepth > 0) {
                return;
            }
            session.replicationLockObjectName = null;
            session.replicationLockManualDepth = 0;
            for (int i = 0; i < session.replicationWaitingSessions.size(); ++i) {
                Session current = (Session)session.replicationWaitingSessions.get(i);
                if (!current.replicationWaitedSessions.remove(session)) continue;
                current.latch.countDown();
            }
            session.replicationWaitingSessions.clear();
            this.enqueueCheckpoint(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beginLockReplicationManual(Session session, NameManager.ObjectName replicaObjectName) {
        this.writeLock.lock();
        try {
            this.checkForCheckpoint(50);
            if (session.replicationLockObjectName != null && session.replicationLockObjectName != replicaObjectName) {
                boolean bl = true;
                return bl;
            }
            if (session.replicationLockObjectName == replicaObjectName) {
                ++session.replicationLockManualDepth;
                boolean bl = true;
                return bl;
            }
            boolean canProceed = this.setReplicationSessions(session, replicaObjectName);
            if (canProceed) {
                if (session.tempSet.isEmpty()) {
                    session.replicationLockObjectName = replicaObjectName;
                    session.replicationLockManualDepth = 1;
                    boolean bl = true;
                    return bl;
                }
                this.setWaitingSessionTPLForReplication(session);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return false;
    }

    private boolean setReplicationSessions(Session session, NameManager.ObjectName replicaObjectName) {
        session.tempSet.clear();
        if (session.abortTransaction) {
            return false;
        }
        this.getReplicationSessionsForObject(session.tempSet, replicaObjectName);
        session.tempSet.remove(session);
        this.removeDfetchSessionsFromList(session.tempSet);
        if (session.tempSet.isEmpty()) {
            return true;
        }
        if (this.checkDeadlock(session, session.tempSet)) {
            return true;
        }
        Trace.logError(this, "WARNING: deadlock for replication sessions detected.");
        session.tempSet.clear();
        session.abortTransaction = true;
        return false;
    }

    private void setWaitingSessionTPLForReplication(Session session) {
        if (!session.tempSet.isEmpty()) {
            session.replicationWaitedSessions.addAll(session.tempSet);
            for (int i = 0; i < session.tempSet.size(); ++i) {
                Session current = (Session)session.tempSet.get(i);
                current.replicationWaitingSessions.add(session);
            }
            session.latch.countUp(session.tempSet.size());
            session.tempSet.clear();
        }
    }

    public void describe(RowSetNavigatorClient navigator) {
        navigator.add(new Object[]{"Committed Transactions Count", this.committedTransactions.size()});
        navigator.add(new Object[]{"Committed Transactions Timestamps", this.committedTransactionTimestamps.toList().stream().map(a -> String.valueOf(a)).collect(Collectors.joining(","))});
        navigator.add(new Object[]{"Live Transaction Timestamps", this.liveTransactionTimestamps.toList().stream().map(a -> String.valueOf(a)).collect(Collectors.joining(","))});
        navigator.add(new Object[]{"Global Change Timestamp", this.globalChangeTimestamp.get()});
        navigator.add(new Object[]{"Transaction Count", this.transactionCount});
        navigator.add(new Object[]{"Is Locked Mode", this.isLockedMode});
        navigator.add(new Object[]{"Catalog Write Session", this.catalogWriteSession != null ? Long.valueOf(this.catalogWriteSession.getId()) : null});
        navigator.add(new Object[]{"lockTxTs", this.lockTxTs});
        navigator.add(new Object[]{"lockSessionId", this.lockSessionId});
        navigator.add(new Object[]{"unlockTxTs", this.unlockTxTs});
        navigator.add(new Object[]{"unlockSessionId", this.unlockSessionId});
        navigator.add(new Object[]{"redoCount", this.redoCount});
        navigator.add(new Object[]{"checkpointLatch", this.checkpointLatch.getCount()});
        navigator.add(new Object[]{"lockedForMaterialization size", this.lockedForMaterialization.size()});
        navigator.add(new Object[]{"tableWriteLocks size", this.tableWriteLocks.size()});
        navigator.add(new Object[]{"tableReadLocks size", this.tableReadLocks.size()});
        navigator.add(new Object[]{"rowActionMap size", this.rowActionMap.size()});
    }
}

