/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.transaction;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.IntKeyHashMapConcurrent;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.LongDeque;
import com.streamscape.ds.lib.MultiValueHashMap;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.persist.row.RowAction;
import com.streamscape.ds.persist.row.RowActionBase;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionData;
import com.streamscape.ds.transaction.TransactionManager;
import com.streamscape.ds.transaction.TransactionManager2PL;
import com.streamscape.ds.transaction.TransactionManagerMV2PL;
import com.streamscape.ds.transaction.TransactionManagerMVCC;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.LobData;
import com.streamscape.lib.utils.Pair;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

abstract class TransactionManagerCommon
implements TransactionManager {
    DataspaceStore database;
    int txModel;
    NameManager.ObjectName[] catalogNameList;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    public ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    public ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    LongDeque liveTransactionTimestamps = new LongDeque();
    AtomicLong globalChangeTimestamp = new AtomicLong(1L);
    int transactionCount = 0;
    com.streamscape.ds.lib.HashMap tableWriteLocks = new com.streamscape.ds.lib.HashMap();
    MultiValueHashMap tableReadLocks = new MultiValueHashMap();
    public IntKeyHashMapConcurrent rowActionMap;

    TransactionManagerCommon(DataspaceStore db) {
        this.database = db;
    }

    protected boolean isLobSession(Session session) {
        return session == this.database.collectionSessionManager.getSysLobSession() || session == this.database.collectionSessionManager.getSysFlobSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionControl(Session session, int mode) {
        TransactionManagerCommon manager = null;
        if (mode == this.txModel) {
            return;
        }
        this.writeLock.lock();
        switch (this.txModel) {
            case 1: 
            case 2: {
                if (this.liveTransactionTimestamps.size() == 1) break;
                throw Error.error(3701);
            }
        }
        try {
            switch (mode) {
                case 2: {
                    manager = new TransactionManagerMVCC(this.database);
                    manager.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                    break;
                }
                case 1: {
                    manager = new TransactionManagerMV2PL(this.database);
                    manager.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                    break;
                }
                case 0: {
                    manager = new TransactionManager2PL(this.database);
                }
            }
            manager.globalChangeTimestamp.set(this.globalChangeTimestamp.get());
            manager.transactionCount = this.transactionCount;
            this.database.txManager = manager;
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    boolean persistCommit(Session session, int start, int limit, boolean subTran) {
        boolean allRowsInMemory = true;
        ArrayList insertedRows = new ArrayList();
        boolean commit = true;
        int subTranBegin = session.rowActionList.size();
        for (int i = start; i < limit; ++i) {
            RowAction rowAction = (RowAction)session.rowActionList.get(i);
            if (rowAction.type == 0) continue;
            int type = rowAction.getCommitTypeOn(session.actionTimestamp);
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            if (row.getTable().getTableType() != 4) {
                allRowsInMemory = false;
            }
            try {
                rowAction.store.commitRow(session, row, type, this.txModel);
                if (this.txModel == 0) {
                    rowAction.setAsNoOp();
                    row.rowAction = null;
                }
            }
            catch (DataspaceException e) {
                this.database.dataspaceLogger.logWarningEvent("data commit failed", e);
            }
            if (type != 1 || row.getTable() == null || !(row.getTable() instanceof Table)) continue;
            Table table = (Table)row.getTable();
            Pair<Table, ArrayList<Object>> pair = null;
            for (Pair p : insertedRows) {
                pair = p.first == table ? p : null;
                if (pair == null) continue;
                break;
            }
            if (pair == null) {
                pair = new Pair(table, new ArrayList());
                insertedRows.add(pair);
            }
            ((List)pair.second).add(row.getData());
        }
        try {
            if (session.rowActionList.size() > subTranBegin) {
                commit = this.commitSubTransaction(session, subTranBegin, session.rowActionList.size());
            }
        }
        catch (Throwable error) {
            commit = false;
        }
        if (start == 0) {
            try {
                session.logSequences();
                if (limit > 0 && !allRowsInMemory) {
                    if (commit) {
                        this.database.dataspaceLogger.writeCommitStatement(session);
                    } else {
                        this.database.dataspaceLogger.writeRollbackStatement(session);
                    }
                }
            }
            catch (DataspaceException e) {
                this.database.dataspaceLogger.logWarningEvent("data commit failed", e);
            }
        }
        for (Pair pair : insertedRows) {
            ((Table)pair.first).dfetchMonitor.rowsInserted(session, (List)pair.second);
        }
        return commit;
    }

    boolean commitSubTransaction(Session session, int start, int limit) {
        int i;
        for (i = start; i < limit; ++i) {
            RowAction rowact = (RowAction)session.rowActionList.get(i);
            if (rowact.canCommit(session, session.tempSet)) continue;
            throw new DataspaceException("Cannot commit row.");
        }
        for (i = start; i < limit; ++i) {
            RowAction action = (RowAction)session.rowActionList.get(i);
            action.commit(session);
        }
        for (i = 0; i < session.tempSet.size(); ++i) {
            Session current = ((RowActionBase)session.tempSet.get((int)i)).session;
            current.abortTransaction = true;
        }
        limit = this.adjustLobUsage(session, start, limit, false);
        return this.persistCommit(session, start, limit, true);
    }

    protected int adjustLobUsage(Session session, int start, int limit, boolean precommit) {
        int newLimit;
        HashMap<Long, Pair<FlobData, Integer>> lobUsages = new HashMap<Long, Pair<FlobData, Integer>>();
        HashMap<Long, Pair<FlobData, Integer>> flobUsages = new HashMap<Long, Pair<FlobData, Integer>>();
        if (!session.isProcessingRecoveryLog && !session.isProcessingLog) {
            block4: for (int i = start; i < limit; ++i) {
                RowAction action = (RowAction)session.rowActionList.get(i);
                if (!action.table.hasLobColumn() || action.table.isTemp || action.type == 0) continue;
                int type = action.getCommitTypeOn(session.actionTimestamp);
                Row row = action.memoryRow;
                if (row == null) {
                    row = (Row)action.store.get(action.getPos(), false);
                }
                Object[] data = row.getData();
                switch (type) {
                    case 1: {
                        Integer n;
                        Pair<FlobData, Integer> pair;
                        Pair<LobData, Integer> pair2;
                        int j;
                        for (j = 0; j < action.table.columnCount; ++j) {
                            if (data[j] instanceof FlobData) {
                                session.sessionData.removeFromNewFlobIds((FlobData)data[j]);
                                pair2 = (Pair)flobUsages.get(((FlobData)data[j]).getId());
                                if (pair2 == null || (Integer)pair2.second >= 0) continue;
                                pair = pair2;
                                n = (Integer)pair.second;
                                pair.second = (Integer)pair.second + 1;
                                continue;
                            }
                            if (!action.table.colTypes[j].isLobType() || data[j] == null) continue;
                            pair2 = (Pair)lobUsages.get(((LobData)data[j]).getId());
                            if (pair2 == null) {
                                pair2 = new Pair<LobData, Integer>((LobData)data[j], 0);
                                lobUsages.put(((LobData)data[j]).getId(), pair2);
                            }
                            pair = pair2;
                            n = (Integer)pair.second;
                            pair.second = (Integer)pair.second + 1;
                        }
                        continue block4;
                    }
                    case 2: {
                        Integer n;
                        Pair<FlobData, Integer> pair;
                        Pair<LobData, Integer> pair2;
                        int j;
                        for (j = 0; j < action.table.columnCount; ++j) {
                            if (data[j] instanceof FlobData) {
                                pair2 = (Pair<FlobData, Integer>)flobUsages.get(((FlobData)data[j]).getId());
                                if (pair2 == null) {
                                    pair2 = new Pair<FlobData, Integer>((FlobData)data[j], 0);
                                    flobUsages.put(((FlobData)data[j]).getId(), pair2);
                                }
                                pair = pair2;
                                n = (Integer)pair.second;
                                pair.second = (Integer)pair.second - 1;
                                continue;
                            }
                            if (!action.table.colTypes[j].isLobType()) continue;
                            pair2 = (Pair)lobUsages.get(((LobData)data[j]).getId());
                            if (pair2 == null) {
                                pair2 = new Pair<LobData, Integer>((LobData)data[j], 0);
                                lobUsages.put(((LobData)data[j]).getId(), pair2);
                            }
                            pair = pair2;
                            n = (Integer)pair.second;
                            pair.second = (Integer)pair.second + 1;
                        }
                        continue block4;
                    }
                }
            }
            for (Pair pair : lobUsages.values()) {
                if ((Integer)pair.second == 0) continue;
                session.sessionData.adjustLobUsageCount(pair.first, (Integer)pair.second);
            }
            for (Pair pair : flobUsages.values()) {
                session.sessionData.removeFromNewFlobIds((FlobData)pair.first);
                if ((Integer)pair.second == 0) continue;
                session.sessionData.adjustLobUsageCount(pair.first, (Integer)pair.second);
            }
        }
        if ((newLimit = session.rowActionList.size()) > limit) {
            for (int i = limit; i < newLimit; ++i) {
                RowAction lobAction = (RowAction)session.rowActionList.get(i);
                if (precommit) {
                    lobAction.prepareCommit(session);
                    continue;
                }
                lobAction.commit(session);
            }
        }
        return session.rowActionList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finaliseRows(Session session, Object[] list, int start, int limit, boolean commit) {
        for (int i = start; i < limit; ++i) {
            RowAction action = (RowAction)list[i];
            if (action.table.getTableType() == 6 && action.type == 0) {
                Lock mapLock = this.rowActionMap.getWriteLock();
                mapLock.lock();
                try {
                    RowAction rowAction = action;
                    synchronized (rowAction) {
                        if (action.type == 0) {
                            this.rowActionMap.remove(action.getPos());
                        }
                    }
                }
                finally {
                    mapLock.unlock();
                }
            }
            if (action.type != 3 || action.deleteComplete) continue;
            try {
                action.deleteComplete = true;
                if (action.table.getTableType() == 3) continue;
                Row row = action.memoryRow;
                if (row == null) {
                    row = (Row)action.store.get(action.getPos(), false);
                }
                action.store.commitRow(session, row, action.type, this.txModel);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeRolledBackTransaction(Session session, long timestamp, Object[] list, int start, int limit) {
        for (int i = start; i < limit; ++i) {
            RowAction action = (RowAction)list[i];
            Row row = action.memoryRow;
            if (row == null) {
                if (action.type == 0) continue;
                row = (Row)action.store.get(action.getPos(), false);
            }
            if (action.table.hasLobColumn()) {
                switch (action.type) {
                    case 1: {
                        session.sessionData.adjustLobUsageCount(action.table, row.getData(), -1, EnumSet.of(SessionData.LobType.FLOB));
                    }
                }
            }
            if (row == null) continue;
            Row row2 = row;
            synchronized (row2) {
                action.mergeRollback(session, timestamp, row);
                continue;
            }
        }
    }

    void mergeTransaction(Session session, Object[] list, int start, int limit, long timestamp) {
        for (int i = start; i < limit; ++i) {
            RowAction rowact = (RowAction)list[i];
            rowact.mergeToTimestamp(timestamp);
        }
    }

    public long nextChangeTimestamp() {
        return this.globalChangeTimestamp.incrementAndGet();
    }

    @Override
    public long getNextGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.incrementAndGet();
    }

    boolean checkDeadlock(Session session, OrderedHashSet newWaits) {
        Session current;
        int i;
        for (i = 0; i < session.waitingSessions.size(); ++i) {
            current = (Session)session.waitingSessions.get(i);
            if (newWaits.contains(current)) {
                Trace.logError(this, "Deadlock detected between sessions: {} and  {}.", session.getId(), current.getId());
                return false;
            }
            if (this.checkDeadlock(current, newWaits)) continue;
            return false;
        }
        for (i = 0; i < session.replicationWaitingSessions.size(); ++i) {
            current = (Session)session.replicationWaitingSessions.get(i);
            if (newWaits.contains(current)) {
                Trace.logError(this, "Deadlock detected between sessions: {} and  {}.", session.getId(), current.getId());
                return false;
            }
            if (this.checkDeadlock(current, newWaits)) continue;
            return false;
        }
        return true;
    }

    boolean checkDeadlock(Session session, Session other) {
        Session current;
        int i;
        for (i = 0; i < session.waitingSessions.size(); ++i) {
            current = (Session)session.waitingSessions.get(i);
            if (current == other) {
                Trace.logError(this, "Deadlock detected between sessions: {} and  {}.", current.getId(), other.getId());
                return false;
            }
            if (this.checkDeadlock(current, other)) continue;
            return false;
        }
        for (i = 0; i < session.replicationWaitingSessions.size(); ++i) {
            current = (Session)session.replicationWaitingSessions.get(i);
            if (current == other) {
                Trace.logError(this, "Deadlock detected between sessions: {} and  {}.", current.getId(), other.getId());
                return false;
            }
            if (this.checkDeadlock(current, other)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endActionTPL(Session session) {
        if (session.isolationLevel == 4 || session.isolationLevel == 8) {
            return;
        }
        if (session.sessionContext.currentStatement == null) {
            return;
        }
        if (session.sessionContext.depth > 0) {
            return;
        }
        Object[] readLocks = session.sessionContext.currentStatement.getTableNamesForRead();
        if (readLocks.length == 0) {
            return;
        }
        this.writeLock.lock();
        try {
            int i;
            this.unlockReadTablesTPL(session, (NameManager.ObjectName[])readLocks);
            int waitingCount = session.waitingSessions.size();
            if (waitingCount == 0) {
                return;
            }
            boolean canUnlock = false;
            for (i = 0; i < readLocks.length; ++i) {
                if (this.tableWriteLocks.get(readLocks[i]) == session) continue;
                canUnlock = true;
                break;
            }
            if (!canUnlock) {
                return;
            }
            canUnlock = false;
            for (i = 0; i < waitingCount; ++i) {
                Session current = (Session)session.waitingSessions.get(i);
                if (current.abortTransaction) {
                    canUnlock = true;
                    break;
                }
                Statement currentStatement = current.sessionContext.currentStatement;
                if (currentStatement == null) {
                    canUnlock = true;
                    break;
                }
                if (!ArrayUtil.containsAny(readLocks, currentStatement.getTableNamesForWrite())) continue;
                canUnlock = true;
                break;
            }
            if (!canUnlock) {
                return;
            }
            this.resetLocks(session);
            this.resetLatchesMidTransaction(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void endTransactionTPL(Session session) {
        this.unlockTablesTPL(session);
        int waitingCount = session.waitingSessions.size();
        if (waitingCount == 0) {
            return;
        }
        this.resetLocks(session);
        this.resetLatches(session);
    }

    void resetLocks(Session session) {
        Session current;
        int i;
        int waitingCount = session.waitingSessions.size();
        for (i = 0; i < waitingCount; ++i) {
            boolean canProceed;
            current = (Session)session.waitingSessions.get(i);
            current.tempUnlocked = false;
            long count = current.latch.getCount();
            if (count != 1L || !(canProceed = this.setWaitedSessionsTPL(current, current.sessionContext.currentStatement)) || !current.tempSet.isEmpty()) continue;
            this.lockTablesTPL(current, current.sessionContext.currentStatement);
            current.tempUnlocked = true;
        }
        for (i = 0; i < waitingCount; ++i) {
            current = (Session)session.waitingSessions.get(i);
            if (current.tempUnlocked || current.abortTransaction) continue;
            this.setWaitedSessionsTPL(current, current.sessionContext.currentStatement);
        }
    }

    void resetLatches(Session session) {
        int waitingCount = session.waitingSessions.size();
        for (int i = 0; i < waitingCount; ++i) {
            Session current = (Session)session.waitingSessions.get(i);
            if (current.abortTransaction || current.tempSet.isEmpty()) {
                // empty if block
            }
            this.setWaitingSessionTPL(current);
        }
        session.waitingSessions.clear();
        session.latch.setCount(session.waitedSessions.size() + session.replicationWaitedSessions.size());
    }

    void resetLatchesMidTransaction(Session session) {
        session.tempSet.clear();
        session.tempSet.addAll(session.waitingSessions);
        session.waitingSessions.clear();
        int waitingCount = session.tempSet.size();
        for (int i = 0; i < waitingCount; ++i) {
            Session current = (Session)session.tempSet.get(i);
            if (current.abortTransaction || current.tempSet.isEmpty()) {
                // empty if block
            }
            this.setWaitingSessionTPL(current);
        }
        session.tempSet.clear();
    }

    boolean setWaitedSessionsTPL(Session session, Statement cs) {
        Session holder;
        NameManager.ObjectName name;
        int i;
        session.tempSet.clear();
        if (cs == null) {
            return true;
        }
        if (session.abortTransaction) {
            return false;
        }
        NameManager.ObjectName[] nameList = cs.getTableNamesForWrite();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_NAME) continue;
            holder = (Session)this.tableWriteLocks.get(name);
            if (holder != null && holder != session) {
                session.tempSet.add(holder);
            }
            Iterator it = this.tableReadLocks.get(name);
            while (it.hasNext()) {
                holder = (Session)it.next();
                if (holder == session) continue;
                session.tempSet.add(holder);
            }
        }
        nameList = cs.getTableNamesForRead();
        if (this.txModel == 1 && session.isReadOnly()) {
            nameList = this.catalogNameList;
        }
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_NAME || (holder = (Session)this.tableWriteLocks.get(name)) == null || holder == session) continue;
            session.tempSet.add(holder);
        }
        if (session.tempSet.isEmpty()) {
            return true;
        }
        if (this.checkDeadlock(session, session.tempSet)) {
            return true;
        }
        session.tempSet.clear();
        session.abortTransaction = true;
        return false;
    }

    void setWaitingSessionTPL(Session session) {
        for (int i = 0; i < session.tempSet.size(); ++i) {
            Session current = (Session)session.tempSet.get(i);
            current.waitingSessions.add(session);
        }
        session.tempSet.clear();
        session.latch.setCount(session.waitedSessions.size() + session.replicationWaitedSessions.size());
    }

    void lockTablesTPL(Session session, Statement cs) {
        NameManager.ObjectName name;
        int i;
        if (cs == null || session.abortTransaction) {
            return;
        }
        NameManager.ObjectName[] nameList = cs.getTableNamesForWrite();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_NAME) continue;
            this.tableWriteLocks.put(name, session);
        }
        nameList = cs.getTableNamesForRead();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_NAME) continue;
            this.tableReadLocks.put(name, session);
        }
    }

    void unlockTablesTPL(Session session) {
        Session s;
        Iterator it = this.tableWriteLocks.values().iterator();
        while (it.hasNext()) {
            s = (Session)it.next();
            if (s != session) continue;
            it.remove();
        }
        it = this.tableReadLocks.values().iterator();
        while (it.hasNext()) {
            s = (Session)it.next();
            if (s != session) continue;
            it.remove();
        }
    }

    void unlockReadTablesTPL(Session session, NameManager.ObjectName[] locks) {
        for (int i = 0; i < locks.length; ++i) {
            this.tableReadLocks.remove(locks[i], session);
        }
    }

    boolean hasLocks(Session session, Statement cs) {
        Session holder;
        NameManager.ObjectName name;
        int i;
        if (cs == null) {
            return true;
        }
        NameManager.ObjectName[] nameList = cs.getTableNamesForWrite();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_NAME) continue;
            holder = (Session)this.tableWriteLocks.get(name);
            if (holder != null && holder != session) {
                return false;
            }
            Iterator it = this.tableReadLocks.get(name);
            while (it.hasNext()) {
                holder = (Session)it.next();
                if (holder == session) continue;
                return false;
            }
        }
        nameList = cs.getTableNamesForRead();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_NAME || (holder = (Session)this.tableWriteLocks.get(name)) == null || holder == session) continue;
            return false;
        }
        return true;
    }

    long getFirstLiveTransactionTimestamp() {
        if (this.liveTransactionTimestamps.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return this.liveTransactionTimestamps.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    RowAction[] getRowActionList() {
        this.writeLock.lock();
        try {
            sessions = this.database.collectionSessionManager.getAllSessions();
            tIndex = new int[sessions.length];
            rowActionCount = 0;
            actioncount = 0;
            for (i = 0; i < sessions.length; ++i) {
                actioncount += sessions[i].getTransactionSize();
            }
            rowActions = new RowAction[actioncount];
            block4: while (true) {
                found = false;
                minChangeNo = 0x7FFFFFFFFFFFFFFFL;
                sessionIndex = 0;
                for (i = 0; i < sessions.length; ++i) {
                    tSize = sessions[i].getTransactionSize();
                    if (tIndex[i] >= tSize) continue;
                    current = (RowAction)sessions[i].rowActionList.get(tIndex[i]);
                    if (current.actionTimestamp < minChangeNo) {
                        minChangeNo = current.actionTimestamp;
                        sessionIndex = i;
                    }
                    found = true;
                }
                if (!found) break;
                currentList = sessions[sessionIndex].rowActionList;
                while (true) {
                    if (tIndex[sessionIndex] >= currentList.size()) continue block4;
                    current = (RowAction)currentList.get(tIndex[sessionIndex]);
                    if (current.actionTimestamp == minChangeNo + 1L) {
                        ++minChangeNo;
                    }
                    if (current.actionTimestamp == minChangeNo) ** break;
                    continue block4;
                    rowActions[rowActionCount++] = current;
                    v0 = sessionIndex;
                    tIndex[v0] = tIndex[v0] + 1;
                }
                break;
            }
            var5_5 = rowActions;
            return var5_5;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean lockCollectionForWrite(Session session, NameManager.ObjectName name) {
        return false;
    }

    @Override
    public void unlockCollectionForWrite(Session session, NameManager.ObjectName name) {
    }

    @Override
    public long getCatalogWriteSessionThreadId() {
        return -1L;
    }
}

